/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.unicom.service.impl;

import com.hs.atic.bis.dao.DivertTacticsDao;
import com.hs.atic.bis.dao.DivertTacticsLogDao;
import com.hs.atic.bis.model.DivertTactics;
import com.hs.atic.bis.model.DivertTacticsLog;
import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.form.DivertTacticsLogForm;
import com.hs.atic.sdk.bis.service.IDivertTacticsService;
import com.hs.atic.sdk.bis.unicom.entity.TaskOperateUnicomEntity;
import com.hs.atic.sdk.bis.unicom.service.IUnicomDivertTacticsService;
import com.hs.atic.sdk.bis.unicom.service.OperateTaskUnicomService;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.AticDiversionUtil;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.DeviceProxy;
import com.hs.atic.util.DeviceProxyFactory;
import com.hs.atic.util.DivertAlarmHandler;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.huawei.atic.comm.south.ssh.Ssh2Connector;
import com.huawei.atic.comm.south.telnet.TelnetConnector;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class UnicomDivertTacticsServiceImpl
implements IUnicomDivertTacticsService {
    private static final String CLEANTASKSTART = "cleanTaskStart";
    private static final String CLEANTASKSTOP = "cleanTaskStop";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private IDivertTacticsService divertTacticsService;
    private IAticDeviceService aticDeviceService;
    private DivertTacticsDao divertTacticsDao;
    private DivertTacticsLogDao divertTacticsLogDao;
    private DivertAlarmHandler divertAlarmHandler;
    private IZoneDeviceService zoneDeviceService;
    private OperateTaskUnicomService operateTaskService;

    @Override
    public DivertTacticsForm getDivertTacticsByZoneIp(Long deviceId, Long zoneId, String zoneIp) {
        return this.divertTacticsService.getDivertTacticsByZoneIp(deviceId, zoneId, zoneIp);
    }

    @Override
    public BatchOperationResult batchAddUnicomDivertTactics(String taskId, String deviceIp, List<BatchOperation> boList, String operator, String clientIp) {
        ArrayList<DivertTactics> divertTacticsList = new ArrayList<DivertTactics>();
        for (BatchOperation bo : boList) {
            DivertTacticsForm divertTacticsForm = (DivertTacticsForm)bo.getExtTargetId();
            divertTacticsForm.setOperator(operator);
            divertTacticsForm.setClientIp(clientIp);
            DivertTactics divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics());
            divertTacticsList.add(divertTactics);
        }
        if (divertTacticsList.isEmpty()) {
            this.logger.error((Object)"unicomCleanTask divertTacticsList is null");
            throw new LegoCheckedException(570503L);
        }
        DivertTactics divert = (DivertTactics)divertTacticsList.get(0);
        if (null == this.aticDeviceService.getDeviceByMoid(divert.getDeviceId().longValue())) {
            this.logger.error((Object)("start divert tactics : " + divert.getDeviceName() + ", " + divert.getDivertIp() + " failed, no device exists!"));
            throw new LegoCheckedException(571205L);
        }
        BatchOperationResult result = null;
        try {
            result = this.exeUnicomDivertListCmd(taskId, deviceIp, boList, divertTacticsList);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"@execTelnet,EXE CLI ERROR,LegoCheckedException:", (Throwable)e);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e1) {
            this.logger.error((Object)"@execTelnet,EXE CLI ERROR:", (Throwable)e1);
            throw new LegoCheckedException(660019L, (Throwable)e1);
        }
        this.logger.info((Object)("unicomCleanTask start divert result : success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
        return result;
    }

    @Override
    public BatchOperationResult stopUnicomDivertTactics(String taskId, String deviceIp, List<BatchOperation> boList, String operator, String clientIp) {
        Collection proxies;
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        HashMap<Long, DeviceProxy> proxyMap = new HashMap<Long, DeviceProxy>();
        DeviceProxy proxy2 = null;
        if (null != boList && !boList.isEmpty()) {
            for (BatchOperation bo : boList) {
                DivertTactics divertTactics = null;
                DivertTacticsLogForm divertTacticsLogForm = null;
                TaskOperateUnicomEntity taskOperate = new TaskOperateUnicomEntity();
                taskOperate.setTaskId(taskId);
                taskOperate.setCommand(CLEANTASKSTOP);
                taskOperate.setCleanEq(deviceIp);
                taskOperate.setExecutTime(System.currentTimeMillis() / 1000L);
                try {
                    this.logger.info((Object)("bo.getTargetId():" + bo.getTargetId()));
                    divertTactics = this.divertTacticsDao.get(Long.valueOf(bo.getTargetId()));
                    if (null == divertTactics) {
                        this.logger.error((Object)("stop divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed, this divert tactics not exists!"));
                        bo.setOptDetail("protectIp:" + this.getcleanedMessage(bo.getTargetName()) + " failed,because the divert tactics  not exists!");
                        taskOperate.setProtectIp(bo.getTargetName().substring(bo.getTargetName().indexOf("[") + 1, bo.getTargetName().indexOf("]")));
                        taskOperate.setStatus(1);
                        taskOperate.setErrorCode(2);
                        taskOperate.setDetail("stop failed, because the divert tactics  not exists!");
                        this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                        bo.setErrorCode(571201L);
                        ++fail;
                        continue;
                    }
                    taskOperate.setProtectIp(divertTactics.getDivertIp() + "/" + divertTactics.getMask());
                    divertTactics.setOperator(operator);
                    divertTactics.setClientIp(clientIp);
                    divertTacticsLogForm = this.getTacticsLog(divertTactics);
                    Long devId = divertTactics.getDeviceId();
                    AticDevice device = this.aticDeviceService.getDeviceByMoid(devId.longValue());
                    if (null == device) {
                        this.logger.error((Object)("stop divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed, no device exists!"));
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, "no.device");
                        bo.setOptDetail("protectIp:" + divertTactics.getDivertIp() + "/" + divertTactics.getMask() + "failed, no device exists!");
                        taskOperate.setStatus(1);
                        taskOperate.setErrorCode(2);
                        taskOperate.setDetail("stop failed, no device exists!");
                        this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                        bo.setErrorCode(571205L);
                        ++fail;
                        continue;
                    }
                    divertTactics.setDeviceName(device.getName());
                    this.logger.info((Object)("save divert tactics device name : " + divertTactics.getDeviceName()));
                    int tryCount = 3;
                    proxy2 = (DeviceProxy)proxyMap.get(devId);
                    if (proxy2 == null) {
                        LegoCheckedException exception = null;
                        for (int countIndex = 0; countIndex < tryCount; ++countIndex) {
                            try {
                                proxy2 = DeviceProxyFactory.createDeviceProxy((Long)devId, (IAticDeviceService)this.aticDeviceService);
                                if (null == proxy2) continue;
                                break;
                            }
                            catch (LegoCheckedException e) {
                                this.logger.error((Object)"@execTelnet,EXE CLI ERROR,LegoCheckedException:", (Throwable)e);
                                exception = e;
                            }
                        }
                        if (proxy2 == null) {
                            this.logger.error((Object)"@execTelnet,EXE CLI ERROR,LegoCheckedException:", exception);
                            throw new LegoCheckedException(exception.getErrorCode(), (Throwable)exception);
                        }
                        proxyMap.put(devId, proxy2);
                    }
                    String command = AticDiversionUtil.getDivertCommand((DivertTactics)divertTactics, (String)"UNDEPLOY");
                    this.logger.info((Object)("deploy command is " + this.getcleanedMessage(command)));
                    if (command == null || "".equals(command)) {
                        this.logger.info((Object)("the divert command is null or empty, this task no need be deployed. zoneIp=" + divertTactics.getDivertIp() + ", deviceId=" + divertTactics.getDeviceId()));
                        continue;
                    }
                    String cmdResult = proxy2.executeCommand(command);
                    this.logger.info((Object)("deploy cmdResult is " + cmdResult));
                    Integer errorCode = this.cmdResult(cmdResult);
                    this.logger.info((Object)("deploy command result errorCode is " + errorCode));
                    if (errorCode == 1) {
                        this.logger.info((Object)("stop divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " successfully."));
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 4, 1, "");
                        bo.setOptDetail("protectIp:" + divertTactics.getDivertIp() + "/" + divertTactics.getMask() + " stop successfully.");
                        taskOperate.setStatus(0);
                        taskOperate.setErrorCode(0);
                        taskOperate.setDetail("stop successfully.");
                        this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                        divertTactics.setDivertStatus(Integer.valueOf(0));
                        this.divertTacticsDao.saveOrUpdate((Object)divertTactics);
                        DivertTacticsForm divertTacticsForm = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm());
                        this.divertTacticsService.removeDivertTactics(divertTacticsForm);
                        this.divertAlarmHandler.divertAlarmResume(divertTactics, device.getIpAddress());
                        continue;
                    }
                    this.logger.error((Object)("stop divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."));
                    if (570503 == errorCode) {
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, cmdResult);
                    } else {
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, String.valueOf(errorCode));
                    }
                    bo.setOptDetail("protectIp:" + divertTactics.getDivertIp() + "/" + divertTactics.getMask() + " stop failed:" + cmdResult + "!");
                    taskOperate.setStatus(1);
                    taskOperate.setErrorCode(2);
                    taskOperate.setDetail(" stop failed:" + cmdResult + "!");
                    this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                    bo.setErrorCode((long)errorCode.intValue());
                    ++fail;
                }
                catch (LegoCheckedException e) {
                    ++fail;
                    bo.setErrorCode(e.getErrorCode());
                    this.logger.error((Object)"stop divert tactics failed.", (Throwable)e);
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, String.valueOf(e.getErrorCode()));
                    String detail = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
                    bo.setOptDetail("protectIp:" + divertTactics.getDivertIp() + "/" + divertTactics.getMask() + " stop failed:" + detail + "!");
                    taskOperate.setStatus(1);
                    taskOperate.setErrorCode(2);
                    taskOperate.setDetail(" stop failed:" + detail + "!");
                    this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                    if (null != divertTactics.getDeviceId()) {
                        if (proxyMap.isEmpty() || !proxyMap.containsKey(divertTactics.getDeviceId())) continue;
                        proxyMap.remove(divertTactics.getDeviceId());
                        continue;
                    }
                    this.logger.error((Object)"stop divert tactics failed. deviceId is null.");
                }
                catch (Exception e) {
                    ++fail;
                    bo.setErrorCode(570507L);
                    this.logger.error((Object)"stop divert tactics failed.", (Throwable)e);
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_STOP, 3, 0, "firewall.exception");
                    bo.setOptDetail("protectIp:" + divertTactics.getDivertIp() + "/" + divertTactics.getMask() + " firewall.exception !");
                    taskOperate.setStatus(1);
                    taskOperate.setErrorCode(2);
                    taskOperate.setDetail(" firewall.exception !");
                    this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                    if (proxyMap.isEmpty() || !proxyMap.containsKey(divertTactics.getDeviceId())) continue;
                    proxyMap.remove(divertTactics.getDeviceId());
                }
            }
        }
        if ((proxies = proxyMap.values()) != null) {
            for (DeviceProxy proxy2 : proxies) {
                if (proxy2 == null) continue;
                proxy2.close();
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList == null ? 0 : boList.size());
        result.setSucceedCount(boList == null ? 0 : boList.size() - fail);
        this.logger.info((Object)("stop divert result : success : " + result.getSucceedCount() + ", failed : " + result.getFailCount() + ", total : " + result.getTotalCount()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BatchOperationResult exeUnicomDivertListCmd(String taskId, String deviceIp, List<BatchOperation> boList, List<DivertTactics> divertTacticsList) {
        BatchOperationResult result = new BatchOperationResult();
        HashMap<Long, DeviceProxy> proxyMap = new HashMap<Long, DeviceProxy>();
        DeviceProxy proxy = null;
        Ssh2Connector sshConn = null;
        TelnetConnector telConn = null;
        int fail = 0;
        List cmdList = AticDiversionUtil.getDivertCommandAsList(divertTacticsList, (String)"DEPLOY");
        String strRetVal = null;
        if (!cmdList.isEmpty()) {
            this.logger.info((Object)("unicomCleanTask: cmd List size:" + cmdList.size() + "; diveretTactics List size:" + divertTacticsList.size() + "; boList size:" + boList.size()));
            for (int i = 0; i < cmdList.size(); ++i) {
                DivertTactics divertTactics = divertTacticsList.get(i);
                DivertTacticsLogForm divertTacticsLogForm = this.getTacticsLog(divertTactics);
                TaskOperateUnicomEntity taskOperate = new TaskOperateUnicomEntity();
                taskOperate.setTaskId(taskId);
                taskOperate.setCommand(CLEANTASKSTART);
                taskOperate.setCleanEq(deviceIp);
                taskOperate.setProtectIp(divertTactics.getDivertIp() + "/" + divertTactics.getMask());
                taskOperate.setExecutTime(System.currentTimeMillis() / 1000L);
                BatchOperation bo = boList.get(i);
                if (this.divertTacticsDao.isExist(divertTactics)) {
                    this.logger.error((Object)"unicomCleanTask: the divert tactics has been existed!");
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, Integer.toString(571204));
                    bo.setOptDetail("protectIp:" + divertTactics.getDivertIp() + "/" + divertTactics.getMask() + " create failed, because the divert tactics has been existed!");
                    taskOperate.setStatus(1);
                    taskOperate.setErrorCode(2);
                    taskOperate.setDetail("create failed, because the divert tactics has been existed!");
                    this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                    divertTactics.setDivertStatus(Integer.valueOf(0));
                    bo.setErrorCode(571204L);
                    ++fail;
                    continue;
                }
                proxy = (DeviceProxy)proxyMap.get(divertTactics.getDeviceId());
                try {
                    LegoCheckedException exception;
                    int tryCount = 3;
                    if (proxy == null) {
                        exception = null;
                        for (int countIndex = 0; countIndex < tryCount; ++countIndex) {
                            try {
                                proxy = DeviceProxyFactory.createDeviceProxy((Long)divertTactics.getDeviceId(), (IAticDeviceService)this.aticDeviceService);
                                if (null == proxy) continue;
                                break;
                            }
                            catch (LegoCheckedException e) {
                                this.logger.error((Object)"@execTelnet,EXE CLI ERROR,LegoCheckedException:", (Throwable)e);
                                exception = e;
                            }
                        }
                        if (proxy == null) {
                            this.logger.error((Object)"@execTelnet,EXE CLI ERROR,LegoCheckedException:", exception);
                            throw new LegoCheckedException(exception.getErrorCode(), (Throwable)exception);
                        }
                        proxyMap.put(divertTactics.getDeviceId(), proxy);
                    }
                    telConn = proxy.getTconn();
                    sshConn = proxy.getSconn();
                    if (null != telConn) {
                        strRetVal = telConn.executeCommand((String)cmdList.get(i));
                    }
                    if (null != sshConn) {
                        strRetVal = sshConn.executeCommand((String)cmdList.get(i));
                    }
                    this.logger.info((Object)("@execTelnet,Command[" + this.getcleanedMessage((String)cmdList.get(i)) + "],Result:" + this.getcleanedMessage(strRetVal)));
                    if (strRetVal == null) {
                        this.logger.error((Object)"strRetVal is null");
                        exception = new BatchOperationResult();
                        return exception;
                    }
                    Integer errorCode = this.cmdResult(strRetVal);
                    this.logger.info((Object)("unicomCleanTask: deploy command result errorCode is " + errorCode));
                    if (errorCode == 1) {
                        AticDevice device = this.aticDeviceService.getDeviceByMoid(divertTactics.getDeviceId().longValue());
                        if (device.getVersion().contains("V100R001") || device.getVersion().contains("V500R001C00")) {
                            if (IPUtil.isIpv4((String)divertTactics.getDivertIp()) && 32 == divertTactics.getMask() || IPUtil.isIpv6((String)divertTactics.getDivertIp()) && 128 == divertTactics.getMask()) {
                                Integer errorCodeOfDispaly;
                                String commandOfDisplay = AticDiversionUtil.getDivertCommand((DivertTactics)divertTactics, (String)"DISPLAY");
                                if (commandOfDisplay == null || "".equals(commandOfDisplay)) {
                                    this.logger.error((Object)("unicomCleanTask: the divert commandOfDisplay is null or empty, this task no need be display. zoneIp=" + divertTactics.getDivertIp() + " device:" + divertTactics.getDeviceId()));
                                    continue;
                                }
                                String cmdResultOfDisplay = proxy.executeCommand(commandOfDisplay);
                                int firstLineBeginIndex = cmdResultOfDisplay.indexOf("\n");
                                if (-1 != firstLineBeginIndex) {
                                    cmdResultOfDisplay = commandOfDisplay + cmdResultOfDisplay.substring(firstLineBeginIndex + 1, cmdResultOfDisplay.length());
                                }
                                if (1 != (errorCodeOfDispaly = this.cmdResultOfDispaly(cmdResultOfDisplay))) {
                                    this.logger.error((Object)("unicomCleanTask: start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."));
                                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, cmdResultOfDisplay);
                                    bo.setOptDetail("protectIp:" + divertTactics.getDivertIp() + "/" + divertTactics.getMask() + " start failed:" + cmdResultOfDisplay + "!");
                                    taskOperate.setStatus(1);
                                    taskOperate.setErrorCode(2);
                                    taskOperate.setDetail(" start failed:" + cmdResultOfDisplay + "!");
                                    this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                                    bo.setErrorCode((long)errorCodeOfDispaly.intValue());
                                    ++fail;
                                    continue;
                                }
                                this.logger.info((Object)("unicomCleanTask: start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " successfully."));
                                this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 4, 1, cmdResultOfDisplay);
                                bo.setOptDetail("protectIp:" + divertTactics.getDivertIp() + "/" + divertTactics.getMask() + " start successfully!");
                                taskOperate.setStatus(0);
                                taskOperate.setErrorCode(0);
                                taskOperate.setDetail("start successfully!");
                                this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                                divertTactics.setDivertStatus(Integer.valueOf(1));
                                this.divertTacticsDao.saveOrUpdate((Object)divertTactics);
                                continue;
                            }
                            this.logger.info((Object)("unicomCleanTask: start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " successfully."));
                            this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 4, 1, "");
                            bo.setOptDetail("protectIp:" + divertTactics.getDivertIp() + "/" + divertTactics.getMask() + " start successfully!");
                            taskOperate.setStatus(0);
                            taskOperate.setErrorCode(0);
                            taskOperate.setDetail("start successfully!");
                            this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                            divertTactics.setDivertStatus(Integer.valueOf(1));
                            this.divertTacticsDao.saveOrUpdate((Object)divertTactics);
                            continue;
                        }
                        String commandOfC20 = AticDiversionUtil.getDivertCommand((DivertTactics)divertTactics, (String)"DISPLAYOFC20");
                        if (commandOfC20 == null || "".equals(commandOfC20)) {
                            this.logger.error((Object)("unicomCleanTask: the divert commandOfC20 is null or empty, this task no need be display. zoneIp=" + divertTactics.getDivertIp() + " device:" + divertTactics.getDeviceId()));
                            continue;
                        }
                        String cmdResultDisplayOfC20 = proxy.executeCommand(commandOfC20);
                        Integer errorCodeOfDisplayOfC20 = this.cmdResultOfDispaly(cmdResultDisplayOfC20);
                        int firstLineBeginIndex = cmdResultDisplayOfC20.indexOf("\n");
                        if (-1 != firstLineBeginIndex) {
                            cmdResultDisplayOfC20 = commandOfC20 + cmdResultDisplayOfC20.substring(firstLineBeginIndex + 1, cmdResultDisplayOfC20.length());
                        }
                        if (1 == errorCodeOfDisplayOfC20) {
                            this.logger.info((Object)("unicomCleanTask: start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " successfully."));
                            this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 4, 1, cmdResultDisplayOfC20);
                            bo.setOptDetail("protectIp:" + divertTactics.getDivertIp() + "/" + divertTactics.getMask() + " start successfully!");
                            taskOperate.setStatus(0);
                            taskOperate.setErrorCode(0);
                            taskOperate.setDetail("start successfully!");
                            this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                            divertTactics.setDivertStatus(Integer.valueOf(1));
                            this.divertTacticsDao.saveOrUpdate((Object)divertTactics);
                            continue;
                        }
                        this.logger.error((Object)("unicomCleanTask: start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."));
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, cmdResultDisplayOfC20);
                        bo.setOptDetail("protectIp:" + divertTactics.getDivertIp() + "/" + divertTactics.getMask() + " start failed:" + cmdResultDisplayOfC20 + "!");
                        taskOperate.setStatus(1);
                        taskOperate.setErrorCode(2);
                        taskOperate.setDetail("start failed:" + cmdResultDisplayOfC20 + "!");
                        this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                        bo.setErrorCode((long)errorCodeOfDisplayOfC20.intValue());
                        ++fail;
                        continue;
                    }
                    divertTactics.setDivertStatus(Integer.valueOf(0));
                    this.logger.error((Object)("unicomCleanTask: start divert tactics : " + this.getcleanedMessage(bo.getTargetName()) + " failed."));
                    if (570503 == errorCode) {
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, strRetVal);
                    } else {
                        this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, String.valueOf(errorCode));
                    }
                    bo.setOptDetail("protectIp:" + divertTactics.getDivertIp() + "/" + divertTactics.getMask() + " start failed:" + strRetVal + "!");
                    taskOperate.setStatus(1);
                    taskOperate.setErrorCode(2);
                    taskOperate.setDetail("start failed:" + strRetVal + "!");
                    this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                    bo.setErrorCode((long)errorCode.intValue());
                    ++fail;
                    continue;
                }
                catch (LegoCheckedException e) {
                    divertTactics.setDivertStatus(Integer.valueOf(0));
                    this.logger.error((Object)("unicomCleanTask: start divert tactics failed, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()), (Throwable)e);
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, String.valueOf(e.getErrorCode()));
                    String detail = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
                    bo.setOptDetail("protectIp:" + divertTactics.getDivertIp() + "/" + divertTactics.getMask() + " start divert failed:" + detail + "!");
                    taskOperate.setStatus(1);
                    taskOperate.setErrorCode(2);
                    taskOperate.setDetail("start failed:" + detail + "!");
                    this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                    ++fail;
                    bo.setErrorCode(e.getErrorCode());
                    continue;
                }
                catch (Exception e) {
                    divertTactics.setDivertStatus(Integer.valueOf(0));
                    this.logger.error((Object)("unicomCleanTask: start divert tactics failed, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()), (Throwable)e);
                    this.fillDivertLog(divertTacticsLogForm, AticConstants.DIVERT_LOG_OPER_TYPE_START, 3, 0, "firewall.exception");
                    bo.setOptDetail("protectIp:" + divertTactics.getDivertIp() + "/" + divertTactics.getMask() + " unknowed exception,please try to check the network and database!");
                    taskOperate.setStatus(1);
                    taskOperate.setErrorCode(2);
                    taskOperate.setDetail("unknowed exception,please try to check the network and database!");
                    this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                    ++fail;
                    bo.setErrorCode(570507L);
                    continue;
                }
                finally {
                    DivertTacticsForm divertTacticsForm = (DivertTacticsForm)AticUtil.copyProperties((Object)divertTactics, (Object)new DivertTacticsForm());
                    if (!this.isExist(divertTacticsForm)) {
                        this.saveDivertTactics(divertTacticsForm);
                        DivertTacticsLogForm divertTacticsLogForms = this.getTacticsLog(divertTactics);
                        this.fillDivertLog(divertTacticsLogForms, AticConstants.DIVERT_LOG_OPER_TYPE_CREATE, 4, 1, "");
                        this.logger.info((Object)("unicomCleanTask: save divertTactics, deviceName=" + divertTactics.getDeviceName() + ", zoneIp=" + divertTactics.getDivertIp()));
                    }
                }
            }
        } else {
            return result;
        }
        Collection proxies = proxyMap.values();
        for (DeviceProxy deviceProxy : proxies) {
            deviceProxy.close();
        }
        if (null != sshConn) {
            this.logger.info((Object)"@execTelnet,EXE CLI close Telnet connected");
            sshConn.close();
            sshConn = null;
        }
        if (null != telConn) {
            this.logger.info((Object)"@execTelnet,EXE CLI close Telnet connected");
            telConn.close();
            telConn = null;
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        return result;
    }

    private DivertTacticsLogForm getTacticsLog(DivertTactics divertTactics) {
        DivertTacticsLogForm divertTacticsLogForm = new DivertTacticsLogForm();
        divertTacticsLogForm.setZoneId(divertTactics.getZoneId());
        divertTacticsLogForm.setDeviceId(divertTactics.getDeviceId());
        divertTacticsLogForm.setOperator(divertTactics.getOperator());
        divertTacticsLogForm.setClientIp(divertTactics.getClientIp());
        String ipAddress = divertTactics.getDivertIp();
        if (ipAddress.contains("/")) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf("/"));
        }
        divertTacticsLogForm.setDivertIp(ipAddress);
        divertTactics.setDivertIp(ipAddress);
        String[] ipRange = IPUtil.getSubnetRange((String)ipAddress, (int)divertTactics.getMask());
        if (ipRange != null && ipRange.length == 2) {
            divertTacticsLogForm.setStartIp(ipRange[0]);
            divertTacticsLogForm.setEndIp(ipRange[1]);
        }
        if (!AticUtil.isNull((String)divertTactics.getVpnName())) {
            divertTacticsLogForm.setVpnName(divertTactics.getVpnName());
        } else {
            divertTacticsLogForm.setVpnName("--");
        }
        divertTacticsLogForm.setMask(divertTactics.getMask());
        divertTacticsLogForm.setLogTime(Long.valueOf(System.currentTimeMillis() / 1000L));
        divertTacticsLogForm.setDivertMode(divertTactics.getDivertMode());
        return divertTacticsLogForm;
    }

    public void fillDivertLog(DivertTacticsLogForm divertTacticsLogForm, int operType, int logLevel, int result, String remark) {
        if (null == divertTacticsLogForm) {
            return;
        }
        divertTacticsLogForm.setOperType(Integer.valueOf(operType));
        divertTacticsLogForm.setLevel(Integer.valueOf(logLevel));
        divertTacticsLogForm.setRemark(remark);
        divertTacticsLogForm.setResult(result);
        DivertTacticsLog divertTacticsLog = (DivertTacticsLog)AticUtil.copyProperties((Object)divertTacticsLogForm, (Object)new DivertTacticsLog());
        divertTacticsLog.setStartIp(IPUtil4Atic.convert2CompleteIp((String)divertTacticsLog.getStartIp()));
        divertTacticsLog.setEndIp(IPUtil4Atic.convert2CompleteIp((String)divertTacticsLog.getEndIp()));
        this.divertTacticsLogDao.saveOrUpdate((Object)divertTacticsLog);
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private Integer cmdResult(String cmdResult) {
        if (cmdResult.contains("Error: Invalid IP address")) {
            return 571208;
        }
        if (cmdResult.contains("Error: The number of IP addresses of traffic diversion reaches limit already")) {
            return 571209;
        }
        if (cmdResult.contains("Error: Please specify IP address of next hop first")) {
            return 571210;
        }
        if (cmdResult.contains("Error: Traffic IP addresses conflict")) {
            return 571211;
        }
        if (cmdResult.contains("Error: The IP address does not exist")) {
            return 1;
        }
        if (cmdResult.contains("Error: This traffic diversion policy does not exist")) {
            return 571212;
        }
        if (cmdResult.contains("Route-Distinguisher has not been set to this VPN-Instance")) {
            return 571214;
        }
        if (cmdResult.contains("The specified VPN-Instance does not exist")) {
            return 571215;
        }
        if (cmdResult.contains("The static route of this policy is the same as an existing one")) {
            return 571216;
        }
        if (cmdResult.contains("Info: The system is busy in collecting the current configuration. Please wait...")) {
            return 571217;
        }
        if (cmdResult.contains("The system is busy in saving or comparing the current configuration. Please wait...")) {
            return 571217;
        }
        if (cmdResult.contains("Error:")) {
            return 570503;
        }
        return 1;
    }

    private Integer cmdResultOfDispaly(String cmdResultOfDispaly) {
        if (cmdResultOfDispaly.contains("Summary Count : 1")) {
            return 1;
        }
        return 571992;
    }

    public void saveDivertTactics(DivertTacticsForm divertTacticsForm) {
        if (null == divertTacticsForm) {
            this.logger.error((Object)"can't save null divertTactics");
            return;
        }
        DivertTactics divertTactics = (DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics());
        if (null != this.zoneDeviceService) {
            Long zoneId = divertTactics.getZoneId();
            Long deviceId = divertTactics.getDeviceId();
            if (null != zoneId && null != deviceId && (divertTactics.getVpnName() == null || "".equals(divertTactics.getVpnName()))) {
                String vpnName = "";
                ZoneDeviceForm zoneDeviceForm = this.zoneDeviceService.findZoneDeviceFormByZoneIdAndDeviceId(zoneId, deviceId);
                if (null != zoneDeviceForm && !AticUtil.isNullForVpn((String)zoneDeviceForm.getVpnName())) {
                    vpnName = zoneDeviceForm.getVpnName();
                }
                divertTactics.setVpnName(vpnName);
            }
        }
        divertTactics.setStartIp(IPUtil4Atic.convert2CompleteIp((String)divertTactics.getStartIp()));
        divertTactics.setEndIp(IPUtil4Atic.convert2CompleteIp((String)divertTactics.getEndIp()));
        this.divertTacticsDao.saveOrUpdate((Object)divertTactics);
        this.logger.info((Object)("save divertTactics, deviceName=" + divertTacticsForm.getDeviceName() + ", zoneIp=" + divertTacticsForm.getDivertIp()));
    }

    public boolean isExist(DivertTacticsForm divertTacticsForm) {
        return this.divertTacticsDao.isExist((DivertTactics)AticUtil.copyProperties((Object)divertTacticsForm, (Object)new DivertTactics()));
    }

    public IDivertTacticsService getDivertTacticsService() {
        return this.divertTacticsService;
    }

    public void setDivertTacticsService(IDivertTacticsService divertTacticsService) {
        this.divertTacticsService = divertTacticsService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public DivertTacticsDao getDivertTacticsDao() {
        return this.divertTacticsDao;
    }

    public void setDivertTacticsDao(DivertTacticsDao divertTacticsDao) {
        this.divertTacticsDao = divertTacticsDao;
    }

    public DivertTacticsLogDao getDivertTacticsLogDao() {
        return this.divertTacticsLogDao;
    }

    public void setDivertTacticsLogDao(DivertTacticsLogDao divertTacticsLogDao) {
        this.divertTacticsLogDao = divertTacticsLogDao;
    }

    public DivertAlarmHandler getDivertAlarmHandler() {
        return this.divertAlarmHandler;
    }

    public void setDivertAlarmHandler(DivertAlarmHandler divertAlarmHandler) {
        this.divertAlarmHandler = divertAlarmHandler;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public OperateTaskUnicomService getOperateTaskService() {
        return this.operateTaskService;
    }

    public void setOperateTaskService(OperateTaskUnicomService operateTaskService) {
        this.operateTaskService = operateTaskService;
    }
}

