/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.unicom.impl;

import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.unicom.AticCleanLogService;
import com.hs.atic.rmi.unicom.CleanLogEntity;
import com.hs.atic.rmi.unicom.UnicomSocRmiService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.unicom.rmi.model.CleanLogBuffer;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;

public class AticCleanLogServiceImpl
extends UnicastRemoteObject
implements AticCleanLogService {
    private static final long serialVersionUID = 8562668850776427195L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private transient CleanLogBuffer buffer;
    private transient UnicomSocRmiService unicomSocRmiService;

    public AticCleanLogServiceImpl() throws RemoteException {
    }

    public AticCleanLogServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        this.unicomSocRmiService = (UnicomSocRmiService)ServiceContext.getInstance().getService("unicomSocRmiService", UnicomSocRmiService.class);
        this.buffer = this.unicomSocRmiService.getCleanLogBuffer();
    }

    public CleanLogBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(CleanLogBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void processCleanLogs(List<CleanLogEntity> cleanLogList) throws RemoteException {
        if (null == cleanLogList || cleanLogList.isEmpty()) {
            this.logger.info((Object)"CleanLongForDdos cleanLogList is null");
            return;
        }
        this.logger.info((Object)("CleanLongForDdos data size : " + cleanLogList.size()));
        if (cleanLogList.size() > 10000) {
            this.logger.info((Object)"CleanLongForDdos data size too long");
            return;
        }
        try {
            this.buffer.addCleanLogList(cleanLogList);
        }
        catch (Exception e) {
            this.logger.error((Object)"processCleanLogs error", (Throwable)e);
        }
    }

    public UnicomSocRmiService getUnicomSocRmiService() {
        return this.unicomSocRmiService;
    }

    public void setUnicomSocRmiService(UnicomSocRmiService unicomSocRmiService) {
        this.unicomSocRmiService = unicomSocRmiService;
    }
}

