/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.model;

import com.hs.atic.sdk.bis.unicom.entity.RestCleanStartTaskInfo;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStopTaskInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;

public class CleanTaskBuffer {
    private static final int MAX_SIZE = 10000;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private final String unicomPath = File.separator + "vsm_conf" + File.separator + "antiddos" + File.separator + "unicom" + File.separator + "unicom.xml";
    private BlockingQueue<RestCleanStartTaskInfo> startQueue = new ArrayBlockingQueue<RestCleanStartTaskInfo>(10000);
    private BlockingQueue<RestCleanStopTaskInfo> stopQueue = new ArrayBlockingQueue<RestCleanStopTaskInfo>(10000);
    private Map<String, String> configMap = new ConcurrentHashMap<String, String>();

    public CleanTaskBuffer() {
        this.getUnicomConfigData();
    }

    public BlockingQueue<RestCleanStartTaskInfo> getStartQueue() {
        return this.startQueue;
    }

    public void setStartQueue(BlockingQueue<RestCleanStartTaskInfo> startQueue) {
        this.startQueue = startQueue;
    }

    public BlockingQueue<RestCleanStopTaskInfo> getStopQueue() {
        return this.stopQueue;
    }

    public void setStopQueue(BlockingQueue<RestCleanStopTaskInfo> stopQueue) {
        this.stopQueue = stopQueue;
    }

    public Map<String, String> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<String, String> configMap) {
        this.configMap = configMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getUnicomConfigData() {
        InputStream iStream = null;
        try {
            this.logger.info((Object)"------begin to read unicom.xml-------");
            String pathName = AticInstallUtil.getInstance().getAticInstallPath() + this.unicomPath;
            Properties properties = new Properties();
            iStream = new FileInputStream(pathName);
            properties.loadFromXML(iStream);
            String isOpen = properties.getProperty("atic.unicom.isOpen");
            String cleanTaskStartUri = properties.getProperty("unicom.uri.cleanTaskStartUri");
            String cleanTaskStopUri = properties.getProperty("unicom.uri.cleanTaskStopUri");
            this.configMap.put("isOpen", isOpen.trim());
            this.configMap.put("cleanTaskStartUri", cleanTaskStartUri.trim());
            this.configMap.put("cleanTaskStopUri", cleanTaskStopUri.trim());
            this.logger.info((Object)"------end to read unicom.xml-------");
        }
        catch (IOException e) {
            this.logger.error((Object)"------read unicom.xml  occur exception-------");
            e.printStackTrace();
        }
        finally {
            try {
                if (null != iStream) {
                    iStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

