/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.restful.daemon;

import com.hs.atic.sdk.bis.unicom.entity.DeployResult;
import com.hs.atic.sdk.bis.unicom.entity.TaskOperateUnicomEntity;
import com.hs.atic.sdk.bis.unicom.service.OperateTaskUnicomService;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.model.ZoneListIpInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.ddos.common.CommandPair;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpData;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpThreadPool;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.service.impl.ExcmdConnectUtil;
import com.huawei.atic.secne.service.impl.ExcmdConnectionPool;
import com.huawei.atic.south.model.TelnetPara;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MoveZoneIpStopThread
extends Thread {
    private static final long DESTROY_TIME = 1800000L;
    private static final String DEPLOYZONEIP = "undoZoneIp";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private IAticDeviceService aticDeviceService;
    private OperateTaskUnicomService operateTaskService;
    private String deviceIp;
    private Map<CommandPair, DeployResult> moveIpDeployResult;
    private boolean active = true;
    private List<MoveZoneIpData> nowProcessing = new ArrayList<MoveZoneIpData>();
    private long threadWorkMillis = System.currentTimeMillis();

    public MoveZoneIpStopThread(String deviceIp, IAticDeviceService aticDeviceService, OperateTaskUnicomService operateTaskService, Map<CommandPair, DeployResult> moveIpDeployResult) {
        this.setName("MoveIpStopThread_" + deviceIp);
        this.deviceIp = deviceIp;
        this.aticDeviceService = aticDeviceService;
        this.operateTaskService = operateTaskService;
        this.moveIpDeployResult = moveIpDeployResult;
        this.logger.info((Object)("construct a undo zone ip thread, deviceIp=" + deviceIp));
    }

    @Override
    public void run() {
        while (this.active) {
            List<MoveZoneIpData> moveIpDataList = this.getBatchData();
            if (null != moveIpDataList && !moveIpDataList.isEmpty()) {
                this.threadWorkMillis = System.currentTimeMillis();
                for (MoveZoneIpData moveZoneIpData : moveIpDataList) {
                    Map<CommandPair, DeployResult> result = null;
                    try {
                        result = this.undoDeployZoneIp(moveZoneIpData.getCommandDeployResult(), moveZoneIpData.getDeviceId(), moveZoneIpData.getDestZoneName(), moveZoneIpData.getZoneIptemp(), moveZoneIpData.isIpv4(), moveZoneIpData.getTaskId(), moveZoneIpData.getResultMap());
                        this.logger.info((Object)("undoDeployZoneIp method result is" + result));
                        this.moveIpDeployResult.putAll(result);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e);
                    }
                }
                continue;
            }
            if (1800000L < System.currentTimeMillis() - this.threadWorkMillis) {
                MoveZoneIpThreadPool.removeStop(this.deviceIp);
                this.logger.info((Object)("construct a move zone ip stop thread is destroyed by pool, deviceIp=" + this.deviceIp));
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MoveZoneIpData> getBatchData() {
        List<MoveZoneIpData> list = this.nowProcessing;
        synchronized (list) {
            if (this.nowProcessing.size() > 0) {
                ArrayList<MoveZoneIpData> result = new ArrayList<MoveZoneIpData>();
                result.addAll(this.nowProcessing);
                this.nowProcessing.clear();
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUndoZoneIpData(MoveZoneIpData zoneIpData) {
        List<MoveZoneIpData> list = this.nowProcessing;
        synchronized (list) {
            this.nowProcessing.add(zoneIpData);
            this.logger.info((Object)("add undo zone ip : " + zoneIpData.getZoneIptemp().getStartIp()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<CommandPair, DeployResult> undoDeployZoneIp(Map<CommandPair, DeployResult> commandDeployResult, Long deviceId, String destZoneName, ZoneIpForm zoneIptemp, boolean isIpv4, String taskId, Map<String, BatchOperationResult> resultMap) {
        String errorMsgKey = "--";
        String errorParam = "";
        String cmdUndo = isIpv4 ? "undo ip address " : "undo ipv6 address ";
        TelnetPara telnetPara = this.aticDeviceService.getDeviceTelnetPara(deviceId.longValue());
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceId.longValue());
        if (null == aticDevice || null == telnetPara) {
            return commandDeployResult;
        }
        if (5 == aticDevice.getDeviceType() || 7 == aticDevice.getDeviceType()) {
            return commandDeployResult;
        }
        ExcmdConnectUtil excmdConnectUtil = null;
        String device01Ip = aticDevice.getIpAddress();
        try {
            excmdConnectUtil = ExcmdConnectionPool.getInstance().getExcmdConnectUtil(telnetPara);
            ArrayList<String> cmdSys = new ArrayList<String>();
            cmdSys.add("sys");
            cmdSys.add("ddos-zone name " + destZoneName);
            ArrayList<String> cmdIp = new ArrayList<String>();
            cmdIp.add(cmdUndo + zoneIptemp.getZoneIp() + " " + zoneIptemp.getMask());
            int tryCount = 3;
            List result = null;
            for (int i = 0; i < tryCount; ++i) {
                try {
                    CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmdSys, (boolean)true);
                    result = CmdUtil.execCmds((ExcmdConnectUtil)excmdConnectUtil, cmdIp, (boolean)false);
                    break;
                }
                catch (LegoCheckedException e) {
                    this.logger.info((Object)("undoDeployZoneIp error and try " + i));
                    if (2 > i) continue;
                    throw e;
                }
            }
            this.logger.info((Object)("undoDeployZoneIp result is" + (null == result ? null : result.toString())));
            Boolean flag = VsmUtil.getInstance().checkCmdResult(result);
            TaskOperateUnicomEntity taskOperate = new TaskOperateUnicomEntity();
            if (!flag.booleanValue()) {
                this.logger.error((Object)("err : move destination action error, zone name :" + destZoneName + " zone ip :" + zoneIptemp.getStartIp()));
                String detail = "deploy undo zoneIp error!";
                this.execRestOperLog(taskId, zoneIptemp, device01Ip, detail, resultMap);
            } else {
                taskOperate.setTaskId(taskId);
                taskOperate.setCommand(DEPLOYZONEIP);
                taskOperate.setCleanEq(device01Ip);
                taskOperate.setProtectIp(zoneIptemp.getZoneIp() + "/" + zoneIptemp.getMask());
                taskOperate.setExecutTime(System.currentTimeMillis() / 1000L);
                taskOperate.setStatus(0);
                taskOperate.setErrorCode(0);
                taskOperate.setDetail("deploy undo zoneIp successful!");
                this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                this.deployIpResult(commandDeployResult, zoneIptemp.getZoneId(), flag, aticDevice.getMoId(), zoneIptemp.getId(), errorMsgKey, errorParam);
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)("move destination action error, zone name :" + destZoneName + " zone ip :" + zoneIptemp.getStartIp()));
            StringBuffer detail = new StringBuffer();
            detail.append("deploy undo zoneIp error! ");
            String msg = AticUtil.getText((String)("lego.err." + e.getErrorCode()), (Locale)new Locale("en"));
            detail.append(msg);
            this.execRestOperLog(taskId, zoneIptemp, device01Ip, detail.toString(), resultMap);
            errorMsgKey = "lego.err." + e.getErrorCode();
            this.deployIpResult(commandDeployResult, zoneIptemp.getZoneId(), false, aticDevice.getMoId(), zoneIptemp.getId(), errorMsgKey, errorParam);
        }
        finally {
            ExcmdConnectionPool.getInstance().excmdConnectionRelease(aticDevice.getMoId(), excmdConnectUtil);
        }
        return commandDeployResult;
    }

    private void execRestOperLog(String taskId, ZoneIpForm zoneIptemp, String devcieIp, String detail, Map<String, BatchOperationResult> resultMap) {
        TaskOperateUnicomEntity taskOperate = new TaskOperateUnicomEntity();
        taskOperate.setTaskId(taskId);
        taskOperate.setCommand(DEPLOYZONEIP);
        taskOperate.setCleanEq(devcieIp);
        taskOperate.setProtectIp(zoneIptemp.getZoneIp() + "/" + zoneIptemp.getMask());
        taskOperate.setExecutTime(System.currentTimeMillis() / 1000L);
        taskOperate.setStatus(1);
        taskOperate.setErrorCode(2);
        taskOperate.setDetail(detail);
        this.operateTaskService.saveOperateTaskUnicom(taskOperate);
        BatchOperationResult operationResult = this.createUndoDeployResult(taskOperate.getDetail());
        if (null == resultMap.get(devcieIp)) {
            resultMap.put(devcieIp, operationResult);
        } else {
            BatchOperationResult boLast = resultMap.get(devcieIp);
            List resultLast = boLast.getResult();
            List resultTemp = operationResult.getResult();
            for (BatchOperation b : resultTemp) {
                resultLast.add(b);
            }
            boLast.setResult(resultLast);
            boLast.setFailCount(boLast.getFailCount() + operationResult.getFailCount());
            boLast.setSucceedCount(boLast.getSucceedCount() + operationResult.getSucceedCount());
            boLast.setTotalCount(boLast.getTotalCount() + operationResult.getTotalCount());
            resultMap.put(devcieIp, boLast);
        }
    }

    private BatchOperationResult createUndoDeployResult(String detail) {
        this.logger.info((Object)"undoDeploy zoneIp fail start!");
        BatchOperationResult operationResult = new BatchOperationResult();
        ArrayList<BatchOperation> result = new ArrayList<BatchOperation>();
        BatchOperation bo = new BatchOperation();
        bo.setOptDetail(detail);
        result.add(bo);
        operationResult.setFailCount(1);
        operationResult.setSucceedCount(0);
        operationResult.setTotalCount(1);
        operationResult.setResult(result);
        this.logger.info((Object)"undoDeploy zoneIp fail end!");
        return operationResult;
    }

    private void deployIpResult(Map<CommandPair, DeployResult> commandDeployResult, Long zoneId, boolean flag, Long deviceId, Long id, String errorMsgKey, String errorParam) {
        this.logger.info((Object)("zoneId = " + zoneId + "; deviceId = " + deviceId + "; id = " + id + "; flag = " + flag));
        Set<CommandPair> commandPairSet = commandDeployResult.keySet();
        if (null != id) {
            CommandPair curCommand = new CommandPair(zoneId, deviceId, ZoneListIpInfo.class.getSimpleName(), id);
            DeployResult deployResult = new DeployResult();
            if (flag) {
                if (!commandPairSet.contains(curCommand)) {
                    deployResult.setIsDeployOk(true);
                    deployResult.setErrorMsgKey("--");
                    deployResult.setErrorParam("");
                    commandDeployResult.put(curCommand, deployResult);
                }
            } else if (!commandPairSet.contains(curCommand) || commandDeployResult.get(curCommand).getIsDeployOk().booleanValue()) {
                deployResult.setIsDeployOk(false);
                deployResult.setErrorMsgKey(errorMsgKey);
                deployResult.setErrorParam(errorParam);
                commandDeployResult.put(curCommand, deployResult);
            }
        }
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public OperateTaskUnicomService getOperateTaskService() {
        return this.operateTaskService;
    }

    public void setOperateTaskService(OperateTaskUnicomService operateTaskService) {
        this.operateTaskService = operateTaskService;
    }

    public Map<CommandPair, DeployResult> getMoveIpDeployResult() {
        return this.moveIpDeployResult;
    }

    public void setMoveIpDeployResult(Map<CommandPair, DeployResult> moveIpDeployResult) {
        this.moveIpDeployResult = moveIpDeployResult;
    }
}

