/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.restful.daemon;

import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.unicom.entity.DeployResult;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStartProtectDetailInfo;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStartTaskInfo;
import com.hs.atic.sdk.bis.unicom.entity.TaskOperateUnicomEntity;
import com.hs.atic.sdk.bis.unicom.entity.TaskUnicomEntity;
import com.hs.atic.sdk.bis.unicom.service.IUnicomDivertTacticsService;
import com.hs.atic.sdk.bis.unicom.service.OperateTaskUnicomService;
import com.hs.atic.sdk.bis.unicom.service.TaskUnicomService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.form.ZoneListIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CommandPair;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.hs.vsm.secservice.nfa.util.JSONUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceDeployStatusForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceDeployStatusService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.unicom.restful.model.RestCleanEqStatus;
import com.hs.vsm.secservice.sdk.unicom.restful.model.RestCleanTaskStartResultInfo;
import com.hs.vsm.secservice.sdk.unicom.restful.service.CleanTaskBufferService;
import com.hs.vsm.secservice.sdk.unicom.restful.service.RestfulCleanService;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpData;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpStartThread;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpThreadPool;
import com.hs.vsm.secservice.unicom.restful.daemon.UnicomData;
import com.hs.vsm.secservice.unicom.restful.daemon.UnicomDivertThreadPool;
import com.hs.vsm.secservice.unicom.restful.daemon.UnicomStartThread;
import com.hs.vsm.secservice.unicom.restful.daemon.UpdateZoneStatusTools;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNexthop;
import com.huawei.atic.policy.third.service.IDivertForPolicy;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.south.model.TelnetPara;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RestCleanTaskStartThread
extends Thread {
    private static final String DATEFORMATE = "yyyy-MM-dd HH:mm:ss";
    private static final String CLEANTASKSTART = "cleanTaskStart";
    private boolean isOpen = false;
    private String cleanTaskStartUrl = "http://host:port/rest";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private RestfulCleanService restfulCleanService;
    private CleanTaskBufferService cleanTaskBufferService;
    private IZoneService zoneService;
    private IAticDeviceService aticDeviceService;
    private IZoneDeviceDeployStatusService zoneDeviceDeployStatusService;
    private IUnicomDivertTacticsService unicomDivertTacticsService;
    private IZoneDeviceService zoneDeviceService;
    private TaskUnicomService taskUnicomService;
    private OperateTaskUnicomService operateTaskService;
    private Map<String, BatchOperationResult> startResult = new ConcurrentHashMap<String, BatchOperationResult>();
    private Map<CommandPair, DeployResult> moveIpDeployResult = new ConcurrentHashMap<CommandPair, DeployResult>();
    private UpdateZoneStatusTools updateZoneStatusTools;

    public RestCleanTaskStartThread() {
        this.setName("RestCleanTaskStartThread");
    }

    private void configThread() {
        this.isOpen = Boolean.parseBoolean(this.cleanTaskBufferService.getConfigMapValue("isOpen"));
        this.cleanTaskStartUrl = this.cleanTaskBufferService.getConfigMapValue("cleanTaskStartUri");
        this.logger.info((Object)("unicom.properties file:[isOpen:" + this.isOpen + ",cleanTaskStartUrl:" + this.cleanTaskStartUrl + "]."));
    }

    @Override
    public void run() {
        this.configThread();
        RestCleanStartTaskInfo cleanTaskStart = null;
        this.logger.info((Object)"RestCleanTaskStartThread start");
        while (this.isOpen) {
            try {
                this.logger.info((Object)"RestCleanTaskStartThread is  open!");
                cleanTaskStart = this.cleanTaskBufferService.takeCleanStartTask();
                this.logger.info((Object)"CleanTaskBuffer:  StartQueue data  has data,begin exec cleanTask!");
                this.cleanTaskStart(cleanTaskStart);
            }
            catch (Exception e) {
                this.logger.error((Object)"RestCleanTaskStartThread occur exception:", (Throwable)e);
            }
        }
    }

    private void cleanTaskStart(RestCleanStartTaskInfo restCleanStartInfo) {
        String taskId = restCleanStartInfo.getTaskId();
        String terminalIp = restCleanStartInfo.getClientIp();
        String userName = restCleanStartInfo.getUserName();
        HashMap<String, BatchOperationResult> resultMap = new HashMap<String, BatchOperationResult>();
        HashMap<String, Long> timeMap = new HashMap<String, Long>();
        Map<String, List<DivertTacticsForm>> divertTacticsFormMap = this.createDivertTacticsForm(restCleanStartInfo, resultMap, timeMap, userName);
        Map<String, List<BatchOperation>> batchOperationMap = this.convertDivertTacticsForm(divertTacticsFormMap);
        ArrayList<UnicomData> unicomDatas = new ArrayList<UnicomData>();
        for (Map.Entry<String, List<BatchOperation>> entry : batchOperationMap.entrySet()) {
            String string = entry.getKey();
            this.logger.info((Object)("RestCleanTaskStartThread for deviceIp to deploy:" + string));
            try {
                UnicomData unicomData = new UnicomData();
                unicomData.setTaskId(taskId);
                unicomData.setBatchMapValue(entry.getValue());
                unicomData.setUserName(userName);
                unicomData.setTerminalIp(terminalIp);
                UnicomStartThread startThread = UnicomDivertThreadPool.getStart(string);
                if (null == startThread) {
                    UnicomStartThread unicomTaskThread = new UnicomStartThread(string, this.unicomDivertTacticsService, this.startResult);
                    unicomTaskThread.start();
                    UnicomDivertThreadPool.putStart(string, unicomTaskThread);
                }
                unicomDatas.add(unicomData);
                UnicomDivertThreadPool.getStart(string).addDivertData(unicomDatas);
                unicomDatas.clear();
            }
            catch (Exception e) {
                this.logger.error((Object)"RestCleanTaskStartThread occur exception when batchAddUnicomDivertTactics:", (Throwable)e);
            }
        }
        int count = 0;
        do {
            for (Map.Entry<String, BatchOperationResult> entry : this.startResult.entrySet()) {
                if (!batchOperationMap.containsKey(entry.getKey())) continue;
                if (null == resultMap.get(entry.getKey())) {
                    resultMap.put(entry.getKey(), entry.getValue());
                } else {
                    BatchOperationResult boLast = (BatchOperationResult)resultMap.get(entry.getKey());
                    List resultLast = boLast.getResult();
                    List resultTemp = entry.getValue().getResult();
                    resultLast.addAll(resultTemp);
                    boLast.setResult(resultLast);
                    boLast.setFailCount(boLast.getFailCount() + entry.getValue().getFailCount());
                    boLast.setSucceedCount(boLast.getSucceedCount() + entry.getValue().getSucceedCount());
                    boLast.setTotalCount(boLast.getTotalCount() + entry.getValue().getTotalCount());
                    resultMap.put(entry.getKey(), boLast);
                }
                this.startResult.remove(entry.getKey());
                timeMap.put(entry.getKey(), System.currentTimeMillis() / 1000L);
                ++count;
            }
        } while (count < batchOperationMap.size());
        this.logger.info((Object)("start taskId=" + taskId + ",resultMap=" + resultMap.size() + ",timeMap=" + timeMap));
        RestCleanTaskStartResultInfo restCleanTaskStartResultInfo = this.handleBatchOperationResult(resultMap, timeMap, taskId);
        TaskUnicomEntity taskUnicomEntity = this.taskUnicomService.getTaskUnicomById(taskId);
        if (null == taskUnicomEntity) {
            return;
        }
        if ("0".equals(restCleanTaskStartResultInfo.getStartStatus())) {
            taskUnicomEntity.setStatus("2");
        } else if ("1".equals(restCleanTaskStartResultInfo.getStartStatus())) {
            taskUnicomEntity.setStatus("3");
        } else {
            taskUnicomEntity.setStatus("4");
        }
        this.taskUnicomService.saveTaskUnicom(taskUnicomEntity);
        this.logger.info((Object)"RestCleanTaskStartThread update to TaskUnicomEntity success!");
        try {
            String json = JSONUtil.getInstance().toJSON((Object)restCleanTaskStartResultInfo);
            this.restfulCleanService.restCleanTaskStartResult(json, this.cleanTaskStartUrl);
        }
        catch (Exception e) {
            this.logger.error((Object)"RestCleanTaskStartThread occur exception when Calling unicom interface :", (Throwable)e);
        }
    }

    private Map<String, List<DivertTacticsForm>> createDivertTacticsForm(RestCleanStartTaskInfo restCleanStartInfo, Map<String, BatchOperationResult> resultMap, Map<String, Long> timeMap, String userName) {
        this.logger.info((Object)"RestCleanTaskStartThread  begin to create divert!");
        String taskId = restCleanStartInfo.getTaskId();
        String terminalIp = restCleanStartInfo.getClientIp();
        List<String> protectIPs = restCleanStartInfo.getProtectIPs();
        List<RestCleanStartProtectDetailInfo> protectDetailInfos = restCleanStartInfo.getProtectDetail();
        HashMap<String, List<DivertTacticsForm>> divertTacticsFormMap = new HashMap<String, List<DivertTacticsForm>>();
        String destZoneName = "";
        Long destZoneId = null;
        Iterator<RestCleanStartProtectDetailInfo> iterator = protectDetailInfos.iterator();
        if (iterator.hasNext()) {
            RestCleanStartProtectDetailInfo reStartProtectDetailInfo = iterator.next();
            destZoneName = reStartProtectDetailInfo.getStrategyName();
            ZoneInfoForm zoneInfoForm = this.zoneService.getZoneByName(destZoneName);
            destZoneId = zoneInfoForm.getZoneId();
        }
        Map<CommandPair, DeployResult> commandDeployResult = this.moveZoneAndDeployZoneIp(restCleanStartInfo, destZoneName, destZoneId, userName, resultMap);
        try {
            this.updateZoneStatusTools.saveDeployStatus(commandDeployResult);
        }
        catch (Exception e) {
            this.logger.error((Object)"saveDeployStatus error!", (Throwable)e);
        }
        for (int k = 0; k < protectDetailInfos.size(); ++k) {
            RestCleanStartProtectDetailInfo protectDetailInfo = protectDetailInfos.get(k);
            List<String> deviceIPs = protectDetailInfo.getDeviceIPs();
            String cleanType = protectDetailInfo.getCleanType();
            TaskOperateUnicomEntity taskOperate = new TaskOperateUnicomEntity();
            BatchOperationResult result = null;
            int deviceIPsLeng = deviceIPs.size();
            for (int i = 0; i < deviceIPsLeng; ++i) {
                ZoneDeviceForm zoneDeviceForm;
                ZoneDeviceDeployStatusForm zoneDeviceDeployStatusForm;
                ArrayList<DivertTacticsForm> divertTacticsForms = new ArrayList<DivertTacticsForm>();
                DivertTacticsForm divertTacticsForm = null;
                AticDevice device = this.aticDeviceService.getDeviceByIp(deviceIPs.get(i));
                Long deviceId = device.getMoId();
                if (null != destZoneId && null == (zoneDeviceDeployStatusForm = this.zoneDeviceDeployStatusService.getByZoneIdAndDeviceId(destZoneId, deviceId))) {
                    result = this.createStartResult(restCleanStartInfo, deviceIPs.get(i));
                    this.logger.warn((Object)"RestCleanTaskStartThread zone not deploy to device!");
                    if (null == resultMap.get(deviceIPs.get(i))) {
                        resultMap.put(deviceIPs.get(i), result);
                    } else {
                        BatchOperationResult boLast = resultMap.get(deviceIPs.get(i));
                        List resultLast = boLast.getResult();
                        List resultTemp = result.getResult();
                        for (BatchOperation b : resultTemp) {
                            resultLast.add(b);
                        }
                        boLast.setResult(resultLast);
                        boLast.setFailCount(boLast.getFailCount() + result.getFailCount());
                        boLast.setSucceedCount(boLast.getSucceedCount() + result.getSucceedCount());
                        boLast.setTotalCount(boLast.getTotalCount() + result.getTotalCount());
                        resultMap.put(deviceIPs.get(i), boLast);
                    }
                    timeMap.put(deviceIPs.get(i), System.currentTimeMillis() / 1000L);
                    taskOperate.setTaskId(taskId);
                    taskOperate.setCommand(CLEANTASKSTART);
                    taskOperate.setCleanEq(deviceIPs.get(i));
                    taskOperate.setProtectIp("--");
                    taskOperate.setExecutTime(System.currentTimeMillis() / 1000L);
                    taskOperate.setStatus(1);
                    taskOperate.setErrorCode(2);
                    taskOperate.setDetail("create failed, because zone not deploy to device!");
                    this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                    continue;
                }
                String vpnName = "";
                if (null != this.zoneDeviceService && null != (zoneDeviceForm = this.zoneDeviceService.findZoneDeviceFormByZoneIdAndDeviceId(destZoneId, deviceId)) && !AticUtil.isNullForVpn((String)zoneDeviceForm.getVpnName())) {
                    vpnName = zoneDeviceForm.getVpnName();
                }
                String nextHop = "";
                AticDeviceNexthop aticDeviceNexthop = null;
                if (cleanType != null && !"".equals(cleanType)) {
                    aticDeviceNexthop = this.aticDeviceService.getNexthopIpByDeviceIpAndCleanType(deviceIPs.get(i), cleanType);
                    this.logger.info((Object)("RestCleanTaskStartThread  get aticDeviceNexthop:" + aticDeviceNexthop.toString()));
                }
                int protectIPsLeng = protectIPs.size();
                for (int j = 0; j < protectIPsLeng; ++j) {
                    this.logger.info((Object)("RestCleanTaskStartThread  for protect_ip:" + protectIPs.get(j)));
                    String[] zoneIpDetails = protectIPs.get(j).split("/");
                    divertTacticsForm = new DivertTacticsForm();
                    String protectIp = zoneIpDetails[0];
                    boolean ipv4 = IPUtil.isIpv4((String)protectIp);
                    nextHop = ipv4 && "JYQX".equals(cleanType) ? aticDeviceNexthop.getJyqxIp() : (ipv4 && "JMDQX".equals(cleanType) ? aticDeviceNexthop.getJmdqxIp() : (!ipv4 && "JYQX".equals(cleanType) ? aticDeviceNexthop.getJyqxIpv6() : aticDeviceNexthop.getJmdqxIpv6()));
                    divertTacticsForm.setZoneId(destZoneId);
                    divertTacticsForm.setDeviceId(deviceId);
                    divertTacticsForm.setDeviceName(device.getName());
                    divertTacticsForm.setDivertMode(Integer.valueOf(2));
                    divertTacticsForm.setDivertIp(protectIp);
                    divertTacticsForm.setMask(Integer.valueOf(Integer.parseInt(zoneIpDetails[1])));
                    divertTacticsForm.setDivertIpAndMask(protectIPs.get(j));
                    String[] rangeIps = IPUtil.getSubnetRange((String)protectIp, (int)Integer.parseInt(zoneIpDetails[1]));
                    divertTacticsForm.setStartIp(rangeIps[0]);
                    divertTacticsForm.setEndIp(rangeIps[1]);
                    divertTacticsForm.setCreateTime(Long.valueOf(System.currentTimeMillis() / 1000L));
                    divertTacticsForm.setVpnName(vpnName);
                    if (nextHop != null) {
                        divertTacticsForm.setNextHop(nextHop);
                    }
                    divertTacticsForm.setClientIp(terminalIp + "(restful)");
                    divertTacticsForms.add(divertTacticsForm);
                }
                if (null == divertTacticsFormMap.get(deviceIPs.get(i)) || ((List)divertTacticsFormMap.get(deviceIPs.get(i))).isEmpty()) {
                    divertTacticsFormMap.put(deviceIPs.get(i), divertTacticsForms);
                    continue;
                }
                ((List)divertTacticsFormMap.get(deviceIPs.get(i))).addAll(divertTacticsForms);
            }
        }
        this.logger.info((Object)("RestCleanTaskStartThread  create divert over,and divertTacticsFormMap.size():" + divertTacticsFormMap.size()));
        return divertTacticsFormMap;
    }

    private Map<CommandPair, DeployResult> moveZoneAndDeployZoneIp(RestCleanStartTaskInfo restCleanStartInfo, String destZoneName, Long zoneId, String userName, Map<String, BatchOperationResult> resultMap) {
        List<String> protectIPs = restCleanStartInfo.getProtectIPs();
        String terminalIp = restCleanStartInfo.getClientIp();
        String taskId = restCleanStartInfo.getTaskId();
        int totalCount = 0;
        HashMap<CommandPair, DeployResult> operationMap = new HashMap<CommandPair, DeployResult>();
        for (String proectIp : protectIPs) {
            String[] zoneIpDetails = proectIp.split("/");
            String zoneIp = zoneIpDetails[0];
            String mask = zoneIpDetails[1];
            boolean isIpv4 = IPUtil.isIpv4((String)zoneIp);
            ZoneIpForm zoneIptemp = new ZoneIpForm();
            zoneIptemp.setZoneIp(zoneIp);
            zoneIptemp.setMask(Integer.valueOf(Integer.parseInt(mask)));
            String[] rangeIps = IPUtil.getSubnetRange((String)zoneIp, (int)Integer.parseInt(mask));
            zoneIptemp.setStartIp(rangeIps[0]);
            zoneIptemp.setEndIp(rangeIps[1]);
            List existForms = this.zoneService.findExistIp(zoneIptemp);
            if (null != existForms && !existForms.isEmpty()) {
                IDivertForPolicy divertTacticsService;
                List divertTacticsForms;
                ZoneIpForm sourceZoneIpForm = (ZoneIpForm)existForms.get(0);
                String sourceZoneIp = sourceZoneIpForm.getZoneIp();
                Integer sourceMask = sourceZoneIpForm.getMask();
                String[] sourceRangeIps = IPUtil.getSubnetRange((String)sourceZoneIp, (int)sourceMask);
                Long sourceZoneId = sourceZoneIpForm.getZoneId();
                ZoneInfoForm sourceZoneForm = this.zoneService.getZoneNOIpById(sourceZoneId);
                String sourceZoneName = sourceZoneForm.getZoneName();
                ZoneIpForm destZoneIpForm = zoneIptemp;
                ZoneListIpForm destZoneListIpForm = new ZoneListIpForm();
                destZoneListIpForm.setEndIp(zoneIptemp.getEndIp());
                destZoneListIpForm.setStartIp(zoneIptemp.getStartIp());
                destZoneListIpForm.setIntMask(zoneIptemp.getMask().intValue());
                destZoneListIpForm.setIpType(0);
                destZoneListIpForm.setMaskType(0);
                destZoneListIpForm.setZoneIp(zoneIptemp.getZoneIp());
                destZoneListIpForm.setDeleteFlag(Integer.valueOf(0));
                ZoneInfoForm destZoneForm = this.zoneService.getCustomZoneByName(destZoneName);
                ArrayList sourceZoneDevicelist = this.zoneDeviceService.queryZoneDeviceFormsByZoneID(sourceZoneForm.getZoneId());
                if (null == sourceZoneDevicelist || sourceZoneDevicelist.isEmpty()) {
                    this.logger.info((Object)"sourceZone not bonded devices");
                    continue;
                }
                List destZoneDevicelist = this.zoneDeviceService.queryZoneDeviceFormsByZoneID(destZoneForm.getZoneId());
                if (null == destZoneDevicelist || destZoneDevicelist.isEmpty()) {
                    this.logger.info((Object)"destZone not bonded devices");
                    continue;
                }
                zoneIptemp.setZoneId(destZoneForm.getZoneId());
                if (rangeIps[0].equals(sourceRangeIps[0]) && rangeIps[1].equals(sourceRangeIps[1])) {
                    if (destZoneName.equalsIgnoreCase(sourceZoneName)) {
                        sourceZoneDevicelist = new ArrayList();
                    } else {
                        this.zoneService.deleteSourceZoneIpAndZoneIpListAndAddDestZoneIp(sourceZoneIpForm, sourceZoneId.longValue(), zoneIp, destZoneIpForm, destZoneListIpForm, destZoneForm.getZoneId().longValue());
                    }
                } else {
                    sourceZoneDevicelist = new ArrayList();
                }
                try {
                    MoveZoneIpStartThread moveIpStartThread;
                    MoveZoneIpStartThread startThread;
                    MoveZoneIpData moveIpData;
                    AticDevice aticDevice;
                    TelnetPara telnetPara;
                    if (0 != sourceZoneDevicelist.size()) {
                        for (ZoneDeviceForm deviceForm : sourceZoneDevicelist) {
                            telnetPara = this.aticDeviceService.getDeviceTelnetPara(deviceForm.getDeviceId().longValue());
                            aticDevice = this.aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
                            if (null == aticDevice || null == telnetPara || 5 == aticDevice.getDeviceType() || 7 == aticDevice.getDeviceType()) continue;
                            moveIpData = new MoveZoneIpData();
                            moveIpData.setSrouceZoneDevice(deviceForm);
                            moveIpData.setSourceZoneName(sourceZoneName);
                            moveIpData.setDestZoneDevice(null);
                            moveIpData.setDestZoneName(null);
                            moveIpData.setZoneIptemp(zoneIptemp);
                            moveIpData.setIpv4(isIpv4);
                            moveIpData.setTaskId(taskId);
                            moveIpData.setResultMap(resultMap);
                            moveIpData.setCommandDeployResult(this.moveIpDeployResult);
                            startThread = MoveZoneIpThreadPool.getStart(aticDevice.getIpAddress());
                            if (null == startThread) {
                                moveIpStartThread = new MoveZoneIpStartThread(aticDevice.getIpAddress(), this.aticDeviceService, this.operateTaskService, this.moveIpDeployResult);
                                moveIpStartThread.start();
                                MoveZoneIpThreadPool.putStart(aticDevice.getIpAddress(), moveIpStartThread);
                            }
                            MoveZoneIpThreadPool.getStart(aticDevice.getIpAddress()).addMoveZoneIptData(moveIpData);
                            if (null == zoneIptemp.getId()) continue;
                            ++totalCount;
                        }
                    }
                    for (ZoneDeviceForm deviceForm : destZoneDevicelist) {
                        telnetPara = this.aticDeviceService.getDeviceTelnetPara(deviceForm.getDeviceId().longValue());
                        aticDevice = this.aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
                        if (null == aticDevice || null == telnetPara || 5 == aticDevice.getDeviceType() || 7 == aticDevice.getDeviceType()) continue;
                        moveIpData = new MoveZoneIpData();
                        moveIpData.setSrouceZoneDevice(null);
                        moveIpData.setSourceZoneName(null);
                        moveIpData.setDestZoneDevice(deviceForm);
                        moveIpData.setDestZoneName(destZoneName);
                        moveIpData.setZoneIptemp(zoneIptemp);
                        moveIpData.setIpv4(isIpv4);
                        moveIpData.setTaskId(taskId);
                        moveIpData.setResultMap(resultMap);
                        moveIpData.setCommandDeployResult(this.moveIpDeployResult);
                        startThread = MoveZoneIpThreadPool.getStart(aticDevice.getIpAddress());
                        if (null == startThread) {
                            moveIpStartThread = new MoveZoneIpStartThread(aticDevice.getIpAddress(), this.aticDeviceService, this.operateTaskService, this.moveIpDeployResult);
                            moveIpStartThread.start();
                            MoveZoneIpThreadPool.putStart(aticDevice.getIpAddress(), moveIpStartThread);
                        }
                        MoveZoneIpThreadPool.getStart(aticDevice.getIpAddress()).addMoveZoneIptData(moveIpData);
                        if (null == zoneIptemp.getId()) continue;
                        ++totalCount;
                    }
                }
                catch (LegoCheckedException e) {
                    this.logger.error((Object)"deploy zoneIp error", (Throwable)e);
                }
                if ((divertTacticsForms = (divertTacticsService = ZoneReferUtil.getDivertForPolicyService()).getDivertTacticsByIp(zoneIptemp.getStartIp(), zoneIptemp.getEndIp())).isEmpty()) continue;
                ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
                for (DivertTacticsForm divertTacticsForm : divertTacticsForms) {
                    BatchOperation bo = new BatchOperation();
                    bo.setTargetId(divertTacticsForm.getId().longValue());
                    bo.setTargetName("(" + divertTacticsForm.getDeviceName() + ", IP :" + zoneIp + ")");
                    boList.add(bo);
                }
                BatchOperationResult boResult = divertTacticsService.deleteDivertTactics(boList, true, userName, terminalIp + "(restful)");
                if (boResult.getFailCount() > 0) {
                    this.logger.info((Object)("boResult is ok" + boResult.toString()));
                    continue;
                }
                this.logger.info((Object)("boResult is fail" + boResult.toString()));
                continue;
            }
            ZoneIpForm destZoneIpForm = zoneIptemp;
            ZoneListIpForm destZoneListIpForm = new ZoneListIpForm();
            destZoneListIpForm.setEndIp(zoneIptemp.getEndIp());
            destZoneListIpForm.setStartIp(zoneIptemp.getStartIp());
            destZoneListIpForm.setIntMask(zoneIptemp.getMask().intValue());
            destZoneListIpForm.setIpType(0);
            destZoneListIpForm.setMaskType(0);
            destZoneListIpForm.setZoneIp(zoneIptemp.getZoneIp());
            destZoneListIpForm.setDeleteFlag(Integer.valueOf(0));
            this.zoneService.deleteSourceZoneIpAndZoneIpListAndAddDestZoneIp(null, 0L, zoneIp, destZoneIpForm, destZoneListIpForm, zoneId.longValue());
            List destZoneDevicelist = this.zoneDeviceService.queryZoneDeviceFormsByZoneID(zoneId);
            try {
                if (null == destZoneDevicelist || destZoneDevicelist.isEmpty()) continue;
                for (ZoneDeviceForm deviceForm : destZoneDevicelist) {
                    TelnetPara telnetPara = this.aticDeviceService.getDeviceTelnetPara(deviceForm.getDeviceId().longValue());
                    AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
                    if (null == aticDevice || null == telnetPara || 5 == aticDevice.getDeviceType() || 7 == aticDevice.getDeviceType()) continue;
                    MoveZoneIpData moveIpData = new MoveZoneIpData();
                    moveIpData.setSrouceZoneDevice(null);
                    moveIpData.setSourceZoneName(null);
                    moveIpData.setDestZoneDevice(deviceForm);
                    moveIpData.setDestZoneName(destZoneName);
                    moveIpData.setZoneIptemp(zoneIptemp);
                    moveIpData.setIpv4(isIpv4);
                    moveIpData.setTaskId(taskId);
                    moveIpData.setResultMap(resultMap);
                    moveIpData.setCommandDeployResult(this.moveIpDeployResult);
                    MoveZoneIpStartThread startThread = MoveZoneIpThreadPool.getStart(aticDevice.getIpAddress());
                    if (null == startThread) {
                        MoveZoneIpStartThread moveIpStartThread = new MoveZoneIpStartThread(aticDevice.getIpAddress(), this.aticDeviceService, this.operateTaskService, this.moveIpDeployResult);
                        moveIpStartThread.start();
                        MoveZoneIpThreadPool.putStart(aticDevice.getIpAddress(), moveIpStartThread);
                    }
                    MoveZoneIpThreadPool.getStart(aticDevice.getIpAddress()).addMoveZoneIptData(moveIpData);
                    ++totalCount;
                }
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)"deploy zoneIp error", (Throwable)e);
            }
        }
        this.logger.info((Object)("deploy ip totalCount is " + totalCount));
        int count = 0;
        do {
            Iterator<Map.Entry<CommandPair, DeployResult>> iterator = this.moveIpDeployResult.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<CommandPair, DeployResult> rs = iterator.next();
                operationMap.put(rs.getKey(), rs.getValue());
                ++count;
                iterator.remove();
            }
        } while (count < totalCount);
        return operationMap;
    }

    private Map<String, List<BatchOperation>> convertDivertTacticsForm(Map<String, List<DivertTacticsForm>> divertTacticsFormMap) {
        this.logger.info((Object)"RestCleanTaskStartThread  begin convert DivertTacticsForm to BatchOperation!");
        HashMap<String, List<BatchOperation>> result = new HashMap<String, List<BatchOperation>>();
        for (Map.Entry<String, List<DivertTacticsForm>> entry : divertTacticsFormMap.entrySet()) {
            ArrayList<BatchOperation> batchOperations = new ArrayList<BatchOperation>();
            String deviceIp = entry.getKey();
            List<DivertTacticsForm> list = entry.getValue();
            for (DivertTacticsForm divert : list) {
                BatchOperation batchOperation = new BatchOperation();
                batchOperation.setExtTargetId((Object)divert);
                batchOperation.setTargetName("(" + divert.getDeviceName() + ", IP :" + divert.getDivertIp() + ")");
                batchOperations.add(batchOperation);
            }
            result.put(deviceIp, batchOperations);
        }
        this.logger.info((Object)"RestCleanTaskStartThread  end convert DivertTacticsForm to BatchOperation!");
        return result;
    }

    private RestCleanTaskStartResultInfo handleBatchOperationResult(Map<String, BatchOperationResult> resultMap, Map<String, Long> timeMap, String taskId) {
        this.logger.info((Object)"RestCleanTaskStartThread  begin convert  to RestCleanTaskStartResultInfo!");
        RestCleanTaskStartResultInfo cleanResult = new RestCleanTaskStartResultInfo();
        ArrayList<RestCleanEqStatus> restCleanEqStatus = new ArrayList<RestCleanEqStatus>();
        cleanResult.setCommand(CLEANTASKSTART);
        cleanResult.setTaskId(taskId);
        Long maxLastTime = 0L;
        String status = "0";
        BatchOperationResult bor = null;
        int totalCount = 0;
        int failCount = 0;
        for (Map.Entry<String, Long> entry : timeMap.entrySet()) {
            RestCleanEqStatus cleanEqStatus = new RestCleanEqStatus();
            Long time = entry.getValue();
            String deviceIp = entry.getKey();
            bor = resultMap.get(deviceIp);
            cleanEqStatus.setCleanEqIp(deviceIp);
            this.handleBatchOperation(bor, cleanEqStatus);
            restCleanEqStatus.add(cleanEqStatus);
            totalCount += bor.getTotalCount();
            failCount += bor.getFailCount();
            if (bor.getTotalCount() == bor.getFailCount() || maxLastTime >= time) continue;
            maxLastTime = time;
        }
        if (totalCount != failCount && 0 != failCount) {
            status = "1";
            this.logger.info((Object)"RestCleanTaskStartThread has success divert task!");
        }
        if (maxLastTime == 0L) {
            maxLastTime = this.minTime(timeMap.values());
            status = "2";
        }
        String startTime = new SimpleDateFormat(DATEFORMATE).format(new Date(maxLastTime * 1000L));
        this.logger.info((Object)("RestCleanTaskStartThread  get startTime:" + startTime));
        cleanResult.setStartTime(startTime);
        cleanResult.setStartStatus(status);
        if ("0".equals(status)) {
            cleanResult.setStartMsg("all success!");
        } else if ("1".equals(status)) {
            cleanResult.setStartMsg("part success!");
        } else {
            cleanResult.setStartMsg("all fail!");
        }
        cleanResult.setCleanEqStatus(restCleanEqStatus);
        this.logger.info((Object)"RestCleanTaskStartThread  end convert  to RestCleanTaskStartResultInfo!");
        return cleanResult;
    }

    private void handleBatchOperation(BatchOperationResult bor, RestCleanEqStatus cleanEqStatus) {
        int size;
        this.logger.info((Object)"RestCleanTaskStartThread  begin  convert BatchOperationResult into RestCleanTaskStartResultInfo!");
        List bo = null;
        StringBuffer temp = new StringBuffer();
        cleanEqStatus.setStatus("1");
        if (bor.getSucceedCount() > 0) {
            cleanEqStatus.setStatus("0");
        }
        if ((size = (bo = bor.getResult()).size()) > 0) {
            for (int i = 0; i < size; ++i) {
                temp.append(((BatchOperation)bo.get(i)).getOptDetail());
            }
            cleanEqStatus.setMsg(temp.toString());
        }
        this.logger.info((Object)("RestCleanTaskStartThread  RestCleanEqStatus infomation: " + temp.toString()));
        this.logger.info((Object)"RestCleanTaskStartThread  end  convert BatchOperationResult into RestCleanTaskStartResultInfo!");
    }

    private Long minTime(Collection<Long> tiems) {
        this.logger.info((Object)"RestCleanTaskStartThread begin to handle minTime!");
        Long min = 0L;
        for (Long time : tiems) {
            if (min >= time) continue;
            min = time;
        }
        this.logger.info((Object)("RestCleanTaskStartThread end to handle minTime,minTime :" + min));
        return min;
    }

    private BatchOperationResult createStartResult(RestCleanStartTaskInfo startTaskInfo, String deviceIp) {
        this.logger.info((Object)"RestCleanTaskStartThread createStartResult ,because device not deploy!");
        BatchOperationResult operationResult = new BatchOperationResult();
        ArrayList<BatchOperation> result = new ArrayList<BatchOperation>();
        BatchOperation bo = new BatchOperation();
        bo.setOptDetail("zone not deploy to device!");
        result.add(bo);
        operationResult.setFailCount(1);
        operationResult.setSucceedCount(0);
        operationResult.setTotalCount(1);
        operationResult.setResult(result);
        this.logger.info((Object)"RestCleanTaskStartThread createStartResult ,because device not deploy!");
        return operationResult;
    }

    public RestfulCleanService getRestfulCleanService() {
        return this.restfulCleanService;
    }

    public void setRestfulCleanService(RestfulCleanService restfulCleanService) {
        this.restfulCleanService = restfulCleanService;
    }

    public CleanTaskBufferService getCleanTaskBufferService() {
        return this.cleanTaskBufferService;
    }

    public void setCleanTaskBufferService(CleanTaskBufferService cleanTaskBufferService) {
        this.cleanTaskBufferService = cleanTaskBufferService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IZoneDeviceDeployStatusService getZoneDeviceDeployStatusService() {
        return this.zoneDeviceDeployStatusService;
    }

    public void setZoneDeviceDeployStatusService(IZoneDeviceDeployStatusService zoneDeviceDeployStatusService) {
        this.zoneDeviceDeployStatusService = zoneDeviceDeployStatusService;
    }

    public TaskUnicomService getTaskUnicomService() {
        return this.taskUnicomService;
    }

    public void setTaskUnicomService(TaskUnicomService taskUnicomService) {
        this.taskUnicomService = taskUnicomService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public OperateTaskUnicomService getOperateTaskService() {
        return this.operateTaskService;
    }

    public void setOperateTaskService(OperateTaskUnicomService operateTaskService) {
        this.operateTaskService = operateTaskService;
    }

    public IUnicomDivertTacticsService getUnicomDivertTacticsService() {
        return this.unicomDivertTacticsService;
    }

    public void setUnicomDivertTacticsService(IUnicomDivertTacticsService unicomDivertTacticsService) {
        this.unicomDivertTacticsService = unicomDivertTacticsService;
    }

    public UpdateZoneStatusTools getUpdateZoneStatusTools() {
        return this.updateZoneStatusTools;
    }

    public void setUpdateZoneStatusTools(UpdateZoneStatusTools updateZoneStatusTools) {
        this.updateZoneStatusTools = updateZoneStatusTools;
    }
}

