/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.restful.daemon;

import com.hs.atic.sdk.bis.form.DivertTacticsForm;
import com.hs.atic.sdk.bis.unicom.entity.DeployResult;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStartInfo;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStartProtectDetailInfo;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStopTaskInfo;
import com.hs.atic.sdk.bis.unicom.entity.TaskOperateUnicomEntity;
import com.hs.atic.sdk.bis.unicom.entity.TaskUnicomEntity;
import com.hs.atic.sdk.bis.unicom.service.IUnicomDivertTacticsService;
import com.hs.atic.sdk.bis.unicom.service.OperateTaskUnicomService;
import com.hs.atic.sdk.bis.unicom.service.TaskUnicomService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.zone.dao.ZoneIpDao;
import com.hs.atic.zone.model.ZoneIpInfo;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CommandPair;
import com.hs.vsm.secservice.nfa.util.JSONUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceService;
import com.hs.vsm.secservice.sdk.unicom.restful.model.RestCleanEqStatus;
import com.hs.vsm.secservice.sdk.unicom.restful.model.RestCleanTaskStopResultInfo;
import com.hs.vsm.secservice.sdk.unicom.restful.service.CleanTaskBufferService;
import com.hs.vsm.secservice.sdk.unicom.restful.service.RestfulCleanService;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpData;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpStopThread;
import com.hs.vsm.secservice.unicom.restful.daemon.MoveZoneIpThreadPool;
import com.hs.vsm.secservice.unicom.restful.daemon.UnicomData;
import com.hs.vsm.secservice.unicom.restful.daemon.UnicomDivertThreadPool;
import com.hs.vsm.secservice.unicom.restful.daemon.UnicomStopThread;
import com.hs.vsm.secservice.unicom.restful.daemon.UpdateZoneStatusTools;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RestCleanTaskStopThread
extends Thread {
    private static final String DATEFORMATE = "yyyy-MM-dd HH:mm:ss";
    private static final String CLEANTASKSTOP = "cleanTaskStop";
    private boolean isOpen = false;
    private String cleanTaskStopUrl = "http://host:port/rest";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private RestfulCleanService restfulCleanService;
    private CleanTaskBufferService cleanTaskBufferService;
    private IZoneService zoneService;
    private IAticDeviceService aticDeviceService;
    private IUnicomDivertTacticsService unicomDivertTacticsService;
    private TaskUnicomService taskUnicomService;
    private OperateTaskUnicomService operateTaskService;
    private IZoneDeviceService zoneDeviceService;
    private Map<String, BatchOperationResult> stopResult = new ConcurrentHashMap<String, BatchOperationResult>();
    private Map<CommandPair, DeployResult> moveIpDeployResult = new ConcurrentHashMap<CommandPair, DeployResult>();
    private UpdateZoneStatusTools updateZoneStatusTools;
    private ZoneIpDao zoneIpDao;

    public RestCleanTaskStopThread() {
        this.setName("RestCleanTaskStopThread");
    }

    private void configThread() {
        this.isOpen = Boolean.parseBoolean(this.cleanTaskBufferService.getConfigMapValue("isOpen"));
        this.cleanTaskStopUrl = this.cleanTaskBufferService.getConfigMapValue("cleanTaskStopUri");
        this.logger.info((Object)("unicom.properties file:[isOpen:" + this.isOpen + ",cleanTaskStopUrl:" + this.cleanTaskStopUrl + "]."));
    }

    @Override
    public void run() {
        this.configThread();
        RestCleanStopTaskInfo cleanTaskStop = null;
        this.logger.info((Object)"RestCleanTaskStopThread  start");
        while (this.isOpen) {
            try {
                this.logger.info((Object)"RestCleanTaskStopThread  is open!");
                cleanTaskStop = this.cleanTaskBufferService.takeCleanStopTask();
                this.logger.info((Object)"CleanTaskBuffer:  StopQueue  has data,begin exec stopTask!");
                this.cleanTaskStop(cleanTaskStop);
            }
            catch (Exception e) {
                this.logger.error((Object)"RestCleanTaskStopThread occur exception:", (Throwable)e);
            }
        }
    }

    private void cleanTaskStop(RestCleanStopTaskInfo stopTaskInfo) {
        String taskId = stopTaskInfo.getTaskId();
        String terminalIp = stopTaskInfo.getClientIp();
        String username = stopTaskInfo.getUserName();
        HashMap<String, BatchOperationResult> resultMap = new HashMap<String, BatchOperationResult>();
        HashMap<String, Long> timeMap = new HashMap<String, Long>();
        BatchOperationResult result = null;
        Map<String, List<BatchOperation>> batchOperationMap = null;
        Map<String, List<DivertTacticsForm>> divertTacticsFormMap = this.createDivertTacticsForm(stopTaskInfo, resultMap, timeMap);
        batchOperationMap = this.convertDivertTacticsForm(divertTacticsFormMap);
        RestCleanTaskStopResultInfo cleanTaskStopResultInfo = null;
        ArrayList<UnicomData> unicomDatas = new ArrayList<UnicomData>();
        for (Map.Entry<String, List<BatchOperation>> entry : batchOperationMap.entrySet()) {
            try {
                String string = entry.getKey();
                UnicomData unicomData = new UnicomData();
                unicomData.setTaskId(taskId);
                unicomData.setBatchMapValue(entry.getValue());
                unicomData.setUserName(username);
                unicomData.setTerminalIp(terminalIp);
                UnicomStopThread stopThread = UnicomDivertThreadPool.getStop(string);
                if (null == stopThread) {
                    UnicomStopThread unicomTaskThread = new UnicomStopThread(string, this.unicomDivertTacticsService, this.stopResult);
                    unicomTaskThread.start();
                    UnicomDivertThreadPool.putStop(string, unicomTaskThread);
                }
                unicomDatas.add(unicomData);
                UnicomDivertThreadPool.getStop(string).addDivertData(unicomDatas);
                unicomDatas.clear();
            }
            catch (Exception exception) {
                this.logger.error((Object)"RestCleanTaskStopThread occur exception when stopUnicomDivertTactics:", (Throwable)exception);
            }
        }
        int count = 0;
        do {
            for (Map.Entry<String, BatchOperationResult> entry : this.stopResult.entrySet()) {
                if (!batchOperationMap.containsKey(entry.getKey())) continue;
                String deviceIp = entry.getKey();
                BatchOperationResult result1 = null;
                result = entry.getValue();
                if (null != resultMap.get(deviceIp)) {
                    result1 = (BatchOperationResult)resultMap.get(deviceIp);
                    List bos = result1.getResult();
                    int totalCount = 0;
                    int successCount = 0;
                    int failCount = 0;
                    bos.addAll(result.getResult());
                    result1.setResult(bos);
                    totalCount = result1.getTotalCount() + result.getTotalCount();
                    successCount = result1.getSucceedCount() + result.getSucceedCount();
                    failCount = result1.getFailCount() + result.getFailCount();
                    result1.setTotalCount(totalCount);
                    result1.setSucceedCount(successCount);
                    result1.setFailCount(failCount);
                } else {
                    resultMap.put(deviceIp, result);
                }
                timeMap.put(deviceIp, System.currentTimeMillis() / 1000L);
                this.stopResult.remove(deviceIp);
                ++count;
            }
        } while (count < batchOperationMap.size());
        cleanTaskStopResultInfo = this.handleBatchOperationResult(resultMap, timeMap, taskId);
        TaskUnicomEntity taskUnicomEntity = this.taskUnicomService.getTaskUnicomById(taskId);
        if (null == taskUnicomEntity) {
            return;
        }
        if ("0".equals(cleanTaskStopResultInfo.getStopStatus())) {
            taskUnicomEntity.setStatus("2");
        } else if ("1".equals(cleanTaskStopResultInfo.getStopStatus())) {
            taskUnicomEntity.setStatus("3");
        } else {
            taskUnicomEntity.setStatus("4");
        }
        this.taskUnicomService.saveTaskUnicom(taskUnicomEntity);
        this.logger.info((Object)"RestCleanTaskStopThread  update to TaskUnicomEntity success!");
        Object var14_23 = null;
        try {
            String string = JSONUtil.getInstance().toJSON((Object)cleanTaskStopResultInfo);
            this.restfulCleanService.restCleanTaskStopResult(string, this.cleanTaskStopUrl);
        }
        catch (Exception e) {
            this.logger.error((Object)"RestCleanTaskStopThread occur exception when Calling unicom interface :", (Throwable)e);
        }
    }

    private Map<String, List<DivertTacticsForm>> createDivertTacticsForm(RestCleanStopTaskInfo stopTaskInfo, Map<String, BatchOperationResult> resultMap, Map<String, Long> timeMap) {
        this.logger.info((Object)"RestCleanTaskStopThread begin to get divertTacticsForm by deviceId,zoneId,protectIp!");
        HashMap<String, List<DivertTacticsForm>> divertTacticsFormMap = new HashMap<String, List<DivertTacticsForm>>();
        TaskUnicomEntity taskEntity = null;
        String taskId = stopTaskInfo.getTaskId();
        taskEntity = this.taskUnicomService.getTaskUnicomById(taskId);
        String protectDetailInfosJson = "{\"protect_detail\":" + taskEntity.getProtectDetail() + "}";
        RestCleanStartInfo startInfos = (RestCleanStartInfo)JSONUtil.getInstance().fromJSON(protectDetailInfosJson, RestCleanStartInfo.class);
        List<RestCleanStartProtectDetailInfo> protectDetailInfos = startInfos.getProtectDetail();
        String protectIpstr = taskEntity.getProtectIps();
        protectIpstr = protectIpstr.substring(1, protectIpstr.lastIndexOf("]"));
        List<String> protectIpList01 = Arrays.asList(protectIpstr.split(","));
        String destZoneName = "";
        Long zoneId = null;
        List<String> deviceIps = new ArrayList<String>();
        Iterator<RestCleanStartProtectDetailInfo> iterator = protectDetailInfos.iterator();
        if (iterator.hasNext()) {
            RestCleanStartProtectDetailInfo reStartProtectDetailInfo = iterator.next();
            destZoneName = reStartProtectDetailInfo.getStrategyName();
            ZoneInfoForm zoneInfoForm = this.zoneService.getZoneByName(destZoneName);
            zoneId = zoneInfoForm.getZoneId();
            deviceIps = reStartProtectDetailInfo.getDeviceIPs();
        }
        Map<CommandPair, DeployResult> commandDeployResult = this.deleteZoneIpAndDeployZoneIp(taskId, destZoneName, zoneId, deviceIps, protectIpList01, resultMap);
        try {
            this.updateZoneStatusTools.deleteZoneIp(commandDeployResult, protectIpList01, zoneId);
            this.updateZoneStatusTools.saveDeployStatus(commandDeployResult);
        }
        catch (Exception e) {
            this.logger.error((Object)"saveDeployStatus error!", (Throwable)e);
        }
        for (int i = 0; i < protectDetailInfos.size(); ++i) {
            RestCleanStartProtectDetailInfo protectDetailInfo = protectDetailInfos.get(i);
            String protectIps = taskEntity.getProtectIps();
            String zoneName = protectDetailInfo.getStrategyName();
            protectIps = protectIps.substring(1, protectIps.lastIndexOf("]"));
            List<String> deviceIpList = protectDetailInfo.getDeviceIPs();
            List<String> protectIpList = Arrays.asList(protectIps.split(","));
            this.logger.info((Object)("RestCleanTaskStopThread protectIps.size:" + protectIpList.size() + ",deviceIpList.size:" + deviceIpList.size()));
            ZoneInfoForm zoneInfoForm = this.zoneService.getZoneByName(zoneName);
            zoneId = zoneInfoForm.getZoneId();
            BatchOperationResult result = null;
            for (String deviceIp : deviceIpList) {
                deviceIp = deviceIp.trim();
                ArrayList<DivertTacticsForm> divertTacticsForms = new ArrayList<DivertTacticsForm>();
                AticDevice device = null;
                DivertTacticsForm divertTacticsForm = null;
                device = this.aticDeviceService.getDeviceByIp(deviceIp);
                Long deviceId = device.getMoId();
                for (String protectIp : protectIpList) {
                    TaskOperateUnicomEntity taskOperate = new TaskOperateUnicomEntity();
                    String[] zoneIpDetails = (protectIp = protectIp.trim()).split("/");
                    divertTacticsForm = this.unicomDivertTacticsService.getDivertTacticsByZoneIp(deviceId, zoneId, zoneIpDetails[0]);
                    if (null != divertTacticsForm) {
                        divertTacticsForms.add(divertTacticsForm);
                        continue;
                    }
                    result = this.createStopResult(protectIp, zoneName);
                    this.logger.warn((Object)("RestCleanTaskStopThread createStopResult ,because divertTactics[deviceIp:" + deviceIp + ",zoneId:" + zoneId + ",ProtectIp:" + zoneIpDetails[0] + "] not existed!"));
                    if (null != resultMap.get(deviceIp)) {
                        BatchOperationResult result1 = null;
                        List bos = null;
                        int totalCount = 0;
                        int successCount = 0;
                        int failCount = 0;
                        result1 = resultMap.get(deviceIp);
                        bos = result1.getResult();
                        bos.addAll(result.getResult());
                        result1.setResult(bos);
                        totalCount = result1.getTotalCount() + result.getTotalCount();
                        successCount = result1.getSucceedCount() + result.getSucceedCount();
                        failCount = result1.getFailCount() + result.getFailCount();
                        result1.setTotalCount(totalCount);
                        result1.setSucceedCount(successCount);
                        result1.setFailCount(failCount);
                    } else {
                        resultMap.put(deviceIp, result);
                        timeMap.put(deviceIp, System.currentTimeMillis() / 1000L);
                    }
                    taskOperate.setTaskId(taskId);
                    taskOperate.setCommand(CLEANTASKSTOP);
                    taskOperate.setCleanEq(deviceIp);
                    taskOperate.setProtectIp(protectIp);
                    taskOperate.setExecutTime(System.currentTimeMillis() / 1000L);
                    taskOperate.setStatus(1);
                    taskOperate.setErrorCode(2);
                    taskOperate.setDetail("stop failed, because the divert tactics  not exists!");
                    this.operateTaskService.saveOperateTaskUnicom(taskOperate);
                }
                if (divertTacticsForms.isEmpty()) continue;
                if (null == divertTacticsFormMap.get(deviceIp) || 0 >= ((List)divertTacticsFormMap.get(deviceIp)).size()) {
                    divertTacticsFormMap.put(deviceIp, divertTacticsForms);
                    continue;
                }
                for (int l = 0; l < divertTacticsForms.size(); ++l) {
                    ((List)divertTacticsFormMap.get(deviceIp)).add(divertTacticsForms.get(l));
                }
            }
        }
        this.logger.info((Object)"RestCleanTaskStopThread end to create divertTacticsForm!");
        return divertTacticsFormMap;
    }

    private Map<CommandPair, DeployResult> deleteZoneIpAndDeployZoneIp(String taskId, String destZoneName, Long zoneId, List<String> deviceIPs, List<String> protectIPs, Map<String, BatchOperationResult> resultMap) {
        HashMap<CommandPair, DeployResult> commandDeployResult = new HashMap<CommandPair, DeployResult>();
        int totalCount = 0;
        List destZoneDevicelist = this.zoneDeviceService.queryZoneDeviceFormsByZoneID(zoneId);
        if (null != destZoneDevicelist && !destZoneDevicelist.isEmpty()) {
            for (ZoneDeviceForm deviceForm : destZoneDevicelist) {
                AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceForm.getDeviceId().longValue());
                String devIp = aticDevice.getIpAddress();
                for (String protectIp : protectIPs) {
                    String[] zoneIps = protectIp.split("/");
                    String zoneIp = zoneIps[0].trim();
                    String mask = zoneIps[1].trim();
                    boolean isIpv4 = IPUtil.isIpv4((String)zoneIp);
                    ZoneIpForm zoneIptemp = new ZoneIpForm();
                    zoneIptemp.setZoneId(zoneId);
                    zoneIptemp.setZoneIp(zoneIp);
                    zoneIptemp.setMask(Integer.valueOf(Integer.parseInt(mask)));
                    String[] rangeIps = IPUtil.getSubnetRange((String)zoneIp, (int)Integer.parseInt(mask));
                    zoneIptemp.setStartIp(rangeIps[0]);
                    zoneIptemp.setEndIp(rangeIps[1]);
                    List zoneIpInfos = this.zoneIpDao.findIpbyStartIpAndEndIpAndZoneId(zoneIptemp.getZoneId(), zoneIptemp.getStartIp(), zoneIptemp.getEndIp());
                    if (null != zoneIpInfos && !zoneIpInfos.isEmpty()) {
                        for (ZoneIpInfo zoneIpInfo : zoneIpInfos) {
                            if (!zoneIpInfo.getZoneIp().equals(zoneIptemp.getZoneIp())) continue;
                            zoneIptemp.setId(zoneIpInfo.getId());
                        }
                    }
                    if (null != zoneIptemp.getId()) {
                        ++totalCount;
                    }
                    MoveZoneIpData moveIpData = new MoveZoneIpData();
                    moveIpData.setDeviceId(deviceForm.getDeviceId());
                    moveIpData.setDestZoneName(destZoneName);
                    moveIpData.setZoneIptemp(zoneIptemp);
                    moveIpData.setIpv4(isIpv4);
                    moveIpData.setTaskId(taskId);
                    moveIpData.setResultMap(resultMap);
                    moveIpData.setCommandDeployResult(this.moveIpDeployResult);
                    this.logger.info((Object)("addUndoZoneIpData: " + devIp + "; zoneIp:" + zoneIp));
                    MoveZoneIpStopThread stopThread = MoveZoneIpThreadPool.getStop(devIp);
                    if (null == stopThread) {
                        MoveZoneIpStopThread moveIpStopThread = new MoveZoneIpStopThread(devIp, this.aticDeviceService, this.operateTaskService, this.moveIpDeployResult);
                        moveIpStopThread.start();
                        MoveZoneIpThreadPool.putStop(devIp, moveIpStopThread);
                    }
                    MoveZoneIpThreadPool.getStop(devIp).addUndoZoneIpData(moveIpData);
                }
            }
        }
        this.logger.info((Object)("deploy undo ip totalCount is " + totalCount));
        int count = 0;
        do {
            Iterator<Map.Entry<CommandPair, DeployResult>> iterator = this.moveIpDeployResult.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<CommandPair, DeployResult> rs = iterator.next();
                commandDeployResult.put(rs.getKey(), rs.getValue());
                ++count;
                iterator.remove();
            }
        } while (count < totalCount);
        return commandDeployResult;
    }

    private RestCleanTaskStopResultInfo handleBatchOperationResult(Map<String, BatchOperationResult> resultMap, Map<String, Long> timeMap, String taskId) {
        this.logger.info((Object)"RestCleanTaskStopThread  begin convert  to RestCleanTaskStartResultInfo!");
        RestCleanTaskStopResultInfo cleanResult = new RestCleanTaskStopResultInfo();
        ArrayList<RestCleanEqStatus> restCleanEqStatus = new ArrayList<RestCleanEqStatus>();
        cleanResult.setCommand(CLEANTASKSTOP);
        cleanResult.setTaskId(taskId);
        Long maxLastTime = 0L;
        String status = "0";
        BatchOperationResult bor = null;
        int totalCount = 0;
        int failCount = 0;
        for (Map.Entry<String, Long> entry : timeMap.entrySet()) {
            RestCleanEqStatus cleanEqStatus = new RestCleanEqStatus();
            Long time = entry.getValue();
            String deviceIp = entry.getKey();
            bor = resultMap.get(deviceIp);
            cleanEqStatus.setCleanEqIp(deviceIp);
            this.handleBatchOperation(bor, cleanEqStatus);
            restCleanEqStatus.add(cleanEqStatus);
            totalCount += bor.getTotalCount();
            failCount += bor.getFailCount();
            if (bor.getTotalCount() == bor.getFailCount() || maxLastTime >= time) continue;
            maxLastTime = time;
        }
        if (totalCount != failCount && 0 != failCount) {
            status = "1";
            this.logger.info((Object)"RestCleanTaskStartThread, Partial divert task success!");
        }
        if (maxLastTime == 0L) {
            maxLastTime = this.minTime(timeMap.values());
            status = "2";
        }
        String startTime = new SimpleDateFormat(DATEFORMATE).format(new Date(maxLastTime * 1000L));
        this.logger.info((Object)("RestCleanTaskStopThread  get startTime:" + startTime));
        cleanResult.setStopTime(startTime);
        cleanResult.setStopStatus(status);
        if ("0".equals(status)) {
            cleanResult.setStopMsg("all success!");
        } else if ("1".equals(status)) {
            cleanResult.setStopMsg("part success!");
        } else {
            cleanResult.setStopMsg("all fail!");
        }
        cleanResult.setCleanEqStatus(restCleanEqStatus);
        this.logger.info((Object)"RestCleanTaskStopThread  end convert  to RestCleanTaskStopResultInfo!");
        return cleanResult;
    }

    private void handleBatchOperation(BatchOperationResult bor, RestCleanEqStatus cleanEqStatus) {
        int size;
        this.logger.info((Object)"RestCleanTaskStopThread  begin  convert BatchOperationResult into RestCleanTaskStopResultInfo!");
        List bo = null;
        StringBuffer temp = new StringBuffer();
        cleanEqStatus.setStatus("1");
        if (bor.getSucceedCount() > 0) {
            cleanEqStatus.setStatus("0");
        }
        if ((size = (bo = bor.getResult()).size()) > 0) {
            for (int i = 0; i < size; ++i) {
                temp.append(((BatchOperation)bo.get(i)).getOptDetail());
            }
            cleanEqStatus.setMsg(temp.toString());
        }
        this.logger.info((Object)"RestCleanTaskStopThread  end  convert BatchOperationResult into RestCleanTaskStopResultInfo!");
    }

    private Long minTime(Collection<Long> tiems) {
        this.logger.info((Object)"RestCleanTaskStopThread begin to handle minTime!");
        Long min = 0L;
        for (Long time : tiems) {
            if (min >= time) continue;
            min = time;
        }
        this.logger.info((Object)("RestCleanTaskStopThread end to handle minTime,minTime :" + min));
        return min;
    }

    private Map<String, List<BatchOperation>> convertDivertTacticsForm(Map<String, List<DivertTacticsForm>> divertTacticsFormMap) {
        this.logger.info((Object)"RestCleanTaskStopThread  begin convert DivertTacticsForm to BatchOperation!");
        HashMap<String, List<BatchOperation>> result = new HashMap<String, List<BatchOperation>>();
        for (Map.Entry<String, List<DivertTacticsForm>> entry : divertTacticsFormMap.entrySet()) {
            ArrayList<BatchOperation> batchOperations = new ArrayList<BatchOperation>();
            String deviceIp = entry.getKey();
            List<DivertTacticsForm> list = entry.getValue();
            for (DivertTacticsForm divert : list) {
                BatchOperation batchOperation = new BatchOperation();
                batchOperation.setTargetId(divert.getId().longValue());
                batchOperation.setTargetName("(" + divert.getDeviceName() + ", IP :[" + divert.getDivertIp() + "/" + divert.getMask() + "])");
                batchOperations.add(batchOperation);
            }
            result.put(deviceIp, batchOperations);
        }
        this.logger.info((Object)"RestCleanTaskStopThread  end convert DivertTacticsForm to BatchOperation!");
        return result;
    }

    private BatchOperationResult createStopResult(String protectIp, String zoneName) {
        BatchOperationResult operationResult = new BatchOperationResult();
        ArrayList<BatchOperation> result = new ArrayList<BatchOperation>();
        BatchOperation bo = new BatchOperation();
        bo.setOptDetail("zoneName:" + zoneName + " and protectIp:" + protectIp + "  divert tactics not exist!");
        result.add(bo);
        operationResult.setTotalCount(1);
        operationResult.setSucceedCount(0);
        operationResult.setFailCount(1);
        operationResult.setResult(result);
        this.logger.info((Object)"RestCleanTaskStopThread createStopResult ,because divertTactics not existed!");
        return operationResult;
    }

    public RestfulCleanService getRestfulCleanService() {
        return this.restfulCleanService;
    }

    public void setRestfulCleanService(RestfulCleanService restfulCleanService) {
        this.restfulCleanService = restfulCleanService;
    }

    public CleanTaskBufferService getCleanTaskBufferService() {
        return this.cleanTaskBufferService;
    }

    public void setCleanTaskBufferService(CleanTaskBufferService cleanTaskBufferService) {
        this.cleanTaskBufferService = cleanTaskBufferService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public TaskUnicomService getTaskUnicomService() {
        return this.taskUnicomService;
    }

    public void setTaskUnicomService(TaskUnicomService taskUnicomService) {
        this.taskUnicomService = taskUnicomService;
    }

    public OperateTaskUnicomService getOperateTaskService() {
        return this.operateTaskService;
    }

    public void setOperateTaskService(OperateTaskUnicomService operateTaskService) {
        this.operateTaskService = operateTaskService;
    }

    public IUnicomDivertTacticsService getUnicomDivertTacticsService() {
        return this.unicomDivertTacticsService;
    }

    public void setUnicomDivertTacticsService(IUnicomDivertTacticsService unicomDivertTacticsService) {
        this.unicomDivertTacticsService = unicomDivertTacticsService;
    }

    public IZoneDeviceService getZoneDeviceService() {
        return this.zoneDeviceService;
    }

    public void setZoneDeviceService(IZoneDeviceService zoneDeviceService) {
        this.zoneDeviceService = zoneDeviceService;
    }

    public UpdateZoneStatusTools getUpdateZoneStatusTools() {
        return this.updateZoneStatusTools;
    }

    public void setUpdateZoneStatusTools(UpdateZoneStatusTools updateZoneStatusTools) {
        this.updateZoneStatusTools = updateZoneStatusTools;
    }

    public ZoneIpDao getZoneIpDao() {
        return this.zoneIpDao;
    }

    public void setZoneIpDao(ZoneIpDao zoneIpDao) {
        this.zoneIpDao = zoneIpDao;
    }
}

