/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.restful.daemon;

import com.hs.atic.sdk.bis.unicom.service.IUnicomDivertTacticsService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.unicom.restful.daemon.UnicomData;
import com.hs.vsm.secservice.unicom.restful.daemon.UnicomDivertThreadPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UnicomStartThread
extends Thread {
    private static final long DESTROY_TIME = 1800000L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private IUnicomDivertTacticsService unicomDivertTacticsService;
    private String deviceIp;
    private Map<String, BatchOperationResult> startResult;
    private boolean active = true;
    private List<UnicomData> nowProcessing = new ArrayList<UnicomData>();
    private long threadWorkMillis = System.currentTimeMillis();

    public UnicomStartThread(String deviceIp, IUnicomDivertTacticsService unicomDivertTacticsService, Map<String, BatchOperationResult> startResult) {
        this.setName("UnicomStartThread_" + deviceIp);
        this.deviceIp = deviceIp;
        this.unicomDivertTacticsService = unicomDivertTacticsService;
        this.startResult = startResult;
        this.logger.info((Object)("construct a unicom start divert thread, deviceIp=" + deviceIp));
    }

    @Override
    public void run() {
        while (this.active) {
            List<UnicomData> divertDataList = this.getBatchData();
            if (null != divertDataList && !divertDataList.isEmpty()) {
                this.threadWorkMillis = System.currentTimeMillis();
                BatchOperationResult result = null;
                UnicomData divertData = divertDataList.remove(0);
                try {
                    result = this.unicomDivertTacticsService.batchAddUnicomDivertTactics(divertData.getTaskId(), this.deviceIp, divertData.getBatchMapValue(), divertData.getUserName(), divertData.getTerminalIp());
                    this.startResult.put(this.deviceIp, result);
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
                continue;
            }
            if (1800000L < System.currentTimeMillis() - this.threadWorkMillis) {
                UnicomDivertThreadPool.removeStart(this.deviceIp);
                this.logger.info((Object)("construct a unicom start divert thread is destroyed by pool, deviceIp=" + this.deviceIp));
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UnicomData> getBatchData() {
        List<UnicomData> list = this.nowProcessing;
        synchronized (list) {
            if (this.nowProcessing.size() > 0) {
                ArrayList<UnicomData> result = new ArrayList<UnicomData>();
                result.addAll(this.nowProcessing);
                this.nowProcessing.clear();
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDivertData(List<UnicomData> divertDataList) {
        List<UnicomData> list = this.nowProcessing;
        synchronized (list) {
            this.nowProcessing.addAll(divertDataList);
        }
    }

    public Map<String, BatchOperationResult> getStartResult() {
        return this.startResult;
    }

    public void setStartResult(Map<String, BatchOperationResult> startResult) {
        this.startResult = startResult;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public IUnicomDivertTacticsService getUnicomDivertTacticsService() {
        return this.unicomDivertTacticsService;
    }

    public void setUnicomDivertTacticsService(IUnicomDivertTacticsService unicomDivertTacticsService) {
        this.unicomDivertTacticsService = unicomDivertTacticsService;
    }
}

