/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.restful.daemon;

import com.hs.atic.sdk.bis.unicom.entity.DeployResult;
import com.hs.atic.sdk.zone.form.ZoneIpForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.zone.dao.ZoneIpStatusDao;
import com.hs.atic.zone.dao.ZoneListIpDao;
import com.hs.atic.zone.model.ZoneIpStatusInfo;
import com.hs.atic.zone.model.ZoneListIpInfo;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.ddos.common.CommandPair;
import com.hs.vsm.secservice.ddos.dao.ZoneDeviceDeployStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZoneFeatureStatusDao;
import com.hs.vsm.secservice.ddos.dao.ZonePolicyApplyDao;
import com.hs.vsm.secservice.ddos.model.ZoneDeviceDeployStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZoneFeatureStatusInfo;
import com.hs.vsm.secservice.ddos.model.ZonePolicyApplyInfo;
import com.hs.vsm.secservice.sdk.common.util.CrcUtil;
import com.hs.vsm.secservice.sdk.module.ddos.Constant;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneDeviceDeployStatusService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateZoneStatusTools {
    private IAticDeviceService aticDeviceService;
    private IZoneService zoneService;
    private ZoneListIpDao zoneListIpDao;
    private ZoneIpStatusDao zoneIpStatusDao;
    private ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao;
    private ZoneFeatureStatusDao zoneFeatureStatusDao;
    private ZonePolicyApplyDao zonePolicyApplyDao;
    private Map<Long, Boolean> zoneDeployResult = null;

    public void saveDeployStatus(Map<CommandPair, DeployResult> commandDeployResult) {
        this.saveZoneIpDeviceStatus(commandDeployResult);
        Map<CommandPair, DeployResult> commandResult = this.deployZoneDeviceRestult(commandDeployResult);
        this.saveZoneDeviceStatus(commandResult);
        this.saveZoneFeatureStatus(commandResult);
        this.saveZonePolicyStatus(commandResult);
    }

    public void deleteZoneIp(Map<CommandPair, DeployResult> commandDeployResult, List<String> protectIpList01, Long zoneId) {
        int countSuccNum = 0;
        for (Map.Entry<CommandPair, DeployResult> deployResult : commandDeployResult.entrySet()) {
            Boolean deployState = deployResult.getValue().getIsDeployOk();
            if (!deployState.booleanValue()) continue;
            ++countSuccNum;
        }
        if (commandDeployResult.size() == countSuccNum) {
            for (String protectIp : protectIpList01) {
                String[] zoneIps = protectIp.split("/");
                String zoneIp = zoneIps[0].trim();
                String mask = zoneIps[1].trim();
                ZoneIpForm zoneIptemp = new ZoneIpForm();
                zoneIptemp.setZoneId(zoneId);
                zoneIptemp.setZoneIp(zoneIp);
                zoneIptemp.setMask(Integer.valueOf(Integer.parseInt(mask)));
                String[] rangeIps = IPUtil.getSubnetRange((String)zoneIp, (int)Integer.parseInt(mask));
                zoneIptemp.setStartIp(rangeIps[0]);
                zoneIptemp.setEndIp(rangeIps[1]);
                this.zoneService.deleteSourceZoneIpAndZoneIpListAndAddDestZoneIp(zoneIptemp, zoneId.longValue(), zoneIp, null, null, 0L);
            }
        }
    }

    private Map<CommandPair, DeployResult> deployZoneDeviceRestult(Map<CommandPair, DeployResult> commandDeployResult) {
        HashMap<CommandPair, DeployResult> commandResult = new HashMap<CommandPair, DeployResult>();
        for (Map.Entry<CommandPair, DeployResult> result : commandDeployResult.entrySet()) {
            DeployResult deployResult;
            Long zoneId = result.getKey().getZoneId();
            Long deviceId = result.getKey().getDeviceId();
            CommandPair commandPair = new CommandPair(zoneId, deviceId, ZoneListIpInfo.class.getSimpleName());
            if (!result.getValue().getIsDeployOk().booleanValue()) {
                deployResult = new DeployResult();
                deployResult.setIsDeployOk(false);
                deployResult.setErrorMsgKey(result.getValue().getErrorMsgKey());
                deployResult.setErrorParam(result.getValue().getErrorParam());
                commandResult.put(commandPair, deployResult);
                continue;
            }
            deployResult = new DeployResult();
            deployResult.setIsDeployOk(true);
            deployResult.setErrorMsgKey("--");
            deployResult.setErrorParam("");
            commandResult.put(commandPair, deployResult);
        }
        return commandResult;
    }

    private void saveZonePolicyStatus(Map<CommandPair, DeployResult> commandDeployResult) {
        this.zoneDeployResult = new HashMap<Long, Boolean>();
        for (Map.Entry<CommandPair, DeployResult> entry : commandDeployResult.entrySet()) {
            Boolean deployRest = entry.getValue().getIsDeployOk();
            Long nowZoneId = entry.getKey().getZoneId();
            if (null != this.zoneDeployResult && null != this.zoneDeployResult.get(nowZoneId)) {
                if (!this.zoneDeployResult.get(nowZoneId).booleanValue()) continue;
                this.zoneDeployResult.put(nowZoneId, deployRest);
                continue;
            }
            this.zoneDeployResult.put(nowZoneId, deployRest);
        }
        for (Map.Entry<Object, Serializable> entry : this.zoneDeployResult.entrySet()) {
            long totalZoneId = (Long)entry.getKey();
            boolean zoneResult = (Boolean)entry.getValue();
            ZonePolicyApplyInfo zonePolicyApplyInfo = this.zonePolicyApplyDao.getByZoneId(Long.valueOf(totalZoneId));
            if (zonePolicyApplyInfo.getDeployState().equals("SUCCESS") && zoneResult) {
                zonePolicyApplyInfo.setDeployState("SUCCESS");
            } else if (zonePolicyApplyInfo.getDeployState().equals("SUCCESS") && !zoneResult) {
                zonePolicyApplyInfo.setDeployState("PART_SUCCESS");
            } else if (!zonePolicyApplyInfo.getDeployState().equals("SUCCESS")) {
                if (zoneResult && this.getZoneDeviceDeployStatus(totalZoneId)) {
                    zonePolicyApplyInfo.setDeployState("SUCCESS");
                }
            } else {
                zonePolicyApplyInfo.setDeployState("INCREAMENT_UNDEPLOY");
            }
            this.zonePolicyApplyDao.saveOrUpdate((Object)zonePolicyApplyInfo);
        }
    }

    private boolean getZoneDeviceDeployStatus(Long zoneId) {
        IZoneDeviceDeployStatusService zoneDeviceDeployStatusService = (IZoneDeviceDeployStatusService)ServiceContext.getInstance().getService("zoneDeviceDeployStatusService", IZoneDeviceDeployStatusService.class);
        List deployStatueList = zoneDeviceDeployStatusService.queryPolicyDeployResult(zoneId);
        for (ZoneDeviceDeployStatusInfo zoneDeviceDeployStatusInfo : deployStatueList) {
            if (zoneDeviceDeployStatusInfo.getDeployState().booleanValue()) continue;
            return false;
        }
        return true;
    }

    private void saveZoneFeatureStatus(Map<CommandPair, DeployResult> commandDeployResult) {
        for (Map.Entry<CommandPair, DeployResult> deviceResult : commandDeployResult.entrySet()) {
            long zoneId = deviceResult.getKey().getZoneId();
            long deviceId = deviceResult.getKey().getDeviceId();
            ZoneFeatureStatusInfo zoneFeatureStatusInfo = this.zoneFeatureStatusDao.getByZoneIdAndDeviceIdAndTypeAndFeatureId(Long.valueOf(zoneId), Long.valueOf(deviceId), ZoneIpForm.class.getSimpleName(), Long.valueOf(zoneId));
            ZonePolicyApplyInfo zonePolicyApplyInfo = this.zonePolicyApplyDao.getByZoneId(Long.valueOf(zoneId));
            if (null == zoneFeatureStatusInfo) {
                zoneFeatureStatusInfo = new ZoneFeatureStatusInfo();
                zoneFeatureStatusInfo.setZoneId(Long.valueOf(zoneId));
                zoneFeatureStatusInfo.setDeviceId(Long.valueOf(deviceId));
                zoneFeatureStatusInfo.setFeatureId(Long.valueOf(zoneId));
                zoneFeatureStatusInfo.setFeatureType(ZoneIpForm.class.getSimpleName());
                zoneFeatureStatusInfo.setDefendMode(Constant.DEFENDMODE_DEFEND_AUTO);
                zoneFeatureStatusInfo.setDeployCrc(Long.valueOf(CrcUtil.getCrcValue((String)"0")));
                zoneFeatureStatusInfo.setDeployState(deviceResult.getValue().getIsDeployOk());
                zoneFeatureStatusInfo.setDefendMode(zonePolicyApplyInfo.getDefendMode());
                this.zoneFeatureStatusDao.save((Object)zoneFeatureStatusInfo);
                continue;
            }
            zoneFeatureStatusInfo.setDefendMode(Constant.DEFENDMODE_DEFEND_AUTO);
            zoneFeatureStatusInfo.setDeployCrc(Long.valueOf(CrcUtil.getCrcValue((String)"0")));
            zoneFeatureStatusInfo.setDeployState(deviceResult.getValue().getIsDeployOk());
            zoneFeatureStatusInfo.setDefendMode(zonePolicyApplyInfo.getDefendMode());
            this.zoneFeatureStatusDao.update((Object)zoneFeatureStatusInfo);
        }
    }

    private void saveZoneDeviceStatus(Map<CommandPair, DeployResult> commandDeployResult) {
        for (Map.Entry<CommandPair, DeployResult> deviceResult : commandDeployResult.entrySet()) {
            ZoneDeviceDeployStatusInfo info = null;
            long zoneId = deviceResult.getKey().getZoneId();
            long deviceId = deviceResult.getKey().getDeviceId();
            List statutList = this.zoneDeviceDeployStatusDao.queryByZoneId(Long.valueOf(zoneId));
            if (null != statutList && !statutList.isEmpty()) {
                for (ZoneDeviceDeployStatusInfo each : statutList) {
                    if (null == each || 1 != each.getDeployType() || deviceId != each.getDeviceId()) continue;
                    info = each;
                    break;
                }
            }
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(deviceId);
            if (null == info) {
                info = new ZoneDeviceDeployStatusInfo();
                info.setZoneId(Long.valueOf(zoneId));
                info.setDeviceId(Long.valueOf(deviceId));
            } else if (deviceResult.getValue().getIsDeployOk().booleanValue()) {
                info.setDeployState(Boolean.valueOf(true));
            } else {
                info.setDeployState(Boolean.valueOf(false));
            }
            info.setDeployType(Integer.valueOf(1));
            info.setDeployTime(new Date());
            info.setErrorMsgKey(deviceResult.getValue().getErrorMsgKey());
            info.setHasChange(Boolean.valueOf(false));
            info.setErrorParam(deviceResult.getValue().getErrorParam());
            if (aticDevice.getDeviceType() == 7) continue;
            this.zoneDeviceDeployStatusDao.save((Object)info);
        }
    }

    private void saveZoneIpDeviceStatus(Map<CommandPair, DeployResult> commandDeployResult) {
        for (Map.Entry<CommandPair, DeployResult> ipResult : commandDeployResult.entrySet()) {
            if (!ipResult.getValue().getIsDeployOk().booleanValue()) continue;
            this.zoneListIpDao.updateDeployStateById(ipResult.getKey().getCommandId(), ipResult.getValue().getIsDeployOk().booleanValue());
            this.updateZoneIpStatusInfo(ipResult);
        }
        for (Map.Entry<CommandPair, DeployResult> ipResult : commandDeployResult.entrySet()) {
            if (ipResult.getValue().getIsDeployOk().booleanValue()) continue;
            this.zoneListIpDao.updateDeployStateById(ipResult.getKey().getCommandId(), ipResult.getValue().getIsDeployOk().booleanValue());
            this.updateZoneIpStatusInfo(ipResult);
        }
    }

    private void updateZoneIpStatusInfo(Map.Entry<CommandPair, DeployResult> ipResult) {
        CommandPair commandPair = ipResult.getKey();
        Long deviceId = commandPair.getDeviceId();
        Long pkId = commandPair.getCommandId();
        boolean deployState = ipResult.getValue().getIsDeployOk();
        List zoneIpStatusInfoList = this.zoneIpStatusDao.findByIpIdAndDeviceId(pkId, deviceId);
        ZoneIpStatusInfo zoneIpStatusInfo = null;
        if (zoneIpStatusInfoList.isEmpty()) {
            zoneIpStatusInfo = new ZoneIpStatusInfo();
            zoneIpStatusInfo.setDeviceId(deviceId);
            zoneIpStatusInfo.setIpId(pkId);
            zoneIpStatusInfo.setDeployState(deployState);
        } else {
            zoneIpStatusInfo = (ZoneIpStatusInfo)zoneIpStatusInfoList.get(0);
            zoneIpStatusInfo.setDeployState(deployState);
        }
        this.zoneIpStatusDao.saveOrUpdate((Object)zoneIpStatusInfo);
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }

    public ZoneListIpDao getZoneListIpDao() {
        return this.zoneListIpDao;
    }

    public void setZoneListIpDao(ZoneListIpDao zoneListIpDao) {
        this.zoneListIpDao = zoneListIpDao;
    }

    public ZoneIpStatusDao getZoneIpStatusDao() {
        return this.zoneIpStatusDao;
    }

    public void setZoneIpStatusDao(ZoneIpStatusDao zoneIpStatusDao) {
        this.zoneIpStatusDao = zoneIpStatusDao;
    }

    public ZoneDeviceDeployStatusDao getZoneDeviceDeployStatusDao() {
        return this.zoneDeviceDeployStatusDao;
    }

    public void setZoneDeviceDeployStatusDao(ZoneDeviceDeployStatusDao zoneDeviceDeployStatusDao) {
        this.zoneDeviceDeployStatusDao = zoneDeviceDeployStatusDao;
    }

    public ZoneFeatureStatusDao getZoneFeatureStatusDao() {
        return this.zoneFeatureStatusDao;
    }

    public void setZoneFeatureStatusDao(ZoneFeatureStatusDao zoneFeatureStatusDao) {
        this.zoneFeatureStatusDao = zoneFeatureStatusDao;
    }

    public ZonePolicyApplyDao getZonePolicyApplyDao() {
        return this.zonePolicyApplyDao;
    }

    public void setZonePolicyApplyDao(ZonePolicyApplyDao zonePolicyApplyDao) {
        this.zonePolicyApplyDao = zonePolicyApplyDao;
    }
}

