/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.unicom.restful.service.impl;

import com.hs.atic.sdk.bis.unicom.entity.CleanAlarmObject;
import com.hs.atic.sdk.bis.unicom.entity.CleanLogCommandObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.nfa.util.JSONUtil;
import com.hs.vsm.secservice.unicom.restful.service.RestfulUnicomService;
import com.hs.vsm.secservice.unicom.rmi.model.CleanLogBuffer;
import com.hs.vsm.secservice.unicom.util.UnicomHttpsClient;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import java.io.IOException;

public class RestfulUnicomServiceImpl
implements RestfulUnicomService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private UnicomHttpsClient httpsClient = UnicomHttpsClient.getInstance();
    private CleanLogBuffer cleanLogBuffer;

    @Override
    public Result upLoadCleanLog(CleanLogCommandObject object) {
        Result result = null;
        try {
            if (null == this.cleanLogBuffer.getConfigMap() || null == this.cleanLogBuffer.getConfigMap().get("unicomCleanLogUri")) {
                this.logger.warn((Object)"can not find unicomCleanLogUri from unicom.properties");
                return null;
            }
            String unicomCleanLogUri = this.cleanLogBuffer.getConfigMap().get("unicomCleanLogUri");
            String json = JSONUtil.getInstance().toJSON((Object)object);
            result = this.httpsClient.doHttpsPost(json, unicomCleanLogUri);
        }
        catch (IOException e) {
            result = new Result();
            result.setJson(e.getMessage());
            this.logger.error((Object)("upLoadCleanLog method is exception," + e));
        }
        return result;
    }

    @Override
    public Result upLoadAlarm(CleanAlarmObject object) {
        Result result = null;
        try {
            if (null == this.cleanLogBuffer.getConfigMap() || null == this.cleanLogBuffer.getConfigMap().get("unicomCleanAlarmUri")) {
                this.logger.warn((Object)"can not find unicomCleanAlarmUri from unicom.properties");
                return null;
            }
            String unicomCleanAlarmUri = this.cleanLogBuffer.getConfigMap().get("unicomCleanAlarmUri");
            String json = JSONUtil.getInstance().toJSON((Object)object);
            result = this.httpsClient.doHttpsPost(json, unicomCleanAlarmUri);
        }
        catch (IOException e) {
            result = new Result();
            result.setJson(e.getMessage());
            this.logger.error((Object)("upLoadAlarm method is exception," + e));
        }
        return result;
    }

    public CleanLogBuffer getCleanLogBuffer() {
        return this.cleanLogBuffer;
    }

    public void setCleanLogBuffer(CleanLogBuffer cleanLogBuffer) {
        this.cleanLogBuffer = cleanLogBuffer;
    }
}

