/*
 * Decompiled with CFR 0.152.
 */
package com.unicom.restful.service.impl;

import com.hs.atic.sdk.bis.unicom.entity.RestCleanResult;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStartInfo;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStartProtectDetailInfo;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStartTaskInfo;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStopInfo;
import com.hs.atic.sdk.bis.unicom.entity.RestCleanStopTaskInfo;
import com.hs.atic.sdk.bis.unicom.entity.TaskOperateUnicomEntity;
import com.hs.atic.sdk.bis.unicom.entity.TaskUnicomEntity;
import com.hs.atic.sdk.bis.unicom.service.OperateTaskUnicomService;
import com.hs.atic.sdk.bis.unicom.service.TaskUnicomService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.sdk.unicom.restful.service.CleanTaskBufferService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.restful.util.JSONUtil;
import com.restful.util.RestAuthUtil;
import com.restful.util.RestUtil;
import com.unicom.restful.service.RestCleanTaskService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

@Path(value="unicom/divert")
public class RestCleanTaskServiceImpl
implements RestCleanTaskService {
    private static final String CLEANSTART = "cleanStart";
    private static final String CLEANSTOP = "cleanStop";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_UNICOM_SOC);
    private TaskUnicomService taskUnicomService;
    private OperateTaskUnicomService operateTaskService;
    private IAticDeviceService aticDeviceService;
    private CleanTaskBufferService cleanTaskBufferService;
    private IZoneService zoneService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @POST
    @Path(value="/start")
    @Produces(value={"application/json"})
    public Response startCleanTask(@FormParam(value="Content") String json) {
        this.logger.info((Object)("RestCleanTaskServiceImpl.startCleanTask start to do ...and json is:" + json));
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestCleanResult cleanTaskResult = new RestCleanResult();
        cleanTaskResult.setStatus("true");
        HttpServletRequest request = ServletActionContext.getRequest();
        String requestMsg = "restful request is null. json :" + json;
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"unicom/divert/start");
            requestMsg = "restful request url : " + url + ". json :" + json;
            terminalIp = request.getRemoteAddr();
        }
        this.logger.info((Object)("RestCleanTaskServiceImpl.startCleanTask request information:" + requestMsg));
        String responseMsg = "";
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = json;
        RestCleanStartInfo restCleanStartInfo = null;
        try {
            restCleanStartInfo = (RestCleanStartInfo)JSONUtil.getInstance().fromJSON(json, RestCleanStartInfo.class);
            cleanTaskResult = this.checkCleanStartInfo(restCleanStartInfo, this.taskUnicomService, this.aticDeviceService);
            if ("true".equals(cleanTaskResult.getStatus())) {
                RestCleanStartTaskInfo taskInfo = RestCleanStartTaskInfo.convertRestCleanStartInfo(restCleanStartInfo, null, terminalIp);
                boolean flag = this.cleanTaskBufferService.offerCleanStartTask(taskInfo);
                if (flag) {
                    this.logger.info((Object)"RestCleanStartTaskInfo add to startQueue success!");
                } else {
                    this.logger.info((Object)"RestCleanStartTaskInfo add to startQueue failure!");
                }
                cleanTaskResult.setErrorCode("0");
                cleanTaskResult.setMsg("");
            }
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"convert the format from java to pojo bean failed.", (Exception)e);
            detailPara[2] = responseCode + "," + responseMsg;
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, null, (String)"atic.restful.create.divert.StartUnicomCleanTask");
            this.logger.error((Object)"RestCleanTaskServiceImpl.startCleanTask request json format error");
            responseBuilder = responseBuilder.status(responseCode);
            cleanTaskResult.setStatus("false");
            cleanTaskResult.setErrorCode("2");
            cleanTaskResult.setMsg("json format error");
        }
        finally {
            this.logger.info((Object)("RestCleanTaskServiceImpl.startCleanTask response information:[status:" + cleanTaskResult.getStatus() + ",errorCode:" + cleanTaskResult.getErrorCode() + ",msg:" + cleanTaskResult.getMsg() + "]"));
            if (restCleanStartInfo != null) {
                TaskUnicomEntity taskEntity = this.convert2TaskUnicomEntity(restCleanStartInfo);
                TaskOperateUnicomEntity taskOperateEntity = this.convert2TaskOperateUnicomEntity(restCleanStartInfo);
                boolean ipv4 = false;
                String protectIps = taskEntity.getProtectIps();
                protectIps = protectIps.substring(1, protectIps.lastIndexOf("]"));
                List<String> protectIpList = Arrays.asList(protectIps.split(","));
                ArrayList<String> cleanTypes = new ArrayList<String>();
                cleanTypes.add("JYQX");
                cleanTypes.add("JMDQX");
                ArrayList<String> nexthopList = new ArrayList<String>();
                List<RestCleanStartProtectDetailInfo> protectDetailInfos = restCleanStartInfo.getProtectDetail();
                for (int i = 0; i < protectDetailInfos.size(); ++i) {
                    RestCleanStartProtectDetailInfo protectDetailInfo = protectDetailInfos.get(i);
                    String cleanType = protectDetailInfo.getCleanType();
                    if (cleanType == null || "".equals(cleanType) || !cleanTypes.contains(cleanType)) continue;
                    List<String> deviceIps = protectDetailInfo.getDeviceIPs();
                    for (String deviceIp : deviceIps) {
                        for (String protectIp : protectIpList) {
                            String[] zoneIpDetails = protectIp.split("/");
                            ipv4 = IPUtil.isIpv4((String)zoneIpDetails[0].trim());
                            String nextHopip = this.aticDeviceService.getNexthopIpByDeviceIpAndCleanType(deviceIp, cleanType, ipv4);
                            if (nextHopip == null || "".equals(nextHopip) || nexthopList.contains(nextHopip)) continue;
                            nexthopList.add(nextHopip);
                        }
                    }
                }
                if (!nexthopList.isEmpty()) {
                    String nextHops = StringUtils.join((Object[])nexthopList.toArray(), (String)",");
                    this.logger.info((Object)("RestCleanTaskServiceImpl.startCleanTask nextHops :" + nextHops));
                    taskEntity.setNextHop(nextHops);
                }
                if ("true".equals(cleanTaskResult.getStatus())) {
                    taskEntity.setStatus("0");
                    taskOperateEntity.setStatus(0);
                } else {
                    if ("1".equals(cleanTaskResult.getErrorCode())) {
                        taskEntity = this.taskUnicomService.getTaskUnicomById(restCleanStartInfo.getTaskId());
                    }
                    if (null == taskEntity) {
                        taskEntity = new TaskUnicomEntity();
                    }
                    taskEntity.setStatus("1");
                    taskOperateEntity.setStatus(1);
                }
                taskOperateEntity.setErrorCode(Integer.parseInt(cleanTaskResult.getErrorCode()));
                taskOperateEntity.setDetail(cleanTaskResult.getMsg());
                this.taskUnicomService.saveTaskUnicom(taskEntity);
                this.logger.info((Object)"RestCleanTaskServiceImpl.startCleanTask save TaskUnicomEntity success!");
                this.operateTaskService.saveOperateTaskUnicom(taskOperateEntity);
                this.logger.info((Object)"RestCleanTaskServiceImpl.startCleanTask save TaskOperateUnicomEntity success!");
            }
        }
        return this.formatResult(responseBuilder, cleanTaskResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @POST
    @Path(value="/stop")
    @Produces(value={"application/json"})
    public Response stopCleanTask(@FormParam(value="Content") String json) {
        this.logger.info((Object)("RestCleanTaskServiceImpl.stopCleanTask start to do ...and json is:" + json));
        Response.ResponseBuilder responseBuilder = Response.ok();
        RestCleanResult cleanTaskResult = new RestCleanResult();
        cleanTaskResult.setStatus("true");
        HttpServletRequest request = ServletActionContext.getRequest();
        String requestMsg = "restful request is null. json :" + json;
        String terminalIp = "127.0.0.1";
        String url = "null";
        if (null != request) {
            url = RestAuthUtil.getRequestURL((HttpServletRequest)request, (String)"unicom/divert/stop");
            requestMsg = "restful request url : " + url + ". json :" + json;
            terminalIp = request.getRemoteAddr();
        }
        this.logger.info((Object)("RestCleanTaskServiceImpl.stopCleanTask request information:" + requestMsg));
        String responseMsg = "";
        int responseCode = 500;
        String[] detailPara = new String[3];
        detailPara[0] = url;
        detailPara[1] = json;
        RestCleanStopInfo restCleanStopInfo = null;
        try {
            restCleanStopInfo = (RestCleanStopInfo)JSONUtil.getInstance().fromJSON(json, RestCleanStopInfo.class);
            cleanTaskResult = this.checkCleanStopInfo(restCleanStopInfo, this.taskUnicomService, this.operateTaskService);
            if ("true".equals(cleanTaskResult.getStatus())) {
                RestCleanStopTaskInfo taskInfo = RestCleanStopTaskInfo.convertRestCleanStopInfo(restCleanStopInfo, null, terminalIp);
                boolean flag = this.cleanTaskBufferService.offerCleanStopTask(taskInfo);
                if (flag) {
                    this.logger.info((Object)"RestCleanStopTaskInfo add to stopQueue success!");
                } else {
                    this.logger.info((Object)"RestCleanStopTaskInfo add to stopQueue failure!");
                }
                cleanTaskResult.setErrorCode("0");
                cleanTaskResult.setMsg("");
            }
        }
        catch (Exception e) {
            responseMsg = "json format error";
            responseCode = 400;
            RestUtil.processSysLog((String)requestMsg, (int)responseCode, (String)"convert the format from java to pojo bean failed.", (Exception)e);
            detailPara[2] = responseCode + "," + responseMsg;
            RestUtil.processOpeLog((String[])detailPara, (int)responseCode, (String)terminalIp, null, (String)"atic.restful.create.divert.StopUnicomCleanTask");
            this.logger.error((Object)"RestCleanTaskServiceImpl.stopCleanTask1 request json format error");
            responseBuilder = responseBuilder.status(responseCode);
            cleanTaskResult.setStatus("false");
            cleanTaskResult.setErrorCode("2");
            cleanTaskResult.setMsg("json format error");
        }
        finally {
            TaskUnicomEntity taskEntity;
            this.logger.info((Object)("RestCleanTaskServiceImpl.stopCleanTask response information:[status:" + cleanTaskResult.getStatus() + ",errorCode:" + cleanTaskResult.getErrorCode() + ",msg:" + cleanTaskResult.getMsg() + "]"));
            if (restCleanStopInfo != null && (taskEntity = this.taskUnicomService.getTaskUnicomById(restCleanStopInfo.getTaskId())) != null) {
                TaskOperateUnicomEntity taskOperateEntity = this.convert2TaskOperateUnicomEntity(taskEntity);
                if ("true".equals(cleanTaskResult.getStatus())) {
                    taskEntity.setStatus("0");
                    taskOperateEntity.setStatus(0);
                } else {
                    taskEntity.setStatus("1");
                    taskOperateEntity.setStatus(1);
                }
                taskOperateEntity.setCommand(CLEANSTOP);
                taskOperateEntity.setErrorCode(Integer.parseInt(cleanTaskResult.getErrorCode()));
                taskOperateEntity.setDetail(cleanTaskResult.getMsg());
                this.taskUnicomService.saveTaskUnicom(taskEntity);
                this.logger.info((Object)"RestCleanTaskServiceImpl.stopCleanTask update TaskUnicomEntity success!");
                this.operateTaskService.saveOperateTaskUnicom(taskOperateEntity);
                this.logger.info((Object)"RestCleanTaskServiceImpl.stopCleanTask create TaskOperateUnicomEntity success!");
            }
        }
        return this.formatResult(responseBuilder, cleanTaskResult);
    }

    private RestCleanResult checkCleanStartInfo(RestCleanStartInfo restCleanTaskInfo, TaskUnicomService tTaskUnicomService, IAticDeviceService tAticDeviceService) {
        String taskId = restCleanTaskInfo.getTaskId();
        this.logger.info((Object)("task_id:" + taskId + "begin check!"));
        RestCleanResult cleanResult = new RestCleanResult();
        cleanResult.setStatus("true");
        if (taskId != null && !"".equals(taskId)) {
            TaskUnicomEntity taskEntity = tTaskUnicomService.getTaskUnicomById(taskId);
            if (taskEntity != null) {
                cleanResult.setStatus("false");
                cleanResult.setErrorCode("1");
                cleanResult.setMsg("task_id:" + taskId + " is resend!");
                this.logger.warn((Object)("task_id:" + taskId + " is resend!"));
                return cleanResult;
            }
            String command = restCleanTaskInfo.getCommand();
            if (command == null || "".equals(command)) {
                cleanResult.setStatus("false");
                cleanResult.setErrorCode("2");
                cleanResult.setMsg("command is null!");
                this.logger.warn((Object)"command is null!");
                return cleanResult;
            }
            if (!CLEANSTART.equals(command)) {
                cleanResult.setStatus("false");
                cleanResult.setErrorCode("2");
                cleanResult.setMsg("command is error!");
                this.logger.warn((Object)"command is error!");
                return cleanResult;
            }
            List<String> protectIPs = restCleanTaskInfo.getProtectIPs();
            if (protectIPs == null || protectIPs.isEmpty()) {
                cleanResult.setStatus("false");
                cleanResult.setErrorCode("2");
                cleanResult.setMsg("protect_ips is null!");
                this.logger.warn((Object)"protect_ips is null !");
                return cleanResult;
            }
            if (protectIPs.size() > 100) {
                cleanResult.setStatus("false");
                cleanResult.setErrorCode("2");
                cleanResult.setMsg("protect_ips number more than 100!");
                this.logger.warn((Object)"protect_ips number more than 100!");
                return cleanResult;
            }
            boolean flag = true;
            for (String ip : protectIPs) {
                flag = this.checkIpMark(ip);
                if (!flag) {
                    cleanResult.setStatus("false");
                    cleanResult.setErrorCode("2");
                    cleanResult.setMsg("protect_ips format error!");
                    this.logger.warn((Object)"protect_ips format error !");
                    return cleanResult;
                }
                String[] split = ip.split("/");
                if (IPUtil.isIpv4((String)split[0])) {
                    if (8 <= Integer.parseInt(split[1]) && 32 >= Integer.parseInt(split[1])) continue;
                    cleanResult.setStatus("false");
                    cleanResult.setErrorCode("2");
                    cleanResult.setMsg("protect_ips mask must be a number ranging from 8 to 32 while inputing IPv4 address.");
                    this.logger.warn((Object)("protect_ips mask must be a number ranging from 8 to 32 while inputing IPv4 address. ip : " + ip));
                    return cleanResult;
                }
                if (8 <= Integer.parseInt(split[1]) && 128 >= Integer.parseInt(split[1])) continue;
                cleanResult.setStatus("false");
                cleanResult.setErrorCode("2");
                cleanResult.setMsg("protect_ips mask must be a number ranging from 8 to 128 while inputing IPv6 address.");
                this.logger.warn((Object)("protect_ips mask must be a number ranging from 8 to 128 while inputing IPv6 address. ip : " + ip));
                return cleanResult;
            }
            List<RestCleanStartProtectDetailInfo> protectDetailInfos = restCleanTaskInfo.getProtectDetail();
            if (null == protectDetailInfos) {
                cleanResult.setStatus("false");
                cleanResult.setErrorCode("2");
                cleanResult.setMsg("protect_detail is null!");
                this.logger.warn((Object)"protect_detail is null !");
                return cleanResult;
            }
            for (int i = 0; i < protectDetailInfos.size(); ++i) {
                RestCleanStartProtectDetailInfo protectDetailInfo = protectDetailInfos.get(i);
                List<String> deviceIPs = protectDetailInfo.getDeviceIPs();
                if (deviceIPs == null || deviceIPs.isEmpty()) {
                    cleanResult.setStatus("false");
                    cleanResult.setErrorCode("2");
                    cleanResult.setMsg("device_ips is null!");
                    this.logger.warn((Object)"device_ips is null !");
                    return cleanResult;
                }
                AticDevice device = null;
                for (String ip : deviceIPs) {
                    flag = this.checkIp(ip);
                    if (!flag) {
                        cleanResult.setStatus("false");
                        cleanResult.setErrorCode("2");
                        cleanResult.setMsg("device_ips format error!");
                        this.logger.warn((Object)"device_ips format error !");
                        return cleanResult;
                    }
                    device = tAticDeviceService.getDeviceByIp(ip);
                    if (device == null) {
                        cleanResult.setStatus("false");
                        cleanResult.setErrorCode("2");
                        cleanResult.setMsg("device_ips: " + ip + " device not exist!");
                        this.logger.warn((Object)("device_ips: " + ip + " device not exist!"));
                        return cleanResult;
                    }
                    if (device.getDdosType() == 0 || device.getDdosType() == 2) {
                        this.logger.info((Object)("device_ips: " + ip + " device is clean device!"));
                        continue;
                    }
                    cleanResult.setStatus("false");
                    cleanResult.setErrorCode("2");
                    cleanResult.setMsg("device_ips: " + ip + " device not clean device!");
                    this.logger.warn((Object)("device_ips: " + ip + " device not clean device!"));
                    return cleanResult;
                }
                String strategyName = protectDetailInfo.getStrategyName();
                if (strategyName == null || "".equals(strategyName)) {
                    cleanResult.setStatus("false");
                    cleanResult.setErrorCode("2");
                    cleanResult.setMsg("strategy_name is null!");
                    this.logger.warn((Object)"strategy_name is null!");
                    return cleanResult;
                }
                ZoneInfoForm zoneInfo = this.zoneService.getZoneByName(strategyName);
                if (zoneInfo == null) {
                    cleanResult.setStatus("false");
                    cleanResult.setErrorCode("2");
                    cleanResult.setMsg("strategy_name:" + strategyName + " not exist!");
                    this.logger.warn((Object)("strategy_name:" + strategyName + " not exist!"));
                    return cleanResult;
                }
                if (zoneInfo.getZoneType() == 1) {
                    cleanResult.setStatus("false");
                    cleanResult.setErrorCode("2");
                    cleanResult.setMsg("strategy_name:" + strategyName + " is default zone, not supported ip!");
                    this.logger.warn((Object)("strategy_name:" + strategyName + " is default zone, not supported ip!"));
                    return cleanResult;
                }
                String cleanType = protectDetailInfo.getCleanType();
                for (String protectIP01 : protectIPs) {
                    boolean ipv4 = IPUtil.isIpv4((String)protectIP01.split("/")[0]);
                    if (cleanType == null || "".equals(cleanType)) continue;
                    if ("JYQX".equals(cleanType) || "JMDQX".equals(cleanType)) {
                        for (String ip : deviceIPs) {
                            String nextHop = tAticDeviceService.getNexthopIpByDeviceIpAndCleanType(ip, cleanType, ipv4);
                            if (nextHop != null && !"".equals(nextHop)) continue;
                            cleanResult.setStatus("false");
                            cleanResult.setErrorCode("2");
                            StringBuffer message = new StringBuffer();
                            message.append("device_ips: " + ip);
                            if ("JYQX".equals(cleanType)) {
                                message.append(" JYQX ");
                            } else {
                                message.append(" JMDQX ");
                            }
                            if (ipv4) {
                                message.append(" nexthop ipv4 address not exist!");
                            } else {
                                message.append(" nexthop ipv6 address not exist!");
                            }
                            cleanResult.setMsg(message.toString());
                            this.logger.warn((Object)("device_ips: " + ip + " nexthop not exist!"));
                            return cleanResult;
                        }
                        continue;
                    }
                    cleanResult.setStatus("false");
                    cleanResult.setErrorCode("2");
                    cleanResult.setMsg("clean_type format error!");
                    this.logger.warn((Object)"clean_type format error!");
                    return cleanResult;
                }
            }
        } else {
            cleanResult.setStatus("false");
            cleanResult.setErrorCode("2");
            cleanResult.setMsg("task_id value is null!");
            this.logger.warn((Object)"task_id value is null!");
        }
        if ("true".equals(cleanResult.getStatus())) {
            cleanResult.setErrorCode("0");
            cleanResult.setMsg("check success!");
            this.logger.info((Object)("task_id:" + taskId + "  is ok!"));
        }
        return cleanResult;
    }

    private RestCleanResult checkCleanStopInfo(RestCleanStopInfo restCleanStopInfo, TaskUnicomService tTaskUnicomService, OperateTaskUnicomService tOperateTaskService) {
        RestCleanResult cleanResult = new RestCleanResult();
        cleanResult.setStatus("true");
        String taskId = restCleanStopInfo.getTaskId();
        if (taskId != null && !"".equals(taskId)) {
            TaskUnicomEntity taskEntity = tTaskUnicomService.getTaskUnicomById(taskId);
            if (null == taskEntity) {
                cleanResult.setStatus("false");
                cleanResult.setErrorCode("2");
                cleanResult.setMsg("task_id is not exist!");
                return cleanResult;
            }
            String command = restCleanStopInfo.getCommand();
            if (command == null || "".equals(command)) {
                cleanResult.setStatus("false");
                cleanResult.setErrorCode("2");
                cleanResult.setMsg("command is null!");
                this.logger.warn((Object)"command is null!");
                return cleanResult;
            }
            if (!CLEANSTOP.equals(command)) {
                cleanResult.setStatus("false");
                cleanResult.setErrorCode("2");
                cleanResult.setMsg("command is error!");
                this.logger.warn((Object)"command is error!");
                return cleanResult;
            }
            List<TaskOperateUnicomEntity> taskOperateEntitys = tOperateTaskService.getOperateTaskUnicom(CLEANSTOP, taskId);
            if (taskOperateEntitys != null && taskOperateEntitys.size() > 0) {
                cleanResult.setStatus("false");
                cleanResult.setErrorCode("1");
                cleanResult.setMsg("task_id:" + taskId + " is resend");
                return cleanResult;
            }
            taskOperateEntitys = tOperateTaskService.getOperateTaskUnicom(CLEANSTART, taskId);
            if (taskOperateEntitys != null && taskOperateEntitys.size() > 0) {
                boolean flag = false;
                for (TaskOperateUnicomEntity operate : taskOperateEntitys) {
                    if (operate.getStatus() != 0) continue;
                    flag = true;
                    break;
                }
                if (!flag) {
                    cleanResult.setStatus("false");
                    cleanResult.setErrorCode("2");
                    cleanResult.setMsg("task_id:" + taskId + " is fail\uff0cbecause when cleanStart fail to pass check!");
                    return cleanResult;
                }
            }
        } else {
            cleanResult.setStatus("false");
            cleanResult.setErrorCode("2");
            cleanResult.setMsg("task_id value is null!");
            this.logger.warn((Object)"task_id value is null!");
        }
        if ("true".equals(cleanResult.getStatus())) {
            cleanResult.setErrorCode("0");
            cleanResult.setMsg("");
        }
        return cleanResult;
    }

    private Response formatResult(Response.ResponseBuilder responseBuilder, RestCleanResult resultBean) {
        String jsonResult = "";
        try {
            jsonResult = JSONUtil.getInstance().toJSON((Object)resultBean);
            this.logger.info((Object)("RestCleanTaskServiceImpl response result :" + jsonResult));
        }
        catch (Exception e) {
            RestUtil.processSysLog((String)"divert", (int)500, (String)"convert the format from java to json  failed.", (Exception)e);
            this.logger.error((Object)("(RestCleanResult) convert the format from java to json  failed." + e));
        }
        return responseBuilder.entity((Object)jsonResult).build();
    }

    private TaskUnicomEntity convert2TaskUnicomEntity(RestCleanStartInfo cleanStartInfo) {
        TaskUnicomEntity taskEntity = new TaskUnicomEntity();
        taskEntity.setTaskId(cleanStartInfo.getTaskId());
        if (null != cleanStartInfo.getProtectIPs()) {
            taskEntity.setProtectIps(cleanStartInfo.getProtectIPs().toString());
        }
        if (null != cleanStartInfo.getProtectDetail()) {
            try {
                taskEntity.setProtectDetail(JSONUtil.getInstance().toJSON(cleanStartInfo.getProtectDetail()));
            }
            catch (IOException e) {
                this.logger.error((Object)"(RestCleanResult) protectDetail to json error. ", (Throwable)e);
            }
        }
        taskEntity.setCreateTime(System.currentTimeMillis() / 1000L);
        return taskEntity;
    }

    private TaskOperateUnicomEntity convert2TaskOperateUnicomEntity(RestCleanStartInfo cleanStartInfo) {
        TaskOperateUnicomEntity taskOperateEntity = new TaskOperateUnicomEntity();
        taskOperateEntity.setTaskId(cleanStartInfo.getTaskId());
        taskOperateEntity.setProtectIp("--");
        taskOperateEntity.setCleanEq("--");
        taskOperateEntity.setExecutTime(System.currentTimeMillis() / 1000L);
        taskOperateEntity.setCommand(CLEANSTART);
        return taskOperateEntity;
    }

    private TaskOperateUnicomEntity convert2TaskOperateUnicomEntity(TaskUnicomEntity taskEntity) {
        TaskOperateUnicomEntity taskOperateEntity = new TaskOperateUnicomEntity();
        taskOperateEntity.setTaskId(taskEntity.getTaskId());
        taskOperateEntity.setProtectIp("--");
        taskOperateEntity.setCleanEq("--");
        taskOperateEntity.setExecutTime(System.currentTimeMillis() / 1000L);
        return taskOperateEntity;
    }

    private boolean checkIpMark(String ipMark) {
        try {
            this.logger.info((Object)("check ipMark:" + ipMark));
            if (!ipMark.contains("/")) {
                this.logger.warn((Object)"check ipMark not contains '/'!");
                return false;
            }
            String[] zoneIpDetails = ipMark.split("/");
            IPUtil.getSubnetRange((String)zoneIpDetails[0], (int)Integer.parseInt(zoneIpDetails[1]));
        }
        catch (RuntimeException ew) {
            this.logger.warn((Object)"getSubnetRange has error!");
            return false;
        }
        return true;
    }

    private boolean checkIp(String ip) {
        try {
            if (IPUtil.isIpv4((String)ip) || IPUtil.isIpv6((String)ip)) {
                return true;
            }
        }
        catch (Exception ew) {
            return false;
        }
        return false;
    }

    public TaskUnicomService getTaskUnicomService() {
        return this.taskUnicomService;
    }

    public void setTaskUnicomService(TaskUnicomService taskUnicomService) {
        this.taskUnicomService = taskUnicomService;
    }

    public OperateTaskUnicomService getOperateTaskService() {
        return this.operateTaskService;
    }

    public void setOperateTaskService(OperateTaskUnicomService operateTaskService) {
        this.operateTaskService = operateTaskService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public CleanTaskBufferService getCleanTaskBufferService() {
        return this.cleanTaskBufferService;
    }

    public void setCleanTaskBufferService(CleanTaskBufferService cleanTaskBufferService) {
        this.cleanTaskBufferService = cleanTaskBufferService;
    }

    public IZoneService getZoneService() {
        return this.zoneService;
    }

    public void setZoneService(IZoneService zoneService) {
        this.zoneService = zoneService;
    }
}

