/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.security;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.security.AcceptedPatternsChecker;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class DefaultAcceptedPatternsChecker
implements AcceptedPatternsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAcceptedPatternsChecker.class);
    public static final String[] ACCEPTED_PATTERNS = new String[]{"\\w+((\\.\\w+)|(\\[\\d+\\])|(\\(\\d+\\))|(\\['(\\w|[\\u4e00-\\u9fa5])+'\\])|(\\('(\\w|[\\u4e00-\\u9fa5])+'\\)))*"};
    private Set<Pattern> acceptedPatterns;

    public DefaultAcceptedPatternsChecker() {
        this.setAcceptedPatterns(ACCEPTED_PATTERNS);
    }

    @Inject(value="overrideAcceptedPatterns", required=false)
    public void setOverrideAcceptedPatterns(String acceptablePatterns) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Overriding accepted patterns [#0] with [#1], be aware that this affects all instances and safety of your application!", "overrideAcceptedPatterns", acceptablePatterns);
        }
        this.acceptedPatterns = new HashSet<Pattern>();
        for (String pattern : TextParseUtil.commaDelimitedStringToSet(acceptablePatterns)) {
            this.acceptedPatterns.add(Pattern.compile(pattern, 2));
        }
    }

    @Inject(value="additionalAcceptedPatterns", required=false)
    public void setAdditionalAcceptedPatterns(String acceptablePatterns) {
        if (LOG.isDebugEnabled()) {
            LOG.warn("Adding additional global patterns [#0] to accepted patterns!", acceptablePatterns);
        }
        for (String pattern : TextParseUtil.commaDelimitedStringToSet(acceptablePatterns)) {
            this.acceptedPatterns.add(Pattern.compile(pattern, 2));
        }
    }

    @Override
    public void setAcceptedPatterns(String commaDelimitedPatterns) {
        this.setAcceptedPatterns(TextParseUtil.commaDelimitedStringToSet(commaDelimitedPatterns));
    }

    @Override
    public void setAcceptedPatterns(String[] additionalPatterns) {
        this.setAcceptedPatterns(new HashSet<String>(Arrays.asList(additionalPatterns)));
    }

    @Override
    public void setAcceptedPatterns(Set<String> patterns) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sets accepted patterns [#0]", patterns);
        }
        this.acceptedPatterns = new HashSet<Pattern>(patterns.size());
        for (String pattern : patterns) {
            this.acceptedPatterns.add(Pattern.compile(pattern, 2));
        }
    }

    @Override
    public AcceptedPatternsChecker.IsAccepted isAccepted(String value) {
        for (Pattern acceptedPattern : this.acceptedPatterns) {
            if (!acceptedPattern.matcher(value).matches()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("[#0] matches accepted pattern [#1]", value, acceptedPattern);
            }
            return AcceptedPatternsChecker.IsAccepted.yes(acceptedPattern.toString());
        }
        return AcceptedPatternsChecker.IsAccepted.no(this.acceptedPatterns.toString());
    }

    @Override
    public Set<Pattern> getAcceptedPatterns() {
        return this.acceptedPatterns;
    }
}

