/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.action;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.exception.LegoSecurityException;
import com.security.ireport.engine.PluginManager;
import com.security.ireport.engine.ReportSession;
import com.security.ireport.engine.ReportSessionManager;
import com.security.ireport.engine.definition.ComponentElement;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.engine.exception.ParaException;
import com.security.ireport.engine.output.ExportReport;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.model.vo.TableObj;
import com.security.ireport.util.CRCCheckUtil;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.JSONUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.validator.ReportValidatorFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class QueryReportRestful {
    public static final String COMMA = ",";
    public static final String USERS = "users";
    public static final String DEPARTMENT = "department";
    public static final String OPERA_OBJECT = "operaObject";
    public static final String OEPRA_USER_ALL = "0";
    public static final String OEPRA_USER = "1";
    public static final String OEPRA_IP = "2";
    public static final String OEPRA_DEPARTMENT = "3";
    public static final String NETWORK = "network";
    public static final String NE_ALL = "0";
    public static final String SELECT_NE_GROUP = "1";
    public static final String SELECT_NE = "2";
    public static final String STATISTICCONTENT = "statistictcontent";
    public static final String URLTYPESWITCHOPTION = "urlTypeSwitchOption";
    public static final String SELECT_URLTYPES = "1";
    public static final String SELECT_URLSUBTYPES = "2";
    public static final String URLTYPES = "urlTypes";
    public static final String URLSUBTYPES = "urlSubTypes";
    public static final String NE_GROUP = "group";
    public static final String DEVICE_ID = "DEVICE_ID";
    public static final String SWITCH_OPTION = "switchOption";
    public static final String SWITCH_APP_TYPE = "1";
    public static final String SWITCH_APP_SUBTYPE = "2";
    public static final String SWITCH_APP = "3";
    public static final String APP = "app";
    public static final String APP_TYPE = "appType";
    public static final String APP_SUBTYPE = "appSubType";
    public static final String STARTIP = "ipMark1";
    public static final String ENDIP = "ipMark2";
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private String reportId;
    private TableObj tableObj = new TableObj();
    private Long sessionId = 0L;
    private String sessionIds;
    private List<ComponentElement> elementList = new ArrayList<ComponentElement>();
    private int columnNumber = 1;
    private List<String> exportList = new ArrayList<String>();
    private String conditionStr;
    private String checkCode;
    private String exportCountAlert;
    private int maxExportCount;
    private String templateName;
    private String templateId = null;
    private boolean saveCond = false;
    private String theme;
    private String ccAddressee;
    private String content;
    private String exportTypes;
    private String type;
    private String pageSize;
    private String pageNum;
    private boolean firstQuery = true;
    private boolean checkBackTaskReport = false;
    private String dataDrillTitle;
    private String reportSessionId;
    private String orderField;
    private String orderType;
    private String httpSessionId;
    private Locale locale;
    private String curUserName;
    private long userId;
    private String path;
    private String unitText;

    public String getUnitText() {
        return this.unitText;
    }

    public void setUnitText(String unitText) {
        this.unitText = unitText;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getCurUserName() {
        return this.curUserName;
    }

    public void setCurUserName(String curUserName) {
        this.curUserName = curUserName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    public void setHttpSessionId(String httpSessionId) {
        this.httpSessionId = httpSessionId;
    }

    public void importTurnBackTaskPage() {
        this.validateImportTurnBackTaskPage();
        Map<String, JsonValueObj> reportCond = null;
        boolean createReportSessionSuccess = true;
        ReportSession reportSession = ReportSessionManager.getInstance().createReportSession(this.reportId, this.getHttpSessionId(), this.locale);
        if (null == reportSession) {
            createReportSessionSuccess = false;
            LOGGER.error((Object)"rest:importTurnBackTaskPage : create reportSession failure");
        } else {
            this.sessionId = reportSession.getSessionId();
        }
        try {
            reportCond = JSONUtil.transformKeyValueObjMap(this.conditionStr);
            if (null != reportSession) {
                boolean result = reportSession.splitTask(reportCond);
                if (createReportSessionSuccess && result) {
                    LOGGER.error((Object)"rest:importTurnBackTaskPage : createReportSessionSuccess && result. error");
                }
            }
        }
        catch (ParaException e) {
            e.printStackTrace();
            LOGGER.error((Object)("rest:importTurnBackTaskPage : conditionStr value is invalid , and redirect to attack process. conditionStr: " + this.conditionStr), (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)"rest:importTurnBackTaskPage : ", (Throwable)e);
        }
    }

    public boolean queryReport() {
        LOGGER.info((Object)"rest:queryReport : start queryReport");
        boolean checkCycl = this.checkCyclomatic();
        if (!checkCycl) {
            LOGGER.error((Object)("rest:queryReport : checkCyclomatic : " + checkCycl));
            return false;
        }
        if (null == this.sessionId || this.sessionId == 0L) {
            LOGGER.error((Object)"rest:queryReport : sessionId is null!");
            return false;
        }
        try {
            ReportSession reportSession = null;
            LOGGER.info((Object)"rest:queryReport : get reportSession");
            reportSession = this.getReportSession(this.getHttpSessionId(), this.sessionId, this.checkBackTaskReport);
            JsonValueObj user = new JsonValueObj("currentLogUserId", this.userId + "", this.curUserName);
            reportSession.getParameterMap().put("currentLogUserId", user);
            JsonValueObj byInterface = new JsonValueObj("byInterface", this.locale.toString(), this.locale.toString());
            reportSession.getParameterMap().put("byInterface", byInterface);
            LOGGER.info((Object)"rest:queryReport : get reportSession sucess");
            reportSession.setJsonValueStr(this.conditionStr);
            this.sessionId = reportSession.getSessionId();
            LOGGER.info((Object)("rest:queryReport : get reportSession sessionId=" + this.sessionId));
            this.handleFirstQuery(this.firstQuery, reportSession, this.checkBackTaskReport);
            LOGGER.info((Object)"rest:queryReport : after handleFirstQuery");
            return true;
        }
        catch (ParaException e) {
            LOGGER.error((Object)("rest:queryReport : conditionStr value is invalid , and redirect to attack process. conditionStr: " + this.conditionStr), (Throwable)e);
            return false;
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("rest:queryReport : failed to queryReport errorcode is " + e.getErrorCode()), (Throwable)e);
            throw e;
        }
    }

    private boolean checkCyclomatic() {
        boolean isValidateQueryReport = this.validateQueryReport();
        if (!isValidateQueryReport) {
            LOGGER.error((Object)"old validate query report param error");
            return false;
        }
        if (null == this.reportId) {
            return false;
        }
        boolean isValidate = ReportValidatorFactory.getInstance().validate(this.reportId, this.conditionStr);
        if (!isValidate) {
            LOGGER.error((Object)"new validate query report param error");
            return false;
        }
        return true;
    }

    private Map<String, JsonValueObj> handleFirstQuery(boolean isFirstQuery, ReportSession reportSession, boolean checkBackTaskReportM) throws ParaException {
        Map<String, JsonValueObj> reportCond = null;
        if (isFirstQuery) {
            if (!reportSession.getParameterMap().isEmpty()) {
                reportCond = reportSession.getParameterMap();
            } else if (!IReportConfCheckUtil.isStringEmpty(this.conditionStr)) {
                reportCond = JSONUtil.transformKeyValueObjMap(this.conditionStr);
            } else {
                reportCond = this.getProductCond();
                reportSession.splitTask(reportCond);
            }
            if (TimeZone.getDefault().useDaylightTime() && reportCond != null && reportCond.get("dateRange") != null) {
                JsonValueObj valueObj = reportCond.get("dateRange");
                List<JsonValueItem> valueList = valueObj.getValueList();
                for (JsonValueItem jsonValueItem : valueList) {
                    String valueH = jsonValueItem.getValue();
                    if (!valueH.matches("\\d+")) continue;
                    Date baseTime = new Date(Long.parseLong(valueH) * 1000L);
                    Calendar base = Calendar.getInstance();
                    base.setTime(baseTime);
                    Calendar pre = Calendar.getInstance();
                    Calendar after = Calendar.getInstance();
                    pre.setTime(baseTime);
                    after.setTime(baseTime);
                    pre.add(11, -1);
                    after.add(11, 1);
                    if (pre.get(11) == base.get(11)) {
                        LOGGER.info((Object)("transform1 DST:" + baseTime + " to " + pre.getTime()));
                        jsonValueItem.setValue(String.valueOf(pre.getTime().getTime() / 1000L));
                    }
                    if (after.get(11) != base.get(11)) continue;
                    LOGGER.info((Object)("transform2 DST:" + baseTime + " to " + after.getTime()));
                    jsonValueItem.setValue(String.valueOf(baseTime.getTime() / 1000L));
                }
            }
            if (this.templateId != null) {
                reportSession.splitTask(reportCond);
            }
            if (!"SIG V2".equalsIgnoreCase(IReportConfigUtil.getInstance().getProductName()) && checkBackTaskReportM) {
                reportSession.splitTask(reportCond);
            }
            try {
                reportSession.prepare(reportCond, false);
            }
            catch (NumberFormatException e) {
                throw new LegoSecurityException(206L, "conditionStr");
            }
        }
        return reportCond;
    }

    private Map<String, JsonValueObj> getProductCond() {
        return new HashMap<String, JsonValueObj>();
    }

    private ReportSession getReportSession(String httpSessionIdx, Long reportSessionIdI, boolean checkBackTaskReportM) {
        ReportSession reportSession = null;
        if (checkBackTaskReportM) {
            reportSession = !ReportSessionManager.getInstance().hasReportSession(reportSessionIdI, this.httpSessionId) ? ReportSessionManager.getInstance().createSessionForBackTask(this.reportId, reportSessionIdI, this.httpSessionId, this.locale) : ReportSessionManager.getInstance().getSessionBySessionId(reportSessionIdI, this.httpSessionId);
        } else if (null != reportSessionIdI) {
            reportSession = ReportSessionManager.getInstance().getSessionBySessionId(reportSessionIdI, this.httpSessionId);
            if (null == reportSession) {
                LOGGER.error((Object)"--------------reportSession null: ");
            } else {
                LOGGER.info((Object)("--------------reportSession: " + reportSession));
                this.reportId = reportSession.getIReport().getId();
            }
        } else {
            reportSession = ReportSessionManager.getInstance().createReportSession(this.reportId, this.httpSessionId, this.locale);
        }
        return reportSession;
    }

    public boolean exportReport() {
        ReportSession reportSession = this.getReportSession(this.getHttpSessionId(), this.sessionId, false);
        if (null == reportSession) {
            return false;
        }
        reportSession.prepareJasper();
        ArrayList<ReportSession> reportSessionList = new ArrayList<ReportSession>();
        reportSessionList.add(reportSession);
        ExportReport exportReport = new ExportReport(reportSessionList);
        return exportReport.exportx(this.type, this.reportId, this.curUserName, this.path, this.unitText);
    }

    private String getSuffixName(String fileType) {
        String suffixName = "";
        suffixName = "pdf".equalsIgnoreCase(fileType) ? ".pdf" : ("excel".equalsIgnoreCase(fileType) ? ".xls" : ("html".equalsIgnoreCase(fileType) ? ".zip" : ("csv".equalsIgnoreCase(fileType) ? ".csv" : ("rtf".equalsIgnoreCase(fileType) ? ".rtf" : ""))));
        return suffixName;
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public Long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Long sessionId) {
        this.sessionId = sessionId;
    }

    public List<String> getExportList() {
        return this.exportList;
    }

    public void setExportList(List<String> exportList) {
        this.exportList = exportList;
    }

    public int getMaxExportCount() {
        IReportConfigUtil reportCfg = IReportConfigUtil.getInstance();
        String maxExportStr = reportCfg.getConfig("maxExportCount");
        this.maxExportCount = null != maxExportStr && !maxExportStr.isEmpty() ? Integer.parseInt(maxExportStr) : 2000;
        return this.maxExportCount;
    }

    public void setMaxExportCount(int maxExportCount) {
        this.maxExportCount = maxExportCount;
    }

    public String getExportCountAlert() {
        if (null == this.exportCountAlert || this.exportCountAlert.isEmpty()) {
            String maxReportAlert = LocaleUtil.getLocaleText("export.confirm.datacountExceed");
            this.exportCountAlert = MessageFormat.format(maxReportAlert, this.getMaxExportCount());
        }
        return this.exportCountAlert;
    }

    public void setExportCountAlert(String exportCountAlert) {
        this.exportCountAlert = exportCountAlert;
    }

    public String getConditionStr() {
        return this.conditionStr;
    }

    public void setConditionStr(String conditionStr) {
        this.conditionStr = conditionStr;
    }

    public List<ComponentElement> getElementList() {
        return this.elementList;
    }

    public void setElementList(List<ComponentElement> elementList) {
        this.elementList = elementList;
    }

    public TableObj getTableObj() {
        return this.tableObj;
    }

    public void setTableObj(TableObj tableObj) {
        this.tableObj = tableObj;
    }

    public String getSessionIds() {
        return this.sessionIds;
    }

    public void setSessionIds(String sessionIds) {
        this.sessionIds = sessionIds;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public String getShowQueryReportType() {
        String showQueryReport = IReportConfigUtil.getInstance().getConfig("showQueryReportType");
        return IReportUtil.parseShowQueryReportType(showQueryReport);
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public boolean isSaveCond() {
        return this.saveCond;
    }

    public void setSaveCond(boolean saveCond) {
        this.saveCond = saveCond;
    }

    public boolean validateExportType() {
        String suffixName = this.getSuffixName(this.type);
        return !"".equals(suffixName);
    }

    private boolean validateImportTurnBackTaskPage() {
        boolean jsonValidFlag;
        IReport report = PluginManager.getInstance().getReportPlugin(this.reportId);
        if (null == report) {
            LOGGER.info((Object)"");
        }
        if (!(jsonValidFlag = JSONUtil.isValidJsonStr(this.conditionStr))) {
            LOGGER.error((Object)("conditionStr is invalid jsonstr, and redirect to attack process. conditionStr: " + this.conditionStr));
        }
        return true;
    }

    private boolean validateQueryReport() {
        boolean jsonValidFlag;
        ReportSession reportSession = ReportSessionManager.getInstance().getSessionBySessionId(this.sessionId, this.getHttpSessionId());
        if (null == reportSession) {
            LOGGER.info((Object)"");
        } else if (this.reportId == null) {
            return true;
        }
        IReport report = PluginManager.getInstance().getReportPlugin(this.reportId);
        if (null == report) {
            LOGGER.info((Object)"");
        }
        if (!(jsonValidFlag = JSONUtil.isValidJsonStr(this.conditionStr))) {
            LOGGER.error((Object)("conditionStr is invalid jsonstr, and redirect to attack process. conditionStr: " + this.conditionStr));
        }
        return true;
    }

    public boolean validateEmailThem() {
        String regex = "(?im-)^(?!null$)[\\u4e00-\\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\!|\\:|\\;|\\?|\\.|\\,|\\(|\\)]*$";
        if (null == this.theme || "".equals(this.theme.trim())) {
            return true;
        }
        return this.theme.matches(regex);
    }

    public static String getConditionsById(String id, Map<String, JsonValueObj> reportCond) {
        List<JsonValueItem> valueItems = reportCond.get(id).getValueList();
        if (null == valueItems || valueItems.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (JsonValueItem jsonValueItem : valueItems) {
            sb.append(jsonValueItem.getValue());
            sb.append(COMMA);
        }
        return sb.substring(0, sb.length() - 1);
    }

    public boolean validateCrc() {
        if (null != this.reportId && !this.reportId.isEmpty() && !this.reportId.matches("^[a-zA-Z0-9]{1,30}$")) {
            return false;
        }
        if (null == this.conditionStr || this.conditionStr.isEmpty()) {
            return true;
        }
        if (!this.conditionStr.startsWith("[") || !this.conditionStr.endsWith("]")) {
            return false;
        }
        if (!JSONUtil.isValidJsonStr(this.conditionStr)) {
            return false;
        }
        try {
            JSONUtil.transformKeyValueObjMap(this.conditionStr);
        }
        catch (ParaException e) {
            return false;
        }
        return this.validateCheckCode(this.conditionStr, this.checkCode);
    }

    private boolean validateCheckCode(String conditionStrCh, String checkCodeCh) {
        long code = CRCCheckUtil.getCrc32Code(conditionStrCh);
        if (!String.valueOf(code).equals(checkCodeCh)) {
            LOGGER.error((Object)"conditionStr has been modified");
            return false;
        }
        return true;
    }

    public boolean validateccAddressee() {
        String[] each;
        if (this.ccAddressee == null || "".equals(this.ccAddressee.trim())) {
            return true;
        }
        for (String tempeach : each = this.ccAddressee.split(";")) {
            if (tempeach.matches("^\\w+([-\\.]\\w+)*@\\w+([-\\.]\\w+)*\\.\\w+([-\\.]\\w+)*$")) continue;
            return false;
        }
        return true;
    }

    public String getCheckCode() {
        return this.checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getCcAddressee() {
        return this.ccAddressee;
    }

    public void setCcAddressee(String ccAddressee) {
        this.ccAddressee = ccAddressee;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getExportTypes() {
        return this.exportTypes;
    }

    public void setExportTypes(String exportTypes) {
        this.exportTypes = exportTypes;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(String pageNum) {
        this.pageNum = pageNum;
    }

    public boolean isCheckBackTaskReport() {
        return this.checkBackTaskReport;
    }

    public void setCheckBackTaskReport(boolean checkBackTaskReport) {
        this.checkBackTaskReport = checkBackTaskReport;
    }

    public boolean isFirstQuery() {
        return this.firstQuery;
    }

    public void setFirstQuery(boolean firstQuery) {
        this.firstQuery = firstQuery;
    }

    public String getDataDrillTitle() {
        return this.dataDrillTitle;
    }

    public void setDataDrillTitle(String dataDrillTitle) {
        this.dataDrillTitle = dataDrillTitle;
    }

    public String getReportSessionId() {
        return this.reportSessionId;
    }

    public void setReportSessionId(String reportSessionId) {
        this.reportSessionId = reportSessionId;
    }

    public String getOrderField() {
        return this.orderField;
    }

    public void setOrderField(String orderField) {
        this.orderField = orderField;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }
}

