/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.action;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.PluginManager;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.util.ProductFaceUtil;
import com.security.logserver.module.condition.ConditionMgr;
import com.security.logserver.module.condition.common.BaseAction;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReportPageAction
extends BaseAction
implements ApplicationContextAware {
    public static final int PARAM_ERROR = 570505;
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final long serialVersionUID = 1L;
    private String reportId;
    private String conditionStr;
    private String isSigCustomReport = "false";
    private Integer formNum;
    private transient ApplicationContext appContent;

    public Integer getFormNum() {
        return this.formNum;
    }

    public void setFormNum(Integer formNum) {
        this.formNum = formNum;
    }

    public String getReportPage() {
        try {
            LOGGER.info((Object)("start getReportPage, reportId=" + this.reportId));
            IReport report = PluginManager.getInstance().getReportPlugin(this.reportId);
            if (null == report) {
                LOGGER.error((Object)"getReportPage report is null");
                this.getSysOptLog().setDetail("elog.report.err.reportobject.not.exist");
                this.getSysOptLog().setDetailPara(new String[]{this.reportId});
                this.writeOptLog();
                this.secoOptWithAttack();
                return "error";
            }
            LOGGER.info((Object)("getReportPage report=" + report.toString()));
            ConditionMgr.getInstance().setConditionInfoToRequest(report.getId(), this.fetchRequest(), this.appContent, this.reportId);
            LOGGER.info((Object)"end getReportPage");
            return "reportPageResult";
        }
        catch (Exception e) {
            LOGGER.error((Object)"getReportPage:", (Throwable)e);
            if (ProductFaceUtil.getInstance().isBusinessException(e)) {
                ProductFaceUtil.getInstance().throwProductException(e.getMessage(), "INFO", e);
            }
            return "error";
        }
    }

    public boolean validateReportId() {
        return null == this.reportId || this.reportId.matches("^[a-zA-Z0-9]+$");
    }

    public String getReportId() {
        return this.reportId;
    }

    public String getNullPage() {
        return "success";
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public String getConditionStr() {
        return this.conditionStr;
    }

    public void setConditionStr(String conditionStr) {
        this.conditionStr = conditionStr;
    }

    public void setApplicationContext(ApplicationContext arg0) {
        this.appContent = arg0;
    }

    public String getIsSigCustomReport() {
        return this.isSigCustomReport;
    }

    public void setIsSigCustomReport(String isSigCustomReport) {
        this.isSigCustomReport = isSigCustomReport;
    }

    public String showWinGrid() {
        return "success";
    }

    public String showWinTree() {
        return "success";
    }
}

