/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.awt.Color;
import java.awt.Paint;
import java.util.Locale;

public abstract class ChartUtil {
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final int R = 0;
    private static final int G = 1;
    private static final int B = 2;

    public static Paint getPaint(String rgbString) {
        try {
            String[] rgbStringArray = rgbString.split(",");
            Color paint = new Color(Integer.parseInt(rgbStringArray[0].trim()), Integer.parseInt(rgbStringArray[1].trim()), Integer.parseInt(rgbStringArray[2].trim()));
            return paint;
        }
        catch (Exception e) {
            LOG.error((Object)("color '" + rgbString + "' is not valid color"), (Throwable)e);
            return Color.WHITE;
        }
    }

    public static String getFontColor(String rgbString) {
        try {
            String[] rgbStringArray = rgbString.split(",");
            String hexString = ChartUtil.toHexString(Integer.parseInt(rgbStringArray[0].trim())) + ChartUtil.toHexString(Integer.parseInt(rgbStringArray[1].trim())) + ChartUtil.toHexString(Integer.parseInt(rgbStringArray[2].trim()));
            return "#" + hexString;
        }
        catch (Exception e) {
            LOG.error((Object)("color '" + rgbString + "' is not valid color"), (Throwable)e);
            return "#ffffff";
        }
    }

    public static String getFontColor(int r, int g, int b) {
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            LOG.error((Object)("r =" + r + ";g = " + g + ";b = " + b + " is not valid color"));
            return "#ffffff";
        }
        String hexString = ChartUtil.toHexString(r) + ChartUtil.toHexString(g) + ChartUtil.toHexString(b);
        return "#" + hexString;
    }

    private static String toHexString(int r) {
        String result = Integer.toHexString(r);
        if (1 == result.length()) {
            result = "0" + result;
        }
        return result;
    }

    public static int[] transHextoRGB(String hex) {
        int[] rgb = new int[3];
        int i = 0;
        int j = 0;
        while (i < 3) {
            rgb[i] = Integer.valueOf(hex.substring(j, j + 2), 16);
            ++i;
            j += 2;
        }
        return rgb;
    }

    public static String transRGBtoHex(int[] rgbNew) {
        int rgb = new Color(rgbNew[0], rgbNew[1], rgbNew[2]).getRGB() - -16777216;
        String colorSty = String.format("%1$#6s", Integer.toHexString(rgb).toUpperCase(Locale.getDefault()));
        return colorSty.replace(' ', '0');
    }
}

