/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.engine.dataset.FieldList;
import com.security.ireport.engine.dataset.ParaList;
import com.security.ireport.engine.dataset.Parameter;
import com.security.ireport.engine.definition.ExtendAttribute;
import com.security.ireport.engine.definition.HeaderColumn;
import com.security.ireport.engine.definition.HeaderRow;
import com.security.ireport.engine.definition.IPageFooter;
import com.security.ireport.engine.definition.IPageHeader;
import com.security.ireport.engine.definition.IRAxis;
import com.security.ireport.engine.definition.IRChart;
import com.security.ireport.engine.definition.IRChartDataItem;
import com.security.ireport.engine.definition.IRColorMap;
import com.security.ireport.engine.definition.IRColumn;
import com.security.ireport.engine.definition.IRColumnCase;
import com.security.ireport.engine.definition.IRCover;
import com.security.ireport.engine.definition.IRDataSet;
import com.security.ireport.engine.definition.IRDataSource;
import com.security.ireport.engine.definition.IRDefine;
import com.security.ireport.engine.definition.IRFirstPage;
import com.security.ireport.engine.definition.IRLabelGenerator;
import com.security.ireport.engine.definition.IRPlot;
import com.security.ireport.engine.definition.IRSeriesColor;
import com.security.ireport.engine.definition.IRSwitchOption;
import com.security.ireport.engine.definition.IRTable;
import com.security.ireport.engine.definition.IRTextField;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.engine.definition.SqlSectionList;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportDTDParser;
import com.security.ireport.util.IReportMgrUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.chart.LegendUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.digester.Digester;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class IReportParse {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static IReportParse pluginParse = null;
    private IReport commReport = null;
    private Digester dgstr = null;
    private final Object lock = new Object();

    private IReportParse() {
        String commReportPath = IReportUtil.getRealPath() + "/iReport/iReportBiz/config/commReport.xml";
        this.dgstr = this.createDigester();
        this.commReport = this.createIReportObj(commReportPath);
        if (this.commReport != null) {
            try {
                LegendUtil.createFourColLegendSubreport(this.commReport.getIRChartList().get(0).getPlot().getAllColorList());
                LegendUtil.createTwoColLegendSubreport(this.commReport.getIRChartList().get(0).getPlot().getAllColorList());
            }
            catch (Exception e) {
                LOGGER.error((Object)"create legendSubreport failed", (Throwable)e);
            }
        }
    }

    public static IReportParse getInstance() {
        if (null == pluginParse) {
            pluginParse = new IReportParse();
        }
        return pluginParse;
    }

    public IReport getPluginWithNoCheck(String pluginPath, String dirName) {
        IReport iReport = null;
        iReport = this.createIReportObj(pluginPath, dirName);
        return iReport;
    }

    public IReport getPlugin(String topPath, String reportId, StringBuffer sb) {
        String ret = "";
        IReport myReport = null;
        String pluginFile = IReportUtil.getRealPath() + "/iReport/iReportBiz/temp/" + topPath + File.separator + reportId;
        if (!IReportMgrUtil.isExistNeededFiles(pluginFile)) {
            ret = "Plugin id:" + reportId + " must have 5 necessary files at least, please check.";
        } else {
            myReport = this.createIReportObj(pluginFile, reportId);
            if (null == myReport) {
                ret = "Create plugin ID:" + reportId + " object failed!";
            } else {
                ret = IReportConfCheckUtil.isReportPlugValid(myReport, pluginFile);
                if (!IReportConfCheckUtil.isStringEmpty(ret)) {
                    myReport = null;
                }
            }
        }
        sb.append(ret);
        return myReport;
    }

    public IReport getPlugin(String pluginId) {
        IReport iReport = null;
        String ret = "";
        String pluginFile = IReportUtil.getRealPath() + "/iReport/iReportBiz/reportPlugins/" + pluginId;
        if (!IReportMgrUtil.isExistNeededFiles(pluginFile)) {
            ret = pluginId + LocaleUtil.getProperty("plugin.dir.not.full");
            LOGGER.error((Object)ret);
        } else {
            iReport = this.createIReportObj(pluginFile, pluginId);
            if (null == iReport) {
                ret = "Create plugin ID:" + pluginId + " object failed!";
                LOGGER.error((Object)ret);
            } else {
                ret = IReportConfCheckUtil.isReportPlugValid(iReport, pluginFile);
                if (!IReportConfCheckUtil.isStringEmpty(ret)) {
                    iReport = null;
                }
            }
        }
        return iReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IReport createIReportObj(String pluginFullPath) {
        IReport iReport = null;
        File sourceFile = null;
        InputStream in = null;
        try {
            sourceFile = new File(pluginFullPath);
            in = new FileInputStream(sourceFile);
            iReport = this.parseInputStream(in);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Can not find file:" + pluginFullPath), (Throwable)e);
            iReport = null;
        }
        catch (SAXException e) {
            LOGGER.error((Object)("File configurate error:" + pluginFullPath), (Throwable)e);
            iReport = null;
        }
        catch (Exception e) {
            LOGGER.error((Object)("File configurate error:" + pluginFullPath), (Throwable)e);
            iReport = null;
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Close report.xml stream with error:", (Throwable)e);
            }
        }
        return iReport;
    }

    private IReport createIReportObj(String pluginPath, String dirName) {
        String pluginFullPath = pluginPath + File.separator + "report.xml";
        IReport iReport = this.createIReportObj(pluginFullPath);
        if (null != iReport) {
            iReport.setId(dirName);
            this.setCommReportConf(iReport);
        }
        return iReport;
    }

    private void setCommReportConf(IReport ireport) {
        if (ireport != null && this.commReport != null) {
            IRChart commChart = this.commReport.getIRChartList().get(0);
            this.setCommonReportConfChart(commChart, ireport.getIRChartList());
            this.setCommonReportConfChart(commChart, ireport.getTableCellIRChartMap().values());
        }
    }

    private void setCommonReportConfChart(IRChart commChart, Collection<IRChart> chartList) {
        for (IRChart chart : chartList) {
            if (chart.getPlot().getSectionPaintList().isEmpty()) {
                chart.getPlot().setSectionPaintList(commChart.getPlot().getSectionPaintList());
            }
            if (chart.getPlot().getColorMapList().isEmpty()) {
                chart.getPlot().setColorMapList(commChart.getPlot().getColorMapList());
            }
            if (chart.getTopN() <= 0) {
                chart.setTopN(commChart.getTopN());
            }
            if (chart.getWidth() <= 0) {
                if (chart.isTableCell()) {
                    chart.setWidth(120);
                } else {
                    chart.setWidth(commChart.getWidth());
                }
            }
            if (chart.getHeight() > 0) continue;
            if (chart.isTableCell()) {
                chart.setHeight(60);
                continue;
            }
            chart.setHeight(commChart.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IReport parseInputStream(InputStream in) throws IOException, SAXException {
        Object object = this.lock;
        synchronized (object) {
            IReport iReport = null;
            this.clearDigester();
            iReport = (IReport)this.dgstr.parse(in);
            this.clearDigester();
            return iReport;
        }
    }

    private void clearDigester() {
        this.dgstr.resetRoot();
        this.dgstr.clear();
    }

    private Digester createDigester() {
        Digester dgstrNew = new Digester();
        dgstrNew.addObjectCreate("report", IReport.class);
        dgstrNew.addSetProperties("report", "name", "name");
        dgstrNew.addSetProperties("report", "version", "version");
        dgstrNew.addSetProperties("report", "publishTime", "publishTime");
        dgstrNew.addSetProperties("report", "showMenu", "showMenu");
        dgstrNew.addSetProperties("report", "treeNodeKey", "treeNodeKey");
        dgstrNew.addSetProperties("report", "export", "export");
        dgstrNew.addSetProperties("report", "refresh", "refresh");
        dgstrNew.addSetProperties("report", "useProductDefine", "useProductDefine");
        dgstrNew.addSetProperties("report", "buildJasper", "buildJasper");
        dgstrNew.addObjectCreate("report/switchOption", IRSwitchOption.class);
        dgstrNew.addSetNestedProperties("report/switchOption", "caseValue", "caseValue");
        dgstrNew.addSetNext("report/switchOption", "addIRSwitchOption");
        dgstrNew.addObjectCreate("report/define", IRDefine.class);
        dgstrNew.addSetProperties("report/define", "title", "title");
        dgstrNew.addSetProperties("report/define", "caseValue", "caseValue");
        dgstrNew.addSetProperties("report/define", "style", "style");
        dgstrNew.addSetProperties("report/define", "columnNumber", "columnNumber");
        dgstrNew.addSetProperties("report/define", "exportShowCondition", "exportShowCondition");
        dgstrNew.addSetProperties("report/define", "titleBold", "titleBold");
        dgstrNew.addSetProperties("report/define", "mainTitle", "mainTitle");
        dgstrNew.addSetProperties("report/define", "showReportTitle", "showReportTitle");
        dgstrNew.addSetProperties("report/define", "mainTitleBold", "mainTitleBold");
        dgstrNew.addSetNext("report/define", "addIRDefine");
        dgstrNew.addObjectCreate("report/pageHeader", IPageHeader.class);
        dgstrNew.addSetProperties("report/pageHeader", "imageName", "imageName");
        dgstrNew.addSetProperties("report/pageHeader", "pageHeaderTitle", "pageHeaderTitle");
        dgstrNew.addSetProperties("report/pageHeader", "showPageHeader", "showPageHeader");
        dgstrNew.addSetNext("report/pageHeader", "addPageHeader");
        dgstrNew.addObjectCreate("report/pageFooter", IPageFooter.class);
        dgstrNew.addSetProperties("report/pageFooter", "showPageFooter", "showPageFooter");
        dgstrNew.addSetNext("report/pageFooter", "addPageFooter");
        dgstrNew.addObjectCreate("report/cover", IRCover.class);
        dgstrNew.addSetProperties("report/cover", "coverMainTitle", "coverMainTitle");
        dgstrNew.addSetProperties("report/cover", "coverTitle", "coverTitle");
        dgstrNew.addSetProperties("report/cover", "coverReportCycle", "coverReportCycle");
        dgstrNew.addSetProperties("report/cover", "coverReportTime", "coverReportTime");
        dgstrNew.addSetProperties("report/cover", "showCover", "showCover");
        dgstrNew.addSetProperties("report/cover", "coverImagePath", "coverImagePath");
        dgstrNew.addSetNext("report/cover", "addCover");
        dgstrNew.addObjectCreate("report/firstPage", IRFirstPage.class);
        dgstrNew.addSetProperties("report/firstPage", "showFirstPage", "showFirstPage");
        dgstrNew.addSetProperties("report/firstPage", "title", "title");
        dgstrNew.addSetProperties("report/firstPage", "reportDesc", "reportDesc");
        dgstrNew.addSetProperties("report/firstPage", "reportType", "reportType");
        dgstrNew.addSetProperties("report/firstPage", "reportVersion", "reportVersion");
        dgstrNew.addSetProperties("report/firstPage", "collectionName", "collectionName");
        dgstrNew.addSetProperties("report/firstPage", "authorName", "authorName");
        dgstrNew.addSetProperties("report/firstPage", "dataTime", "dataTime");
        dgstrNew.addSetProperties("report/firstPage", "createTime", "createTime");
        dgstrNew.addSetProperties("report/firstPage", "logImageUrl", "logImageUrl");
        dgstrNew.addSetProperties("report/firstPage", "firstPageUrl", "firstPageUrl");
        dgstrNew.addSetNext("report/firstPage", "addFirstPage");
        dgstrNew.addObjectCreate("report/firstPage/extendAttribute", ExtendAttribute.class);
        dgstrNew.addSetProperties("report/firstPage/extendAttribute", "name", "name");
        dgstrNew.addSetProperties("report/firstPage/extendAttribute", "value", "value");
        dgstrNew.addSetNext("report/firstPage/extendAttribute", "addExtendsAttribute");
        dgstrNew.addObjectCreate("report/textField", IRTextField.class);
        dgstrNew.addSetProperties("report/textField", "id", "id");
        dgstrNew.addSetProperties("report/textField", "text", "text");
        dgstrNew.addSetProperties("report/textField", "fontSize", "fontSize");
        dgstrNew.addSetProperties("report/textField", "bold", "bold");
        dgstrNew.addSetProperties("report/textField", "colspan", "colspan");
        dgstrNew.addSetProperties("report/textField", "bookmarkLevel", "bookmarkLevel");
        dgstrNew.addSetNext("report/textField", "addTextField");
        dgstrNew.addObjectCreate("report/chart", IRChart.class);
        dgstrNew.addSetProperties("report/chart", "id", "id");
        dgstrNew.addSetProperties("report/chart", "comShow", "comShow");
        dgstrNew.addSetProperties("report/chart", "caseValue", "caseValue");
        dgstrNew.addSetProperties("report/chart", "chartType", "chartType");
        dgstrNew.addSetProperties("report/chart", "subTitle", "subTitle");
        dgstrNew.addSetProperties("report/chart", "title", "title");
        dgstrNew.addSetProperties("report/chart", "colspan", "colspan");
        dgstrNew.addSetProperties("report/chart", "backgroundPaint", "backgroundPaint");
        dgstrNew.addSetProperties("report/chart", "borderVisible", "borderVisible");
        dgstrNew.addSetProperties("report/chart", "display", "display");
        dgstrNew.addSetProperties("report/chart", "legendVisible", "legend");
        dgstrNew.addSetProperties("report/chart", "valueShowTop", "valueShowTop");
        dgstrNew.addSetProperties("report/chart", "topN", "topN");
        dgstrNew.addSetProperties("report/chart", "width", "width");
        dgstrNew.addSetProperties("report/chart", "height", "height");
        dgstrNew.addSetProperties("report/chart", "timeLevel", "timeLevel");
        dgstrNew.addSetProperties("report/chart", "domainAxisByParaDate", "domainAxisByParaDate");
        dgstrNew.addSetProperties("report/chart", "pointWidth", "pointWidth");
        dgstrNew.addSetProperties("report/chart", "pointHeight", "pointHeight");
        dgstrNew.addSetProperties("report/chart", "sortOrder", "sortOrder");
        dgstrNew.addSetProperties("report/chart", "tableCell", "tableCell");
        dgstrNew.addObjectCreate("report/chart/dataSet", IRDataSet.class);
        dgstrNew.addSetProperties("report/chart/dataSet", "dataSetType", "dataSetType");
        dgstrNew.addSetProperties("report/chart/dataSet", "datasource", "datasource");
        dgstrNew.addSetProperties("report/chart/dataSet", "autoExpand", "autoExpand");
        dgstrNew.addSetProperties("report/chart/dataSet", "group", "group");
        dgstrNew.addSetProperties("report/chart/dataSet", "fillByTimeCycle", "fillByTimeCycle");
        dgstrNew.addSetProperties("report/chart/dataSet", "fillValue", "fillValue");
        dgstrNew.addSetProperties("report/chart/dataSet", "keyMaxLength", "keyMaxLength");
        dgstrNew.addObjectCreate("report/chart/dataSet/item", IRChartDataItem.class);
        dgstrNew.addSetProperties("report/chart/dataSet/item", "keyFormatType", "keyFormatType");
        dgstrNew.addSetNestedProperties("report/chart/dataSet/item", "key", "key");
        dgstrNew.addSetNestedProperties("report/chart/dataSet/item", "value", "value");
        dgstrNew.addSetNestedProperties("report/chart/dataSet/item", "series", "series");
        dgstrNew.addSetNestedProperties("report/chart/dataSet/item", "urlField", "urlField");
        dgstrNew.addSetNestedProperties("report/chart/dataSet/item", "dataDrillAction", "dataDrillAction");
        dgstrNew.addSetNext("report/chart/dataSet/item", "addDataItem");
        dgstrNew.addSetNext("report/chart/dataSet", "addIRDataSet");
        dgstrNew.addObjectCreate("report/chart/rangeAxis", IRAxis.class);
        dgstrNew.addSetProperties("report/chart/rangeAxis", "label", "label");
        dgstrNew.addSetProperties("report/chart/rangeAxis", "isVisible", "visible");
        dgstrNew.addSetProperties("report/chart/rangeAxis", "formatType", "formatType");
        dgstrNew.addSetProperties("report/chart/rangeAxis", "formatValue", "formatValue");
        dgstrNew.addSetProperties("report/chart/rangeAxis", "fixRange", "fixRange");
        dgstrNew.addSetProperties("report/chart/rangeAxis", "lowerBound", "lowerBound");
        dgstrNew.addSetProperties("report/chart/rangeAxis", "upperBound", "upperBound");
        dgstrNew.addSetNext("report/chart/rangeAxis", "setRangeAxis");
        dgstrNew.addObjectCreate("report/chart/domainAxis", IRAxis.class);
        dgstrNew.addSetProperties("report/chart/domainAxis", "label", "label");
        dgstrNew.addSetProperties("report/chart/domainAxis", "isVisible", "visible");
        dgstrNew.addSetProperties("report/chart/domainAxis", "labelAngle", "labelAngle");
        dgstrNew.addSetProperties("report/chart/domainAxis", "formatType", "formatType");
        dgstrNew.addSetProperties("report/chart/domainAxis", "formatValue", "formatValue");
        dgstrNew.addSetProperties("report/chart/domainAxis", "regionNum", "regionNum");
        dgstrNew.addSetProperties("report/chart/domainAxis", "rightEndShow", "rightEndShow");
        dgstrNew.addSetNext("report/chart/domainAxis", "setDomainAxis");
        dgstrNew.addObjectCreate("report/chart/plot", IRPlot.class);
        dgstrNew.addSetProperties("report/chart/plot", "foregroundAlpha", "foregroundAlpha");
        dgstrNew.addSetProperties("report/chart/plot", "orientation", "orientation");
        dgstrNew.addSetProperties("report/chart/plot", "showWhenLessNum", "showWhenLessNum");
        dgstrNew.addSetProperties("report/chart/plot", "sectionLabelMaxLen", "sectionLabelMaxLen");
        dgstrNew.addObjectCreate("report/chart/plot/labelGenerator", IRLabelGenerator.class);
        dgstrNew.addSetProperties("report/chart/plot/labelGenerator", "labelFormat", "labelFormat");
        dgstrNew.addSetProperties("report/chart/plot/labelGenerator", "valueFormat", "valueFormat");
        dgstrNew.addSetProperties("report/chart/plot/labelGenerator", "numberFormat", "numberFormat");
        dgstrNew.addSetProperties("report/chart/plot/labelGenerator", "percentFormat", "percentFormat");
        dgstrNew.addSetProperties("report/chart/plot/labelGenerator", "rangeFormatType", "rangeFormatType");
        dgstrNew.addSetProperties("report/chart/plot/labelGenerator", "rangeFormatValue", "rangeFormatValue");
        dgstrNew.addSetProperties("report/chart/plot/labelGenerator", "domainFormatValue", "domainFormatValue");
        dgstrNew.addSetNext("report/chart/plot/labelGenerator", "addLabelGenerator");
        dgstrNew.addObjectCreate("report/chart/plot/seriesColor", IRSeriesColor.class);
        dgstrNew.addSetProperties("report/chart/plot/seriesColor", "seriesOrder", "section");
        dgstrNew.addSetProperties("report/chart/plot/seriesColor", "color", "color");
        dgstrNew.addSetNext("report/chart/plot/seriesColor", "addIRSeriesColor");
        dgstrNew.addObjectCreate("report/chart/plot/colorMap/colorItem", IRColorMap.class);
        dgstrNew.addSetProperties("report/chart/plot/colorMap/colorItem", "key", "key");
        dgstrNew.addSetProperties("report/chart/plot/colorMap/colorItem", "color", "color");
        dgstrNew.addSetNext("report/chart/plot/colorMap/colorItem", "addIRColorMap");
        dgstrNew.addSetNext("report/chart/plot", "addPlot");
        dgstrNew.addSetNext("report/chart", "addIRChart");
        dgstrNew.addObjectCreate("report/table", IRTable.class);
        dgstrNew.addSetProperties("report/table", "title", "title");
        dgstrNew.addSetProperties("report/table", "caseValue", "caseValue");
        dgstrNew.addSetProperties("report/table", "colspan", "colspan");
        dgstrNew.addSetProperties("report/table", "exportColspan", "exportColspan");
        dgstrNew.addSetProperties("report/table", "datasource", "dataSource");
        dgstrNew.addSetProperties("report/table", "pageShow", "pageShow");
        dgstrNew.addSetProperties("report/table", "topPageBarShow", "topPageBarShow");
        dgstrNew.addSetProperties("report/table", "pageSize", "pageSize");
        dgstrNew.addSetProperties("report/table", "flexTable", "flexTable");
        dgstrNew.addSetProperties("report/table", "jasperReferId", "jasperReferId");
        dgstrNew.addSetProperties("report/table", "comShow", "comShow");
        dgstrNew.addSetProperties("report/table", "id", "id");
        dgstrNew.addSetProperties("report/table", "csvExport", "csvExport");
        dgstrNew.addSetProperties("report/table", "totalBarShow", "totalBarShow");
        dgstrNew.addSetProperties("report/table", "serialNumShow", "serialNumShow");
        dgstrNew.addSetProperties("report/table", "groupField", "groupField");
        dgstrNew.addSetProperties("report/table", "groupNum", "groupNum");
        dgstrNew.addSetProperties("report/table", "totalBarDown", "totalBarDown");
        dgstrNew.addSetProperties("report/table", "useJasper", "useJasper");
        dgstrNew.addSetProperties("report/table", "chartRef", "chartRef");
        dgstrNew.addObjectCreate("report/table/headerRow", HeaderRow.class);
        dgstrNew.addObjectCreate("report/table/headerRow/headerColumn", HeaderColumn.class);
        dgstrNew.addSetProperties("report/table/headerRow/headerColumn", "colspan", "colspan");
        dgstrNew.addSetProperties("report/table/headerRow/headerColumn", "value", "value");
        dgstrNew.addSetProperties("report/table/headerRow/headerColumn", "exportColspan", "exportColspan");
        dgstrNew.addSetNext("report/table/headerRow/headerColumn", "addHeaderColumn");
        dgstrNew.addSetNext("report/table/headerRow", "addHeaderRow");
        dgstrNew.addObjectCreate("report/table/column", IRColumn.class);
        dgstrNew.addSetNestedProperties("report/table/column", "dataDrillAction", "dataDrillAction");
        dgstrNew.addSetProperties("report/table/column", "header", "header");
        dgstrNew.addSetProperties("report/table/column", "sortable", "sortable");
        dgstrNew.addSetProperties("report/table/column", "tooltips", "tooltips");
        dgstrNew.addSetProperties("report/table/column", "field", "field");
        dgstrNew.addSetProperties("report/table/column", "width", "width");
        dgstrNew.addSetProperties("report/table/column", "urlField", "urlField");
        dgstrNew.addSetProperties("report/table/column", "userJavaScript", "userJavaScript");
        dgstrNew.addSetProperties("report/table/column", "dataDrillAction", "dataDrillAction");
        dgstrNew.addSetProperties("report/table/column", "jsonKey", "jsonKey");
        dgstrNew.addSetProperties("report/table/column", "columnExport", "columnExport");
        dgstrNew.addSetProperties("report/table/column", "formatType", "formatType");
        dgstrNew.addSetProperties("report/table/column", "formatValue", "formatValue");
        dgstrNew.addSetProperties("report/table/column", "textAlign", "textAlign");
        dgstrNew.addSetProperties("report/table/column", "totalExpression", "totalExpression");
        dgstrNew.addObjectCreate("report/table/column/columnCase", IRColumnCase.class);
        dgstrNew.addSetProperties("report/table/column/columnCase", "originValue", "originValue");
        dgstrNew.addSetProperties("report/table/column/columnCase", "mapped", "mapped");
        dgstrNew.addSetNext("report/table/column/columnCase", "addColumnCase");
        dgstrNew.addSetNext("report/table/column", "addIRColumn");
        dgstrNew.addSetNext("report/table", "addIRTable");
        dgstrNew.addObjectCreate("report/datasource", IRDataSource.class);
        dgstrNew.addSetProperties("report/datasource", "id", "id");
        dgstrNew.addSetProperties("report/datasource", "type", "type");
        dgstrNew.addSetProperties("report/datasource", "loadOrder", "loadOrder");
        dgstrNew.addSetProperties("report/datasource", "useSqlInterface", "useSqlInterface");
        dgstrNew.addSetNestedProperties("report/datasource", "className", "className");
        dgstrNew.addSetNestedProperties("report/datasource", "pojo", "pojo");
        dgstrNew.addSetNestedProperties("report/datasource", "cache", "cache");
        dgstrNew.addSetNestedProperties("report/datasource", "procedure", "procedure");
        dgstrNew.addSetNestedProperties("report/datasource", "sql", "sql");
        dgstrNew.addObjectCreate("report/datasource/paraList", ParaList.class);
        dgstrNew.addObjectCreate("report/datasource/paraList/parameter", Parameter.class);
        dgstrNew.addSetProperties("report/datasource/paraList/parameter", "seriesOrder", "section");
        dgstrNew.addSetProperties("report/datasource/paraList/parameter", "key", "key");
        dgstrNew.addSetNext("report/datasource/paraList/parameter", "addParameter");
        dgstrNew.addSetNext("report/datasource/paraList", "addParaList");
        dgstrNew.addSetNestedProperties("report/datasource", "database", "database");
        dgstrNew.addSetProperties("report/datasource", "filePath", "filePath");
        dgstrNew.addSetProperties("report/datasource", "fileSeparator", "fileSeparator");
        dgstrNew.addSetProperties("report/datasource", "encoding", "encoding");
        dgstrNew.addSetProperties("report/datasource", "ignoreFirst", "ignoreFirst");
        dgstrNew.addObjectCreate("report/datasource/fieldList", FieldList.class);
        dgstrNew.addObjectCreate("report/datasource/fieldList/field", FieldInfo.class);
        dgstrNew.addSetProperties("report/datasource/fieldList/field", "seriesOrder", "section");
        dgstrNew.addSetProperties("report/datasource/fieldList/field", "name", "fieldName");
        dgstrNew.addSetProperties("report/datasource/fieldList/field", "dataType", "fieldType");
        dgstrNew.addSetNext("report/datasource/fieldList/field", "addField");
        dgstrNew.addSetNext("report/datasource/fieldList", "addFieldList");
        dgstrNew.addObjectCreate("report/datasource/sqlSectionList", SqlSectionList.class);
        dgstrNew.addSetNestedProperties("report/datasource/sqlSectionList", "sqlSection", "sqlSection");
        dgstrNew.addSetNext("report/datasource/sqlSectionList", "addSqlSectionList");
        dgstrNew.addSetNext("report/datasource", "addIRDataSource");
        dgstrNew.setEntityResolver((EntityResolver)new InnerClass());
        return dgstrNew;
    }

    private static class InnerClass
    implements EntityResolver {
        private InnerClass() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return IReportDTDParser.resolveEntity("report.dtd", "com/security/ireport/engine/dtds/report.dtd");
        }
    }
}

