/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.IReportParse;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.model.vo.ReportPlugVO;
import com.security.ireport.service.impl.ReportLoader;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportMgrUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.ProductFaceUtil;
import com.security.logserver.module.condition.cfg.ConditionParser;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class PluginManager {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static ConcurrentHashMap<String, IReport> pluginList = new ConcurrentHashMap();
    private static PluginManager pluginMgr = new PluginManager();
    private static String productVersion = null;

    private PluginManager() {
        long s = System.currentTimeMillis();
        LOGGER.debug((Object)"Begin init all plugins...");
        this.initAllPluginList();
        LOGGER.debug((Object)("End init all plugins OK with:" + (System.currentTimeMillis() - s) + " ms!"));
    }

    public static PluginManager getInstance() {
        return pluginMgr;
    }

    public ConcurrentHashMap<String, IReport> getReportPluginList() {
        return pluginList;
    }

    public IReport getReportPlugin(String reportId) {
        IReport tmpReport = null;
        for (Map.Entry<String, IReport> rptEntry : pluginList.entrySet()) {
            String rptId = rptEntry.getKey();
            if (!rptId.equalsIgnoreCase(reportId)) continue;
            tmpReport = rptEntry.getValue();
            break;
        }
        return tmpReport;
    }

    public boolean updateToPluginList(IReport iReport) {
        boolean ret = true;
        if (!this.appendToPluginList(iReport)) {
            String pluginId = iReport.getId();
            LOGGER.error((Object)("Append plugin id:" + pluginId + " to list failed!"));
            ret = false;
        }
        return ret;
    }

    public boolean deleteReportPlugin(String reportId) {
        boolean returnValue = true;
        for (Map.Entry<String, IReport> rptEntry : pluginList.entrySet()) {
            String rptId = rptEntry.getKey();
            IReport myReport = rptEntry.getValue();
            if (!rptId.equalsIgnoreCase(reportId)) continue;
            Locale locale = LocaleUtil.getCurrentUserLocale();
            LocaleUtil.removeReportRroperty(reportId, locale);
            if (!this.deleteFromServiceMenu(myReport)) {
                LOGGER.error((Object)("del plugin id:" + reportId + "from service menu failed!"));
                return false;
            }
            if (!this.deleteFromLocalMenu(reportId)) {
                LOGGER.error((Object)("del plugin id:" + reportId + "from local menu failed!"));
                return false;
            }
            if (!this.deleteFromPluginList(reportId)) break;
            LOGGER.error((Object)("del plugin id:" + reportId + "from list failed!"));
            return false;
        }
        return returnValue;
    }

    private void initAllPluginList() {
        pluginList.clear();
        String filePath = IReportUtil.getRealPath() + "/iReport/iReportBiz/reportPlugins/";
        try {
            File pluginDir = new File(filePath);
            String[] pluginDirs = pluginDir.list();
            if (null == pluginDirs || pluginDirs.length <= 0) {
                LOGGER.error((Object)("Have not plugins at:" + filePath));
            } else {
                String pluginId = "";
                for (int i = 0; i < pluginDirs.length; ++i) {
                    Map<String, String> map;
                    pluginId = pluginDirs[i];
                    if (!this.checkPluginBaseInfo(filePath, pluginId)) continue;
                    Object object = ConditionParser.getInstance().parse().getConditionGroupMap().get(pluginId);
                    if (null == object) {
                        LOGGER.error((Object)("object is null, pluginId:" + pluginId));
                    }
                    if (null != (map = ConditionParser.getInstance().getConditionGroupInfoMap().get(pluginId))) continue;
                    LOGGER.error((Object)("map is null, pluginId:" + pluginId));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Load plugin failed:", (Throwable)e);
        }
    }

    public static String getProductVersion() {
        if (null == productVersion) {
            productVersion = IReportConfigUtil.getInstance().getConfig("productVersion");
        }
        return productVersion;
    }

    private boolean checkPluginBaseInfo(String filePath, String pluginId) {
        String ret = "";
        boolean isChecked = false;
        File newDir = null;
        IReport tmpReport = null;
        String pluginPath = filePath + pluginId;
        newDir = new File(pluginPath);
        if (!newDir.isDirectory()) {
            LOGGER.error((Object)("Plugin id:" + pluginId + " can not be exist as file!"));
            return isChecked;
        }
        if (pluginId.length() > 50 || !IReportUtil.isStrValid("^[a-zA-Z][a-zA-Z0-9-_.]*$", pluginId)) {
            LOGGER.error((Object)("Plugin id:" + pluginId + " name not be correctly!"));
            return isChecked;
        }
        tmpReport = IReportParse.getInstance().getPlugin(pluginId);
        if (null == tmpReport) {
            LOGGER.error((Object)"Create plugin object failed!");
            return isChecked;
        }
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        if (!productName.equalsIgnoreCase("ATIC") && !IReportMgrUtil.parseQueryFile(pluginPath)) {
            LOGGER.error((Object)("Parse Plugin id:" + pluginId + " parameter.xml failed!"));
            return isChecked;
        }
        if (!this.appendToPluginList(tmpReport)) {
            ret = "Add plugin id:" + pluginId + " to list failed!";
            LOGGER.info((Object)ret);
            return isChecked;
        }
        if (!IReportConfCheckUtil.isStringEmpty(ret)) {
            LOGGER.error((Object)ret);
            return isChecked;
        }
        isChecked = true;
        return isChecked;
    }

    public boolean updateToLocalMenu(IReport iReport) {
        boolean result = false;
        if (ReportLoader.getInstance().addReport(IReportConfigUtil.ireportToVO(iReport))) {
            result = true;
        }
        return result;
    }

    private boolean appendToPluginList(IReport iReport) {
        boolean ret = false;
        if (null == iReport) {
            return ret;
        }
        try {
            String reportId = iReport.getId();
            pluginList.put(reportId, iReport);
            ret = true;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Append plugin to list fail:", (Throwable)e);
            return false;
        }
        return ret;
    }

    private boolean getShowMenuValue(IReport myReport) {
        boolean ret = true;
        boolean showInMenu = myReport.isShowMenu();
        if (!showInMenu) {
            ret = false;
        }
        return ret;
    }

    private boolean deleteFromLocalMenu(String reportId) {
        boolean ret = false;
        try {
            if (ReportLoader.getInstance().delReport(reportId)) {
                ret = true;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"del from locale menu fail:", (Throwable)e);
            return false;
        }
        return ret;
    }

    private boolean deleteFromServiceMenu(IReport iReport) {
        boolean ret = true;
        String id = iReport.getId();
        try {
            if (this.getShowMenuValue(iReport)) {
                ReportPlugVO rptVO = IReportConfigUtil.ireportToVO(iReport);
                if (!ProductFaceUtil.getInstance().delReportMenu(rptVO)) {
                    ret = false;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Add plugin id:" + id + " to service menu failed!"), (Throwable)e);
            return false;
        }
        return ret;
    }

    private boolean deleteFromPluginList(String reportId) {
        boolean ret = false;
        try {
            pluginList.remove(reportId);
        }
        catch (Exception e) {
            LOGGER.error((Object)"del from plugin list fail:", (Throwable)e);
            return false;
        }
        return ret;
    }
}

