/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.ProviderException;
import com.security.ireport.engine.dataset.DataSourceFactory;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.engine.dataset.IDataSourceCollector;
import com.security.ireport.engine.dataset.IFlexTableData;
import com.security.ireport.engine.dataset.JavaDataSourceCollector;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.engine.definition.ComponentElement;
import com.security.ireport.engine.definition.IRChart;
import com.security.ireport.engine.definition.IRChartDataItem;
import com.security.ireport.engine.definition.IRColumn;
import com.security.ireport.engine.definition.IRDataSource;
import com.security.ireport.engine.definition.IRDefine;
import com.security.ireport.engine.definition.IRSwitchOption;
import com.security.ireport.engine.definition.IRTable;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.engine.definition.JasperDefinitionParser;
import com.security.ireport.engine.definition.chart.ChartValue;
import com.security.ireport.engine.output.ChartEngineOutput;
import com.security.ireport.engine.output.SigExportOutput;
import com.security.ireport.model.vo.ImageLegendVo;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.model.vo.LegendColor;
import com.security.ireport.model.vo.TableCellObj;
import com.security.ireport.model.vo.TableObj;
import com.security.ireport.model.vo.group.Node;
import com.security.ireport.util.CalculateNodeUtil;
import com.security.ireport.util.ExportConfigUtil;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.JSONUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.ProductFaceUtil;
import com.security.ireport.util.chart.ChartValueFactory;
import com.security.ireport.util.chart.IReportChartUtilities;
import com.security.ireport.util.chart.JChartFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.ChartRenderingInfo;

public class ReportSession {
    public static final String CHART_MAX_DATA_ZH = "/iReport/images/ImgDataMaxError.PNG";
    public static final String CHART_MAX_DATA_ZH_EXPORT = "/iReport/images/ExportImgDataMaxError.png";
    public static final String CHART_MAX_DATA_EN = "/iReport/images/ImgDataMaxErrorEn.PNG";
    public static final String CHART_MAX_DATA_EN_EXPORT = "/iReport/images/ExportImgDataMaxErrorEn.png";
    private static final int CHART_MAX_DATA = 10000;
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private IReport mReport;
    private Map<String, JsonValueObj> mParameters = new HashMap<String, JsonValueObj>();
    private Map<String, List<String>> productParameters = new HashMap<String, List<String>>();
    private String switchOption = "";
    private long mSessionId;
    private Map<String, IDataSourceCollector> mDataCollectors = new HashMap<String, IDataSourceCollector>();
    private Map<String, OrderInfo> orderInfoMap = new HashMap<String, OrderInfo>();
    private Map<String, String[]> mImagePaths = null;
    private Map<String, List<ImageLegendVo>> mImageInfoList = null;
    private Map<String, String[]> mExportImagePaths = null;
    private Map<String, String> exportSmallImagePaths = new HashMap<String, String>();
    private Map<String, String> exportSmallExcelImagePaths = new HashMap<String, String>();
    private Map<String, String> tableCellImageMap = new HashMap<String, String>();
    private boolean bPrepare = false;
    private String jsonValueStr = "";
    private long backTaskId = 0L;
    private Map<String, String> chartInfoMap = new HashMap<String, String>();
    private Locale locale = LocaleUtil.getCurrentUserLocale();
    private final Object lock = new Object();
    private SecureRandom gORandom = new SecureRandom();

    protected ReportSession(IReport report, long sessionId, Locale localePara) {
        this.mReport = report;
        this.mSessionId = sessionId;
        this.locale = localePara;
    }

    public void clean() {
        LOG.info((Object)"into -->> clean ss;");
        this.cleanImage(this.tableCellImageMap);
        this.cleanImage(this.exportSmallImagePaths);
        this.cleanImage(this.exportSmallExcelImagePaths);
        if (this.mImagePaths != null && !this.mImagePaths.isEmpty()) {
            String imagPath;
            int i;
            Collection<String[]> filePathes = this.mImagePaths.values();
            for (String[] stringArray : filePathes) {
                for (i = 0; i < stringArray.length; ++i) {
                    imagPath = IReportUtil.getRealPath() + stringArray[i];
                    IReportUtil.delFile(imagPath);
                    String mapBuffPath = IReportUtil.getPathWithoutSuffix(imagPath);
                    IReportUtil.delFile(mapBuffPath);
                }
            }
            filePathes = this.mExportImagePaths.values();
            for (String[] stringArray : filePathes) {
                for (i = 0; i < stringArray.length; ++i) {
                    imagPath = IReportUtil.getRealPath() + stringArray[i];
                    IReportUtil.delFile(imagPath);
                }
            }
            for (Map.Entry entry : this.mDataCollectors.entrySet()) {
                ((IDataSourceCollector)entry.getValue()).clean();
            }
            this.mDataCollectors.clear();
        }
        LOG.info((Object)"out <<-- clean ss");
    }

    private void cleanImage(Map<String, String> imageMap) {
        Collection<String> tableCellImageTempList;
        if (!imageMap.isEmpty() && null != (tableCellImageTempList = imageMap.values())) {
            String imagPath = null;
            for (String tempTableCellImagePath : tableCellImageTempList) {
                if (null == tempTableCellImagePath || tempTableCellImagePath.length() <= 0) continue;
                imagPath = IReportUtil.getRealPath() + tempTableCellImagePath;
                if (!tempTableCellImagePath.startsWith("/iReport/temp/")) continue;
                IReportUtil.delFile(imagPath);
            }
        }
    }

    public IReport getIReport() {
        return this.mReport;
    }

    public boolean prepare(Map<String, JsonValueObj> condParameters, boolean isSplitTask) {
        boolean isPrepare;
        if (isSplitTask && !(isPrepare = this.splitTask(condParameters))) {
            return false;
        }
        isPrepare = this.prepareDataSource(this.mReport, this.mDataCollectors, this.mParameters, this.mSessionId);
        if (isPrepare) {
            this.bPrepare = true;
            int timeLevel = ProductFaceUtil.getInstance().getTimeLevel(this.mSessionId);
            for (ComponentElement element : this.mReport.getElementList()) {
                if (!(element instanceof IRChart)) continue;
                IRChart chartDefine = (IRChart)element;
                chartDefine.setTimeLevel(timeLevel + "");
            }
            Map<String, List<String>> paramKeyValueMap = JSONUtil.transformKeyValueMap(condParameters);
            paramKeyValueMap.putAll(this.productParameters);
            this.mReport = IReportUtil.setReportParamter(this.mReport, paramKeyValueMap);
        }
        return isPrepare;
    }

    public boolean splitTask(Map<String, JsonValueObj> condParameters) {
        this.handleCondition(condParameters);
        boolean isPrepare = this.splitDatasetTask(this.mReport, this.mReport.getElementList());
        return isPrepare;
    }

    private boolean handleCondition(Map<String, JsonValueObj> condParameters) {
        JsonValueObj switchOptionParam;
        this.mParameters = condParameters;
        if (null == this.mParameters) {
            this.mParameters = new HashMap<String, JsonValueObj>();
        }
        if ((switchOptionParam = this.mParameters.get("switchOption")) != null) {
            return this.handlSwitchOptionCondition(switchOptionParam);
        }
        return this.handlCommonCondition();
    }

    private boolean handlSwitchOptionCondition(JsonValueObj switchOptionParam) {
        this.switchOption = switchOptionParam.getValueList().get(0).getValue();
        IRSwitchOption reportSwitchOption = this.mReport.getIRSwitchOption();
        if (reportSwitchOption != null && reportSwitchOption.getCaseValueList().contains(this.switchOption)) {
            IRDefine iRDefine = this.mReport.getDefineByCase(this.switchOption);
            if (iRDefine != null) {
                this.mReport.setIRDefine(iRDefine);
                List<ComponentElement> elementList = this.mReport.getComponentListByCase(this.switchOption);
                this.mReport.setElementList(elementList);
                return true;
            }
            this.mReport.setElementList(new ArrayList<ComponentElement>());
            this.mReport.setIRDefine(new IRDefine());
            return false;
        }
        this.mReport.setElementList(new ArrayList<ComponentElement>());
        this.mReport.setIRDefine(new IRDefine());
        return false;
    }

    private boolean handlCommonCondition() {
        IRSwitchOption reportSwitchOption = this.mReport.getIRSwitchOption();
        if (null == reportSwitchOption) {
            ArrayList<ComponentElement> elementList = new ArrayList<ComponentElement>();
            int num = 0;
            for (ComponentElement element : this.mReport.getElementList()) {
                if (!element.isShow()) continue;
                element.setNum(num);
                elementList.add(element);
                ++num;
            }
            this.mReport.setElementList(elementList);
            this.mReport.setIRDefine(this.mReport.getIRDefineList().get(0));
            return true;
        }
        List<String> caseList = reportSwitchOption.getCaseValueList();
        String defaultCaseValue = "";
        for (String val : caseList) {
            if (!"".endsWith(defaultCaseValue) && defaultCaseValue.compareTo(val) <= 0) continue;
            defaultCaseValue = val;
        }
        JsonValueObj caseCondition = new JsonValueObj();
        caseCondition.addValue(defaultCaseValue, "");
        return this.handlSwitchOptionCondition(caseCondition);
    }

    public boolean isShowReport(Map<String, JsonValueObj> condParameters) {
        try {
            if (this.mDataCollectors.isEmpty() && this.handleCondition(condParameters)) {
                this.orderDataSource(this.mReport, this.mReport.getElementList());
            }
            Set<Map.Entry<String, IDataSourceCollector>> dataCollectorSet = this.mDataCollectors.entrySet();
            for (Map.Entry<String, IDataSourceCollector> item : dataCollectorSet) {
                boolean isPrepareSucc = item.getValue().isShowReport(this.mSessionId, this.mParameters);
                if (!isPrepareSucc) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return false;
    }

    private boolean splitDatasetTask(IReport report, List<ComponentElement> comList) {
        boolean result = false;
        int isPrepare = 0;
        this.orderDataSource(report, comList);
        Set<Map.Entry<String, IDataSourceCollector>> dataCollectorSet = this.mDataCollectors.entrySet();
        for (Map.Entry<String, IDataSourceCollector> item : dataCollectorSet) {
            boolean isPrepareSucc = item.getValue().splitTask(this.mReport.getId(), item.getKey(), this.mParameters, this.mSessionId);
            if (!isPrepareSucc) continue;
            ++isPrepare;
        }
        if (isPrepare == dataCollectorSet.size()) {
            result = true;
        }
        return result;
    }

    private boolean prepareDataSource(IReport report, Map<String, IDataSourceCollector> dataSourceMap, Map<String, JsonValueObj> parasMap, long sessionId) {
        boolean result = false;
        int isPrepare = 0;
        Set<String> dsIdList = dataSourceMap.keySet();
        Object[] dsIds = this.orderDataSource(dsIdList);
        this.productParameters.clear();
        for (Object dsId : dsIds) {
            int isPrepareSucc = dataSourceMap.get(dsId.toString()).prepareData(report.getId(), dsId.toString(), parasMap, sessionId);
            if (0 != isPrepareSucc) continue;
            Map<String, List<String>> temp = dataSourceMap.get(dsId.toString()).getPrepareParasMap(report.getId(), dsId.toString(), parasMap, sessionId);
            this.productParameters.putAll(temp);
            ++isPrepare;
        }
        if (isPrepare == dataSourceMap.size()) {
            result = true;
        }
        return result;
    }

    private void orderDataSource(IReport report, List<ComponentElement> comList) {
        Object[] dsIds;
        ArrayList<String> dsIdList = new ArrayList<String>();
        for (ComponentElement element : comList) {
            IRChart chart;
            if (element instanceof IRTable) {
                IRTable table = (IRTable)element;
                if (dsIdList.contains(table.getDataSource())) continue;
                dsIdList.add(table.getDataSource());
                continue;
            }
            if (!(element instanceof IRChart) || dsIdList.contains((chart = (IRChart)element).getIRDataSet().getDatasource())) continue;
            dsIdList.add(chart.getIRDataSet().getDatasource());
        }
        for (Object dsId : dsIds = this.orderDataSource(dsIdList)) {
            IRDataSource datasource = report.getIRDataSourceMap().get(dsId.toString());
            IDataSourceCollector dataSourceCollector = DataSourceFactory.createDataSourceCollector(this.mSessionId, datasource);
            this.mDataCollectors.put(datasource.getId(), dataSourceCollector);
        }
    }

    private Object[] orderDataSource(Collection<String> dsIdList) {
        Object[] dsIds = dsIdList.toArray();
        for (int i = dsIdList.size() - 1; i > 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (this.mReport.getIRDataSourceMap().get(dsIds[j]).getLoadOrder() <= this.mReport.getIRDataSourceMap().get(dsIds[j + 1]).getLoadOrder()) continue;
                Object temp = dsIds[j];
                dsIds[j] = dsIds[j + 1];
                dsIds[j + 1] = temp;
            }
        }
        return dsIds;
    }

    public void fetchData(String dataSourceId, long pgIndex, long pgSize, OrderInfo sortInfo) throws ProviderException {
        IDataSourceCollector collector = this.mDataCollectors.get(dataSourceId);
        if (collector == null) {
            throw new ProviderException("fetchData: dataSourceId'" + dataSourceId + "' can't fetch data!");
        }
        collector.loadData(pgIndex, pgSize, sortInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableObj getTableData(IRTable iRTable, long pgIndex, long pgSize, OrderInfo orderInfo, boolean isExport) {
        Object object = this.lock;
        synchronized (object) {
            if (iRTable.isFlexTable()) {
                return this.getFlexTableObj(iRTable, pgIndex, pgSize);
            }
            TableObj tableObj = new TableObj();
            tableObj.setTableFooter(iRTable.getTableFooter());
            tableObj.setTableHeader(iRTable.getTableHeader());
            tableObj.setId(iRTable.getId());
            tableObj.setTitle(iRTable.getTitle());
            boolean pageShow = iRTable.isPageShow();
            List<Integer> pageSizeOption = IReportUtil.parsePageSize(iRTable.getPageSize());
            tableObj.setPageShow(pageShow);
            tableObj.setTopPageBarShow(iRTable.isTopPageBarShow());
            tableObj.setPageSizeOption(pageSizeOption);
            tableObj.setSerialNumShow(iRTable.isSerialNumShow());
            tableObj.setHeaderRowList(iRTable.getHeaderRowList());
            tableObj.setTotalBarDown(iRTable.isTotalBarDown());
            try {
                if (!pageShow) {
                    pgIndex = 0L;
                    pgSize = 0L;
                } else if (pgIndex > 0L && pgSize <= 0L) {
                    pgSize = pageSizeOption.get(0).intValue();
                }
                this.fetchData(iRTable.getDataSource(), pgIndex, pgSize, orderInfo);
                List<IRColumn> uiColumnList = this.getTableColList(iRTable, isExport);
                if (iRTable.getGroupNum() <= 1) {
                    ArrayList<String> groupKeyList = new ArrayList<String>();
                    Map<String, List<TableCellObj[]>> cellOjbListMap = this.getTableDataAllList(iRTable, isExport, groupKeyList);
                    tableObj.setCellOjbListMap(cellOjbListMap);
                    tableObj.setGroupKeyList(groupKeyList);
                } else {
                    List<? extends Node> groupTableCellNodeList = CalculateNodeUtil.getTableDataByMultiGroup(this, iRTable, isExport);
                    tableObj.setGroupTableCellNodeList(groupTableCellNodeList);
                }
                tableObj.setColumnList(uiColumnList);
                tableObj.setPageNum((int)pgIndex);
                tableObj.setPageSize((int)pgSize);
                tableObj.setTotalNum((int)this.getAllCount(iRTable.getDataSource()));
                if (pgSize != 0L) {
                    int totalPageNum = (int)(this.getAllCount(iRTable.getDataSource()) + (long)tableObj.getPageSize() - 1L) / tableObj.getPageSize();
                    tableObj.setTotalPageNum(totalPageNum);
                }
                if (null == orderInfo) {
                    orderInfo = new OrderInfo();
                }
                tableObj.setOrderInfo(orderInfo);
            }
            catch (ProviderException e) {
                LOG.error((Object)"get table message failed!", (Throwable)e);
            }
            LOG.debug((Object)IReportUtil.getcleanedMessage(tableObj.toString()));
            return tableObj;
        }
    }

    private List<IRColumn> getTableColList(IRTable iRTable, boolean isExport) {
        ArrayList<IRColumn> uiColumnList = new ArrayList<IRColumn>();
        List<IRColumn> columnList = iRTable.getIRColumnList();
        if (columnList != null && !columnList.isEmpty()) {
            for (IRColumn item : columnList) {
                if (isExport && (!item.isColumnExport() || null != item.getChartRef() && item.getChartRef().length() > 0)) continue;
                IRColumn newItem = new IRColumn();
                newItem.setField(item.getField());
                String header = IReportUtil.getProperty(item.getHeader(), this.getIReport().getId(), this.getLocale());
                newItem.setHeader(header);
                newItem.setWidth(item.getWidth());
                newItem.setTooltips(item.getTooltips());
                newItem.setSortable(item.getSortable());
                newItem.setFormatType(item.getFormatType());
                newItem.setFormatValue(item.getFormatValue());
                newItem.setTextAlign(item.getTextAlign());
                newItem.setDataDrillTitle(item.getDataDrillTitle());
                newItem.setUserJavaScript(item.isUserJavaScript());
                newItem.setChartRef(item.getChartRef());
                uiColumnList.add(newItem);
            }
        }
        return uiColumnList;
    }

    private List<TableCellObj[]> getTableDataList(IRTable iRTable, boolean isExport) {
        ArrayList<TableCellObj[]> dataSetList = new ArrayList<TableCellObj[]>();
        List<IRColumn> columnList = iRTable.getIRColumnList();
        List<IRColumn> validColumnList = ReportSession.getValidColumnCVSList(isExport, columnList);
        int i = 0;
        while ((long)i < this.getCurPageCount(iRTable.getDataSource())) {
            TableCellObj[] dataSet = this.getTableCellObj(iRTable, validColumnList, i, validColumnList.size());
            dataSetList.add(dataSet);
            ++i;
        }
        TableCellObj[] totalDataSet = this.getTotalTableCellObj(iRTable, dataSetList, validColumnList);
        if (totalDataSet.length > 0) {
            if (iRTable.isTotalBarDown()) {
                dataSetList.add(totalDataSet);
            } else {
                dataSetList.add(0, totalDataSet);
            }
        }
        return dataSetList;
    }

    private Map<String, List<TableCellObj[]>> getTableDataAllList(IRTable iRTable, boolean isExport, List<String> groupKeyList) {
        if (!iRTable.isGroupTable()) {
            HashMap<String, List<TableCellObj[]>> dataMap = new HashMap<String, List<TableCellObj[]>>();
            List<TableCellObj[]> temp = this.getTableDataList(iRTable, isExport);
            dataMap.put("", temp);
            groupKeyList.add("");
            return dataMap;
        }
        return this.getTableDataBySimpleGroup(iRTable, isExport, groupKeyList);
    }

    private Map<String, List<TableCellObj[]>> getTableDataBySimpleGroup(IRTable iRTable, boolean isExport, List<String> groupKeyList) {
        HashMap<String, List<TableCellObj[]>> dataMap = new HashMap<String, List<TableCellObj[]>>();
        List<IRColumn> columnList = iRTable.getIRColumnList();
        List<IRColumn> validColumnList = ReportSession.getValidColumnCVSList(isExport, columnList);
        String groupField = iRTable.getGroupField();
        ArrayList dataSetList = null;
        int i = 0;
        while ((long)i < this.getCurPageCount(iRTable.getDataSource())) {
            TableCellObj[] dataSet = this.getTableCellObj(iRTable, validColumnList, i, validColumnList.size());
            String groupValue = "";
            if (groupField != null && !groupField.isEmpty()) {
                groupValue = IReportConfCheckUtil.formatObj(this.getValue(iRTable.getDataSource(), i, groupField), iRTable.getGroupColumn());
            }
            if (!dataMap.containsKey(groupValue)) {
                dataSetList = new ArrayList();
                dataMap.put(groupValue, dataSetList);
                groupKeyList.add(groupValue);
            }
            ((List)dataMap.get(groupValue)).add(dataSet);
            ++i;
        }
        TableCellObj[] totalDataSet = null;
        for (Map.Entry item : dataMap.entrySet()) {
            totalDataSet = this.getTotalTableCellObj(iRTable, (List)item.getValue(), validColumnList);
            if (totalDataSet.length <= 0 || null == item.getValue() || ((List)item.getValue()).isEmpty()) {
                ((TableCellObj[])((List)item.getValue()).get(0))[0].setDataText((String)item.getKey());
                continue;
            }
            if (iRTable.isTotalBarDown()) {
                ((List)item.getValue()).add(totalDataSet);
                ((TableCellObj[])((List)item.getValue()).get(0))[0].setDataText((String)item.getKey());
                totalDataSet[0].setDataText("");
                continue;
            }
            ((List)item.getValue()).add(0, totalDataSet);
            totalDataSet[0] = new TableCellObj();
            totalDataSet[0].setDataText((String)item.getKey());
        }
        return dataMap;
    }

    public static List<IRColumn> getValidColumnList(boolean isExport, List<IRColumn> columnList) {
        ArrayList<IRColumn> newColumnList = new ArrayList<IRColumn>();
        for (int i = 0; i < columnList.size(); ++i) {
            if (isExport && !columnList.get(i).isColumnExport()) continue;
            newColumnList.add(columnList.get(i));
        }
        return newColumnList;
    }

    public static List<IRColumn> getValidColumnCVSList(boolean isExport, List<IRColumn> columnList) {
        ArrayList<IRColumn> newColumnList = new ArrayList<IRColumn>();
        for (int i = 0; i < columnList.size(); ++i) {
            if (isExport && (!columnList.get(i).isColumnExport() || null != columnList.get(i).getChartRef() && columnList.get(i).getChartRef().length() > 0)) continue;
            newColumnList.add(columnList.get(i));
        }
        return newColumnList;
    }

    private TableCellObj[] getTotalTableCellObj(IRTable iRTable, List<TableCellObj[]> dataSetList, List<IRColumn> validColumnList) {
        TableCellObj[] totalDataSet = null;
        if (!iRTable.isTotalBarShow()) {
            return new TableCellObj[0];
        }
        totalDataSet = new TableCellObj[validColumnList.size()];
        for (int i = 0; i < totalDataSet.length; ++i) {
            String tempStr = IReportConfCheckUtil.calcTableColCount(dataSetList, i, validColumnList.get(i));
            totalDataSet[i] = new TableCellObj(tempStr);
        }
        return totalDataSet;
    }

    private TableCellObj[] getTableCellObj(IRTable iRTable, List<IRColumn> columnList, int row, int exportColumnSize) {
        Object[] dataSet = new TableCellObj[exportColumnSize];
        IRColumn column = null;
        for (int j = 0; j < columnList.size(); ++j) {
            column = columnList.get(j);
            if (0 == j && iRTable.isGroupTable()) {
                dataSet[0] = new TableCellObj();
                ((TableCellObj)dataSet[0]).setDataText("");
                continue;
            }
            Object item = null;
            item = IReportConfCheckUtil.isSpecialField(column.getField()) ? this.getSpecialValue(dataSet, column) : this.getValue(iRTable.getDataSource(), row, column.getField());
            dataSet[j] = new TableCellObj();
            String imgPath = this.handleTableImageCell(column, iRTable, item, row);
            ((TableCellObj)dataSet[j]).setImgPath(imgPath);
            String dataText = IReportConfCheckUtil.formatObj(item, column);
            ((TableCellObj)dataSet[j]).setDataText(dataText);
            ((TableCellObj)dataSet[j]).getDataTextList().add(((TableCellObj)dataSet[j]).getDataText());
            String url = this.createUrlText(column, iRTable.getDataSource(), row);
            ((TableCellObj)dataSet[j]).setUrlText(url);
            ((TableCellObj)dataSet[j]).getUrlTextList().add(((TableCellObj)dataSet[j]).getUrlText());
            this.setSubColumnData(column, row, iRTable, (TableCellObj)dataSet[j]);
        }
        return dataSet;
    }

    public String handleTableImageCell(IRColumn column, IRTable iRTable, Object chartQueryInfo, int index) {
        String charRef = column.getChartRef();
        String imgPath = null;
        if (null != charRef && charRef.trim().length() > 0) {
            HashMap<Object, Object> tableCellField = null;
            if (null != chartQueryInfo && chartQueryInfo instanceof Map) {
                tableCellField = (HashMap<Object, Object>)chartQueryInfo;
            }
            if (null == tableCellField) {
                tableCellField = new HashMap<Object, Object>();
            }
            try {
                imgPath = this.createImagePathByTableCell(this.mReport.getTableCellIRChartMap().get(charRef), tableCellField, column, index, iRTable)[0];
                imgPath = IReportConfigUtil.getInstance().getContextPath() + imgPath;
            }
            catch (Exception e) {
                LOG.error((Object)("table contain image create fail , case:" + IReportUtil.getcleanedMessage(column.getHeader())), (Throwable)e);
            }
        } else if (null != column.getFormatType() && "img".equalsIgnoreCase(column.getFormatType())) {
            imgPath = IReportConfCheckUtil.formatObj(chartQueryInfo, column);
        }
        return imgPath;
    }

    public Object getSpecialValue(Object[] dataSet, IRColumn column) {
        double resultNum = 0.0;
        try {
            ArrayList<Double> cellList = new ArrayList<Double>();
            ArrayList<String> operatorList = new ArrayList<String>();
            ReportSession.decomposeSpecialValue(dataSet, column, cellList, operatorList);
            resultNum = SigExportOutput.getSpecialValue(cellList, operatorList);
        }
        catch (Exception e) {
            LOG.error((Object)"getSpecialValue failed.", (Throwable)e);
        }
        return resultNum;
    }

    private static void decomposeSpecialValue(Object[] dataSet, IRColumn column, List<Double> cellList, List<String> operatorList) {
        String temp;
        int index;
        String subFieldStr = column.getField().substring(1);
        do {
            int plusIndex = subFieldStr.indexOf("+");
            int minusIndex = subFieldStr.indexOf("-");
            int multiplyIndex = subFieldStr.indexOf("*");
            int divideIndex = subFieldStr.indexOf("/");
            index = -1;
            if (plusIndex != -1) {
                index = plusIndex;
            }
            if (minusIndex != -1 && (minusIndex < index || -1 == index)) {
                index = minusIndex;
            }
            if (multiplyIndex != -1 && (multiplyIndex < index || -1 == index)) {
                index = multiplyIndex;
            }
            if (divideIndex != -1 && (divideIndex < index || -1 == index)) {
                index = divideIndex;
            }
            temp = subFieldStr.substring(0, index);
            temp = temp.substring(1);
            cellList.add(Double.valueOf(String.valueOf(dataSet[Integer.parseInt(temp)])));
            operatorList.add(SigExportOutput.getOperator(index, plusIndex, minusIndex, multiplyIndex));
        } while ((subFieldStr = subFieldStr.substring(index + 1)).indexOf("+") != -1 || subFieldStr.indexOf("-") != -1 || subFieldStr.indexOf("*") != -1 || subFieldStr.indexOf("/") != -1);
        temp = subFieldStr.substring(1);
        cellList.add(Double.valueOf(String.valueOf(dataSet[Integer.parseInt(temp)])));
    }

    public void setSubColumnData(IRColumn column, int row, IRTable iRTable, TableCellObj tableCell) {
        if (!column.getSubColumnList().isEmpty()) {
            StringBuffer dataText = new StringBuffer(tableCell.getDataText());
            String textTemp = null;
            for (int k = 0; k < column.getSubColumnList().size(); ++k) {
                IRColumn subcolumn = column.getSubColumnList().get(k);
                Object subitem = this.getValue(iRTable.getDataSource(), row, subcolumn.getField());
                textTemp = IReportConfCheckUtil.formatObj(subitem, subcolumn);
                tableCell.getDataTextList().add(textTemp);
                dataText.append(" | ").append(textTemp);
                String suburl = this.createUrlText(subcolumn, iRTable.getDataSource(), row);
                tableCell.getUrlTextList().add(suburl);
            }
            tableCell.setDataText(dataText.toString());
        }
    }

    private TableObj getFlexTableObj(IRTable iRTable, long pgIndex, long pgSize) {
        TableObj tableObj = new TableObj();
        tableObj.setTableFooter(iRTable.getTableFooter());
        tableObj.setTableHeader(iRTable.getTableHeader());
        tableObj.setId(iRTable.getId());
        tableObj.setTitle(iRTable.getTitle());
        tableObj.setFlexTable(true);
        boolean pageShow = iRTable.isPageShow();
        List<Integer> pageSizeOption = IReportUtil.parsePageSize(iRTable.getPageSize());
        tableObj.setPageShow(pageShow);
        tableObj.setTopPageBarShow(iRTable.isTopPageBarShow());
        tableObj.setPageSizeOption(pageSizeOption);
        try {
            if (!pageShow) {
                pgIndex = 0L;
                pgSize = 0L;
            } else if (pgIndex > 0L && pgSize <= 0L) {
                pgSize = pageSizeOption.get(0).intValue();
            }
            this.fetchData(iRTable.getDataSource(), pgIndex, pgSize, null);
            JavaDataSourceCollector dataCollector = (JavaDataSourceCollector)this.mDataCollectors.get(iRTable.getDataSource());
            List<IRColumn> uiColumnList = this.createFlexColumnList(dataCollector);
            ArrayList<TableCellObj[]> dataSetList = new ArrayList<TableCellObj[]>();
            long size = this.getCurPageCount(iRTable.getDataSource());
            int i = 0;
            while ((long)i < size) {
                TableCellObj[] dataSet = new TableCellObj[uiColumnList.size()];
                List rowData = (List)dataCollector.getValue(i);
                for (int j = 0; j < uiColumnList.size(); ++j) {
                    dataSet[j] = new TableCellObj();
                    dataSet[j].setDataText(((IFlexTableData)rowData.get(j)).getDisplayTxt());
                    dataSet[j].setUrlText(((IFlexTableData)rowData.get(j)).getDataDrillUrl());
                }
                dataSetList.add(dataSet);
                ++i;
            }
            tableObj.getCellOjbListMap().put("", dataSetList);
            tableObj.setColumnList(uiColumnList);
            tableObj.setPageNum((int)pgIndex);
            tableObj.setPageSize((int)pgSize);
            tableObj.setTotalNum((int)this.getAllCount(iRTable.getDataSource()));
            if (pgSize != 0L) {
                int totalPageNum = (int)(this.getAllCount(iRTable.getDataSource()) + (long)tableObj.getPageSize() - 1L) / tableObj.getPageSize();
                tableObj.setTotalPageNum(totalPageNum);
            }
            tableObj.setOrderInfo(new OrderInfo());
        }
        catch (ProviderException e) {
            LOG.error((Object)"getFlexTableData failed.", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"getFlexTableData failed.", (Throwable)e);
        }
        return tableObj;
    }

    public Object getValue(String dsId, long row) {
        JavaDataSourceCollector dataCollector = (JavaDataSourceCollector)this.mDataCollectors.get(dsId);
        return dataCollector.getValue(row);
    }

    public void prepareJasper() {
        if (this.mReport.isFlexTable()) {
            HashMap<String, List<IRColumn>> temp = new HashMap<String, List<IRColumn>>();
            for (IRTable table : this.mReport.getIRTableList(this.switchOption)) {
                if (!table.isFlexTable()) continue;
                JavaDataSourceCollector dataCollector = (JavaDataSourceCollector)this.mDataCollectors.get(table.getDataSource());
                List<IRColumn> uiColumnList = this.createFlexColumnList(dataCollector);
                table.setIRColumnList(uiColumnList);
                temp.put(table.getId(), uiColumnList);
            }
            for (ComponentElement element : this.mReport.getElementList(this.switchOption)) {
                if (!(element instanceof IRTable) || !((IRTable)element).isFlexTable()) continue;
                IRTable table = (IRTable)element;
                table.setIRColumnList((List)temp.get(table.getId()));
            }
            JasperDefinitionParser jasperParser = new JasperDefinitionParser(this.mReport);
            jasperParser.buildJasperReport(this.switchOption);
        }
    }

    private List<IRColumn> createFlexColumnList(JavaDataSourceCollector dataCollector) {
        List<IFlexTableData> columnHeadList = dataCollector.getFlexTableHeader();
        ArrayList<IRColumn> uiColumnList = new ArrayList<IRColumn>();
        if (columnHeadList != null) {
            int n = columnHeadList.size();
            for (int i = 0; i < n; ++i) {
                IRColumn newItem = new IRColumn();
                newItem.setWidth(String.valueOf(534 / columnHeadList.size()));
                newItem.setHeader(columnHeadList.get(i).getDisplayTxt());
                newItem.setDataDrillAction(columnHeadList.get(i).getDataDrillUrl());
                newItem.setField("FlexColumn" + i);
                uiColumnList.add(newItem);
            }
        }
        return uiColumnList;
    }

    public String createUrlText(IRColumn column, String dataSetId, long row) {
        String result = "";
        if (!IReportConfCheckUtil.isStringEmpty(column.getDataDrillAction())) {
            result = column.getDataDrillAction();
            if (!column.isUserJavaScript()) {
                result = IReportUtil.formatUrl(result, row, this.mDataCollectors.get(dataSetId), this.mSessionId);
            }
        } else if (!IReportConfCheckUtil.isStringEmpty(column.getUrlField())) {
            Object url = this.getValue(dataSetId, row, column.getUrlField());
            result = IReportConfCheckUtil.getObjectStr(url);
        }
        return result;
    }

    public List<FieldInfo> getColumnInfo(String dataSourceId) {
        IDataSourceCollector collector = this.mDataCollectors.get(dataSourceId);
        if (collector != null) {
            return collector.getAllFieldInfo();
        }
        return new ArrayList<FieldInfo>();
    }

    public long getAllCount(String dataSetId) {
        IDataSourceCollector collector = this.mDataCollectors.get(dataSetId);
        if (collector != null) {
            return collector.getAllCount();
        }
        return 0L;
    }

    public long getCurPageCount(String dataSetId) {
        IDataSourceCollector collector = this.mDataCollectors.get(dataSetId);
        if (collector != null) {
            return collector.getCurPageCount();
        }
        return 0L;
    }

    public Object getValue(String dataSetId, long row, String colName) {
        IDataSourceCollector collector = this.mDataCollectors.get(dataSetId);
        if (collector != null) {
            return collector.getValue(row, colName);
        }
        return null;
    }

    public Map<String, String[]> getAllChartsImgPath(PrintWriter pw) throws ProviderException {
        if (null == this.mImagePaths) {
            this.createImagePathByCaseValue();
        }
        this.writeImageMap(pw, this.mImagePaths);
        return this.mImagePaths;
    }

    public List<ImageLegendVo> getImgLegendMap(String chartId) {
        if (null == this.mImageInfoList || !this.mImageInfoList.containsKey(chartId)) {
            return null;
        }
        return this.mImageInfoList.get(chartId);
    }

    public Map<String, String[]> getAllExportChartsImgPath(String exportType) throws ProviderException {
        if (null == this.mExportImagePaths) {
            this.createImagePathByCaseValue();
        }
        if (exportType.equals("excel")) {
            return this.filterExportImagePaths(this.exportSmallExcelImagePaths, this.mExportImagePaths);
        }
        return this.filterExportImagePaths(this.exportSmallImagePaths, this.mImagePaths);
    }

    private Map<String, String[]> filterExportImagePaths(Map<String, String> emptySmallMap, Map<String, String[]> defaultMap) {
        if (ExportConfigUtil.isEmptySmallHeight() && null != emptySmallMap && !emptySmallMap.isEmpty()) {
            HashMap<String, String[]> returnMap = new HashMap<String, String[]>();
            returnMap.putAll(defaultMap);
            Map.Entry<String, String> temEntry2 = null;
            for (Map.Entry<String, String> temEntry2 : emptySmallMap.entrySet()) {
                if (!returnMap.containsKey(temEntry2.getKey()) || null == temEntry2.getValue()) continue;
                returnMap.put(temEntry2.getKey(), new String[]{temEntry2.getValue()});
            }
            return returnMap;
        }
        return defaultMap;
    }

    private void writeImageMap(PrintWriter pw, Map<String, String[]> mImagePathsNew) {
        if (null != pw) {
            for (Map.Entry<String, String[]> item : mImagePathsNew.entrySet()) {
                if (!this.isChartDataDrill(item.getKey())) continue;
                for (int i = 0; i < item.getValue().length; ++i) {
                    this.writeImageMap(pw, item.getValue()[i]);
                }
            }
            pw.flush();
        }
    }

    private boolean isChartDataDrill(String id) {
        for (ComponentElement item : this.mReport.getElementList()) {
            if (!(item instanceof IRChart) || !item.getId().equals(id)) continue;
            return ((IRChart)item).isShowDataDrill();
        }
        return false;
    }

    private void writeImageMap(PrintWriter pw, String filePath) {
        String mapInfo = "";
        if (this.chartInfoMap.containsKey(filePath)) {
            mapInfo = this.chartInfoMap.get(filePath);
        } else {
            String buffPath = IReportUtil.getRealPath() + filePath;
            buffPath = IReportUtil.getFileNameNotSuffix(buffPath);
            mapInfo = IReportUtil.readImageMap(buffPath);
        }
        pw.println(mapInfo);
    }

    public long getSessionId() {
        return this.mSessionId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Map<String, OrderInfo> getOrderInfoMap() {
        return this.orderInfoMap;
    }

    public void setOrderInfoMap(Map<String, OrderInfo> orderInfoMap) {
        this.orderInfoMap = orderInfoMap;
    }

    public Map<String, String[]> getMImagePaths() {
        return this.mImagePaths;
    }

    public boolean isPrepare() {
        return this.bPrepare;
    }

    public long getBackTaskId() {
        return this.backTaskId;
    }

    public void setBackTaskId(long backTaskId) {
        this.backTaskId = backTaskId;
    }

    public Map<String, JsonValueObj> getParameterMap() {
        return this.mParameters;
    }

    public String getSwitchOption() {
        return this.switchOption;
    }

    public void setSwitchOption(String switchOption) {
        this.switchOption = switchOption;
    }

    private ChartEngineOutput renderChart(IRChart chart) throws ProviderException {
        ChartEngineOutput output = new ChartEngineOutput();
        try {
            IDataSourceCollector collector;
            Map<String, ChartValue[]> valueMap;
            if (this.productParameters.get("timeLevel") != null) {
                chart.setTimeLevel(this.productParameters.get("timeLevel").get(0));
            }
            if ((valueMap = ChartValueFactory.getChartValues(chart, this.mParameters, collector = this.mDataCollectors.get(chart.getIRDataSet().getDatasource()), this.mSessionId)).isEmpty()) {
                output = JChartFactory.createEmptyOutput(this.getLocale(), chart, "ireport.nodata", 15);
                return output;
            }
            if (this.isChartMaxData(valueMap)) {
                if (chart.isTableCell()) {
                    output = JChartFactory.createEmptyOutput(this.getLocale(), chart, "ireport.vsm.maxdata", 25);
                    return output;
                }
                return null;
            }
            output = JChartFactory.createChartOutput(chart, valueMap);
        }
        catch (ProviderException e) {
            LOG.error((Object)("failed to generate chart:" + IReportUtil.getcleanedMessage(chart.toString())), (Throwable)e);
        }
        return output;
    }

    private boolean isChartMaxData(Map<String, ChartValue[]> valueMap) {
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        if (productName.equalsIgnoreCase("VSM V2")) {
            for (Map.Entry<String, ChartValue[]> item : valueMap.entrySet()) {
                if (item.getValue().length <= 10000) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createImagePathByCaseValue(IRChart chart) throws ProviderException {
        ChartEngineOutput output = this.renderChart(chart);
        ArrayList<ImageLegendVo> tempLegendInfo = new ArrayList<ImageLegendVo>();
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        if (productName.equalsIgnoreCase("VSM V2") && null == output) {
            String path = CHART_MAX_DATA_ZH;
            String exportPath = CHART_MAX_DATA_ZH_EXPORT;
            if (this.locale.toString().contains("en")) {
                path = CHART_MAX_DATA_EN;
                exportPath = CHART_MAX_DATA_EN_EXPORT;
            }
            String[] imagPaths = new String[]{path};
            String[] exportImagPaths = new String[]{exportPath};
            chart.setShowDataDrill(10000);
            this.mImagePaths.put(chart.getId(), imagPaths);
            this.mExportImagePaths.put(chart.getId(), exportImagPaths);
            ImageLegendVo imageLegend = new ImageLegendVo();
            imageLegend.setImagePath(path);
            imageLegend.setExportImagePath(exportPath);
            imageLegend.setHeight(chart.getHeight());
            imageLegend.setWidth(chart.getWidth());
            tempLegendInfo.add(imageLegend);
            this.mImageInfoList.put(chart.getId(), tempLegendInfo);
            return;
        }
        if (null == output) {
            return;
        }
        int groupCount = output.getContent().size();
        String[] imagPaths = new String[groupCount];
        String[] exportImagPaths = new String[groupCount];
        this.makeEmptyImagePath(chart, output);
        for (int i = 0; i < groupCount; ++i) {
            ImageLegendVo tempVo = new ImageLegendVo();
            String relativePath = "/iReport/temp/Img" + this.gORandom.nextDouble() + ".png";
            String exportRelativePath = "/iReport/temp/ExportImg" + this.gORandom.nextDouble() + ".png";
            List<ChartRenderingInfo> renderInfoList = output.getRenderInfoList();
            if (null == renderInfoList || renderInfoList.isEmpty()) {
                this.chartInfoMap.put(relativePath, "");
            } else {
                String mapStr = IReportChartUtilities.getImageMap(relativePath.substring(14), renderInfoList.get(i));
                this.chartInfoMap.put(relativePath, mapStr);
            }
            String imagPath = IReportUtil.getRealPath() + relativePath;
            String exportImagPath = IReportUtil.getRealPath() + exportRelativePath;
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(new File(imagPath));
                ((OutputStream)out).write(output.getContent().get(i));
                out.flush();
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("failed to generate chart:" + IReportUtil.getcleanedMessage(chart.toString())));
            }
            catch (IOException e) {
                LOG.error((Object)("failed to generate chart:" + IReportUtil.getcleanedMessage(chart.toString())), (Throwable)e);
            }
            finally {
                if (null != out) {
                    this.destroy(out);
                }
            }
            try {
                out = new FileOutputStream(new File(exportImagPath));
                ((OutputStream)out).write(output.getExportContent().get(i));
                out.flush();
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("failed to generate chart:" + IReportUtil.getcleanedMessage(chart.toString())));
            }
            catch (IOException e) {
                LOG.error((Object)("failed to generate chart:" + IReportUtil.getcleanedMessage(chart.toString())), (Throwable)e);
            }
            finally {
                this.destroy(out);
            }
            imagPaths[i] = relativePath;
            exportImagPaths[i] = exportRelativePath;
            tempVo.setHeight(chart.getHeight());
            tempVo.setWidth(chart.getWidth());
            tempVo.setImagePath(relativePath);
            tempVo.setExportImagePath(exportRelativePath);
            this.handleOrderLegend(chart, output, i, tempVo);
            tempLegendInfo.add(tempVo);
        }
        this.mImagePaths.put(output.getELementId(), imagPaths);
        this.mExportImagePaths.put(output.getELementId(), exportImagPaths);
        this.mImageInfoList.put(output.getELementId(), tempLegendInfo);
    }

    private void destroy(OutputStream out) {
        try {
            if (null != out) {
                out.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeEmptyImagePath(IRChart chart, ChartEngineOutput output) {
        String absoluteExportSmallHeightPath = "/iReport/temp/ExportSmallImg" + this.gORandom.nextDouble() + ".png";
        String absoluteExportSmallExcelHeightPath = "/iReport/temp/ExportExcelSmallImg" + this.gORandom.nextDouble() + ".png";
        String exportSmallHeightPath = IReportUtil.getRealPath() + absoluteExportSmallHeightPath;
        String exportSmallExcelHeightPath = IReportUtil.getRealPath() + absoluteExportSmallExcelHeightPath;
        OutputStream outStream = null;
        try {
            if (null != output.getExportSmallHeightContent()) {
                outStream = new FileOutputStream(new File(exportSmallHeightPath));
                outStream.write(output.getExportSmallHeightContent());
                outStream.flush();
                outStream.close();
                this.exportSmallImagePaths.put(output.getELementId(), absoluteExportSmallHeightPath);
            }
            if (null != output.getExportSmallExcelHeightContent()) {
                outStream = new FileOutputStream(new File(exportSmallExcelHeightPath));
                outStream.write(output.getExportSmallExcelHeightContent());
                outStream.flush();
                this.exportSmallExcelImagePaths.put(output.getELementId(), absoluteExportSmallExcelHeightPath);
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("failed to generate chart:" + IReportUtil.getcleanedMessage(chart.toString())));
        }
        catch (IOException e) {
            LOG.error((Object)("failed to generate chart:" + IReportUtil.getcleanedMessage(chart.toString())), (Throwable)e);
        }
        catch (RuntimeException e) {
            LOG.error((Object)("failed to generate chart:" + IReportUtil.getcleanedMessage(chart.toString())), (Throwable)e);
        }
        finally {
            if (null != outStream) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] createImagePathByTableCell(IRChart chart, Map<Object, Object> productQueryMap, IRColumn column, int index, IRTable iRTable) throws ProviderException {
        int isPrepareSucc;
        String[] tableCellImagesPath = new String[2];
        Map<Object, Object> tableCellParametersMap = productQueryMap;
        this.getSourceMapInfo(tableCellParametersMap, this.mParameters);
        String dataSourceId = chart.getIRDataSet().getDatasource();
        if (null == this.mDataCollectors.get(dataSourceId)) {
            IRDataSource datasource = this.mReport.getIRDataSourceMap().get(dataSourceId);
            IDataSourceCollector dataSourceCollector = DataSourceFactory.createDataSourceCollector(this.mSessionId, datasource);
            this.mDataCollectors.put(datasource.getId(), dataSourceCollector);
        }
        if (0 == (isPrepareSucc = this.mDataCollectors.get(dataSourceId).prepareData(this.mReport.getId(), dataSourceId, tableCellParametersMap, this.mSessionId))) {
            this.productParameters = this.mDataCollectors.get(dataSourceId).getPrepareParasMap(this.mReport.getId(), dataSourceId, productQueryMap, this.mSessionId);
        }
        ChartEngineOutput output = this.renderChart(chart);
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        if (productName.equalsIgnoreCase("VSM V2") && null == output) {
            String path = CHART_MAX_DATA_ZH;
            String exportPath = CHART_MAX_DATA_ZH_EXPORT;
            if (this.locale.toString().contains("en")) {
                path = CHART_MAX_DATA_EN;
                exportPath = CHART_MAX_DATA_EN_EXPORT;
            }
            tableCellImagesPath[0] = path;
            tableCellImagesPath[1] = exportPath;
            this.tableCellImageMap.put(this.createTableCellImageName(iRTable, column, index), tableCellImagesPath[0]);
            return tableCellImagesPath;
        }
        if (null != output) {
            int groupCount = output.getContent().size();
            for (int i = 0; i < groupCount; ++i) {
                String relativePath = "/iReport/temp/Img" + this.gORandom.nextDouble() + ".png";
                String exportRelativePath = "/iReport/temp/ExportImg" + this.gORandom.nextDouble() + ".png";
                String imagPath = IReportUtil.getRealPath() + relativePath;
                String exportImagPath = IReportUtil.getRealPath() + exportRelativePath;
                tableCellImagesPath[0] = relativePath;
                tableCellImagesPath[1] = exportRelativePath;
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(new File(imagPath));
                    ((OutputStream)out).write(output.getContent().get(i));
                    out.flush();
                    ((OutputStream)out).close();
                    if (output.getExportContent().size() <= i) continue;
                    try {
                        out = new FileOutputStream(new File(exportImagPath));
                        ((OutputStream)out).write(output.getExportContent().get(i));
                        out.flush();
                        continue;
                    }
                    catch (IOException e) {
                        LOG.error((Object)e);
                        continue;
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)("failed to generate chart:" + IReportUtil.getcleanedMessage(chart.toString())), (Throwable)e);
                    continue;
                }
                finally {
                    if (null != out) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException e) {
                            LOG.error((Object)e);
                        }
                    }
                }
            }
        }
        this.tableCellImageMap.put(this.createTableCellImageName(iRTable, column, index), tableCellImagesPath[0]);
        return tableCellImagesPath;
    }

    private void handleOrderLegend(IRChart chart, ChartEngineOutput output, int i, ImageLegendVo tempVo) {
        if (!output.getLegendColorList().isEmpty() && output.getLegendColorList().size() > i) {
            if (!chart.getIRDataSet().isAutoExpand()) {
                ArrayList<LegendColor> legendList = new ArrayList<LegendColor>((Collection)output.getLegendColorList().get(i));
                tempVo.setLegendColorList(this.orderLegendList(legendList, chart));
            } else {
                tempVo.setLegendColorList(output.getLegendColorList().get(i));
            }
        }
    }

    private List<LegendColor> orderLegendList(List<LegendColor> legendListParam, IRChart chart) {
        ArrayList<LegendColor> legendList = new ArrayList<LegendColor>();
        List<IRChartDataItem> dataItemList = chart.getIRDataSet().getDataItemList();
        for (IRChartDataItem item : dataItemList) {
            for (LegendColor legend : legendListParam) {
                if (!item.getSeries().equals(legend.getLegend())) continue;
                legendList.add(legend);
            }
        }
        return legendList;
    }

    private void createImagePathByCaseValue() throws ProviderException {
        this.mImagePaths = new HashMap<String, String[]>();
        this.mExportImagePaths = new HashMap<String, String[]>();
        this.mImageInfoList = new HashMap<String, List<ImageLegendVo>>();
        long[] timeRange = this.getStartEndTime(this.mParameters);
        for (ComponentElement element : this.mReport.getElementList()) {
            if (!(element instanceof IRChart)) continue;
            this.setStartEndTime((IRChart)element, timeRange);
            this.createImagePathByCaseValue((IRChart)element);
        }
    }

    private long[] getStartEndTime(Map<String, JsonValueObj> mParametersNew) {
        if (null == mParametersNew || mParametersNew.isEmpty()) {
            return new long[0];
        }
        long[] timeRange = new long[2];
        String type = null;
        for (Map.Entry<String, JsonValueObj> item : mParametersNew.entrySet()) {
            type = item.getValue().getType();
            if (!"comboDate".equals(type) && !"natureDate".equals(type) && !"dateRange".equals(type)) continue;
            timeRange[0] = this.getServerTime(item.getValue().getValueList().get(0));
            timeRange[1] = this.getServerTime(item.getValue().getValueList().get(1));
        }
        return timeRange;
    }

    private long getServerTime(JsonValueItem item) {
        long resultValue = 0L;
        if (null != item.getText() && item.getText().trim().length() > 0) {
            try {
                resultValue = Timestamp.valueOf(item.getText()).getTime() / 1000L * 1000L;
            }
            catch (Exception e) {
                resultValue = Long.parseLong(item.getValue()) * 1000L;
            }
        }
        return resultValue;
    }

    private void setStartEndTime(IRChart chart, long[] timeRange) {
        if (timeRange.length == 0) {
            return;
        }
        chart.setStartTime(timeRange[0]);
        chart.setEndTime(timeRange[1]);
    }

    public String getJsonValueStr() {
        return this.jsonValueStr;
    }

    public void setJsonValueStr(String jsonValueStr) {
        this.jsonValueStr = jsonValueStr;
    }

    public void clearDataset() {
        for (Map.Entry<String, IDataSourceCollector> item : this.mDataCollectors.entrySet()) {
            item.getValue().clean();
        }
        this.mDataCollectors.clear();
        this.chartInfoMap.clear();
        this.bPrepare = false;
    }

    public ReportSession getCloneObj() {
        ReportSession item = new ReportSession(this.mReport, this.mSessionId, this.locale);
        item.mParameters = new HashMap<String, JsonValueObj>();
        if (this.mParameters != null && !this.mParameters.isEmpty()) {
            item.mParameters.putAll(this.mParameters);
        } else {
            LOG.warn((Object)"mParameters is empty");
        }
        item.mImagePaths = new HashMap<String, String[]>();
        if (this.mImagePaths != null && !this.mImagePaths.isEmpty()) {
            item.mImagePaths.putAll(this.mImagePaths);
        } else {
            LOG.warn((Object)"mImagePaths is empty");
        }
        item.mExportImagePaths = new HashMap<String, String[]>();
        if (this.mExportImagePaths != null && !this.mExportImagePaths.isEmpty()) {
            item.mExportImagePaths.putAll(this.mExportImagePaths);
        } else {
            LOG.warn((Object)"mExportImagePaths is empty");
        }
        item.mImageInfoList = new HashMap<String, List<ImageLegendVo>>();
        if (this.mImageInfoList != null && !this.mImageInfoList.isEmpty()) {
            item.mImageInfoList.putAll(this.mImageInfoList);
        }
        for (Map.Entry<String, String> obj : this.chartInfoMap.entrySet()) {
            this.writeChartInfoToDisk(obj.getKey(), obj.getValue());
        }
        return item;
    }

    private void writeChartInfoToDisk(String fileName, String chartInfoStr) {
        String filePath = IReportUtil.getRealPath() + fileName;
        filePath = IReportUtil.getPathWithoutSuffix(filePath);
        IReportUtil.writeImageMap(chartInfoStr, filePath);
    }

    private void getSourceMapInfo(Map<Object, Object> sourceMap, Map<String, JsonValueObj> map) {
        Map.Entry<String, JsonValueObj> entry2 = null;
        for (Map.Entry<String, JsonValueObj> entry2 : map.entrySet()) {
            if (null != sourceMap.get(entry2.getKey())) continue;
            sourceMap.put(entry2.getKey(), entry2.getValue());
        }
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ReportSession) {
            ReportSession item = (ReportSession)obj;
            if (this.mSessionId == item.mSessionId) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String createTableCellImageName(IRTable iRTable, IRColumn column, int index) {
        return iRTable.getId() + "_" + column.getField() + "_" + index;
    }

    public Map<String, String> getTableCellImageMap() {
        return this.tableCellImageMap;
    }
}

