/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.PluginManager;
import com.security.ireport.engine.ReportSession;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.engine.definition.JasperDefinitionParser;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.ProductFaceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.lang3.StringUtils;

public final class ReportSessionManager {
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static ReportSessionManager instance = null;
    private Map<String, HashMap<Long, ReportSession>> sessions = null;
    private ArrayBlockingQueue<String> firstReportSessionQueue = null;
    private ArrayBlockingQueue<String> secondReportSessionQueue = null;
    private Map<Long, ReportSession> reportSessionMap = null;
    private final Object lock = new Object();

    private ReportSessionManager() {
        int firstBufflength = IReportConfigUtil.getInstance().getFirstRSessionQueueLength();
        int secondBufflength = IReportConfigUtil.getInstance().getSecondRSessionQueueLength();
        this.firstReportSessionQueue = new ArrayBlockingQueue(firstBufflength);
        this.secondReportSessionQueue = new ArrayBlockingQueue(secondBufflength);
        this.sessions = new HashMap<String, HashMap<Long, ReportSession>>();
        this.reportSessionMap = new HashMap<Long, ReportSession>();
    }

    public static ReportSessionManager getInstance() {
        if (null == instance) {
            instance = new ReportSessionManager();
        }
        return instance;
    }

    private boolean isSecondQueueAndSessionEqual() {
        LOG.info((Object)("secondReportSessionQueue.size()=" + this.secondReportSessionQueue.size() + "; reportSessionMap.size=" + this.reportSessionMap.size()));
        return this.secondReportSessionQueue.size() == this.reportSessionMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFirstQueue(String httpSessionId, long reportSessionId, ReportSession reportSession) {
        Object object = this.lock;
        synchronized (object) {
            boolean result;
            String sessionStr = httpSessionId + "@@_@@" + reportSessionId;
            if (this.firstReportSessionQueue.contains(sessionStr)) {
                return;
            }
            if (this.secondReportSessionQueue.contains(sessionStr)) {
                this.secondReportSessionQueue.remove(sessionStr);
                this.reportSessionMap.remove(reportSessionId);
                LOG.info((Object)"remove secondReportSessionQueue");
            }
            if (!(result = this.firstReportSessionQueue.offer(sessionStr))) {
                String waitRemoveObj = this.firstReportSessionQueue.poll();
                if (null != waitRemoveObj) {
                    String[] objs = waitRemoveObj.split("@@_@@");
                    try {
                        Long pollReportSessionId = Long.valueOf(objs[1]);
                        String pollHSessionId = objs[0];
                        HashMap<Long, ReportSession> reportSessionSet = this.sessions.get(pollHSessionId);
                        if (reportSessionSet != null && reportSessionSet.containsKey(pollReportSessionId)) {
                            ReportSession item = reportSessionSet.get(pollReportSessionId);
                            ReportSession cloneObj = item.getCloneObj();
                            item.clearDataset();
                            this.sessions.get(pollHSessionId).remove(pollReportSessionId);
                            this.addSecondQueue(pollHSessionId, pollReportSessionId, cloneObj);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"addQueue failed", (Throwable)e);
                    }
                }
                result = this.firstReportSessionQueue.offer(sessionStr);
            }
            if (result) {
                HashMap<Long, ReportSession> reportSessionSet = this.sessions.get(httpSessionId);
                if (reportSessionSet != null) {
                    reportSessionSet.put(reportSession.getSessionId(), reportSession);
                } else {
                    reportSessionSet = new HashMap();
                    reportSessionSet.put(reportSession.getSessionId(), reportSession);
                    this.sessions.put(httpSessionId, reportSessionSet);
                }
            }
            LOG.info((Object)("addFirstQueue result=" + result));
        }
    }

    private void addSecondQueue(String pollHSessionId, Long pollReportSessionId, ReportSession cloneObj) {
        boolean result;
        String sessionStr = pollHSessionId + "@@_@@" + pollReportSessionId;
        if (this.secondReportSessionQueue.contains(sessionStr)) {
            this.secondReportSessionQueue.remove(sessionStr);
            this.reportSessionMap.remove(pollReportSessionId);
        }
        if (!(result = this.secondReportSessionQueue.offer(sessionStr))) {
            String[] objs;
            Long waitRSessionId;
            String waitRemoveObj = this.secondReportSessionQueue.poll();
            if (null != waitRemoveObj && this.reportSessionMap.containsKey(waitRSessionId = Long.valueOf((objs = waitRemoveObj.split("@@_@@"))[1]))) {
                this.reportSessionMap.get(waitRSessionId).clean();
                this.reportSessionMap.remove(waitRSessionId);
            }
            result = this.secondReportSessionQueue.offer(sessionStr);
        }
        if (result) {
            this.reportSessionMap.put(pollReportSessionId, cloneObj);
        }
    }

    public ReportSession createReportSession(String reportId, String httpSessionId, Locale locale) {
        IReport report = PluginManager.getInstance().getReportPlugin(reportId);
        if (null == report) {
            LOG.error((Object)("Cannot get report Instance: reportId = " + reportId));
            return null;
        }
        IReport iReport = IReportUtil.createCloneObj(report, locale);
        long sessionId = ProductFaceUtil.getInstance().getNextSessionId();
        if (-1L == sessionId) {
            LOG.error((Object)"create failure");
            return null;
        }
        ReportSession reportSession = new ReportSession(iReport, sessionId, locale);
        if (!iReport.isFlexTable()) {
            JasperDefinitionParser jasperParser = new JasperDefinitionParser(iReport);
            jasperParser.buildJasperReport();
        }
        if (httpSessionId != null) {
            this.addFirstQueue(httpSessionId, sessionId, reportSession);
        }
        return reportSession;
    }

    public boolean hasReportSession(long sessionId, String httpSessionId) {
        return this.sessions.containsKey(httpSessionId) && this.sessions.get(httpSessionId).containsKey(sessionId);
    }

    public ReportSession getSessionBySessionId(long sessionId, String httpSessionId) {
        ReportSession reportSession = null;
        if (!this.hasReportSession(sessionId, httpSessionId)) {
            if (this.reportSessionMap.containsKey(sessionId) && !(reportSession = this.reportSessionMap.get(sessionId)).isPrepare()) {
                reportSession.prepare(reportSession.getParameterMap(), true);
                this.addFirstQueue(httpSessionId, sessionId, reportSession);
            }
        } else {
            reportSession = this.sessions.get(httpSessionId).get(sessionId);
        }
        return reportSession;
    }

    public ReportSession createSessionForBackTask(String reportId, long sessionId, String httpSessionId, Locale locale) {
        IReport iReport = PluginManager.getInstance().getReportPlugin(reportId);
        if (null == iReport) {
            return null;
        }
        IReport report = IReportUtil.createCloneObj(iReport, locale);
        ReportSession reportSession = new ReportSession(report, sessionId, locale);
        this.addFirstQueue(httpSessionId, sessionId, reportSession);
        if (!report.isFlexTable()) {
            JasperDefinitionParser jasperParser = new JasperDefinitionParser(report);
            jasperParser.buildJasperReport();
        }
        return reportSession;
    }

    public ReportSession createSessionForDataDrill(String reportId, long reportSessionId, String httpSessionId, Map<String, JsonValueObj> newParaMap) {
        ReportSession oldReportSession = this.getSessionBySessionId(reportSessionId, httpSessionId);
        if (null == oldReportSession) {
            LOG.error((Object)"httpsession timeout, can not dataDrill");
            return null;
        }
        IReport iReport = PluginManager.getInstance().getReportPlugin(reportId);
        if (null == iReport) {
            return null;
        }
        IReport report = IReportUtil.createCloneObj(iReport, oldReportSession.getLocale());
        if (StringUtils.isNotBlank((CharSequence)report.getName())) {
            LOG.info((Object)"report is not null");
        }
        Map<String, JsonValueObj> oldParameterMap = oldReportSession.getParameterMap();
        HashMap<String, JsonValueObj> newParameterMap = new HashMap<String, JsonValueObj>();
        newParameterMap.putAll(oldParameterMap);
        newParameterMap.remove("switchOption");
        newParameterMap.putAll(newParaMap);
        return this.createNewSessionForDataDrill(reportId, httpSessionId, newParameterMap, oldReportSession.getLocale());
    }

    public ReportSession createNewSessionForDataDrill(String reportId, String httpSessionId, Map<String, JsonValueObj> newParameterMap, Locale locale) {
        boolean status;
        IReport iReport = PluginManager.getInstance().getReportPlugin(reportId);
        if (null == iReport) {
            return null;
        }
        IReport report = IReportUtil.createCloneObj(iReport, LocaleUtil.getCurrentUserLocale());
        long newReportSessionId = ProductFaceUtil.getInstance().getNextSessionId();
        if (-1L == newReportSessionId) {
            LOG.error((Object)"create sessionId failure");
            return null;
        }
        ReportSession reportSession = new ReportSession(report, newReportSessionId, locale);
        this.addFirstQueue(httpSessionId, newReportSessionId, reportSession);
        if (!report.isFlexTable()) {
            JasperDefinitionParser jasperParser = new JasperDefinitionParser(report);
            jasperParser.buildJasperReport();
        }
        if (!(status = reportSession.prepare(newParameterMap, true))) {
            return null;
        }
        return reportSession;
    }

    public void removeReportSession(long sessionId, String httpSessionId) {
        this.pollFirstQueue(httpSessionId, sessionId);
        this.pollSecondQueue(httpSessionId, sessionId);
    }

    public void httpSessionExpired(String httpSessionId) {
        if (this.sessions.containsKey(httpSessionId)) {
            HashMap<Long, ReportSession> reportSessionSet = this.sessions.get(httpSessionId);
            ArrayList<Long> rsList = new ArrayList<Long>(reportSessionSet.keySet());
            for (Long item : rsList) {
                this.pollFirstQueue(httpSessionId, item);
            }
        }
        String[] sessionKeys = new String[this.secondReportSessionQueue.size()];
        sessionKeys = this.secondReportSessionQueue.toArray(sessionKeys);
        String httpSessionFix = httpSessionId + "@@_@@";
        for (String key : sessionKeys) {
            if (key.indexOf(httpSessionFix) == -1) continue;
            String[] objs = key.split("@@_@@");
            Long rSessionId = Long.valueOf(objs[1]);
            this.pollSecondQueue(httpSessionId, rSessionId);
        }
    }

    private void pollFirstQueue(String httpSessionId, long reportSessionId) {
        HashMap<Long, ReportSession> reportSessionSet = this.sessions.get(httpSessionId);
        if (reportSessionSet != null && reportSessionSet.containsKey(reportSessionId)) {
            this.sessions.get(httpSessionId).get(reportSessionId).clean();
            this.sessions.get(httpSessionId).remove(reportSessionId);
        }
    }

    private void pollSecondQueue(String httpSessionId, long reportSessionId) {
        String key = httpSessionId + "@@_@@" + reportSessionId;
        if (this.reportSessionMap.containsKey(reportSessionId)) {
            this.reportSessionMap.get(reportSessionId).clean();
            this.reportSessionMap.remove(reportSessionId);
        }
        boolean result = this.secondReportSessionQueue.remove(key);
        LOG.info((Object)("secondReportSessionQueue remove, result=" + result + "; secondReportSessionQueue.size=" + this.secondReportSessionQueue.size() + "; isSecondQueueAndSessionEqual=" + this.isSecondQueueAndSessionEqual()));
        this.deleteTempFile();
    }

    private void deleteTempFile() {
        LOG.info((Object)"into deleteTempFile-------->");
        String dirPath = IReportUtil.getIReportTempImagePath();
        File sourDirectory = new File(dirPath);
        File[] sourFiles = sourDirectory.listFiles();
        Calendar cal = Calendar.getInstance();
        cal.roll(11, -2);
        long lastTwoHourTime = cal.getTimeInMillis();
        if (sourFiles != null && sourFiles.length > 0) {
            for (File file : sourFiles) {
                if (file.getName().equalsIgnoreCase(".svn") || file.lastModified() >= lastTwoHourTime) continue;
                boolean result = file.delete();
                LOG.info((Object)("file->" + file.getName() + " is del, result=" + result));
            }
        }
        LOG.info((Object)"<--------------out deleteTempFile");
    }
}

