/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.dataset;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.DBConnectionManager;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.engine.dataset.IDataSourceCollector;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.engine.definition.IRDataSource;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.JSONUtil;
import com.security.ireport.util.SqlUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class CsvDataSourceCollector
extends IDataSourceCollector {
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<Object[]> curPageData = new ArrayList<Object[]>();
    private String tempTableName = null;
    private String reportId;
    private long allCount = -1L;
    private IRDataSource dataSourceCfg = null;
    private List<String> sqlSectionList = null;

    public CsvDataSourceCollector(IRDataSource dsCfg) {
        this.dataSourceCfg = dsCfg;
    }

    @Override
    public void setCacheData(boolean cache) {
    }

    private Connection getDBConnect(IRDataSource ds, String sql) {
        String fileAllPath = IReportUtil.getRealPath() + "/iReport/iReportBiz/reportPlugins/" + this.reportId + "/" + ds.getFilePath();
        Connection conn = DBConnectionManager.getInstance().getCSVConnection(fileAllPath);
        this.tempTableName = this.createCSVTable(conn, ds, sql);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createCSVTable(Connection conn, IRDataSource ds, String sql) {
        String tempCSVTableName = SqlUtil.getTableNameFromSql(sql) + Calendar.getInstance().getTimeInMillis() / 1000L;
        Statement stms = null;
        try {
            StringBuilder createTable = new StringBuilder();
            createTable.append("DROP TABLE ? IF EXISTS;");
            createTable.append("CREATE TEXT TABLE ? ( " + SqlUtil.getCreateFieldStr(ds.getFieldList().getFieldList()) + " );");
            stms = conn.prepareStatement(createTable.toString());
            stms.setString(1, tempCSVTableName);
            stms.setString(2, tempCSVTableName);
            conn.setAutoCommit(true);
            stms.execute();
        }
        catch (SQLException e) {
            LOG.error((Object)"Error to stms.", (Throwable)e);
        }
        finally {
            try {
                if (null != stms) {
                    stms.close();
                }
            }
            catch (SQLException e) {
                LOG.error((Object)"Error to close stms.", (Throwable)e);
            }
        }
        try {
            String dataSourceSpec = ds.getFilePath() + ";encoding=" + ds.getEncoding() + ";ignore_first=" + ds.isIgnoreFirst() + ";all_quoted=true;fs=" + ds.getFileSeparator();
            StringBuilder setTableSource = new StringBuilder();
            setTableSource.append("SET TABLE ? SOURCE \"?\"");
            stms = conn.prepareStatement(setTableSource.toString());
            stms.setString(1, tempCSVTableName);
            stms.setString(2, dataSourceSpec);
            stms.execute();
        }
        catch (Exception e) {
            LOG.error((Object)"Error to createCSVTable. ", (Throwable)e);
            this.closeCsvTable(conn, this.tempTableName);
        }
        finally {
            if (stms != null) {
                try {
                    stms.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Error to close stms.");
                }
            }
        }
        return tempCSVTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCsvTable(Connection conn, String tableName) {
        PreparedStatement stms = null;
        try {
            String sql = "DROP TABLE ? IF EXISTS;";
            stms = conn.prepareStatement(sql);
            stms.setString(1, tableName);
            stms.execute();
            stms.executeUpdate("SHUTDOWN;");
        }
        catch (Exception e) {
            LOG.error((Object)"Error to closeCsvTable. ", (Throwable)e);
        }
        finally {
            if (stms != null) {
                try {
                    stms.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Error to close stms.");
                }
            }
            this.tempTableName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAllCount() {
        Connection conn;
        if (this.allCount < 0L && (conn = this.getDBConnect(this.dataSourceCfg, this.sqlSectionList.get(0))) != null) {
            String sqlCount = SqlUtil.getCountSql(this.sqlSectionList);
            sqlCount = SqlUtil.replaceTableName(sqlCount, this.tempTableName);
            List<Object[]> result = SqlUtil.execusePrepareQuery(sqlCount, conn, this.dataSourceCfg.getParaList().getParaList(), this.getAllFieldInfo());
            this.allCount = this.getAllCount(result);
            try {
                this.closeCsvTable(conn, this.tempTableName);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)e);
                }
            }
        }
        return this.allCount;
    }

    private long getAllCount(List<Object[]> result) {
        long allCountNew = 0L;
        if (null != result && !result.isEmpty()) {
            allCountNew = IReportConfCheckUtil.getLong(result.get(0)[0]);
        }
        return allCountNew;
    }

    @Override
    public long getCurPageCount() {
        return this.curPageData.size();
    }

    @Override
    public Object getValue(long row, String colName) {
        return SqlUtil.getValue(row, colName, this.curPageData, this.getAllFieldInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(long pgIndex, long pgSize, OrderInfo sortList) {
        List<Object[]> result;
        this.curPageData.clear();
        Connection conn = this.getDBConnect(this.dataSourceCfg, this.sqlSectionList.get(0));
        String tempSql = SqlUtil.replaceTableName(SqlUtil.getFullSql(this.sqlSectionList), this.tempTableName);
        tempSql = this.getSqlFilterByDataType(tempSql, pgIndex, pgSize, sortList);
        if (conn != null && (result = SqlUtil.execusePrepareQuery(tempSql, conn, this.dataSourceCfg.getParaList().getParaList(), this.getAllFieldInfo())) != null && !result.isEmpty()) {
            this.curPageData.addAll(result);
        }
        try {
            this.closeCsvTable(conn, this.tempTableName);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)e);
                }
            }
        }
    }

    private String getSqlFilterByDataType(String sql, long pgIndex, long pgSize, OrderInfo sortList) {
        String tempSql = SqlUtil.transOrderFullSql(sql, sortList);
        if (0L == pgIndex && 0L == pgSize) {
            return tempSql;
        }
        return "select limit " + (pgIndex - 1L) * pgSize + " " + pgSize + " " + tempSql.substring("select".length());
    }

    @Override
    public int prepareData(String reportID, String dataSourceId, Map<?, ?> queryConds, long sessionId) {
        this.reportId = reportID;
        Map<String, JsonValueObj> queryCond = queryConds;
        Map<String, List<String>> paramKeyValueMap = JSONUtil.transformKeyValueMap(queryCond);
        String filterSql = SqlUtil.formatSQL(this.dataSourceCfg.getSql(), paramKeyValueMap);
        this.sqlSectionList = SqlUtil.decomposeSql(filterSql);
        List<Integer> nullKeyIndex = SqlUtil.getNullKeyIndex(paramKeyValueMap, this.dataSourceCfg.getParaList().getParaList());
        String whereSql = SqlUtil.removeWhereNullKey(this.sqlSectionList.get(1), nullKeyIndex);
        whereSql = SqlUtil.replaceKeyMulValueSql(whereSql, this.dataSourceCfg.getParaList().getParaList());
        this.sqlSectionList.remove(1);
        this.sqlSectionList.add(1, whereSql);
        return 0;
    }

    @Override
    public List<FieldInfo> getAllFieldInfo() {
        return this.dataSourceCfg.getFieldList().getFieldList();
    }
}

