/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.dataset;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.connpool.DBPoolFactory;
import com.security.ireport.engine.dataset.JdbcConnectorCfg;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class DBConnectionManager {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static Map<String, JdbcConnectorCfg> dbConfigMap = new HashMap<String, JdbcConnectorCfg>();
    private static DBConnectionManager dbConnectionMgr = null;

    private DBConnectionManager() {
        List<JdbcConnectorCfg> list = this.initDbConfig();
        DBConnectionManager.setDbConfigMap(this.addDBToPool(list));
    }

    private List<JdbcConnectorCfg> initDbConfig() {
        ArrayList<JdbcConnectorCfg> jdbcConnCfgs = new ArrayList<JdbcConnectorCfg>();
        String pathDBConfig = IReportUtil.getRealPath() + "/iReport/iReportBiz/config/" + "dbConfig.xml";
        SAXReader saxReader = new SAXReader();
        try {
            File file = new File(pathDBConfig);
            Document document = saxReader.read(file);
            if (document != null) {
                Element root = document.getRootElement();
                List elementList = root.elements();
                Iterator elementIter = elementList.iterator();
                this.getJDBCConnCfgList(elementIter, jdbcConnCfgs);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"initDbConfig failed.", (Throwable)e);
        }
        return jdbcConnCfgs;
    }

    private void getJDBCConnCfgList(Iterator<?> elementIter, List<JdbcConnectorCfg> jdbcConnCfgs) {
        JdbcConnectorCfg jdbcConnectorCfg = null;
        while (elementIter.hasNext()) {
            Element element = (Element)elementIter.next();
            Attribute id = element.attribute("id");
            List detailList = element.elements();
            Iterator detailIter = detailList.iterator();
            jdbcConnectorCfg = new JdbcConnectorCfg();
            jdbcConnectorCfg.setConnId(id.getData().toString());
            while (detailIter.hasNext()) {
                Element detialElement = (Element)detailIter.next();
                if ("driverClass".equals(detialElement.getName())) {
                    jdbcConnectorCfg.setDriverClass(detialElement.getData().toString());
                    continue;
                }
                if ("url".equals(detialElement.getName())) {
                    jdbcConnectorCfg.setUrl(detialElement.getData().toString());
                    continue;
                }
                if ("username".equals(detialElement.getName())) {
                    jdbcConnectorCfg.setUserName(detialElement.getData().toString());
                    continue;
                }
                if (!"password".equals(detialElement.getName())) continue;
                jdbcConnectorCfg.setPassword(detialElement.getData().toString());
            }
            String driverClass = jdbcConnectorCfg.getDriverClass();
            jdbcConnectorCfg.setType(this.getDBTypeByDriverClass(driverClass));
            jdbcConnCfgs.add(jdbcConnectorCfg);
        }
    }

    private String getDBTypeByDriverClass(String driverClass) {
        String dbType = "";
        if (driverClass.contains("mysql")) {
            dbType = "mysql";
        } else if (driverClass.contains("oracle")) {
            dbType = "oracle";
        } else if (driverClass.contains("sqlserver")) {
            dbType = "sqlserver";
        }
        return dbType;
    }

    private Map<String, JdbcConnectorCfg> addDBToPool(List<JdbcConnectorCfg> jdbcConnCfgs) {
        HashMap<String, JdbcConnectorCfg> map;
        block1: {
            map = new HashMap<String, JdbcConnectorCfg>();
            if (jdbcConnCfgs == null || jdbcConnCfgs.isEmpty()) break block1;
            for (JdbcConnectorCfg item : jdbcConnCfgs) {
                if (this.addToPool(item, map)) break;
            }
        }
        return map;
    }

    private boolean addToPool(JdbcConnectorCfg item, Map<String, JdbcConnectorCfg> map) {
        boolean ret = false;
        if (item.getConnId() != null && !item.getConnId().trim().isEmpty()) {
            if (!map.containsKey(item.getConnId())) {
                try {
                    DBPoolFactory.getInstance().add(item);
                    map.put(item.getConnId(), item);
                }
                catch (Exception e) {
                    LOGGER.error((Object)item.toString(), (Throwable)e);
                }
            } else {
                map.clear();
                LOGGER.error((Object)("dbConnectId =" + item.getConnId() + " is exist, remove all dbConnect, load failed."));
                ret = true;
            }
        } else {
            LOGGER.error((Object)"dbConnectId is null.");
        }
        return ret;
    }

    public static DBConnectionManager getInstance() {
        if (null == dbConnectionMgr) {
            dbConnectionMgr = new DBConnectionManager();
        }
        return dbConnectionMgr;
    }

    public String getConnectionType(String connectionId) {
        if (dbConfigMap.containsKey(connectionId)) {
            return dbConfigMap.get(connectionId).getType();
        }
        return null;
    }

    public Connection getCSVConnection(String filePath) {
        Connection conn = null;
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            String userName = IReportConfigUtil.getInstance().getCsvDbUserName();
            String pwd = IReportConfigUtil.getInstance().getCsvDbPwd();
            conn = DriverManager.getConnection("jdbc:hsqldb:file:" + filePath, userName, pwd);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"Error to getConnection. ", (Throwable)e);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"Error to getConnection. ", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"Error to getConnection. ", (Throwable)e);
        }
        return conn;
    }

    public Map<String, JdbcConnectorCfg> getDbConfigMap() {
        return dbConfigMap;
    }

    public static void setDbConfigMap(Map<String, JdbcConnectorCfg> dbConfig) {
        dbConfigMap = dbConfig;
    }
}

