/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.dataset;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.CsvDataSourceCollector;
import com.security.ireport.engine.dataset.IDataSourceCollector;
import com.security.ireport.engine.dataset.JavaDataSourceCollector;
import com.security.ireport.engine.dataset.ProcedureDataSourceCollector;
import com.security.ireport.engine.dataset.SqlDataSourceCollector;
import com.security.ireport.engine.definition.IRDataSource;

public final class DataSourceFactory {
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    private DataSourceFactory() {
    }

    public static IDataSourceCollector createDataSourceCollector(long sessionId, IRDataSource dataSourceCfg) {
        IDataSourceCollector dsCollector = null;
        LOG.debug((Object)("Create data source, type:" + dataSourceCfg.getType() + ", datasource ID:" + dataSourceCfg.getId()));
        try {
            if ("java".equals(dataSourceCfg.getType())) {
                dsCollector = new JavaDataSourceCollector(dataSourceCfg.clone(), sessionId);
            } else if ("csv".equals(dataSourceCfg.getType())) {
                dsCollector = new CsvDataSourceCollector(dataSourceCfg.clone());
            } else if ("sql".equals(dataSourceCfg.getType())) {
                dsCollector = new SqlDataSourceCollector(dataSourceCfg.clone());
            } else if ("procedure".equals(dataSourceCfg.getType())) {
                dsCollector = new ProcedureDataSourceCollector(dataSourceCfg.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)e);
        }
        return dsCollector;
    }
}

