/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.dataset;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.connpool.DBPool;
import com.security.ireport.connpool.DBPoolFactory;
import com.security.ireport.engine.dataset.DBConnectionManager;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.engine.dataset.IDataSourceCollector;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.engine.definition.IRDataSource;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.util.JSONUtil;
import com.security.ireport.util.SqlUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProcedureDataSourceCollector
extends IDataSourceCollector {
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private IRDataSource dataSourceCfg = null;
    private String dataBaseType = null;
    private List<Object[]> curPageData = new ArrayList<Object[]>();
    private String procedureSql;

    public ProcedureDataSourceCollector(IRDataSource dsCfg) {
        this.dataSourceCfg = dsCfg;
        this.dataBaseType = DBConnectionManager.getInstance().getConnectionType(this.dataSourceCfg.getDatabase());
    }

    @Override
    public long getAllCount() {
        long recordCount = 0L;
        return recordCount;
    }

    @Override
    public List<FieldInfo> getAllFieldInfo() {
        return this.dataSourceCfg.getFieldList().getFieldList();
    }

    @Override
    public long getCurPageCount() {
        return this.curPageData.size();
    }

    @Override
    public Object getValue(long row, String colName) {
        return SqlUtil.getValue(row, colName, this.curPageData, this.getAllFieldInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(long pgIndex, long pgSize, OrderInfo sortList) {
        this.curPageData.clear();
        DBPool dbPool = DBPoolFactory.getInstance().getDBPool(this.dataSourceCfg.getDatabase());
        if (null == dbPool) {
            return;
        }
        try {
            Connection conn = dbPool.getConnection();
            List<Object[]> result = SqlUtil.execusePrepareQuery(this.procedureSql, conn, this.dataSourceCfg.getParaList().getParaList(), this.getAllFieldInfo());
            if (result != null && !result.isEmpty()) {
                this.curPageData.addAll(result);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)(" get getDBPool failed. dbConnId=" + this.dataSourceCfg.getDatabase()), (Throwable)e);
        }
        finally {
            dbPool.closeConnection();
        }
    }

    @Override
    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryConds, long sessionId) {
        Map<String, JsonValueObj> queryCond = queryConds;
        Map<String, List<String>> paramKeyValueMap = JSONUtil.transformKeyValueMap(queryCond);
        this.procedureSql = SqlUtil.formatSQL(this.dataSourceCfg.getSql(), paramKeyValueMap);
        return 0;
    }

    @Override
    public void setCacheData(boolean cache) {
    }

    public String getDataBaseType() {
        return this.dataBaseType;
    }

    public void setDataBaseType(String dataBaseType) {
        this.dataBaseType = dataBaseType;
    }
}

