/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.definition;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.definition.ComponentElement;
import com.security.ireport.engine.definition.IRAxis;
import com.security.ireport.engine.definition.IRDataSet;
import com.security.ireport.engine.definition.IRPlot;
import com.security.ireport.util.LocaleUtil;

public class IRChart
extends ComponentElement {
    public static final int TABLECHARTWIDTH = 120;
    public static final int TABLECHARTHIGHT = 60;
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final int MAX_DATA_DRILL = 5000;
    private static final int CHARTWIDTH = 529;
    private static final int CHARTHEIGHT = 250;
    private String chartType;
    private boolean showDataDrill;
    private boolean legend = true;
    private boolean valueShowTop = false;
    private IRDataSet iRDataSet;
    private int width = 0;
    private int height = 0;
    private int exportWidth = 529;
    private int exportHeight = 250;
    private IRPlot plot = new IRPlot();
    private IRAxis rangeAxis = new IRAxis();
    private IRAxis domainAxis = new IRAxis();
    private int topN = 0;
    private String timeLevel = "";
    private long startTime = -1L;
    private long endTime = -1L;
    private boolean domainAxisByParaDate = true;
    private double pointWidth = 2.0;
    private double pointHeight = 2.0;
    private String sortOrder;
    private String display;
    private boolean tableCell = false;

    public void addPlot(IRPlot chartPlot) {
        this.plot = chartPlot;
    }

    public void addIRDataSet(IRDataSet iRDS) {
        this.iRDataSet = iRDS;
    }

    public String getChartType() {
        return this.chartType;
    }

    public void setChartType(String chartType) {
        this.chartType = chartType;
    }

    public boolean isLegend() {
        return this.legend;
    }

    public void setLegend(boolean legend) {
        this.legend = legend;
    }

    public IRDataSet getIRDataSet() {
        return this.iRDataSet;
    }

    public void setIRDataSet(IRDataSet iRDataSetT) {
        this.iRDataSet = iRDataSetT;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public IRPlot getPlot() {
        return this.plot;
    }

    public void setPlot(IRPlot plot) {
        this.plot = plot;
    }

    public IRAxis getRangeAxis() {
        return this.rangeAxis;
    }

    public void setRangeAxis(IRAxis rangeAxis) {
        this.rangeAxis = rangeAxis;
    }

    public IRAxis getDomainAxis() {
        return this.domainAxis;
    }

    public void setDomainAxis(IRAxis domainAxis) {
        this.domainAxis = domainAxis;
    }

    @Override
    public IRChart clone() throws CloneNotSupportedException {
        IRChart newChart = null;
        try {
            newChart = (IRChart)super.clone();
            IRPlot newPlot = this.plot.clone();
            IRDataSet newIRDataSet = this.iRDataSet.clone();
            IRAxis newRangeAxis = this.rangeAxis.clone();
            IRAxis newDomainAxis = this.domainAxis.clone();
            newChart.setPlot(newPlot);
            newChart.setDomainAxis(newDomainAxis);
            newChart.setRangeAxis(newRangeAxis);
            newChart.setIRDataSet(newIRDataSet);
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)"clone fail", (Throwable)e);
            throw e;
        }
        return newChart;
    }

    public int getTopN() {
        return this.topN;
    }

    public void setTopN(int top) {
        this.topN = top;
    }

    public int getExportWidth() {
        return this.exportWidth;
    }

    public void setExportWidth(int exportWidth) {
        this.exportWidth = exportWidth;
    }

    public int getExportHeight() {
        return this.exportHeight;
    }

    public void setExportHeight(int exportHeight) {
        this.exportHeight = exportHeight;
    }

    public String getTimeLevel() {
        return this.timeLevel;
    }

    public void setTimeLevel(String timeLevel) {
        this.timeLevel = timeLevel;
    }

    public int getIntTimeLevel() {
        int intTimeLevel = 3;
        try {
            intTimeLevel = Integer.parseInt(this.timeLevel);
        }
        catch (Exception e) {
            intTimeLevel = -1;
        }
        switch (intTimeLevel) {
            case 3: {
                intTimeLevel = 2;
                break;
            }
            case 4: {
                intTimeLevel = 1;
                break;
            }
            case 2: {
                intTimeLevel = 3;
                break;
            }
            case 1: {
                intTimeLevel = 4;
                break;
            }
        }
        return intTimeLevel;
    }

    public String getTimeLevelShowStr() {
        String result = null;
        int intTimeLevel = this.getIntTimeLevel();
        switch (intTimeLevel) {
            case 2: {
                result = LocaleUtil.getProperty("text.time_day");
                break;
            }
            case 1: {
                result = LocaleUtil.getProperty("text.time_month");
                break;
            }
            case 4: {
                result = LocaleUtil.getProperty("text.time_min");
                break;
            }
            default: {
                result = LocaleUtil.getProperty("text.time_hour");
            }
        }
        return result;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean isShowDataDrill() {
        return this.showDataDrill;
    }

    public void setShowDataDrill(int dataSize) {
        this.showDataDrill = dataSize <= 5000;
    }

    public boolean isDomainAxisByParaDate() {
        return this.domainAxisByParaDate;
    }

    public void setDomainAxisByParaDate(boolean domainAxisByParaDate) {
        this.domainAxisByParaDate = domainAxisByParaDate;
    }

    public double getPointWidth() {
        return this.pointWidth;
    }

    public void setPointWidth(double pointWidth) {
        if (pointWidth > 0.0) {
            this.pointWidth = pointWidth;
        } else {
            LOG.error((Object)("pointWidth =" + pointWidth + " is invalid. reset pointWidth=" + this.pointWidth));
        }
    }

    public double getPointHeight() {
        return this.pointHeight;
    }

    public void setPointHeight(double pointHeight) {
        if (pointHeight > 0.0) {
            this.pointHeight = pointHeight;
        } else {
            LOG.error((Object)("pointHeight =" + pointHeight + " is invalid. reset pointHeight=" + this.pointHeight));
        }
    }

    public boolean isValueShowTop() {
        return this.valueShowTop;
    }

    public void setValueShowTop(boolean valueShowTop) {
        this.valueShowTop = valueShowTop;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public boolean isTableCell() {
        return this.tableCell;
    }

    public void setTableCell(boolean tableCell) {
        this.tableCell = tableCell;
    }

    public String toString() {
        return "IRChart [chartType=" + this.chartType + ", valueShowTop=" + this.valueShowTop + ", iRDataSet=" + this.iRDataSet + ", plot=" + this.plot + ", rangeAxis=" + this.rangeAxis + ", domainAxis=" + this.domainAxis + ", topN=" + this.topN + ", timeLevel=" + this.timeLevel + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", domainAxisByParaDate=" + this.domainAxisByParaDate + ", pointWidth=" + this.pointWidth + ", pointHeight=" + this.pointHeight + ", sortOrder=" + this.sortOrder + ", display=" + this.display + ", tableCell=" + this.tableCell + "]";
    }
}

