/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.definition;

import com.security.ireport.engine.definition.IRColumnCase;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.LocaleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IRColumn
implements Cloneable {
    private String header;
    private String field;
    private String width;
    private String sortable = "true";
    private String tooltips = "";
    private JasperWidth jasperWidth = new JasperWidth();
    private boolean userJavaScript = false;
    private String formatType = null;
    private String formatValue = null;
    private String urlField;
    private String dataDrillAction;
    private boolean columnExport = true;
    private List<IRColumnCase> columnCaseList = new ArrayList<IRColumnCase>();
    private List<IRColumn> subColumnList = new ArrayList<IRColumn>();
    private String textAlign = "Center";
    private String dataDrillTitle = LocaleUtil.getLocaleText("report.datadrill.title");
    private String totalExpression = null;
    private String chartRef;

    public IRColumn() {
    }

    public IRColumn(String formatType, String formatValue) {
        this.formatType = formatType;
        this.formatValue = formatValue;
    }

    public String getTextAlign() {
        if (!("Center".equals(this.textAlign) || "Left".equals(this.textAlign) || "Right".equals(this.textAlign))) {
            this.textAlign = "Center";
        }
        return this.textAlign;
    }

    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
    }

    public String getTextAlignStyle() {
        if (IReportConfCheckUtil.isStringEmpty(this.textAlign)) {
            return "style='text-align:center'";
        }
        return "style='text-align:" + this.textAlign + "'";
    }

    public String getUrlField() {
        return this.urlField;
    }

    public void setUrlField(String urlField) {
        this.urlField = urlField;
    }

    public String getFormatType() {
        return this.formatType;
    }

    public void setFormatType(String formatType) {
        this.formatType = formatType;
    }

    public String getFormatValue() {
        return this.formatValue;
    }

    public void setFormatValue(String formatValue) {
        this.formatValue = formatValue;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getDataDrillAction() {
        return this.dataDrillAction;
    }

    public void setDataDrillAction(String dataDrillAction) {
        this.dataDrillAction = dataDrillAction;
    }

    protected IRColumn clone() throws CloneNotSupportedException {
        IRColumn col = (IRColumn)super.clone();
        col.columnCaseList = new ArrayList<IRColumnCase>();
        for (IRColumnCase iRColumnCase : this.columnCaseList) {
            col.columnCaseList.add(iRColumnCase.clone());
        }
        col.subColumnList = new ArrayList<IRColumn>();
        if (this.subColumnList != null && !this.subColumnList.isEmpty()) {
            for (IRColumn iRColumn : this.subColumnList) {
                col.subColumnList.add(iRColumn.clone());
            }
        }
        return col;
    }

    public boolean isColumnExport() {
        return this.columnExport;
    }

    public void setColumnExport(boolean columnExport) {
        this.columnExport = columnExport;
    }

    public List<IRColumnCase> getColumnCaseList() {
        return this.columnCaseList;
    }

    public void setColumnCaseList(List<IRColumnCase> columnCaseList) {
        this.columnCaseList = columnCaseList;
    }

    public void addColumnCase(IRColumnCase columnCase) {
        this.columnCaseList.add(columnCase);
    }

    public String getSortable() {
        return this.sortable;
    }

    public void setSortable(String sortable) {
        this.sortable = sortable;
    }

    public String getTooltips() {
        return this.tooltips;
    }

    public void setTooltips(String tooltips) {
        this.tooltips = tooltips;
    }

    public List<IRColumn> getSubColumnList() {
        return this.subColumnList;
    }

    public void setSubColumnList(List<IRColumn> subColumnList) {
        this.subColumnList = subColumnList;
    }

    public void setSubColumn(IRColumn subColumn) {
        this.subColumnList.add(subColumn);
    }

    public String getDataDrillTitle() {
        return this.dataDrillTitle;
    }

    public void setDataDrillTitle(String dataDrillTitle) {
        this.dataDrillTitle = dataDrillTitle;
    }

    public boolean isUserJavaScript() {
        return this.userJavaScript;
    }

    public void setUserJavaScript(boolean userJavaScript) {
        this.userJavaScript = userJavaScript;
    }

    public String getTotalExpression() {
        return this.totalExpression;
    }

    public void setTotalExpression(String totalExpression) {
        this.totalExpression = totalExpression;
    }

    public int getJasperWidth(String caseValue) {
        return this.jasperWidth.jasperWidthMap.get(caseValue);
    }

    public void setJasperWidth(String caseValue, int jasperWidthNew) {
        this.jasperWidth.jasperWidthMap.put(caseValue, jasperWidthNew);
    }

    public boolean isJasperWidthEmpty() {
        return null != this.jasperWidth.jasperWidthMap && !this.jasperWidth.jasperWidthMap.isEmpty();
    }

    public String getChartRef() {
        return this.chartRef;
    }

    public void setChartRef(String chartRef) {
        this.chartRef = chartRef;
    }

    public static class JasperWidth {
        Map<String, Integer> jasperWidthMap = new HashMap<String, Integer>();
    }
}

