/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.definition;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.definition.IRChartDataItem;
import java.util.ArrayList;
import java.util.List;

public class IRDataSet
implements Cloneable {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private String datasource;
    private String group;
    private boolean autoExpand = true;
    private List<IRChartDataItem> dataItemList = new ArrayList<IRChartDataItem>();
    private String fillByTimeCycle = null;
    private long fillValue = -1L;
    private int keyMaxLength;

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isAutoExpand() {
        return this.autoExpand;
    }

    public void setAutoExpand(boolean autoExpand) {
        this.autoExpand = autoExpand;
    }

    public void addDataItem(IRChartDataItem item) {
        this.dataItemList.add(item);
    }

    public List<IRChartDataItem> getDataItemList() {
        return this.dataItemList;
    }

    public void setDataItemList(List<IRChartDataItem> dataItemList) {
        this.dataItemList = dataItemList;
    }

    protected IRDataSet clone() throws CloneNotSupportedException {
        IRDataSet newObj = (IRDataSet)super.clone();
        newObj.dataItemList = new ArrayList<IRChartDataItem>();
        if (this.dataItemList != null && !this.dataItemList.isEmpty()) {
            for (IRChartDataItem item : this.dataItemList) {
                newObj.dataItemList.add(item.clone());
            }
        }
        return newObj;
    }

    public String getFillByTimeCycle() {
        return this.fillByTimeCycle;
    }

    public long getFillByTimeCycleLong() {
        try {
            if (null != this.fillByTimeCycle) {
                return Long.parseLong(this.fillByTimeCycle);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        return 0L;
    }

    public void setFillByTimeCycle(String fillByTimeCycle) {
        this.fillByTimeCycle = fillByTimeCycle;
    }

    public long getFillValue() {
        return this.fillValue;
    }

    public void setFillValue(long fillValue) {
        this.fillValue = fillValue;
    }

    public int getKeyMaxLength() {
        return this.keyMaxLength;
    }

    public void setKeyMaxLength(int keyMaxLength) {
        this.keyMaxLength = keyMaxLength;
    }
}

