/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.definition;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.engine.dataset.FieldList;
import com.security.ireport.engine.dataset.ParaList;
import com.security.ireport.engine.dataset.Parameter;
import com.security.ireport.engine.definition.SqlSectionList;
import com.security.ireport.util.IOrder;
import com.security.ireport.util.IReportConfCheckUtil;
import java.util.List;

public class IRDataSource
implements Cloneable {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private String id;
    private String type;
    private int loadOrder = 0;
    private String className;
    private String pojo;
    private String sql;
    private String procedure;
    private boolean cache = false;
    private FieldList fieldList = new FieldList();
    private ParaList paraList = new ParaList();
    private String database;
    private String filePath;
    private String path;
    private String fileSeparator = ",";
    private String encoding = "GBK";
    private boolean ignoreFirst = true;
    private SqlSectionList sqlSectionList = null;
    private boolean useSqlInterface = false;

    public void addSqlSectionList(SqlSectionList sqlSectionListNew) {
        this.sqlSectionList = sqlSectionListNew;
    }

    public void addFieldList(FieldList fieldListNew) {
        this.fieldList = fieldListNew;
    }

    public void addParaList(ParaList paraListNew) {
        this.paraList = paraListNew;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPojo() {
        return this.pojo;
    }

    public void setPojo(String pojo) {
        this.pojo = pojo;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSql() {
        return this.sql;
    }

    public String getAllSql() {
        StringBuffer tempSql = new StringBuffer(this.sql);
        if (this.sqlSectionList != null) {
            for (String item : this.sqlSectionList.getSqlSectionList()) {
                tempSql.append(' ').append(item);
            }
        }
        return tempSql.toString();
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public void setFileSeparator(String fileSeparator) {
        if (!IReportConfCheckUtil.isStringEmpty(fileSeparator)) {
            this.fileSeparator = fileSeparator;
        } else {
            LOGGER.info((Object)"fileSeparator is empty, use default value ','.");
        }
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public FieldList getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(FieldList fieldList) {
        this.fieldList = fieldList;
    }

    public ParaList getParaList() {
        return this.paraList;
    }

    public void setParaList(ParaList paraList) {
        this.paraList = paraList;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (!IReportConfCheckUtil.isStringEmpty(encoding)) {
            this.encoding = encoding;
        } else {
            LOGGER.info((Object)"encoding is empty, use default value 'GBK'.");
        }
    }

    public boolean isIgnoreFirst() {
        return this.ignoreFirst;
    }

    public void setIgnoreFirst(boolean ignoreFirst) {
        this.ignoreFirst = ignoreFirst;
    }

    public IRDataSource clone() throws CloneNotSupportedException {
        IRDataSource obj = null;
        try {
            List<IOrder> infoList;
            obj = (IRDataSource)super.clone();
            if (this.fieldList != null) {
                obj.fieldList = new FieldList();
                infoList = this.fieldList.getFieldList();
                for (IOrder item : infoList) {
                    obj.fieldList.addField((FieldInfo)item);
                }
            }
            if (this.paraList != null) {
                obj.paraList = new ParaList();
                infoList = this.paraList.getParaList();
                for (IOrder item : infoList) {
                    obj.paraList.addParameter(((Parameter)item).clone());
                }
            }
            if (this.sqlSectionList != null) {
                obj.sqlSectionList = this.sqlSectionList.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error((Object)e);
            throw e;
        }
        return obj;
    }

    public int getLoadOrder() {
        return this.loadOrder;
    }

    public void setLoadOrder(int loadOrder) {
        this.loadOrder = loadOrder;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }

    public SqlSectionList getSqlSectionList() {
        return this.sqlSectionList;
    }

    public void setSqlSectionList(SqlSectionList sqlSectionList) {
        this.sqlSectionList = sqlSectionList;
    }

    public boolean isUseSqlInterface() {
        return this.useSqlInterface;
    }

    public void setUseSqlInterface(boolean useSqlInterface) {
        this.useSqlInterface = useSqlInterface;
    }
}

