/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.definition;

import com.security.ireport.engine.definition.ComponentElement;
import com.security.ireport.engine.definition.HeaderRow;
import com.security.ireport.engine.definition.IRColumn;
import com.security.ireport.util.IReportConfCheckUtil;
import java.util.ArrayList;
import java.util.List;

public class IRTable
extends ComponentElement {
    private String dataSource;
    private boolean pageShow;
    private String pageSize;
    private List<IRColumn> iRColumnList = new ArrayList<IRColumn>();
    private boolean flexTable = false;
    private boolean csvExport = false;
    private String tableHeader = "";
    private String tableFooter = "";
    private boolean topPageBarShow = false;
    private boolean totalBarShow = false;
    private boolean serialNumShow = true;
    private String groupField = null;
    private boolean totalBarDown = true;
    private List<HeaderRow> headerRowList = new ArrayList<HeaderRow>();
    private String useJasper = "";
    private int groupNum;

    public String getUseJasper() {
        return this.useJasper;
    }

    public void setUseJasper(String useJasper) {
        this.useJasper = useJasper;
    }

    public void addHeaderRow(HeaderRow row) {
        this.headerRowList.add(row);
    }

    public void addIRColumn(IRColumn iRColumn) {
        if ("-1".equals(iRColumn.getHeader())) {
            IRColumn column = this.iRColumnList.get(this.iRColumnList.size() - 1);
            column.setSubColumn(iRColumn);
        } else {
            this.iRColumnList.add(iRColumn);
        }
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isPageShow() {
        return this.pageShow;
    }

    public void setPageShow(boolean pageShow) {
        this.pageShow = pageShow;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public List<IRColumn> getIRColumnList() {
        return this.iRColumnList;
    }

    public void setIRColumnList(List<IRColumn> iRColumnListT) {
        this.iRColumnList = iRColumnListT;
    }

    @Override
    protected IRTable clone() throws CloneNotSupportedException {
        IRTable clone = (IRTable)super.clone();
        ArrayList<IRColumn> iRColumnClone = new ArrayList<IRColumn>();
        for (IRColumn iRColumn : this.iRColumnList) {
            iRColumnClone.add(iRColumn.clone());
        }
        clone.setIRColumnList(iRColumnClone);
        clone.headerRowList = new ArrayList<HeaderRow>();
        for (HeaderRow row : this.headerRowList) {
            clone.headerRowList.add(row.clone());
        }
        return clone;
    }

    public boolean isFlexTable() {
        return this.flexTable;
    }

    public void setFlexTable(boolean flexTable) {
        this.flexTable = flexTable;
    }

    public boolean isCsvExport() {
        return this.csvExport;
    }

    public void setCsvExport(boolean csvExport) {
        this.csvExport = csvExport;
    }

    public String getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(String tableHeader) {
        this.tableHeader = tableHeader;
    }

    public String getTableFooter() {
        return this.tableFooter;
    }

    public void setTableFooter(String tableFooter) {
        this.tableFooter = tableFooter;
    }

    public boolean isTopPageBarShow() {
        if (this.pageShow) {
            return this.topPageBarShow;
        }
        return false;
    }

    public void setTopPageBarShow(boolean topPageBarShow) {
        this.topPageBarShow = topPageBarShow;
    }

    public boolean isTotalBarShow() {
        return this.totalBarShow;
    }

    public void setTotalBarShow(boolean totalBarShow) {
        this.totalBarShow = totalBarShow;
    }

    public boolean isSerialNumShow() {
        return this.serialNumShow;
    }

    public void setSerialNumShow(boolean serialNumShow) {
        this.serialNumShow = serialNumShow;
    }

    public String getGroupField() {
        return this.groupField;
    }

    public boolean isGroupTable() {
        return this.groupField != null && !IReportConfCheckUtil.isStringEmpty(this.groupField);
    }

    public IRColumn getGroupColumn() {
        IRColumn result = null;
        if (!this.iRColumnList.isEmpty()) {
            for (IRColumn item : this.iRColumnList) {
                if (!item.getField().equals(this.groupField)) continue;
                result = item;
                break;
            }
        }
        return result;
    }

    public void setGroupField(String groupField) {
        this.groupField = groupField;
    }

    public boolean isTotalBarDown() {
        return this.totalBarDown;
    }

    public void setTotalBarDown(boolean totalBarDown) {
        this.totalBarDown = totalBarDown;
    }

    public int getExportColumnWidthSun() {
        int columnWidthSum = 0;
        for (IRColumn iRColumn : this.getIRColumnList()) {
            if (!iRColumn.isColumnExport()) continue;
            columnWidthSum += Integer.parseInt(iRColumn.getWidth());
        }
        return columnWidthSum;
    }

    public List<HeaderRow> getHeaderRowList() {
        return this.headerRowList;
    }

    public void setHeaderRowList(List<HeaderRow> headerRowList) {
        this.headerRowList = headerRowList;
    }

    public int getGroupNum() {
        return this.groupNum;
    }

    public void setGroupNum(int groupNum) {
        this.groupNum = groupNum;
    }
}

