/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.definition;

import com.security.ireport.engine.PluginManager;
import com.security.ireport.engine.definition.ComponentElement;
import com.security.ireport.engine.definition.IPageFooter;
import com.security.ireport.engine.definition.IPageHeader;
import com.security.ireport.engine.definition.IRChart;
import com.security.ireport.engine.definition.IRColumn;
import com.security.ireport.engine.definition.IRCover;
import com.security.ireport.engine.definition.IRDataSource;
import com.security.ireport.engine.definition.IRDefine;
import com.security.ireport.engine.definition.IRFirstPage;
import com.security.ireport.engine.definition.IRSwitchOption;
import com.security.ireport.engine.definition.IRTable;
import com.security.ireport.engine.definition.IRTextField;
import com.security.ireport.engine.exception.ParaException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class IReport
implements Cloneable {
    public static final int PAGE_WIDTH = 534;
    private String id = "";
    private String name = "";
    private String queryFileName = "";
    private String publishTime = "";
    private boolean showMenu = false;
    private String version = "";
    private String isCorrectVersion = "";
    private IRSwitchOption iRSwitchOption;
    private IRDefine iRDefine;
    private List<IRDefine> iRDefineList = new ArrayList<IRDefine>();
    private List<IRTextField> textFieldList = new ArrayList<IRTextField>();
    private List<IRChart> iRChartList = new ArrayList<IRChart>();
    private List<IRTable> iRTableList = new ArrayList<IRTable>();
    private Map<String, IRChart> tableCellIRChartMap = new HashMap<String, IRChart>();
    private Map<String, IRDataSource> iRDataSourceMap = new HashMap<String, IRDataSource>();
    private List<ComponentElement> elementList = new ArrayList<ComponentElement>();
    private int num = 0;
    private String treeNodeKey = "";
    private boolean flexTable = false;
    private String export = "excel,csv,html,pdf,rtf";
    private String refresh = "false";
    private boolean useProductDefine = false;
    private List<String> exportList = IReport.getAllExportTypeList();
    private IPageHeader pageHeader = new IPageHeader();
    private IPageFooter pageFooter = new IPageFooter();
    private IRFirstPage firstPage = new IRFirstPage();
    private IRCover cover = new IRCover();
    private boolean buildJasper = true;

    public IRFirstPage getFirstPage() {
        return this.firstPage;
    }

    public void addFirstPage(IRFirstPage firstPageNew) {
        this.firstPage = firstPageNew;
    }

    public void addCover(IRCover coverNew) {
        this.cover = coverNew;
    }

    public String getExport() {
        return this.export;
    }

    public static List<String> getAllExportTypeList() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("pdf");
        result.add("rtf");
        result.add("excel");
        result.add("html");
        result.add("csv");
        return result;
    }

    public void setExport(String export) {
        this.export = export;
        String[] exportStr = export.split(",");
        this.exportList.clear();
        for (String fileFormat : exportStr) {
            this.exportList.add(fileFormat.trim().toLowerCase(Locale.US));
        }
    }

    public List<String> getExportList() {
        return this.exportList;
    }

    public void setExportList(List<String> exportList) {
        this.exportList = exportList;
    }

    public void addIRDefine(IRDefine iRDefineNew) {
        this.iRDefineList.add(iRDefineNew);
    }

    public void addIRChart(IRChart iRChart) {
        if (iRChart.isTableCell()) {
            this.tableCellIRChartMap.put(iRChart.getId(), iRChart);
        } else {
            iRChart.setNum(this.num);
            this.iRChartList.add(iRChart);
            this.elementList.add(iRChart);
            ++this.num;
        }
    }

    public void addIRTable(IRTable iRTable) {
        for (IRColumn iRColumn : iRTable.getIRColumnList()) {
            if (null != iRColumn.getWidth() && !"".equals(iRColumn.getWidth())) continue;
            for (IRColumn iRColumnDefault : iRTable.getIRColumnList()) {
                iRColumnDefault.setWidth(String.valueOf(534 / iRTable.getIRColumnList().size()));
            }
        }
        iRTable.setNum(this.num);
        this.iRTableList.add(iRTable);
        this.elementList.add(iRTable);
        ++this.num;
        if (iRTable.isFlexTable()) {
            this.flexTable = true;
        }
    }

    public void addIRDataSource(IRDataSource iRDataSource) throws ParaException {
        if (this.iRDataSourceMap.containsKey(iRDataSource.getId())) {
            throw new ParaException("datasource id=" + iRDataSource.getId() + " is repeat in report.xml");
        }
        this.iRDataSourceMap.put(iRDataSource.getId(), iRDataSource);
    }

    public void addIRSwitchOption(IRSwitchOption iRSwitchOptionNew) {
        this.iRSwitchOption = iRSwitchOptionNew;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<IRChart> getIRChartList() {
        return this.iRChartList;
    }

    public void setIRChartList(List<IRChart> chartList) {
        this.iRChartList = chartList;
    }

    public List<IRTable> getIRTableList() {
        return this.iRTableList;
    }

    public void setIRTableList(List<IRTable> tableList) {
        this.iRTableList = tableList;
    }

    public Map<String, IRDataSource> getIRDataSourceMap() {
        return this.iRDataSourceMap;
    }

    public void setIRDataSourceMap(Map<String, IRDataSource> dataSourceMap) {
        this.iRDataSourceMap = dataSourceMap;
    }

    public String getQueryFileName() {
        return this.queryFileName;
    }

    public void setQueryFileName(String queryFileName) {
        this.queryFileName = queryFileName;
    }

    public String getPublishTime() {
        return this.publishTime;
    }

    public void setPublishTime(String publishTime) {
        this.publishTime = publishTime;
    }

    public List<ComponentElement> getElementList(String caseValue) {
        if (null == caseValue || "".equals(caseValue)) {
            return this.elementList;
        }
        ArrayList<ComponentElement> elementListReturn = new ArrayList<ComponentElement>();
        for (ComponentElement elementTemp : this.elementList) {
            if (!elementTemp.getCaseValueList().contains(caseValue)) continue;
            elementListReturn.add(elementTemp);
        }
        return elementListReturn;
    }

    public List<IRChart> getIRChartList(String caseValue) {
        if (null == caseValue || "".equals(caseValue)) {
            return this.iRChartList;
        }
        ArrayList<IRChart> iRChartListReturn = new ArrayList<IRChart>();
        for (IRChart iRChartTemp : this.iRChartList) {
            if (!iRChartTemp.getCaseValueList().contains(caseValue)) continue;
            iRChartListReturn.add(iRChartTemp);
        }
        return iRChartListReturn;
    }

    public List<IRTable> getIRTableList(String caseValue) {
        if (null == caseValue || "".equals(caseValue)) {
            return this.iRTableList;
        }
        ArrayList<IRTable> iRTableListReturn = new ArrayList<IRTable>();
        for (IRTable iRTableTemp : this.iRTableList) {
            if (!iRTableTemp.getCaseValueList().contains(caseValue)) continue;
            iRTableListReturn.add(iRTableTemp);
        }
        return iRTableListReturn;
    }

    public List<ComponentElement> getElementList() {
        return this.elementList;
    }

    public IRSwitchOption getIRSwitchOption() {
        return this.iRSwitchOption;
    }

    public List<IRDefine> getIRDefineList() {
        return this.iRDefineList;
    }

    public void setIRDefineList(List<IRDefine> defineList) {
        this.iRDefineList = defineList;
    }

    public IRDefine getIRDefine(String caseValue) {
        if (null == caseValue || "".equals(caseValue)) {
            return this.iRDefineList.get(0);
        }
        IRDefine define = new IRDefine();
        for (IRDefine iRDefineTemp : this.iRDefineList) {
            if (!iRDefineTemp.getCaseValueList().contains(caseValue)) continue;
            define = iRDefineTemp;
            break;
        }
        return define;
    }

    public IRDefine getIRDefine() {
        return this.iRDefine;
    }

    public void setIRDefine(IRDefine define) {
        for (IRChart iRChart : this.iRChartList) {
            int width = iRChart.getWidth() * iRChart.getColspan() / define.getColumnNumber();
            iRChart.setWidth(width);
            int exportWidth = iRChart.getExportWidth() * iRChart.getColspan() / define.getColumnNumber();
            iRChart.setExportWidth(exportWidth);
        }
        for (ComponentElement element : this.elementList) {
            if (!(element instanceof IRChart)) continue;
            IRChart iRChart = (IRChart)element;
            int width = iRChart.getWidth() * iRChart.getColspan() / define.getColumnNumber();
            iRChart.setWidth(width);
            int exportWidth = iRChart.getExportWidth() * iRChart.getColspan() / define.getColumnNumber();
            iRChart.setExportWidth(exportWidth);
        }
        this.iRDefine = define;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String nameStr) {
        this.name = nameStr != null ? nameStr.trim() : "";
    }

    public void setElementList(List<ComponentElement> elementList) {
        this.elementList = elementList;
    }

    public IReport clone() throws CloneNotSupportedException {
        IReport cloneObj = (IReport)super.clone();
        ArrayList<IRDefine> iRDefineClone = new ArrayList<IRDefine>();
        for (IRDefine iRDefine : this.iRDefineList) {
            iRDefineClone.add(iRDefine.clone());
        }
        cloneObj.setIRDefineList(iRDefineClone);
        cloneObj.addPageFooter(this.pageFooter.clone());
        cloneObj.addPageHeader(this.pageHeader.clone());
        cloneObj.addFirstPage(this.firstPage.clone());
        cloneObj.addCover(this.cover.clone());
        ArrayList<IRChart> iRChartClone = new ArrayList<IRChart>();
        for (IRChart iRChart : this.iRChartList) {
            iRChartClone.add(iRChart.clone());
        }
        cloneObj.setIRChartList(iRChartClone);
        ArrayList<IRTable> arrayList = new ArrayList<IRTable>();
        for (IRTable iRTable : this.iRTableList) {
            arrayList.add(iRTable.clone());
        }
        cloneObj.setIRTableList(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : this.exportList) {
            arrayList2.add(string);
        }
        cloneObj.setExportList(arrayList2);
        ArrayList<ComponentElement> arrayList3 = new ArrayList<ComponentElement>();
        for (ComponentElement componentElement : this.elementList) {
            if (componentElement instanceof IRTable) {
                arrayList3.add(((IRTable)componentElement).clone());
                continue;
            }
            if (componentElement instanceof IRChart) {
                arrayList3.add(((IRChart)componentElement).clone());
                continue;
            }
            if (!(componentElement instanceof IRTextField)) continue;
            arrayList3.add(((IRTextField)componentElement).clone());
        }
        cloneObj.setElementList(arrayList3);
        HashMap<String, IRChart> hashMap = new HashMap<String, IRChart>();
        for (IRChart tempIRChart : this.tableCellIRChartMap.values()) {
            hashMap.put(tempIRChart.getId(), tempIRChart.clone());
        }
        cloneObj.tableCellIRChartMap = hashMap;
        cloneObj.iRDataSourceMap = new HashMap<String, IRDataSource>();
        for (Map.Entry<String, IRDataSource> item : this.iRDataSourceMap.entrySet()) {
            cloneObj.getIRDataSourceMap().put(item.getKey(), item.getValue().clone());
        }
        ArrayList<IRTextField> arrayList4 = new ArrayList<IRTextField>();
        for (IRTextField item : this.textFieldList) {
            arrayList4.add(item.clone());
        }
        cloneObj.setTextFieldList(arrayList4);
        return cloneObj;
    }

    public int getPageWidth() {
        return 534;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getIsCorrectVersion() {
        if (this.isCorrectVersion.isEmpty()) {
            this.isCorrectVersion = this.version == null || this.version.isEmpty() ? "2" : (this.version.equalsIgnoreCase(PluginManager.getProductVersion()) ? "1" : "0");
        }
        return this.isCorrectVersion;
    }

    public boolean isShowMenu() {
        return this.showMenu;
    }

    public void setShowMenu(boolean showMenu) {
        this.showMenu = showMenu;
    }

    public String getTreeNodeKey() {
        return this.treeNodeKey;
    }

    public void setTreeNodeKey(String treeNodeKey) {
        this.treeNodeKey = treeNodeKey;
    }

    public IRDefine getDefineByCase(String caseValue) {
        for (IRDefine iRDefineNew : this.iRDefineList) {
            if (!iRDefineNew.getCaseValueList().contains(caseValue)) continue;
            return iRDefineNew;
        }
        return null;
    }

    public List<ComponentElement> getComponentListByCase(String caseValue) {
        ArrayList<ComponentElement> elementListNew = new ArrayList<ComponentElement>();
        int numNew = 0;
        for (ComponentElement element : this.getElementList()) {
            if (!element.getCaseValueList().contains(caseValue) || !element.isShow()) continue;
            element.setNum(numNew);
            elementListNew.add(element);
            ++numNew;
        }
        return elementListNew;
    }

    public boolean isFlexTable() {
        return this.flexTable;
    }

    public void setFlexTable(boolean flexTable) {
        this.flexTable = flexTable;
    }

    public String getRefresh() {
        return this.refresh;
    }

    public void setRefresh(String refresh) {
        this.refresh = refresh;
    }

    public IPageHeader getPageHeader() {
        return this.pageHeader;
    }

    public void addPageHeader(IPageHeader pageHeaderNew) {
        this.pageHeader = pageHeaderNew;
    }

    public IPageFooter getPageFooter() {
        return this.pageFooter;
    }

    public void addPageFooter(IPageFooter pageFooterNew) {
        this.pageFooter = pageFooterNew;
    }

    public List<IRTextField> getTextFieldList() {
        return this.textFieldList;
    }

    public void setTextFieldList(List<IRTextField> textFieldList) {
        this.textFieldList = textFieldList;
    }

    public void addTextField(IRTextField textField) {
        textField.setNum(this.num);
        this.textFieldList.add(textField);
        this.elementList.add(textField);
        ++this.num;
    }

    public List<IRTextField> getTextFieldList(String caseValue) {
        if (null == caseValue || "".equals(caseValue)) {
            return this.textFieldList;
        }
        ArrayList<IRTextField> listReturn = new ArrayList<IRTextField>();
        for (IRTextField item : this.textFieldList) {
            if (!item.getCaseValueList().contains(caseValue)) continue;
            listReturn.add(item);
        }
        return listReturn;
    }

    public boolean isBuildJasper() {
        return this.buildJasper;
    }

    public void setBuildJasper(boolean buildJasper) {
        this.buildJasper = buildJasper;
    }

    public IRCover getCover() {
        return this.cover;
    }

    public void setCover(IRCover cover) {
        this.cover = cover;
    }

    public Map<String, IRChart> getTableCellIRChartMap() {
        return this.tableCellIRChartMap;
    }

    public boolean isUseProductDefine() {
        return this.useProductDefine;
    }

    public void setUseProductDefine(boolean useProductDefine) {
        this.useProductDefine = useProductDefine;
    }
}

