/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.output;

import com.security.ireport.model.vo.LegendColor;
import com.security.ireport.util.ArrayDeepClone;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ReportEngineOutput
implements Serializable {
    public static final String CONTENT_TYPE_PDF = "application/pdf";
    public static final String CONTENT_TYPE_XLS = "application/vnd.ms-excel";
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_CSV = "text/comma-separated-values";
    public static final String CONTENT_TYPE_RTF = "application/rtf";
    public static final String CONTENT_TYPE_TEXT = "text/plain";
    public static final String CONTENT_TYPE_XML = "application/xml";
    public static final String CONTENT_TYPE_JPEG = "image/jpeg";
    public static final String CONTENT_TYPE_PNG = "image/png";
    private static final long serialVersionUID = -1891016289500829002L;
    private String contentType;
    private String contentMessage;
    private String elementId;
    private List<byte[]> content = new ArrayList<byte[]>();
    private List<byte[]> exportContent = new ArrayList<byte[]>();
    private byte[] exportSmallHeightContent;
    private byte[] exportSmallExcelHeightContent;
    private transient List<List<LegendColor>> legendColorList = new ArrayList<List<LegendColor>>();

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getELementId() {
        return this.elementId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public String getContentMessage() {
        return this.contentMessage;
    }

    public void setContentMessage(String contentMessage) {
        this.contentMessage = contentMessage;
    }

    public String getContentExtension() {
        if (null == this.contentType) {
            return "";
        }
        if (this.contentType.equals(CONTENT_TYPE_PDF)) {
            return ".pdf";
        }
        if (this.contentType.equals(CONTENT_TYPE_XLS)) {
            return ".xls";
        }
        if (this.contentType.equals(CONTENT_TYPE_HTML)) {
            return ".html";
        }
        if (this.contentType.equals(CONTENT_TYPE_CSV)) {
            return ".csv";
        }
        if (this.contentType.equals(CONTENT_TYPE_RTF)) {
            return ".rtf";
        }
        if (this.contentType.equals(CONTENT_TYPE_TEXT)) {
            return ".txt";
        }
        if (this.contentType.equals(CONTENT_TYPE_XML)) {
            return ".xml";
        }
        if (this.contentType.equals(CONTENT_TYPE_JPEG)) {
            return ".jpg";
        }
        if (this.contentType.equals(CONTENT_TYPE_PNG)) {
            return ".png";
        }
        return "";
    }

    public List<byte[]> getContent() {
        return this.content;
    }

    public void setContent(List<byte[]> content) {
        this.content = content;
    }

    public List<byte[]> getExportContent() {
        return this.exportContent;
    }

    public void setExportContent(List<byte[]> exportContent) {
        this.exportContent = exportContent;
    }

    public List<List<LegendColor>> getLegendColorList() {
        return this.legendColorList;
    }

    public void setLegendColorList(List<List<LegendColor>> legendColorList) {
        this.legendColorList = legendColorList;
    }

    public byte[] getExportSmallHeightContent() {
        return (byte[])ArrayDeepClone.deepClone(this.exportSmallHeightContent);
    }

    public void setExportSmallHeightContent(byte[] exportSmallHeightContent) {
        this.exportSmallHeightContent = (byte[])ArrayDeepClone.deepClone(exportSmallHeightContent);
    }

    public byte[] getExportSmallExcelHeightContent() {
        return (byte[])ArrayDeepClone.deepClone(this.exportSmallExcelHeightContent);
    }

    public void setExportSmallExcelHeightContent(byte[] exportSmallExcelHeightContent) {
        this.exportSmallExcelHeightContent = (byte[])ArrayDeepClone.deepClone(exportSmallExcelHeightContent);
    }
}

