/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.output;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.ProviderException;
import com.security.ireport.engine.ReportSession;
import com.security.ireport.engine.ReportSessionManager;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.engine.dataset.IFlexTableData;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.engine.definition.ComponentElement;
import com.security.ireport.engine.definition.HeaderColumn;
import com.security.ireport.engine.definition.HeaderRow;
import com.security.ireport.engine.definition.IRChart;
import com.security.ireport.engine.definition.IRColumn;
import com.security.ireport.engine.definition.IRTable;
import com.security.ireport.engine.definition.IRTextField;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.engine.definition.ImageDS;
import com.security.ireport.engine.definition.JasperDefinitionParser;
import com.security.ireport.engine.output.UnifiedTableModel;
import com.security.ireport.model.vo.DisplayCondObj;
import com.security.ireport.util.CalculateNodeUtil;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.JSONUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.RegexUtil;
import com.security.ireport.util.chart.LegendUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.engine.util.JRLoader;

public abstract class SigExportOutput {
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static int maxExportCount = 2000;

    public static JasperPrint createJasperPrint(long reportSessionId, String httpSessionId, Boolean isIgnorePagination) throws ProviderException {
        ReportSession reportSession = ReportSessionManager.getInstance().getSessionBySessionId(reportSessionId, httpSessionId);
        JasperReport jasperReport = SigExportOutput.getJasperReportObject(reportSession);
        if (null == jasperReport) {
            return null;
        }
        JasperPrint jasperPrint = SigExportOutput.fillJasperReport(reportSession, jasperReport, isIgnorePagination);
        return jasperPrint;
    }

    public static JasperReport[] getJasperReportObjectArray(ReportSession reportSession) {
        JasperReport[] resultJasperReports = new JasperReport[1];
        JasperReport jasperReport = null;
        IReport report = reportSession.getIReport();
        String caseValue = "";
        if (!IReportConfCheckUtil.isStringEmpty(reportSession.getSwitchOption())) {
            caseValue = reportSession.getSwitchOption();
        }
        String jasperFileName = JasperDefinitionParser.createJasperFilePath(caseValue, report, "jasper");
        try {
            File jpFile;
            if (!new File(jasperFileName).exists()) {
                reportSession.prepareJasper();
            }
            if (!(jpFile = new File(jasperFileName)).exists()) {
                LOG.error((Object)("File:" + jpFile.getName() + " is NOT exist,may be switchCase item in parameter.xml and report.xml NOT consistent, pls check!"));
                return new JasperReport[0];
            }
            resultJasperReports[0] = jasperReport = (JasperReport)JRLoader.loadObject((String)jasperFileName);
            JasperReport[] temJasperReports = null;
            File jasperFile = null;
            int jasperFileIndex = 1;
            while ((jasperFile = new File(jasperFileName = JasperDefinitionParser.createJasperReportFileName(caseValue, report, "jasper", jasperFileIndex))).exists()) {
                jasperReport = (JasperReport)JRLoader.loadObject((File)jasperFile);
                temJasperReports = new JasperReport[resultJasperReports.length + 1];
                System.arraycopy(resultJasperReports, 0, temJasperReports, 0, resultJasperReports.length);
                temJasperReports[resultJasperReports.length] = jasperReport;
                resultJasperReports = temJasperReports;
                ++jasperFileIndex;
            }
        }
        catch (JRException e) {
            LOG.error((Object)"load Jasper failed.", (Throwable)e);
        }
        return resultJasperReports;
    }

    public static JasperReport getJasperReportObject(ReportSession reportSession) {
        JasperReport jasperReport = null;
        IReport report = reportSession.getIReport();
        String caseValue = "";
        if (!IReportConfCheckUtil.isStringEmpty(reportSession.getSwitchOption())) {
            caseValue = reportSession.getSwitchOption();
        }
        String jasperFile = JasperDefinitionParser.createJasperFilePath(caseValue, report, "jasper");
        try {
            File jpFile;
            if (!new File(jasperFile).exists()) {
                reportSession.prepareJasper();
            }
            if (!(jpFile = new File(jasperFile)).exists()) {
                LOG.error((Object)("File:" + jpFile.getName() + " is NOT exist,may be switchCase item in parameter.xml and report.xml NOT consistent, pls check!"));
                return null;
            }
            jasperReport = (JasperReport)JRLoader.loadObject((String)jasperFile);
        }
        catch (JRException e) {
            LOG.error((Object)"load Jasper failed.", (Throwable)e);
        }
        return jasperReport;
    }

    public static JasperPrint fillJasperReport(ReportSession reportSession, JasperReport jasperReport, Boolean isIgnorePagination) throws ProviderException {
        return SigExportOutput.fillJasperReport(reportSession, jasperReport, isIgnorePagination, "pdf");
    }

    public static Map<String, Object> prepareJasperData(ReportSession reportSession, Boolean isIgnorePagination, String exportType, int prevTotalPageSize) throws ProviderException {
        Map<String, Object> paraMap = SigExportOutput.prepareJasperData(reportSession, isIgnorePagination, exportType);
        paraMap.put("prevTotalPageSize", prevTotalPageSize);
        String pageFormatBegin = LocaleUtil.getProperty("pageFormatBegin", reportSession.getLocale());
        String pageFormatEnd = LocaleUtil.getProperty("pageFormatEnd", reportSession.getLocale());
        paraMap.put("IREPORT_SECURITY_DEFAULT_VALUE", "  ");
        paraMap.put("pageFormatBegin", pageFormatBegin);
        paraMap.put("pageFormatEnd", pageFormatEnd);
        return paraMap;
    }

    private static Map<String, Object> prepareJasperData(ReportSession reportSession, Boolean isIgnorePagination, String exportType) throws ProviderException {
        Map<String, Object> paraMap = SigExportOutput.prepareJasperData(reportSession, exportType);
        paraMap.put("IS_IGNORE_PAGINATION", isIgnorePagination);
        return paraMap;
    }

    private static Map<String, Object> prepareJasperData(ReportSession reportSession, String exportType) throws ProviderException {
        IReport report = reportSession.getIReport();
        Map<String, Object> paraMap = SigExportOutput.createReportParmsMap(report, reportSession);
        paraMap.put("templatePath", IReportUtil.getJasperTemplatePath());
        paraMap.put("exportShowCondition", report.getIRDefine().isExportShowCondition());
        paraMap.put("showPageFooter", report.getPageFooter().isShowPageFooter());
        paraMap.put("showPageHeader", report.getPageHeader().isShowPageHeader());
        paraMap.put("imageName", IReportUtil.getJasperTemplatePath() + report.getPageHeader().getImageName());
        paraMap.put("pageHeaderTitle", report.getPageHeader().getPageHeaderTitle());
        paraMap.put("reportMainTitle", report.getIRDefine().getMainTitle());
        List<DisplayCondObj> displayCondList = JSONUtil.toDisplayCond(JSONUtil.mapToJson(reportSession.getParameterMap()), reportSession.getLocale());
        if (!displayCondList.isEmpty()) {
            paraMap.put("condDataset", new JRBeanCollectionDataSource(displayCondList));
        }
        ArrayList<DisplayCondObj> report1List = new ArrayList<DisplayCondObj>();
        report1List.add(new DisplayCondObj("1", "1"));
        paraMap.put("report1Dataset", new JRBeanCollectionDataSource(report1List));
        RegexUtil.MatchObject matchObject = null;
        if ("html".equals(exportType) && !report.isUseProductDefine()) {
            matchObject = RegexUtil.getHtmlMatchObject();
        }
        Map<String, String[]> imageMap = reportSession.getAllExportChartsImgPath(exportType);
        for (IRChart iRChart : report.getIRChartList(reportSession.getSwitchOption())) {
            String[] images;
            boolean isFourCol = iRChart.getColspan().intValue() == report.getIRDefine(reportSession.getSwitchOption()).getColumnNumber().intValue();
            ArrayList<ImageDS> imageDSList = new ArrayList<ImageDS>();
            if (!imageMap.containsKey(iRChart.getId()) || null == (images = imageMap.get(iRChart.getId())) || images.length == 0 || null == reportSession.getImgLegendMap(iRChart.getId())) continue;
            for (int i = 0; i < images.length; ++i) {
                ImageDS imageDs = new ImageDS(String.valueOf(i), IReportUtil.getRealPath() + images[i]);
                List<Object[]> legendData = null;
                List<FieldInfo> fields = null;
                if (isFourCol) {
                    legendData = LegendUtil.getFourColLegendData(reportSession.getImgLegendMap(iRChart.getId()).get(i).getLegendColorList());
                    fields = LegendUtil.getFourColFieldList();
                } else {
                    legendData = LegendUtil.getTwoColLegendData(reportSession.getImgLegendMap(iRChart.getId()).get(i).getLegendColorList());
                    fields = LegendUtil.getTwoColFieldList();
                }
                if (null != matchObject) {
                    RegexUtil.parseArray(matchObject, legendData);
                }
                JRTableModelDataSource legendDs = new JRTableModelDataSource((TableModel)new UnifiedTableModel(fields, legendData));
                imageDs.setLegendDs(legendDs);
                imageDs.setShowLegend(iRChart.isLegend());
                imageDSList.add(imageDs);
                paraMap.put(iRChart.getId() + "_legendDs", legendDs);
            }
            paraMap.put(iRChart.getId() + "DS", new JRBeanCollectionDataSource(imageDSList));
            paraMap.put(iRChart.getId() + "_show", iRChart.isShow());
        }
        IReportConfigUtil reportCfg = IReportConfigUtil.getInstance();
        String maxExportStr = reportCfg.getConfig("maxExportCount");
        if (null != maxExportStr && !maxExportStr.isEmpty()) {
            maxExportCount = Integer.parseInt(maxExportStr);
        }
        for (IRTable iRTable : report.getIRTableList(reportSession.getSwitchOption())) {
            paraMap.put(iRTable.getId() + "Title", IReportUtil.getProperty(iRTable.getTitle(), report.getId(), LocaleUtil.getCurrentUserLocale()));
            paraMap.put(iRTable.getId() + "_show", iRTable.isShow());
            paraMap.put(iRTable.getId() + "_COLUMN_FIRST_CODE_", " ");
            paraMap.put(iRTable.getId() + "_isGroup", true);
            for (int i = 0; i < iRTable.getIRColumnList().size(); ++i) {
                IRColumn iRColumn = iRTable.getIRColumnList().get(i);
                paraMap.put(iRTable.getId() + "Column" + i, IReportUtil.getProperty(iRColumn.getHeader(), report.getId(), LocaleUtil.getCurrentUserLocale()));
            }
            paraMap.put(iRTable.getId() + "DS", SigExportOutput.getDataSource(reportSession, iRTable, matchObject));
            SigExportOutput.handleTableExtendHeaderPara(paraMap, iRTable);
        }
        List<IRTextField> textFieldList = report.getTextFieldList(reportSession.getSwitchOption());
        String textSpaceName = null;
        for (IRTextField item : textFieldList) {
            item.setText(item.getText().replace("\\n", "\n"));
            if (null == item.getText() || item.getText().trim().length() <= 0) continue;
            textSpaceName = item.getId() + "_Text_Space";
            paraMap.put(item.getId() + "_Text", item.getText());
            paraMap.put(textSpaceName, " ");
        }
        if (SigExportOutput.lastElementIsTextField(report, reportSession)) {
            paraMap.remove(textSpaceName);
        }
        return paraMap;
    }

    private static boolean lastElementIsTextField(IReport report, ReportSession reportSession) {
        List<ComponentElement> tempElementList = report.getElementList(reportSession.getSwitchOption());
        if (tempElementList.isEmpty()) {
            return false;
        }
        return tempElementList.get(tempElementList.size() - 1) instanceof IRTextField;
    }

    public static JasperPrint fillJasperReport(ReportSession reportSession, JasperReport jasperReport, Boolean isIgnorePagination, String exportType) throws ProviderException {
        JasperPrint jasperPrint = null;
        Map<String, Object> paraMap = SigExportOutput.prepareJasperData(reportSession, isIgnorePagination, exportType);
        try {
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, paraMap, (JRDataSource)new JREmptyDataSource());
        }
        catch (JRException e) {
            LOG.error((Object)"fill report failed.", (Throwable)e);
        }
        return jasperPrint;
    }

    public static JasperPrint fillJasperReport(ReportSession reportSession, JasperReport jasperReport, Map<String, Object> paraMap, Boolean isIgnorePagination, String exportType, int prevTotalPageSize) throws ProviderException {
        JasperPrint jasperPrint = null;
        try {
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, paraMap, (JRDataSource)new JREmptyDataSource());
        }
        catch (JRException e) {
            LOG.error((Object)"fill report failed.", (Throwable)e);
        }
        return jasperPrint;
    }

    private static void handleTableExtendHeaderPara(Map<String, Object> paraMap, IRTable iRTable) {
        if (null == iRTable.getHeaderRowList() || iRTable.getHeaderRowList().isEmpty()) {
            return;
        }
        for (int rowNo = 0; rowNo < iRTable.getHeaderRowList().size(); ++rowNo) {
            HeaderRow row = iRTable.getHeaderRowList().get(rowNo);
            for (int colNo = 0; colNo < row.getHeaderColumnList().size(); ++colNo) {
                HeaderColumn column = row.getHeaderColumnList().get(colNo);
                String parameterName = iRTable.getId() + "_HeaderStretch_row" + rowNo + "col" + colNo;
                paraMap.put(parameterName, column.getValue());
            }
        }
    }

    private static Map<String, Object> createReportParmsMap(IReport report, ReportSession reportSession) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String reportName = IReportUtil.getProperty(report.getIRDefine().getTitle(), report.getId(), LocaleUtil.getCurrentUserLocale());
        parameters.put("REPORT_LOCALE", reportSession.getLocale());
        parameters.put("reportTitle", reportName);
        parameters.put("style", IReportUtil.getJasperTemplatePath() + "ReportStyle.jrtx");
        return parameters;
    }

    private static JRTableModelDataSource getDataSource(ReportSession reportSession, IRTable iRTable, RegexUtil.MatchObject matchObject) throws ProviderException {
        String dsId = iRTable.getDataSource();
        List<IRColumn> columnList = iRTable.getIRColumnList();
        List<Object[]> reportData = null;
        List<FieldInfo> fields = null;
        boolean isFlexTable = iRTable.isFlexTable();
        if (isFlexTable) {
            reportData = SigExportOutput.getFlexTableData(reportSession, dsId);
            fields = SigExportOutput.createFieldInfo(columnList);
        } else {
            List<IRColumn> validColumnList = ReportSession.getValidColumnList(true, columnList);
            fields = reportSession.getColumnInfo(dsId);
            fields = SigExportOutput.createFieldInfo(validColumnList, fields);
            reportData = SigExportOutput.getReportData(reportSession, iRTable, fields, matchObject);
        }
        if (reportData.isEmpty()) {
            reportData = new ArrayList<Object[]>();
            Object[] objArray = new Object[fields.size()];
            objArray[0] = LocaleUtil.getLocaleText(reportSession.getLocale(), "ireport.nodata");
            reportData.add(objArray);
        } else {
            maxExportCount -= reportData.size();
        }
        return new JRTableModelDataSource((TableModel)new UnifiedTableModel(fields, reportData));
    }

    private static List<FieldInfo> createFieldInfo(List<IRColumn> columnList, List<FieldInfo> allField) {
        ArrayList<FieldInfo> result = new ArrayList<FieldInfo>();
        for (int i = 0; i < columnList.size(); ++i) {
            FieldInfo field = SigExportOutput.getColumnField(allField, columnList.get(i));
            if (null != field) {
                result.add(field);
                continue;
            }
            LOG.error((Object)("getColumnField=" + columnList.get(i).getField() + " failed."));
        }
        return result;
    }

    private static FieldInfo getColumnField(List<FieldInfo> allField, IRColumn column) {
        for (FieldInfo item : allField) {
            if (IReportConfCheckUtil.isSpecialField(column.getField())) {
                FieldInfo newItem = new FieldInfo();
                newItem.setFieldName(column.getField());
                newItem.setFieldType("java.lang.String");
                return newItem;
            }
            if (!item.getFieldName().equals(column.getField())) continue;
            return item;
        }
        return null;
    }

    private static List<Object[]> getFlexTableData(ReportSession reportSession, String dsId) throws ProviderException {
        ArrayList<Object[]> reportData = new ArrayList<Object[]>();
        try {
            reportSession.fetchData(dsId, 1L, maxExportCount, null);
            long recCount = reportSession.getCurPageCount(dsId);
            for (long i = 0L; i < recCount; ++i) {
                List obj = (List)reportSession.getValue(dsId, i);
                Object[] objList = new Object[obj.size()];
                int size = obj.size();
                for (int col = 0; col < size; ++col) {
                    objList[col] = ((IFlexTableData)obj.get(col)).getDisplayTxt();
                }
                reportData.add(objList);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"getFlexTableData failed.", (Throwable)e);
        }
        return reportData;
    }

    private static List<FieldInfo> createFieldInfo(List<IRColumn> columnList) {
        ArrayList<FieldInfo> list = new ArrayList<FieldInfo>();
        if (columnList != null) {
            for (int i = 0; i < columnList.size(); ++i) {
                FieldInfo item = new FieldInfo();
                item.setFieldName("FlexColumn" + i);
                item.setFieldType("java.lang.String");
                list.add(item);
            }
        }
        return list;
    }

    private static List<Object[]> getReportData(ReportSession reportSession, IRTable iRTable, List<FieldInfo> fields, RegexUtil.MatchObject matchObject) {
        String dsId = iRTable.getDataSource();
        List<IRColumn> validColumnList = ReportSession.getValidColumnList(true, iRTable.getIRColumnList());
        OrderInfo orderInfoMap = reportSession.getOrderInfoMap().get(iRTable.getId());
        ArrayList<Object[]> reportData = new ArrayList<Object[]>();
        Object[] objs = null;
        try {
            reportSession.fetchData(dsId, 1L, maxExportCount, orderInfoMap);
            long recCount = reportSession.getCurPageCount(dsId);
            if (iRTable.getGroupNum() > 1) {
                CalculateNodeUtil.makeUpTableDataByMultiGroup(recCount, fields, reportSession, iRTable, reportData);
            } else {
                try {
                    String groupField = iRTable.getGroupField();
                    ArrayList<String> groupKeyList = new ArrayList<String>();
                    HashMap<String, List<Object[]>> groupTableData = new HashMap<String, List<Object[]>>();
                    for (long i = 0L; i < recCount; ++i) {
                        objs = SigExportOutput.getResultArray(fields, reportSession, i, dsId, validColumnList, iRTable);
                        String groupValue = "";
                        if (groupField != null && !groupField.isEmpty()) {
                            groupValue = IReportConfCheckUtil.formatObj(reportSession.getValue(iRTable.getDataSource(), i, groupField), iRTable.getGroupColumn());
                        }
                        if (!groupTableData.containsKey(groupValue)) {
                            groupKeyList.add(groupValue);
                            ArrayList tempData = new ArrayList();
                            groupTableData.put(groupValue, tempData);
                        }
                        if (iRTable.isGroupTable()) {
                            objs[0] = "";
                        }
                        ((List)groupTableData.get(groupValue)).add(objs);
                    }
                    SigExportOutput.handleTotal(iRTable, groupTableData, validColumnList);
                    for (String key : groupKeyList) {
                        reportData.addAll((Collection)groupTableData.get(key));
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"calss cast failed.", (Throwable)e);
                }
            }
            if (null != matchObject) {
                SigExportOutput.parseTableCell(validColumnList, reportData, reportSession);
            }
        }
        catch (ProviderException e1) {
            LOG.error((Object)"get data failed.", (Throwable)e1);
        }
        return reportData;
    }

    private static void handleTotal(IRTable iRTable, Map<String, List<Object[]>> groupTableData, List<IRColumn> validColumnList) {
        if (!iRTable.isTotalBarShow()) {
            if (iRTable.isGroupTable()) {
                for (Map.Entry<String, List<Object[]>> item : groupTableData.entrySet()) {
                    item.getValue().get((int)0)[0] = item.getKey();
                }
            }
            return;
        }
        for (Map.Entry<String, List<Object[]>> item : groupTableData.entrySet()) {
            Object[] totalObj = SigExportOutput.getTotalObj(iRTable, item.getValue(), validColumnList);
            if (iRTable.isTotalBarDown()) {
                item.getValue().add(totalObj);
                if (!iRTable.isGroupTable()) continue;
                item.getValue().get((int)0)[0] = item.getKey();
                totalObj[0] = "";
                continue;
            }
            item.getValue().add(0, totalObj);
            if (!iRTable.isGroupTable()) continue;
            totalObj[0] = item.getKey();
        }
    }

    private static Object[] getTotalObj(IRTable iRTable, List<Object[]> reportData, List<IRColumn> validColumnList) {
        Object[] totalObj = null;
        if (!iRTable.isTotalBarShow()) {
            return new Object[0];
        }
        totalObj = new Object[validColumnList.size()];
        for (int j = 0; j < validColumnList.size(); ++j) {
            String tempStr = IReportConfCheckUtil.calcTableColCount(reportData, j, validColumnList.get(j));
            totalObj[j] = tempStr;
        }
        return totalObj;
    }

    public static Object[] getResultArray(List<FieldInfo> fields, ReportSession reportSession, long i, String dsId, List<IRColumn> columnList, IRTable iRTable) {
        Object[] resultArray = new Object[fields.size()];
        String tableCellImageName = null;
        Object item = null;
        for (int k = 0; k < fields.size(); ++k) {
            IRColumn column = SigExportOutput.getColumn(columnList, fields.get(k).getFieldName());
            if (null != column && null != column.getChartRef() && column.getChartRef().length() > 0) {
                tableCellImageName = reportSession.createTableCellImageName(iRTable, column, (int)i);
                if (null == reportSession.getTableCellImageMap().get(tableCellImageName)) {
                    item = reportSession.getValue(iRTable.getDataSource(), (int)i, column.getField());
                    reportSession.handleTableImageCell(column, iRTable, item, (int)i);
                }
                resultArray[k] = IReportUtil.getRealPath() + reportSession.getTableCellImageMap().get(tableCellImageName);
                continue;
            }
            if (null != column) {
                resultArray[k] = SigExportOutput.getSubColumnData(column, i, dsId, reportSession, resultArray);
                if (null != resultArray[k]) continue;
                resultArray[k] = "";
                continue;
            }
            resultArray[k] = IReportConfCheckUtil.getObjectStr("");
        }
        return resultArray;
    }

    private static Object getSubColumnData(IRColumn column, long row, String dsId, ReportSession reportSession, Object[] resultArray) {
        if (null != column) {
            Object obj = null;
            obj = IReportConfCheckUtil.isSpecialField(column.getField()) ? SigExportOutput.getSpecialValue(resultArray, column) : reportSession.getValue(dsId, row, column.getField());
            if (null == obj) {
                return "";
            }
            Object resultTxt = "";
            String formatType = column.getFormatType();
            if (!IReportConfCheckUtil.isStringEmpty(formatType)) {
                resultTxt = String.valueOf(obj);
                resultTxt = IReportConfCheckUtil.formatObj(resultTxt, column);
            } else {
                resultTxt = obj;
            }
            if (!column.getSubColumnList().isEmpty()) {
                StringBuffer dataText = new StringBuffer(String.valueOf(resultTxt));
                String textTemp = null;
                for (int k = 0; k < column.getSubColumnList().size(); ++k) {
                    IRColumn subcolumn = column.getSubColumnList().get(k);
                    Object subitem = reportSession.getValue(dsId, row, column.getSubColumnList().get(k).getField());
                    textTemp = IReportConfCheckUtil.formatObj(subitem, subcolumn);
                    dataText.append(" | ").append(textTemp);
                }
                resultTxt = dataText.toString();
            }
            return resultTxt;
        }
        return "";
    }

    private static Object getSpecialValue(Object[] dataSet, IRColumn column) {
        double resultNum = 0.0;
        try {
            ArrayList<Double> cellList = new ArrayList<Double>();
            ArrayList<String> operatorList = new ArrayList<String>();
            SigExportOutput.decomposeSpecialValue(dataSet, column, cellList, operatorList);
            resultNum = SigExportOutput.getSpecialValue(cellList, operatorList);
        }
        catch (Exception e) {
            LOG.error((Object)"getSpecialValue failed.", (Throwable)e);
        }
        return resultNum;
    }

    public static double getSpecialValue(List<Double> cellList, List<String> operatorList) {
        double resultNum = cellList.get(0);
        if (!operatorList.isEmpty()) {
            for (int i = 0; i < operatorList.size(); ++i) {
                if (operatorList.get(i).equals("+")) {
                    resultNum += cellList.get(i + 1).doubleValue();
                    continue;
                }
                if (operatorList.get(i).equals("-")) {
                    resultNum -= cellList.get(i + 1).doubleValue();
                    continue;
                }
                if (operatorList.get(i).equals("*")) {
                    resultNum *= cellList.get(i + 1).doubleValue();
                    continue;
                }
                resultNum /= cellList.get(i + 1).doubleValue();
            }
        }
        return resultNum;
    }

    private static void decomposeSpecialValue(Object[] dataSet, IRColumn column, List<Double> cellList, List<String> operatorList) {
        String temp;
        int index;
        String subFieldStr = column.getField().substring(1);
        do {
            int plusIndex = subFieldStr.indexOf("+");
            int minusIndex = subFieldStr.indexOf("-");
            int multiplyIndex = subFieldStr.indexOf("*");
            int divideIndex = subFieldStr.indexOf("/");
            index = -1;
            if (plusIndex != -1) {
                index = plusIndex;
            }
            if (minusIndex != -1 && (minusIndex < index || -1 == index)) {
                index = minusIndex;
            }
            if (multiplyIndex != -1 && (multiplyIndex < index || -1 == index)) {
                index = multiplyIndex;
            }
            if (divideIndex != -1 && (divideIndex < index || -1 == index)) {
                index = divideIndex;
            }
            temp = subFieldStr.substring(0, index);
            temp = temp.substring(1);
            cellList.add(Double.valueOf(dataSet[Integer.parseInt(temp)].toString()));
            operatorList.add(SigExportOutput.getOperator(index, plusIndex, minusIndex, multiplyIndex));
        } while ((subFieldStr = subFieldStr.substring(index + 1)).indexOf("+") != -1 || subFieldStr.indexOf("-") != -1 || subFieldStr.indexOf("*") != -1 || subFieldStr.indexOf("/") != -1);
        temp = subFieldStr.substring(1);
        cellList.add(Double.valueOf(dataSet[Integer.parseInt(temp)].toString()));
    }

    public static String getOperator(int index, int plusIndex, int minusIndex, int multiplyIndex) {
        if (index == plusIndex) {
            return "+";
        }
        if (index == minusIndex) {
            return "-";
        }
        if (index == multiplyIndex) {
            return "*";
        }
        return "/";
    }

    private static IRColumn getColumn(List<IRColumn> columnList, String fieldName) {
        IRColumn column = null;
        for (IRColumn item : columnList) {
            if (!item.getField().equals(fieldName)) continue;
            column = item;
            break;
        }
        return column;
    }

    public static void parseTableCell(List<IRColumn> validColumnList, List<Object[]> targets, ReportSession reportSession) {
        if (null != validColumnList && !validColumnList.isEmpty()) {
            int[] jasperCellLengths = new int[validColumnList.size()];
            IRColumn tempIRColumn = null;
            int n = validColumnList.size();
            for (int index = 0; index < n; ++index) {
                tempIRColumn = validColumnList.get(index);
                if (null != tempIRColumn.getChartRef() && tempIRColumn.getChartRef().length() != 0) continue;
                jasperCellLengths[index] = tempIRColumn.getJasperWidth(reportSession.getSwitchOption());
            }
            RegexUtil.parseTableCell(jasperCellLengths, targets);
        }
    }
}

