/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.output;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.FieldInfo;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class UnifiedTableModel
implements TableModel {
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<FieldInfo> fieldInfoList;
    private List<Object[]> data;

    public UnifiedTableModel(List<FieldInfo> fieldInfoList, List<Object[]> data) {
        this.fieldInfoList = fieldInfoList;
        this.data = data;
    }

    @Override
    public void addTableModelListener(TableModelListener listner) {
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class<?> clazz = null;
        if (columnIndex >= 0 && columnIndex < this.fieldInfoList.size()) {
            String className = this.fieldInfoList.get(columnIndex).getFieldType();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("cannot load class:" + className), (Throwable)e);
            }
        }
        return clazz;
    }

    @Override
    public int getColumnCount() {
        return this.fieldInfoList.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        String columnName = null;
        if (columnIndex >= 0 && columnIndex < this.fieldInfoList.size()) {
            columnName = this.fieldInfoList.get(columnIndex).getFieldName();
        }
        return columnName;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.data.get(rowIndex)[columnIndex];
        }
        catch (Exception e) {
            LOG.error((Object)("rowIndex=" + rowIndex + ";  columnIndex=" + columnIndex));
            return "";
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }
}

