/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.jasperreports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JRXlsAbstractExporter
extends JRAbstractExporter {
    protected static final String XLS_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xls.";
    private static final Log LOG = LogFactory.getLog(JRXlsAbstractExporter.class);
    private static final float D_2F = 2.0f;
    private static final double D_0_375 = 0.375;
    private static final double U_0_125 = -0.125;
    private static final double D_0_5 = 0.5;
    private static final double D_0_25 = 0.25;
    private static final double D_1000_0 = 1000.0;
    private static final double U_0_25 = -0.25;
    private static final double D_2_0 = 2.0;
    protected List loadedFonts = new ArrayList();
    protected boolean isOnePagePerSheet;
    protected boolean isRemoveEmptySpaceBetweenRows;
    protected boolean isRemoveEmptySpaceBetweenColumns;
    protected boolean isWhitePageBackground;
    protected boolean isAutoDetectCellType = false;
    protected boolean isDetectCellType;
    protected boolean isFontSizeFixEnabled;
    protected boolean isImageBorderFixEnabled;
    protected boolean isIgnoreGraphics;
    protected boolean isCollapseRowSpan;
    protected boolean isIgnoreCellBorder;
    protected boolean isIgnoreCellBackground;
    protected int maxRowsPerSheet;
    protected String[] sheetNames = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected int reportIndex = 0;
    protected int pageIndex = 0;
    protected Map fontMap = null;
    protected JRFont defaultFont = null;
    protected int sheetIndex = 0;
    protected Map sheetNamesMap = null;
    protected String currentSheetName = null;
    protected boolean isIgnorePageMargins;

    protected JRFont getDefaultFont() {
        return this.defaultFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block19: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(XLS_EXPORTER_PROPERTIES_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.setParameters();
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    this.exportReportToStream(os);
                    break block19;
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.exportReportToStream(os);
                    os.flush();
                }
                catch (IOException e) {
                    throw new JRException("Error trying to export to file : " + destFile, (Throwable)e);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e) {
                            LOG.error((Object)e);
                        }
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void setParameters() {
        this.isOnePagePerSheet = this.getBooleanParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, "net.sf.jasperreports.export.xls.one.page.per.sheet", false);
        this.isRemoveEmptySpaceBetweenRows = this.getBooleanParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, "net.sf.jasperreports.export.xls.remove.empty.space.between.rows", false);
        this.isRemoveEmptySpaceBetweenColumns = this.getBooleanParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, "net.sf.jasperreports.export.xls.remove.empty.space.between.columns", false);
        this.isWhitePageBackground = this.getBooleanParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, "net.sf.jasperreports.export.xls.white.page.background", false);
        this.setBackground();
        Boolean isAutoDetectCellTypeParameter = (Boolean)this.parameters.get(JRXlsAbstractExporterParameter.IS_AUTO_DETECT_CELL_TYPE);
        if (isAutoDetectCellTypeParameter != null) {
            this.isAutoDetectCellType = isAutoDetectCellTypeParameter;
        }
        this.isDetectCellType = this.getBooleanParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_DETECT_CELL_TYPE, "net.sf.jasperreports.export.xls.detect.cell.type", false);
        this.isFontSizeFixEnabled = this.getBooleanParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_FONT_SIZE_FIX_ENABLED, "net.sf.jasperreports.export.xls.font.size.fix.enabled", false);
        this.isImageBorderFixEnabled = this.getBooleanParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IMAGE_BORDER_FIX_ENABLED, "net.sf.jasperreports.export.xls.image.border.fix.enabled", false);
        this.isIgnoreGraphics = this.getBooleanParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IGNORE_GRAPHICS, "net.sf.jasperreports.export.xls.ignore.graphics", false);
        this.isCollapseRowSpan = this.getBooleanParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_COLLAPSE_ROW_SPAN, "net.sf.jasperreports.export.xls.collapse.row.span", false);
        this.isIgnoreCellBorder = this.getBooleanParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IGNORE_CELL_BORDER, "net.sf.jasperreports.export.xls.ignore.cell.border", false);
        this.isIgnoreCellBackground = this.getBooleanParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IGNORE_CELL_BACKGROUND, "net.sf.jasperreports.export.xls.ignore.cell.background", false);
        String[] sheetNamesArray = this.getStringArrayParameter((JRExporterParameter)JRXlsAbstractExporterParameter.SHEET_NAMES, "net.sf.jasperreports.export.xls.sheet.names.");
        if (sheetNamesArray != null) {
            ArrayList<String> sheetNamesList = new ArrayList<String>();
            for (int i = 0; i < sheetNamesArray.length; ++i) {
                String[] currentSheetNamesArray = sheetNamesArray[i].split("/");
                sheetNamesList.addAll(Arrays.asList(currentSheetNamesArray));
            }
            this.sheetNames = sheetNamesList.toArray(new String[sheetNamesList.size()]);
        }
        this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
        this.setHyperlinkProducerFactory();
        this.maxRowsPerSheet = this.getIntegerParameter(JRXlsAbstractExporterParameter.MAXIMUM_ROWS_PER_SHEET, "net.sf.jasperreports.export.xls.max.rows.per.sheet", 0);
        this.isIgnorePageMargins = this.getBooleanParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, "net.sf.jasperreports.export.ignore.page.margins", false);
    }

    protected abstract void setBackground();

    protected void exportReportToStream(OutputStream os) throws JRException {
        this.openWorkbook(os);
        this.sheetNamesMap = new HashMap();
        this.sheetNamesMap.put("Page", 0);
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
            this.defaultFont = new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider());
            List pages = this.jasperPrint.getPages();
            if (pages != null && !pages.isEmpty()) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                if (this.isOnePagePerSheet) {
                    this.pageIndex = this.startPageIndex;
                    while (this.pageIndex <= this.endPageIndex) {
                        if (Thread.interrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = (JRPrintPage)pages.get(this.pageIndex);
                        if (this.sheetNames != null && this.sheetIndex < this.sheetNames.length) {
                            this.createSheet(this.getSheetName(this.sheetNames[this.sheetIndex]));
                        } else {
                            this.createSheet(this.getSheetName("Page"));
                        }
                        ++this.sheetIndex;
                        this.exportPage(page, null, 0);
                        ++this.pageIndex;
                    }
                } else {
                    boolean isCreateSheetByIndex = false;
                    if (this.sheetNames != null && this.sheetIndex < this.sheetNames.length) {
                        this.createSheet(this.getSheetName(this.sheetNames[this.sheetIndex]));
                        isCreateSheetByIndex = true;
                        this.exportPage(pages, isCreateSheetByIndex);
                        ++this.sheetIndex;
                    } else {
                        ArrayList<Object> pagesNew = new ArrayList<Object>();
                        this.filterPage(pagesNew, pages);
                        for (int i = 0; i < pagesNew.size(); ++i) {
                            List pagesOfSheet = (List)pagesNew.get(i);
                            if (pagesOfSheet.isEmpty()) continue;
                            this.createSheet(this.getSheetName("Page"));
                            this.exportPage(pagesOfSheet, isCreateSheetByIndex);
                            ++this.sheetIndex;
                        }
                    }
                }
            }
            ++this.reportIndex;
        }
        this.closeWorkbook(os);
    }

    protected void exportPage(List pages, boolean isCreateSheetByIndex) throws JRException {
        if (!isCreateSheetByIndex) {
            this.endPageIndex = pages.size() - 1;
        }
        CutsInfo xCuts = JRGridLayout.calculateXCuts((ExporterNature)this.getNature(), (List)pages, (int)this.startPageIndex, (int)this.endPageIndex, (int)this.jasperPrint.getPageWidth(), (int)this.globalOffsetX);
        if (this.filter instanceof ResetableExporterFilter) {
            ((ResetableExporterFilter)this.filter).reset();
        }
        int startRow = 0;
        ArrayList removeLi = new ArrayList();
        for (int pageIndexNew = this.startPageIndex; pageIndexNew <= this.endPageIndex; ++pageIndexNew) {
            if (Thread.currentThread().isInterrupted()) {
                throw new JRException("Current thread interrupted.");
            }
            JRPrintPage page = (JRPrintPage)pages.get(pageIndexNew);
            Object[] resultArr = this.exportPage(page, xCuts, startRow);
            startRow = (Integer)resultArr[0];
            removeLi.addAll((List)resultArr[1]);
        }
        int removeIndex = 0;
        if (removeLi.size() > 1) {
            for (int i = 1; i < removeLi.size(); ++i) {
                int rowIndex = (Integer)removeLi.get(i);
                rowIndex = rowIndex + 1 - removeIndex;
                this.removeRow(rowIndex);
                ++removeIndex;
            }
        }
        if (this.isRemoveEmptySpaceBetweenColumns) {
            this.removeEmptyColumns(xCuts);
        }
    }

    protected void filterPage(List<Object> pagesNew, List pages) throws JRException {
        ArrayList<JRBasePrintPage> pagesOfSheetOne = new ArrayList<JRBasePrintPage>();
        ArrayList<Object> pagesOfSheetTwo = new ArrayList<Object>();
        boolean isNewSheet = false;
        int point = -1;
        for (int pageIndexNew = 0; pageIndexNew < pages.size(); ++pageIndexNew) {
            JRPrintPage page = (JRPrintPage)pages.get(pageIndexNew);
            JRBasePrintPage firstPage = new JRBasePrintPage();
            JRBasePrintPage copyPage = new JRBasePrintPage();
            if (!isNewSheet) {
                int elementIndex;
                List elements = page.getElements();
                firstPage.setElements(elements);
                ArrayList remainedElements = new ArrayList();
                ArrayList selectedElements = new ArrayList();
                for (elementIndex = 0; elementIndex < elements.size(); ++elementIndex) {
                    JRPrintElement element = (JRPrintElement)elements.get(elementIndex);
                    JROrigin origin = element.getOrigin();
                    if (!(element instanceof JRTemplatePrintText) || origin == null || origin.getBandType() != 4) continue;
                    point = elementIndex;
                    break;
                }
                if (point >= 0) {
                    for (elementIndex = 0; elementIndex < elements.size(); ++elementIndex) {
                        if (elementIndex < point) {
                            selectedElements.add(elements.get(elementIndex));
                            continue;
                        }
                        remainedElements.add(elements.get(elementIndex));
                    }
                    firstPage.setElements(selectedElements);
                    copyPage.setElements(remainedElements);
                    isNewSheet = true;
                    pagesOfSheetTwo.add(copyPage);
                }
                pagesOfSheetOne.add(firstPage);
                continue;
            }
            pagesOfSheetTwo.add(page);
        }
        pagesNew.add(pagesOfSheetOne);
        if (this.maxRowsPerSheet > 0) {
            int total = pagesOfSheetTwo.size();
            int divisor = total / this.maxRowsPerSheet;
            for (int i = 0; i <= divisor; ++i) {
                ArrayList al = new ArrayList();
                pagesNew.add(al);
                for (int j = 0; j < this.maxRowsPerSheet && i * this.maxRowsPerSheet + j < total; ++j) {
                    al.add(pagesOfSheetTwo.get(i * this.maxRowsPerSheet + j));
                }
            }
        } else {
            pagesNew.add(pagesOfSheetTwo);
        }
    }

    protected Object[] exportPage(JRPrintPage page, CutsInfo xCuts, int startRow) throws JRException {
        boolean createXCuts;
        ArrayList<Integer> removeList;
        JRGridLayout layout = new JRGridLayout(this.getNature(), page.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, xCuts);
        JRExporterGridCell[][] grid = layout.getGrid();
        Object[] ret = new Object[]{0, removeList = new ArrayList<Integer>()};
        boolean bl = createXCuts = xCuts == null;
        if (createXCuts) {
            xCuts = layout.getXCuts();
            this.setColumnWidths(xCuts);
        }
        if (startRow == 0) {
            this.setColumnWidths(xCuts);
        }
        CutsInfo yCuts = layout.getYCuts();
        int skippedRows = 0;
        int rowIndex = startRow;
        boolean isHeader = false;
        for (int y = 0; y < grid.length; ++y) {
            rowIndex = y - skippedRows + startRow;
            if (this.maxRowsPerSheet > 0 && rowIndex >= this.maxRowsPerSheet || yCuts.isBreak(y)) {
                this.createSheet(this.getSheetName(this.currentSheetName));
                this.setColumnWidths(xCuts);
                startRow = 0;
                rowIndex = 0;
                skippedRows = y;
            }
            if (yCuts.isCutNotEmpty(y) || (!this.isRemoveEmptySpaceBetweenRows || yCuts.isCutSpanned(y)) && !this.isCollapseRowSpan) {
                JRExporterGridCell[] gridRow = grid[y];
                int emptyCellColSpan = 0;
                int emptyCellWidth = 0;
                this.setRowHeight(rowIndex, this.isCollapseRowSpan ? JRGridLayout.getMaxRowHeight((JRExporterGridCell[])gridRow) : JRGridLayout.getRowHeight((JRExporterGridCell[])gridRow));
                int emptyCols = 0;
                for (int colIndex = 0; colIndex < gridRow.length; ++colIndex) {
                    emptyCols += this.isRemoveEmptySpaceBetweenColumns && !xCuts.isCutNotEmpty(colIndex) && !xCuts.isCutSpanned(colIndex) ? 1 : 0;
                    JRExporterGridCell gridCell = gridRow[colIndex];
                    this.setCell(gridCell, colIndex, rowIndex);
                    if (gridCell.getType() == 2) {
                        if (emptyCellColSpan > 0) {
                            emptyCellColSpan = 0;
                            emptyCellWidth = 0;
                        }
                        this.addOccupiedCell((OccupiedGridCell)gridCell, colIndex, rowIndex);
                        continue;
                    }
                    if (gridCell.getWrapper() != null) {
                        JRPrintElement element;
                        if (emptyCellColSpan > 0) {
                            emptyCellColSpan = 0;
                            emptyCellWidth = 0;
                        }
                        if ((element = gridCell.getWrapper().getElement()).getOrigin() != null && element.getOrigin().getBandType() == 4 && !isHeader) {
                            isHeader = true;
                            removeList.add(rowIndex);
                        }
                        if (element instanceof JRPrintLine) {
                            this.exportLine((JRPrintLine)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintRectangle) {
                            this.exportRectangle((JRPrintGraphicElement)((JRPrintRectangle)element), gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintEllipse) {
                            this.exportRectangle((JRPrintGraphicElement)((JRPrintEllipse)element), gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintImage) {
                            this.exportImage((JRPrintImage)element, gridCell, colIndex, rowIndex, emptyCols);
                            continue;
                        }
                        if (element instanceof JRPrintText) {
                            this.exportText((JRPrintText)element, gridCell, colIndex, rowIndex);
                            continue;
                        }
                        if (element instanceof JRPrintFrame) {
                            this.exportFrame((JRPrintFrame)element, gridCell, colIndex, y);
                            continue;
                        }
                        if (!(element instanceof JRGenericPrintElement)) continue;
                        this.exportGenericElement((JRGenericPrintElement)element, gridCell, colIndex, rowIndex, emptyCols);
                        continue;
                    }
                    ++emptyCellColSpan;
                    emptyCellWidth += gridCell.getWidth();
                    this.addBlankCell(gridCell, colIndex, rowIndex);
                }
                ++rowIndex;
                continue;
            }
            ++skippedRows;
        }
        if (createXCuts && this.isRemoveEmptySpaceBetweenColumns) {
            this.removeEmptyColumns(xCuts);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
        ret[0] = rowIndex;
        return ret;
    }

    protected void setColumnWidths(CutsInfo xCuts) {
        for (int col = 0; col < xCuts.size() - 1; ++col) {
            if (this.isRemoveEmptySpaceBetweenColumns && !xCuts.isCutNotEmpty(col) && !xCuts.isCutSpanned(col)) continue;
            int width = xCuts.getCut(col + 1) - xCuts.getCut(col);
            this.setColumnWidth(col, width);
        }
    }

    protected void removeEmptyColumns(CutsInfo xCuts) {
        for (int col = xCuts.size() - 1; col >= 0; --col) {
            if (xCuts.isCutNotEmpty(col) || xCuts.isCutSpanned(col)) continue;
            this.removeColumn(col);
        }
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        return textElement.getFullStyledText(JRStyledTextAttributeSelector.NONE);
    }

    protected static TextAlignHolder getTextAlignHolder(JRPrintText textElement) {
        HorizontalAlignEnum horizontalAlignment = null;
        VerticalAlignEnum verticalAlignment = null;
        RotationEnum rotation = textElement.getRotationValue();
        block0 : switch (textElement.getRotationValue()) {
            case LEFT: {
                switch (textElement.getHorizontalAlignmentValue()) {
                    case LEFT: {
                        verticalAlignment = VerticalAlignEnum.BOTTOM;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalAlignEnum.MIDDLE;
                        break;
                    }
                    case RIGHT: {
                        verticalAlignment = VerticalAlignEnum.TOP;
                        break;
                    }
                    case JUSTIFIED: {
                        verticalAlignment = VerticalAlignEnum.JUSTIFIED;
                        break;
                    }
                }
                switch (textElement.getVerticalAlignmentValue()) {
                    case TOP: {
                        horizontalAlignment = HorizontalAlignEnum.LEFT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalAlignEnum.CENTER;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalAlignEnum.RIGHT;
                        break block0;
                    }
                }
                break;
            }
            case RIGHT: {
                switch (textElement.getHorizontalAlignmentValue()) {
                    case LEFT: {
                        verticalAlignment = VerticalAlignEnum.TOP;
                        break;
                    }
                    case CENTER: {
                        verticalAlignment = VerticalAlignEnum.MIDDLE;
                        break;
                    }
                    case RIGHT: {
                        verticalAlignment = VerticalAlignEnum.BOTTOM;
                        break;
                    }
                    case JUSTIFIED: {
                        verticalAlignment = VerticalAlignEnum.JUSTIFIED;
                        break;
                    }
                }
                switch (textElement.getVerticalAlignmentValue()) {
                    case TOP: {
                        horizontalAlignment = HorizontalAlignEnum.RIGHT;
                        break block0;
                    }
                    case MIDDLE: {
                        horizontalAlignment = HorizontalAlignEnum.CENTER;
                        break block0;
                    }
                    case BOTTOM: {
                        horizontalAlignment = HorizontalAlignEnum.LEFT;
                        break block0;
                    }
                }
                break;
            }
            default: {
                horizontalAlignment = textElement.getHorizontalAlignmentValue();
                verticalAlignment = textElement.getVerticalAlignmentValue();
            }
        }
        return new TextAlignHolder(horizontalAlignment, verticalAlignment, rotation);
    }

    protected int getImageBorderCorrection(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            if (lineWidth >= 2.0f) {
                return 2;
            }
            return 1;
        }
        return this.isImageBorderFixEnabled ? 1 : 0;
    }

    private String getSheetName(String sheetName) {
        this.currentSheetName = sheetName;
        if (!this.sheetNamesMap.containsKey(sheetName)) {
            this.sheetNamesMap.put(sheetName, 1);
            return sheetName.length() > 31 ? sheetName.substring(0, 31) : sheetName;
        }
        int currentIndex = (Integer)this.sheetNamesMap.get(sheetName) + 1;
        this.sheetNamesMap.put(sheetName, currentIndex);
        String name = sheetName + " " + currentIndex;
        if (name.length() > 31) {
            String crtIndex = String.valueOf(currentIndex);
            name = (sheetName + " ").substring(0, 31 - crtIndex.length()) + crtIndex;
        }
        return name;
    }

    protected int calculateWidthForDinAN(int n) {
        return (int)(Math.pow(2.0, -0.25 - (double)n / 2.0) * 1000.0);
    }

    protected int calculateHeightForDinAN(int n) {
        return (int)(Math.pow(2.0, 0.25 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateWidthForDinBN(int n) {
        return (int)(Math.pow(2.0, -((double)n / 2.0)) * 1000.0);
    }

    protected final int calculateHeightForDinBN(int n) {
        return (int)(Math.pow(2.0, 0.5 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateWidthForDinCN(int n) {
        return (int)(Math.pow(2.0, -0.125 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateHeightForDinCN(int n) {
        return (int)(Math.pow(2.0, 0.375 - (double)n / 2.0) * 1000.0);
    }

    protected abstract ExporterNature getNature();

    protected abstract void openWorkbook(OutputStream var1) throws JRException;

    protected abstract void createSheet(String var1);

    protected abstract void closeWorkbook(OutputStream var1) throws JRException;

    protected abstract void setColumnWidth(int var1, int var2);

    protected abstract void removeColumn(int var1);

    protected abstract void removeRow(int var1);

    protected abstract void setRowHeight(int var1, int var2) throws JRException;

    protected abstract void setCell(JRExporterGridCell var1, int var2, int var3);

    protected abstract void addBlankCell(JRExporterGridCell var1, int var2, int var3) throws JRException;

    protected abstract void addOccupiedCell(OccupiedGridCell var1, int var2, int var3) throws JRException;

    protected abstract void exportText(JRPrintText var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportImage(JRPrintImage var1, JRExporterGridCell var2, int var3, int var4, int var5) throws JRException;

    protected abstract void exportRectangle(JRPrintGraphicElement var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportLine(JRPrintLine var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportFrame(JRPrintFrame var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportGenericElement(JRGenericPrintElement var1, JRExporterGridCell var2, int var3, int var4, int var5) throws JRException;

    protected static class TextAlignHolder {
        private HorizontalAlignEnum horizontalAlignment;
        private VerticalAlignEnum verticalAlignment;
        private RotationEnum rotation;

        public TextAlignHolder(HorizontalAlignEnum horizontalAlignment, VerticalAlignEnum verticalAlignment, RotationEnum rotation) {
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
        }

        public HorizontalAlignEnum getHorizontalAlignment() {
            return this.horizontalAlignment;
        }

        public VerticalAlignEnum getVerticalAlignment() {
            return this.verticalAlignment;
        }

        public RotationEnum getRotation() {
            return this.rotation;
        }
    }
}

