/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.jasperreports;

import com.security.ireport.jasperreports.JRXlsAbstractExporter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementXlsHandler;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsExporterContext;
import net.sf.jasperreports.engine.export.JRXlsExporterNature;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public class JRXlsExporter
extends JRXlsAbstractExporter {
    public static final String XLS_EXPORTER_KEY = "net.sf.jasperreports.xls";
    private static final double D_25_4 = 25.4;
    private static final double D_72_0 = 72.0;
    private static final float D_0_5F = 0.5f;
    private static final float D_2F = 2.0f;
    private static final Log LOG = LogFactory.getLog(JRXlsAbstractExporter.class);
    private static Map hssfColorsCache = new ReferenceMap();
    protected Map loadedCellStyles = new HashMap();
    protected Map anchorLinks = new HashMap();
    protected Map<Integer, List> pageLinks = new HashMap<Integer, List>();
    protected Map<String, HSSFName> anchorNames = new HashMap<String, HSSFName>();
    protected HSSFWorkbook workbook = null;
    protected HSSFSheet sheet = null;
    protected HSSFRow row = null;
    protected HSSFCell cell = null;
    protected HSSFCellStyle emptyCellStyle = null;
    protected CreationHelper createHelper = null;
    protected short whiteIndex = new HSSFColor.WHITE().getIndex();
    protected short blackIndex = new HSSFColor.BLACK().getIndex();
    protected short backgroundMode = 1;
    protected HSSFDataFormat dataFormat = null;
    protected Map formatPatternsMap = null;
    protected ExporterNature nature = null;
    protected HSSFPatriarch patriarch = null;
    protected String password = null;
    protected JRXlsExporterContext exporterContext = new ExporterContext();

    @Override
    protected void setParameters() {
        super.setParameters();
        this.formatPatternsMap = (Map)this.getParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP);
        this.nature = new JRXlsExporterNature(this.filter, this.isIgnoreGraphics, this.isIgnorePageMargins);
        this.password = this.getStringParameter((JRExporterParameter)JRXlsExporterParameter.PASSWORD, "net.sf.jasperreports.export.xls.password");
    }

    @Override
    protected void setBackground() {
        if (!this.isWhitePageBackground) {
            this.backgroundMode = 0;
        }
    }

    @Override
    protected void openWorkbook(OutputStream os) {
        this.workbook = new HSSFWorkbook();
        this.emptyCellStyle = this.workbook.createCellStyle();
        this.emptyCellStyle.setFillForegroundColor(new HSSFColor.WHITE().getIndex());
        this.emptyCellStyle.setFillPattern(FillPatternType.forInt((int)this.backgroundMode));
        this.dataFormat = this.workbook.createDataFormat();
        this.createHelper = this.workbook.getCreationHelper();
    }

    @Override
    protected void createSheet(String name) {
        this.sheet = this.workbook.createSheet(name);
        this.patriarch = this.sheet.createDrawingPatriarch();
        this.sheet.getPrintSetup().setLandscape(this.jasperPrint.getOrientationValue() == OrientationEnum.LANDSCAPE);
        short paperSize = this.getSuitablePaperSize(this.jasperPrint);
        if (paperSize != -1) {
            this.sheet.getPrintSetup().setPaperSize(paperSize);
        }
        if (this.password != null) {
            this.sheet.protectSheet(this.password);
        }
    }

    @Override
    protected void removeRow(int rowNew) {
        HSSFRow currentRow = this.sheet.getRow(rowNew);
        if (currentRow != null) {
            this.sheet.removeRow((Row)currentRow);
            this.sheet.shiftRows(rowNew - 1, rowNew - 1, 1);
        }
    }

    @Override
    protected void closeWorkbook(OutputStream os) throws JRException {
        try {
            for (Map.Entry<String, HSSFName> entry : this.anchorNames.entrySet()) {
                HSSFName anchor = entry.getValue();
                List linkList = (List)this.anchorLinks.get(entry.getKey());
                int index = anchor.getSheetIndex();
                anchor.setRefersToFormula("'" + this.workbook.getSheetName(index) + "'!" + anchor.getRefersToFormula());
                if (linkList == null || linkList.isEmpty()) continue;
                for (Object hyperlink : linkList) {
                    Hyperlink link = (Hyperlink)hyperlink;
                    link.setAddress(anchor.getRefersToFormula());
                }
            }
            for (Map.Entry<Object, Object> entry : this.pageLinks.entrySet()) {
                List linkList = (List)entry.getValue();
                if (linkList == null || linkList.isEmpty()) continue;
                for (Object hyperlink : linkList) {
                    Hyperlink link = (Hyperlink)hyperlink;
                    if (this.isOnePagePerSheet) {
                        link.setAddress("'" + this.workbook.getSheetName((Integer)entry.getKey() - 1) + "'!A1");
                        continue;
                    }
                    link.setAddress("'" + this.workbook.getSheetName(0) + "'!A1");
                }
            }
            this.workbook.write(os);
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), (Throwable)e);
        }
    }

    @Override
    protected void setColumnWidth(int col, int width) {
        this.sheet.setColumnWidth(col, 43 * width);
    }

    @Override
    protected void setRowHeight(int rowIndex, int lastRowHeight) {
        this.row = this.sheet.getRow(rowIndex);
        if (this.row == null) {
            this.row = this.sheet.createRow(rowIndex);
        }
        this.row.setHeightInPoints((float)lastRowHeight);
    }

    @Override
    protected void setCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        HSSFCell emptyCell = this.row.getCell(colIndex);
        if (emptyCell == null) {
            emptyCell = this.row.createCell(colIndex);
            emptyCell.setCellStyle(this.emptyCellStyle);
        }
    }

    @Override
    protected void removeColumn(int colIndex) {
        this.sheet.setColumnHidden(colIndex, true);
    }

    @Override
    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        this.cell = this.row.createCell(colIndex);
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(gridCell.getCellBackcolor()).getIndex();
        }
        short forecolor = this.blackIndex;
        if (gridCell.getForecolor() != null) {
            forecolor = JRXlsExporter.getNearestColor(gridCell.getForecolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, HorizontalAlignment.LEFT.getCode(), VerticalAlignment.TOP.getCode(), (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), gridCell);
        this.cell.setCellStyle(cellStyle);
    }

    @Override
    protected void addOccupiedCell(OccupiedGridCell occupiedGridCell, int colIndex, int rowIndex) {
    }

    @Override
    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        short forecolor = JRXlsExporter.getNearestColor(line.getLinePen().getLineColor()).getIndex();
        int side = 0;
        float ratio = (float)line.getWidth() / (float)line.getHeight();
        side = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? 0 : 2) : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? 1 : 3);
        BoxStyle boxStyle = new BoxStyle(side, line.getLinePen());
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(gridCell.getCellBackcolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, HorizontalAlignment.LEFT.getCode(), VerticalAlignment.TOP.getCode(), (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), boxStyle);
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell(colIndex);
        this.cell.setCellStyle(cellStyle);
    }

    @Override
    protected void exportRectangle(JRPrintGraphicElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        short forecolor = JRXlsExporter.getNearestColor(element.getLinePen().getLineColor()).getIndex();
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(gridCell.getCellBackcolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, HorizontalAlignment.LEFT.getCode(), VerticalAlignment.TOP.getCode(), (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), gridCell);
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell(colIndex);
        this.cell.setCellStyle(cellStyle);
    }

    @Override
    public void exportText(JRPrintText textElement, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        JRStyledText styledText = this.getStyledText(textElement);
        if (styledText == null) {
            return;
        }
        short forecolor = JRXlsExporter.getNearestColor(textElement.getForecolor()).getIndex();
        JRXlsAbstractExporter.TextAlignHolder textAlignHolder = JRXlsExporter.getTextAlignHolder(textElement);
        short horizontalAlignment = this.getHorizontalAlignment(textAlignHolder);
        short verticalAlignment = this.getVerticalAlignment(textAlignHolder);
        short rotation = this.getRotation(textAlignHolder);
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(gridCell.getCellBackcolor()).getIndex();
        }
        StyleInfo baseStyle = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, this.getLoadedFont((JRFont)textElement, forecolor, null, this.getTextLocale(textElement)), gridCell, JRProperties.getBooleanProperty((JRPropertiesHolder)textElement, (String)"net.sf.jasperreports.export.xls.wrap.text", (boolean)true));
        this.createTextCell(textElement, gridCell, colIndex, rowIndex, styledText, baseStyle, forecolor);
    }

    protected void createTextCell(final JRPrintText textElement, final JRExporterGridCell gridCell, final int colIndex, final int rowIndex, final JRStyledText styledText, final StyleInfo baseStyle, final short forecolor) throws JRException {
        HSSFCellStyle cellStyle;
        String textStr;
        block17: {
            String formula = textElement.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.formula");
            textStr = styledText.getText();
            if (formula != null) {
                if ((formula = formula.trim()).startsWith("=")) {
                    formula = formula.substring(1);
                }
                try {
                    TextValue value = this.getTextValue(textElement, textStr);
                    if (value instanceof NumberTextValue && ((NumberTextValue)value).getPattern() != null) {
                        baseStyle.setDataFormat(this.dataFormat.getFormat(this.getConvertedPattern(((NumberTextValue)value).getPattern())));
                    } else if (value instanceof DateTextValue && ((DateTextValue)value).getPattern() != null) {
                        baseStyle.setDataFormat(this.dataFormat.getFormat(this.getConvertedPattern(((DateTextValue)value).getPattern())));
                    }
                    HSSFCellStyle cellStyle2 = this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    this.cell.setCellType(2);
                    this.cell.setCellFormula(formula);
                    this.endCreateCell(cellStyle2);
                    return;
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block17;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
        if (this.isDetectCellType) {
            TextValue value = this.getTextValue(textElement, textStr);
            value.handle(new TextValueHandler(){

                public void handle(StringTextValue textValue) {
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if ("none".equals(textElement.getMarkup())) {
                        JRXlsExporter.this.setStringCellValue(textValue.getText());
                    } else {
                        JRXlsExporter.this.setRichTextStringCellValue(styledText, forecolor, (JRFont)textElement, JRXlsExporter.this.getTextLocale(textElement));
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                public void handle(NumberTextValue textValue) {
                    if (textValue.getPattern() != null) {
                        baseStyle.setDataFormat(JRXlsExporter.this.dataFormat.getFormat(JRXlsExporter.this.getConvertedPattern(textValue.getPattern())));
                    }
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if (textValue.getValue() == null) {
                        JRXlsExporter.this.cell.setCellType(3);
                    } else {
                        JRXlsExporter.this.cell.setCellValue(textValue.getValue().doubleValue());
                        JRXlsExporter.this.cell.setCellType(0);
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                public void handle(DateTextValue textValue) {
                    baseStyle.setDataFormat(JRXlsExporter.this.dataFormat.getFormat(JRXlsExporter.this.getConvertedPattern(textValue.getPattern())));
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if (textValue.getValue() == null) {
                        JRXlsExporter.this.cell.setCellType(3);
                    } else {
                        JRXlsExporter.this.cell.setCellValue(textValue.getValue());
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                public void handle(BooleanTextValue textValue) {
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if (textValue.getValue() == null) {
                        JRXlsExporter.this.cell.setCellType(3);
                    } else {
                        JRXlsExporter.this.cell.setCellValue(textValue.getValue().booleanValue());
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }
            });
        } else if (this.isAutoDetectCellType) {
            cellStyle = this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
            try {
                this.cell.setCellValue(Double.parseDouble(textStr));
            }
            catch (NumberFormatException e) {
                if ("none".equals(textElement.getMarkup())) {
                    this.setStringCellValue(textStr);
                }
                this.setRichTextStringCellValue(styledText, forecolor, (JRFont)textElement, this.getTextLocale(textElement));
            }
            this.endCreateCell(cellStyle);
        } else {
            cellStyle = this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
            if ("none".equals(textElement.getMarkup())) {
                this.setStringCellValue(textStr);
            } else {
                this.setRichTextStringCellValue(styledText, forecolor, (JRFont)textElement, this.getTextLocale(textElement));
            }
            this.endCreateCell(cellStyle);
        }
        String anchorName = textElement.getAnchorName();
        if (anchorName != null) {
            HSSFName aName = this.workbook.createName();
            aName.setSheetIndex(this.workbook.getSheetIndex((Sheet)this.sheet));
            CellReference cRef = new CellReference(rowIndex, colIndex);
            aName.setRefersToFormula(cRef.formatAsString());
            this.anchorNames.put(anchorName, aName);
        }
        this.setHyperlinkCell((JRPrintHyperlink)textElement);
    }

    protected HSSFCellStyle initCreateCell(JRExporterGridCell gridCell, int colIndex, int rowIndex, StyleInfo baseStyle) {
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(baseStyle);
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell(colIndex);
        return cellStyle;
    }

    protected void endCreateCell(HSSFCellStyle cellStyle) {
        this.cell.setCellStyle(cellStyle);
    }

    protected final void setStringCellValue(String textStr) {
        this.cell.setCellValue((RichTextString)new HSSFRichTextString(textStr));
    }

    protected final void setRichTextStringCellValue(JRStyledText styledText, short forecolor, JRFont defaultFont, Locale locale) {
        if (styledText != null) {
            this.cell.setCellValue((RichTextString)this.getRichTextString(styledText, forecolor, defaultFont, locale));
        }
    }

    protected HSSFRichTextString getRichTextString(JRStyledText styledText, short forecolor, JRFont defaultFont, Locale locale) {
        String text = styledText.getText();
        HSSFRichTextString richTextStr = new HSSFRichTextString(text);
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            JRFont runFont = attributes.isEmpty() ? defaultFont : new JRBaseFont(attributes);
            short runForecolor = attributes.get(TextAttribute.FOREGROUND) != null ? JRXlsExporter.getNearestColor((Color)attributes.get(TextAttribute.FOREGROUND)).getIndex() : forecolor;
            HSSFFont font = this.getLoadedFont(runFont, runForecolor, attributes, locale);
            richTextStr.applyFont(iterator.getIndex(), runLimit, (Font)font);
            iterator.setIndex(runLimit);
        }
        return richTextStr;
    }

    protected void createMergeRegion(JRExporterGridCell gridCell, int colIndex, int rowIndex, HSSFCellStyle cellStyle) {
        int rowSpan;
        int n = rowSpan = this.isCollapseRowSpan ? 1 : gridCell.getRowSpan();
        if (gridCell.getColSpan() > 1 || rowSpan > 1) {
            this.sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex + rowSpan - 1, colIndex, colIndex + gridCell.getColSpan() - 1));
            for (int i = 0; i < rowSpan; ++i) {
                HSSFRow spanRow = this.sheet.getRow(rowIndex + i);
                if (spanRow == null) {
                    spanRow = this.sheet.createRow(rowIndex + i);
                }
                for (int j = 0; j < gridCell.getColSpan(); ++j) {
                    HSSFCell spanCell = spanRow.getCell(colIndex + j);
                    if (spanCell == null) {
                        spanCell = spanRow.createCell(colIndex + j);
                    }
                    spanCell.setCellStyle(cellStyle);
                }
            }
        }
    }

    private short getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.getHorizontalAlignment()) {
            case RIGHT: {
                return HorizontalAlignment.RIGHT.getCode();
            }
            case CENTER: {
                return HorizontalAlignment.CENTER.getCode();
            }
            case JUSTIFIED: {
                return HorizontalAlignment.JUSTIFY.getCode();
            }
        }
        return HorizontalAlignment.LEFT.getCode();
    }

    private short getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.getVerticalAlignment()) {
            case BOTTOM: {
                return VerticalAlignment.BOTTOM.getCode();
            }
            case MIDDLE: {
                return VerticalAlignment.CENTER.getCode();
            }
            case JUSTIFIED: {
                return VerticalAlignment.JUSTIFY.getCode();
            }
        }
        return VerticalAlignment.TOP.getCode();
    }

    private short getRotation(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.getRotation()) {
            case LEFT: {
                return 90;
            }
            case RIGHT: {
                return -90;
            }
        }
        return 0;
    }

    protected static HSSFColor getNearestColor(Color awtColor) {
        HSSFColor color = (HSSFColor)hssfColorsCache.get(awtColor);
        if (color == null) {
            Map triplets = HSSFColor.getTripletHash();
            if (triplets != null) {
                int minDiff = 999;
                int diff = 0;
                short[] rgb = null;
                HSSFColor crtColor = null;
                for (Map.Entry entr : triplets.entrySet()) {
                    crtColor = (HSSFColor)entr.getValue();
                    rgb = crtColor.getTriplet();
                    diff = Math.abs(rgb[0] - awtColor.getRed()) + Math.abs(rgb[1] - awtColor.getGreen()) + Math.abs(rgb[2] - awtColor.getBlue());
                    if (diff >= minDiff) continue;
                    minDiff = diff;
                    color = crtColor;
                }
            }
            hssfColorsCache.put(awtColor, color);
        }
        return color;
    }

    protected HSSFFont getLoadedFont(JRFont font, short forecolor, Map attributes, Locale locale) {
        HSSFFont cellFont = null;
        String fontName = font.getFontName();
        if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
            fontName = (String)this.fontMap.get(fontName);
        } else {
            FontFamily family;
            String exportFont;
            FontInfo fontInfo = JRFontUtil.getFontInfo((String)fontName, (Locale)locale);
            if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.getExporterKey())) != null) {
                fontName = exportFont;
            }
        }
        short superscriptType = 0;
        if (attributes != null && attributes.get(TextAttribute.SUPERSCRIPT) != null) {
            Object value = attributes.get(TextAttribute.SUPERSCRIPT);
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(value)) {
                superscriptType = 1;
            } else if (TextAttribute.SUPERSCRIPT_SUB.equals(value)) {
                superscriptType = 2;
            }
        }
        for (int i = 0; i < this.loadedFonts.size(); ++i) {
            boolean bol2;
            boolean bol1;
            HSSFFont cf = (HSSFFont)this.loadedFonts.get(i);
            short fontSize = (short)font.getFontSize();
            if (this.isFontSizeFixEnabled) {
                fontSize = (short)(fontSize - 1);
            }
            boolean bl = cf.getFontName().equals(fontName) && cf.getColor() == forecolor && cf.getFontHeightInPoints() == fontSize && (cf.getUnderline() == 1 ? font.isUnderline() : !font.isUnderline()) ? true : (bol1 = false);
            boolean bl2 = cf.getStrikeout() == font.isStrikeThrough() && (cf.getBold() ? font.isBold() : !font.isBold()) && cf.getItalic() == font.isItalic() && cf.getTypeOffset() == superscriptType ? true : (bol2 = false);
            if (!bol1 || !bol2) continue;
            cellFont = cf;
            break;
        }
        if (cellFont == null) {
            cellFont = this.workbook.createFont();
            cellFont.setFontName(fontName);
            cellFont.setColor(forecolor);
            short fontSize = (short)font.getFontSize();
            if (this.isFontSizeFixEnabled) {
                fontSize = (short)(fontSize - 1);
            }
            cellFont.setFontHeightInPoints(fontSize);
            if (font.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (font.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (font.isBold()) {
                cellFont.setBold(true);
            }
            if (font.isItalic()) {
                cellFont.setItalic(true);
            }
            cellFont.setTypeOffset(superscriptType);
            this.loadedFonts.add(cellFont);
        }
        return cellFont;
    }

    protected HSSFCellStyle getLoadedCellStyle(StyleInfo style) {
        HSSFCellStyle cellStyle = (HSSFCellStyle)this.loadedCellStyles.get(style);
        if (cellStyle == null) {
            cellStyle = this.workbook.createCellStyle();
            cellStyle.setFillForegroundColor(style.backcolor);
            cellStyle.setFillPattern(FillPatternType.forInt((int)style.mode));
            cellStyle.setAlignment(HorizontalAlignment.forInt((int)style.horizontalAlignment));
            cellStyle.setVerticalAlignment(VerticalAlignment.forInt((int)style.verticalAlignment));
            cellStyle.setRotation(style.rotation);
            cellStyle.setFont(style.font);
            cellStyle.setWrapText(style.wrapText);
            if (style.hasDataFormat()) {
                cellStyle.setDataFormat(style.getDataFormat());
            }
            if (!this.isIgnoreCellBorder) {
                BoxStyle box = style.box;
                cellStyle.setBorderTop(BorderStyle.valueOf((short)box.borderStyle[0]));
                cellStyle.setTopBorderColor(box.borderColour[0]);
                cellStyle.setBorderLeft(BorderStyle.valueOf((short)box.borderStyle[1]));
                cellStyle.setLeftBorderColor(box.borderColour[1]);
                cellStyle.setBorderBottom(BorderStyle.valueOf((short)box.borderStyle[2]));
                cellStyle.setBottomBorderColor(box.borderColour[2]);
                cellStyle.setBorderRight(BorderStyle.valueOf((short)box.borderStyle[3]));
                cellStyle.setRightBorderColor(box.borderColour[3]);
            }
            this.loadedCellStyles.put(style, cellStyle);
        }
        return cellStyle;
    }

    protected HSSFCellStyle getLoadedCellStyle(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell) {
        StyleInfo style = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, gridCell);
        return this.getLoadedCellStyle(style);
    }

    protected HSSFCellStyle getLoadedCellStyle(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box) {
        StyleInfo style = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box);
        return this.getLoadedCellStyle(style);
    }

    protected static short getBorderStyle(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            switch (pen.getLineStyleValue()) {
                case DOUBLE: {
                    return BorderStyle.DOUBLE.getCode();
                }
                case DOTTED: {
                    return BorderStyle.DOTTED.getCode();
                }
                case DASHED: {
                    if (lineWidth >= 1.0f) {
                        return BorderStyle.MEDIUM_DASHED.getCode();
                    }
                    return BorderStyle.DASHED.getCode();
                }
            }
            if (lineWidth >= 2.0f) {
                return BorderStyle.THICK.getCode();
            }
            if (lineWidth >= 1.0f) {
                return BorderStyle.MEDIUM.getCode();
            }
            if (lineWidth >= 0.5f) {
                return BorderStyle.THIN.getCode();
            }
            return BorderStyle.HAIR.getCode();
        }
        return BorderStyle.NONE.getCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exportImage(JRPrintImage element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols) throws JRException {
        try {
            int topPadding = Math.max(element.getLineBox().getTopPadding(), this.getImageBorderCorrection((JRPen)element.getLineBox().getTopPen()));
            int leftPadding = Math.max(element.getLineBox().getLeftPadding(), this.getImageBorderCorrection((JRPen)element.getLineBox().getLeftPen()));
            int bottomPadding = Math.max(element.getLineBox().getBottomPadding(), this.getImageBorderCorrection((JRPen)element.getLineBox().getBottomPen()));
            int rightPadding = Math.max(element.getLineBox().getRightPadding(), this.getImageBorderCorrection((JRPen)element.getLineBox().getRightPen()));
            int availableImageWidth = element.getWidth() - leftPadding - rightPadding;
            availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
            int availableImageHeight = element.getHeight() - topPadding - bottomPadding;
            availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
            JRRenderable renderer = element.getRenderer();
            if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
                if (renderer.getType() == 0 && (renderer = JRImageRenderer.getOnErrorRendererForImageData((JRRenderable)renderer, (OnErrorTypeEnum)element.getOnErrorTypeValue())) != null) {
                    renderer = JRImageRenderer.getOnErrorRendererForDimension((JRRenderable)renderer, (OnErrorTypeEnum)element.getOnErrorTypeValue());
                }
            } else {
                renderer = null;
            }
            if (renderer != null) {
                int normalWidth = availableImageWidth;
                int normalHeight = availableImageHeight;
                Dimension2D dimension = renderer.getDimension();
                if (dimension != null) {
                    normalWidth = (int)dimension.getWidth();
                    normalHeight = (int)dimension.getHeight();
                }
                float xalignFactor = 0.0f;
                switch (element.getHorizontalAlignmentValue()) {
                    case RIGHT: {
                        xalignFactor = 1.0f;
                        break;
                    }
                    case CENTER: {
                        xalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        xalignFactor = 0.0f;
                    }
                }
                float yalignFactor = 0.0f;
                switch (element.getVerticalAlignmentValue()) {
                    case BOTTOM: {
                        yalignFactor = 1.0f;
                        break;
                    }
                    case MIDDLE: {
                        yalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        yalignFactor = 0.0f;
                    }
                }
                BufferedImage bi = new BufferedImage(element.getWidth(), element.getHeight(), 2);
                Graphics2D grx = bi.createGraphics();
                switch (element.getScaleImageValue()) {
                    case CLIP: {
                        int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                        int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                        Shape oldClipShape = grx.getClip();
                        grx.clip(new Rectangle(leftPadding, topPadding, availableImageWidth, availableImageHeight));
                        try {
                            renderer.render(grx, (Rectangle2D)new Rectangle(xoffset + leftPadding, yoffset + topPadding, normalWidth, normalHeight));
                            break;
                        }
                        finally {
                            grx.setClip(oldClipShape);
                        }
                    }
                    case FILL_FRAME: {
                        renderer.render(grx, (Rectangle2D)new Rectangle(leftPadding, topPadding, availableImageWidth, availableImageHeight));
                        break;
                    }
                    default: {
                        if (element.getHeight() <= 0) break;
                        double ratio = (double)normalWidth / (double)normalHeight;
                        if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                            normalWidth = availableImageWidth;
                            normalHeight = (int)((double)availableImageWidth / ratio);
                        } else {
                            normalWidth = (int)((double)availableImageHeight * ratio);
                            normalHeight = availableImageHeight;
                        }
                        int xoffset = leftPadding + (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                        int yoffset = topPadding + (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                        renderer.render(grx, (Rectangle2D)new Rectangle(xoffset, yoffset, normalWidth, normalHeight));
                    }
                }
                short mode = this.backgroundMode;
                short backcolor = this.whiteIndex;
                if (!this.isIgnoreCellBackground && gridCell.getCellBackcolor() != null) {
                    mode = 1;
                    backcolor = JRXlsExporter.getNearestColor(gridCell.getCellBackcolor()).getIndex();
                }
                short forecolor = JRXlsExporter.getNearestColor(element.getLineBox().getPen().getLineColor()).getIndex();
                if (element.getModeValue() == ModeEnum.OPAQUE) {
                    backcolor = JRXlsExporter.getNearestColor(element.getBackcolor()).getIndex();
                }
                HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, HorizontalAlignment.LEFT.getCode(), VerticalAlignment.TOP.getCode(), (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), gridCell);
                this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
                this.cell = this.row.createCell(colIndex);
                this.cell.setCellStyle(cellStyle);
                HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)colIndex, rowIndex, (short)(colIndex + gridCell.getColSpan()), rowIndex + (this.isCollapseRowSpan ? 1 : gridCell.getRowSpan()));
                int imgIndex = this.workbook.addPicture(JRImageLoader.loadImageDataFromAWTImage((Image)bi, (byte)3), 6);
                this.patriarch.createPicture(anchor, imgIndex);
            }
        }
        catch (Exception ex) {
            throw new JRException("The cell cannot be added", (Throwable)ex);
        }
        catch (Error err) {
            throw new JRException("The cell cannot be added", (Throwable)err);
        }
    }

    @Override
    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell, int x, int y) {
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (frame.getModeValue() == ModeEnum.OPAQUE) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(frame.getBackcolor()).getIndex();
        }
        short forecolor = JRXlsExporter.getNearestColor(frame.getForecolor()).getIndex();
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, HorizontalAlignment.LEFT.getCode(), VerticalAlignment.TOP.getCode(), (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), gridCell);
        this.createMergeRegion(gridCell, x, y, cellStyle);
        this.cell = this.row.createCell(x);
        this.cell.setCellStyle(cellStyle);
    }

    @Override
    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols) throws JRException {
        GenericElementXlsHandler handler = (GenericElementXlsHandler)GenericElementHandlerEnviroment.getHandler((JRGenericElementType)element.getGenericType(), (String)XLS_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement(this.exporterContext, element, gridCell, colIndex, rowIndex);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"No XLS generic element handler");
        }
    }

    @Override
    protected ExporterNature getNature() {
        return this.nature;
    }

    private String getConvertedPattern(String pattern) {
        if (this.formatPatternsMap != null && this.formatPatternsMap.containsKey(pattern)) {
            return (String)this.formatPatternsMap.get(pattern);
        }
        return pattern;
    }

    private final short getSuitablePaperSize(JasperPrint jasP) {
        if (jasP == null) {
            return -1;
        }
        long width = 0L;
        long height = 0L;
        int ps = -1;
        if (jasP.getPageWidth() != 0 && jasP.getPageHeight() != 0) {
            double dWidth = (double)jasP.getPageWidth() / 72.0;
            double dHeight = (double)jasP.getPageHeight() / 72.0;
            height = Math.round(dHeight * 25.4);
            width = Math.round(dWidth * 25.4);
            for (int i = 4; i < 6; ++i) {
                int w = this.calculateWidthForDinAN(i);
                int h = this.calculateHeightForDinAN(i);
                if (((long)w != width || (long)h != height) && ((long)h != width || (long)w != height)) continue;
                if (i == 4) {
                    ps = 9;
                    break;
                }
                if (i != 5) break;
                ps = 11;
                break;
            }
            if (ps == -1 && (width == 110L && height == 220L || width == 220L && height == 110L)) {
                ps = 27;
            }
            if (ps == -1) {
                if (width == 216L && height == 279L || width == 279L && height == 216L) {
                    ps = 1;
                }
                if (width == 216L && height == 356L || width == 356L && height == 216L) {
                    ps = 5;
                } else if (width == 190L && height == 254L || width == 254L && height == 190L) {
                    ps = 7;
                }
            }
        }
        return (short)ps;
    }

    protected void setHyperlinkCell(JRPrintHyperlink hyperlink) {
        String href = null;
        Hyperlink link = null;
        JRHyperlinkProducer customHandler = this.getHyperlinkProducer(hyperlink);
        if (customHandler == null) {
            switch (hyperlink.getHyperlinkTypeValue()) {
                case REFERENCE: {
                    href = hyperlink.getHyperlinkReference();
                    if (href == null) break;
                    link = this.createHelper.createHyperlink(HyperlinkType.URL);
                    link.setAddress(href);
                    break;
                }
                case LOCAL_ANCHOR: {
                    href = hyperlink.getHyperlinkAnchor();
                    if (href == null) break;
                    link = this.createHelper.createHyperlink(HyperlinkType.DOCUMENT);
                    if (this.anchorLinks.containsKey(href)) {
                        ((List)this.anchorLinks.get(href)).add(link);
                        break;
                    }
                    ArrayList<Hyperlink> hrefList = new ArrayList<Hyperlink>();
                    hrefList.add(link);
                    this.anchorLinks.put(href, hrefList);
                    break;
                }
                case LOCAL_PAGE: {
                    Integer hrefPage = hyperlink.getHyperlinkPage();
                    if (hrefPage == null) break;
                    link = this.createHelper.createHyperlink(HyperlinkType.DOCUMENT);
                    if (this.pageLinks.containsKey(hrefPage)) {
                        this.pageLinks.get(hrefPage).add(link);
                        break;
                    }
                    ArrayList<Hyperlink> hrefList = new ArrayList<Hyperlink>();
                    hrefList.add(link);
                    this.pageLinks.put(hrefPage, hrefList);
                    break;
                }
                case REMOTE_ANCHOR: {
                    href = hyperlink.getHyperlinkReference();
                    if (href == null || hyperlink.getHyperlinkAnchor() == null) break;
                    href = href + "#" + hyperlink.getHyperlinkAnchor();
                    link = this.createHelper.createHyperlink(HyperlinkType.FILE);
                    link.setAddress(href);
                    break;
                }
                case REMOTE_PAGE: {
                    href = hyperlink.getHyperlinkReference();
                    if (href == null || hyperlink.getHyperlinkPage() == null) break;
                    href = href + "#JR_PAGE_ANCHOR_0_" + hyperlink.getHyperlinkPage().toString();
                    link = this.createHelper.createHyperlink(HyperlinkType.FILE);
                    link.setAddress(href);
                    break;
                }
            }
            if (link != null) {
                this.cell.setHyperlink(link);
            }
        }
    }

    protected String getExporterKey() {
        return XLS_EXPORTER_KEY;
    }

    public HSSFCell getCell() {
        return this.cell;
    }

    public HSSFDataFormat getDataFormat() {
        return this.dataFormat;
    }

    protected static class StyleInfo {
        protected final short mode;
        protected final short backcolor;
        protected final short horizontalAlignment;
        protected final short verticalAlignment;
        protected final short rotation;
        protected final HSSFFont font;
        protected final BoxStyle box;
        protected final boolean wrapText;
        private short dataFormat = (short)-1;
        private int hashCodeNew;

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, new BoxStyle(gridCell), true);
        }

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell, boolean wrapText) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, new BoxStyle(gridCell), wrapText);
        }

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box) {
            this(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box, true);
        }

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, BoxStyle box, boolean wrapText) {
            this.mode = mode;
            this.backcolor = backcolor;
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
            this.font = font;
            this.box = box;
            this.wrapText = wrapText;
            this.hashCodeNew = this.computeHash();
        }

        protected int computeHash() {
            int hash = this.mode;
            hash = 31 * hash + this.backcolor;
            hash = 31 * hash + this.horizontalAlignment;
            hash = 31 * hash + this.verticalAlignment;
            hash = 31 * hash + this.rotation;
            hash = 31 * hash + (this.font == null ? 0 : (int)this.font.getIndex());
            hash = 31 * hash + (this.box == null ? 0 : this.box.hashCode());
            hash = 31 * hash + this.dataFormat;
            hash = 31 * hash + (this.wrapText ? 0 : 1);
            return hash;
        }

        public void setDataFormat(short dataFormat) {
            this.dataFormat = dataFormat;
            this.hashCodeNew = this.computeHash();
        }

        public boolean hasDataFormat() {
            return this.dataFormat != -1;
        }

        public short getDataFormat() {
            return this.dataFormat;
        }

        public int hashCode() {
            return this.hashCodeNew;
        }

        public boolean equals(Object o) {
            if (o instanceof StyleInfo) {
                StyleInfo s = (StyleInfo)o;
                return s.mode == this.mode && s.backcolor == this.backcolor && s.horizontalAlignment == this.horizontalAlignment && s.verticalAlignment == this.verticalAlignment && s.rotation == this.rotation && (s.font == null ? this.font == null : this.font != null && s.font.getIndex() == this.font.getIndex()) && (s.box == null ? this.box == null : this.box != null && s.box.equals(this.box)) && s.rotation == this.rotation && s.wrapText == this.wrapText;
            }
            return false;
        }

        public String toString() {
            return "(" + this.mode + "," + this.backcolor + "," + this.horizontalAlignment + "," + this.verticalAlignment + "," + this.rotation + "," + this.font + "," + this.box + "," + this.dataFormat + "," + this.wrapText + ")";
        }
    }

    protected static class BoxStyle {
        protected static final int TOP = 0;
        protected static final int LEFT = 1;
        protected static final int BOTTOM = 2;
        protected static final int RIGHT = 3;
        protected short[] borderStyle = new short[4];
        protected short[] borderColour = new short[4];
        private int hash;

        public BoxStyle(int side, JRPen pen) {
            this.borderStyle[side] = JRXlsExporter.getBorderStyle(pen);
            this.borderColour[side] = JRXlsExporter.getNearestColor(pen.getLineColor()).getIndex();
            this.hash = this.computeHash();
        }

        public BoxStyle(JRExporterGridCell gridCell) {
            JRPrintElement element;
            JRLineBox lineBox = gridCell.getBox();
            if (lineBox != null) {
                this.setBox(lineBox);
            }
            if ((element = gridCell.getElement()) instanceof JRCommonGraphicElement) {
                this.setPen(((JRCommonGraphicElement)element).getLinePen());
            }
            this.hash = this.computeHash();
        }

        public void setBox(JRLineBox box) {
            this.borderStyle[0] = JRXlsExporter.getBorderStyle((JRPen)box.getTopPen());
            this.borderColour[0] = JRXlsExporter.getNearestColor(box.getTopPen().getLineColor()).getIndex();
            this.borderStyle[2] = JRXlsExporter.getBorderStyle((JRPen)box.getBottomPen());
            this.borderColour[2] = JRXlsExporter.getNearestColor(box.getBottomPen().getLineColor()).getIndex();
            this.borderStyle[1] = JRXlsExporter.getBorderStyle((JRPen)box.getLeftPen());
            this.borderColour[1] = JRXlsExporter.getNearestColor(box.getLeftPen().getLineColor()).getIndex();
            this.borderStyle[3] = JRXlsExporter.getBorderStyle((JRPen)box.getRightPen());
            this.borderColour[3] = JRXlsExporter.getNearestColor(box.getRightPen().getLineColor()).getIndex();
            this.hash = this.computeHash();
        }

        public void setPen(JRPen pen) {
            if (this.borderStyle[0] == BorderStyle.NONE.getCode() && this.borderStyle[1] == BorderStyle.NONE.getCode() && this.borderStyle[2] == BorderStyle.NONE.getCode() && this.borderStyle[3] == BorderStyle.NONE.getCode()) {
                short style = JRXlsExporter.getBorderStyle(pen);
                short colour = JRXlsExporter.getNearestColor(pen.getLineColor()).getIndex();
                this.borderStyle[0] = style;
                this.borderStyle[2] = style;
                this.borderStyle[1] = style;
                this.borderStyle[3] = style;
                this.borderColour[0] = colour;
                this.borderColour[2] = colour;
                this.borderColour[1] = colour;
                this.borderColour[3] = colour;
            }
            this.hash = this.computeHash();
        }

        private int computeHash() {
            int hashCode = this.borderStyle[0];
            hashCode = 31 * hashCode + this.borderColour[0];
            hashCode = 31 * hashCode + this.borderStyle[2];
            hashCode = 31 * hashCode + this.borderColour[2];
            hashCode = 31 * hashCode + this.borderStyle[1];
            hashCode = 31 * hashCode + this.borderColour[1];
            hashCode = 31 * hashCode + this.borderStyle[3];
            hashCode = 31 * hashCode + this.borderColour[3];
            return hashCode;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o instanceof BoxStyle) {
                BoxStyle b = (BoxStyle)o;
                return b.borderStyle[0] == this.borderStyle[0] && b.borderColour[0] == this.borderColour[0] && b.borderStyle[2] == this.borderStyle[2] && b.borderColour[2] == this.borderColour[2] && b.borderStyle[1] == this.borderStyle[1] && b.borderColour[1] == this.borderColour[1] && b.borderStyle[3] == this.borderStyle[3] && b.borderColour[3] == this.borderColour[3];
            }
            return false;
        }

        public String toString() {
            return "(" + this.borderStyle[0] + "/" + this.borderColour[0] + "," + this.borderStyle[2] + "/" + this.borderColour[2] + "," + this.borderStyle[1] + "/" + this.borderColour[1] + "," + this.borderStyle[3] + "/" + this.borderColour[3] + ")";
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRXlsExporterContext {
        protected ExporterContext() {
            super((JRAbstractExporter)JRXlsExporter.this);
        }

        public String getExportPropertiesPrefix() {
            return "net.sf.jasperreports.export.xls.";
        }
    }
}

