/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.jasperreports;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRSubreportRunResult;
import net.sf.jasperreports.engine.fill.JRSubreportRunnable;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;
import net.sf.jasperreports.engine.fill.JRThreadSubreportRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyJRThreadSubreportRunner
extends JRSubreportRunnable
implements JRSubreportRunner {
    public static final ThreadLocal<String> EXPORT_TYPE_THREAD_LOCAL = new ThreadLocal();
    private static final Log LOG = LogFactory.getLog(JRThreadSubreportRunner.class);
    String exportType;
    private final JRBaseFiller subreportFiller;
    private Thread fillThread;

    public MyJRThreadSubreportRunner(JRFillSubreport fillSubreport, JRBaseFiller subreportFiller) {
        super(fillSubreport);
        this.subreportFiller = subreportFiller;
    }

    public boolean isFilling() {
        return this.fillThread != null;
    }

    public JRSubreportRunResult start() {
        this.fillThread = new Thread((Runnable)((Object)this), this.subreportFiller.getJasperReport().getName() + " subreport filler");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fill starting thread " + this.fillThread));
        }
        this.fillThread.start();
        return this.waitResult();
    }

    public JRSubreportRunResult resume() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Fill notifying to continue");
        }
        this.subreportFiller.notifyAll();
        return this.waitResult();
    }

    protected JRSubreportRunResult waitResult() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Fill waiting for fill result");
        }
        try {
            this.subreportFiller.wait();
        }
        catch (InterruptedException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Fill exception", (Throwable)e);
            }
            throw new JRRuntimeException("Error encountered while waiting on the report filling thread.", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Fill notified of fill result");
        }
        return this.runResult();
    }

    public void reset() {
        this.fillThread = null;
    }

    public void cancel() throws JRException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Fill notifying to continue on cancel");
        }
        this.subreportFiller.notifyAll();
        if (this.isRunning()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Fill still running, waiting");
            }
            try {
                this.subreportFiller.wait();
            }
            catch (InterruptedException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Fill exception", (Throwable)e);
                }
                throw new JRException("Error encountered while waiting on the subreport filling thread.", (Throwable)e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Fill wait ended");
            }
        }
    }

    public void suspend() throws JRException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Fill notifying on suspend");
        }
        this.subreportFiller.notifyAll();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Fill waiting to continue");
        }
        try {
            this.subreportFiller.wait();
        }
        catch (InterruptedException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Fill exception", (Throwable)e);
            }
            throw new JRException("Error encountered while waiting on the subreport filling thread.", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Fill notified to continue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        EXPORT_TYPE_THREAD_LOCAL.set(this.exportType);
        super.run();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Fill notifying of completion");
        }
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            this.subreportFiller.notifyAll();
        }
    }
}

