/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.service.impl;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.model.vo.TaskCondition;
import com.security.ireport.model.vo.TimeTask;
import com.security.ireport.service.TimeTaskService;
import com.security.ireport.task.IRTimeTaskMgr;
import com.security.ireport.util.DBConnPool;
import com.security.ireport.util.ProductFaceUtil;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractTimeService
implements TimeTaskService {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    @Override
    public String updateTimeTaskByAction(TimeTask timeTask, List<TaskCondition> taskConditionList) throws SQLException {
        if (this.checkNameWithId(timeTask.getTaskId(), timeTask.getTaskName())) {
            return "error";
        }
        try (ProductFaceUtil.ConnWrapper connWrapper = ProductFaceUtil.getInstance().getConnWrapper();){
            connWrapper.setCommit(false);
            this.updateTimeTaskTransfer(timeTask, connWrapper);
            this.delTaskConditionTransfer(timeTask.getTaskId(), connWrapper);
            this.addTaskConditionTransfer(taskConditionList, connWrapper);
            connWrapper.commit();
            String string = null;
            return string;
        }
    }

    protected boolean checkNameWithId(Integer id, String taskName) {
        boolean flag = false;
        String sql = "SELECT COUNT(0) FROM IREPORT_TASK WHERE TASK_NAME=? AND PKID !=?";
        Object[] psSqlArgs = new Object[]{taskName, id};
        int countNum = DBConnPool.findCount(sql, psSqlArgs);
        if (countNum != 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    public String updateTimeTaskTransfer(TimeTask timeTask, ProductFaceUtil.ConnWrapper connWrapper) throws SQLException {
        String sql = "UPDATE IREPORT_TASK  SET START_DATE=?,END_DATE=?,TASK_DESC=?,RUN_TIMING=?,TASK_NAME=?,SCHEDULE=?,STATISTIC_TIME=?,USERNAME=?,RESULT_TYPE=?,STATE=? WHERE PKID=?";
        Object[] psSqlArgs = new Object[]{String.valueOf(timeTask.getStartDate()), String.valueOf(timeTask.getEndDate()), timeTask.getTaskDesc(), timeTask.getRunTime(), timeTask.getTaskName(), timeTask.getSchedule(), timeTask.getStatisticTime(), timeTask.getUserName(), timeTask.getResultType(), timeTask.getLocale(), String.valueOf(timeTask.getState()), timeTask.getTaskId()};
        DBConnPool.update(sql, psSqlArgs);
        return null;
    }

    @Override
    public Object delTaskConditionTransfer(Integer taskId, ProductFaceUtil.ConnWrapper connWrapper) throws SQLException {
        String sql = "DELETE FROM IREPORT_TASK_CONDITION WHERE TASK_ID=?";
        Object[] psSqlArgs = new Object[]{String.valueOf(taskId)};
        DBConnPool.delete(sql, psSqlArgs);
        IRTimeTaskMgr.getInstance().delTimeTask(taskId);
        return null;
    }

    @Override
    public Object addTaskConditionTransfer(List<TaskCondition> taskCondtionList, ProductFaceUtil.ConnWrapper connWrapper) throws SQLException {
        String sql = "INSERT INTO IREPORT_TASK_CONDITION(TASK_ID,TEMPLATE_ID,REPORT_ID,REPORT_CONDITION) VALUES(?,?,?,?)";
        for (TaskCondition item : taskCondtionList) {
            Object[] psSqlArgs = new Object[]{String.valueOf(item.getTaskId()), String.valueOf(item.getTemplateId()), item.getReportId(), item.getReportCondition()};
            DBConnPool.save(sql, psSqlArgs);
        }
        return null;
    }
}

