/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.service.impl;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.opensymphony.xwork2.ActionContext;
import com.security.ireport.engine.BaseException;
import com.security.ireport.engine.PluginManager;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.model.vo.BackTask;
import com.security.ireport.model.vo.ReportPlugVO;
import com.security.ireport.model.vo.SysOptLog;
import com.security.ireport.model.vo.UserInfo;
import com.security.ireport.service.IReportProductAdapter;
import com.security.ireport.service.impl.BackTaskServiceImpl;
import com.security.ireport.util.CreateReportSessionId;
import com.security.ireport.util.IReportLogManager;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.logserver.module.condition.model.TreeNode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IReportProductAdapterImpl
extends IReportProductAdapter {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private final Locale defaultLocale = Locale.SIMPLIFIED_CHINESE;

    @Override
    public boolean addReportMenu(ReportPlugVO report) {
        return true;
    }

    @Override
    public boolean delReportMenu(ReportPlugVO report) {
        return true;
    }

    @Override
    public TreeNode getMenuNode(String userName) {
        TreeNode root = new TreeNode();
        root.setKey("0");
        root.setTitle(LocaleUtil.getProperty("report.add"));
        root.setValue("0");
        root.setLevel(0);
        ArrayList<TreeNode> reportNodeList = new ArrayList<TreeNode>();
        ArrayList<TreeNode> reportTemp = new ArrayList<TreeNode>();
        ConcurrentHashMap<String, IReport> reportList = PluginManager.getInstance().getReportPluginList();
        String rptId = "";
        String rptName = "";
        String nodeKey = "";
        for (Map.Entry<String, IReport> item : reportList.entrySet()) {
            rptId = item.getKey();
            rptName = item.getValue().getName();
            nodeKey = item.getValue().getId();
            Locale locale = LocaleUtil.getCurrentUserLocale();
            String name = IReportUtil.getProperty(rptName, rptId, locale);
            reportTemp.add(new TreeNode(nodeKey, name + "(" + rptId + ")", rptId, null, 2, true));
        }
        reportNodeList.add(new TreeNode("100", LocaleUtil.getProperty("report.plugin"), "100", reportTemp, 1, false));
        root.setChildren(reportNodeList);
        return root;
    }

    @Override
    public Locale getUserLocale() {
        ActionContext actionContext = ActionContext.getContext();
        if (null == actionContext) {
            return this.defaultLocale;
        }
        Locale locale = actionContext.getLocale();
        if (null == locale) {
            locale = this.defaultLocale;
        }
        return locale;
    }

    @Override
    public String getUserName() {
        return "admin";
    }

    @Override
    public boolean isBusinessException(Exception e) {
        boolean flag = false;
        if (e instanceof BaseException) {
            flag = true;
        }
        return flag;
    }

    @Override
    public void throwException(String message, String level, Throwable inThrowable) {
        throw new BaseException(message, level, inThrowable);
    }

    @Override
    public long getSessionId() {
        return CreateReportSessionId.getNextSessionId();
    }

    @Override
    public UserInfo getUserInfo() {
        return new UserInfo();
    }

    @Override
    public long addBackTask(BackTask backTask, long reportSessionId) {
        try {
            BackTaskServiceImpl service = new BackTaskServiceImpl();
            return service.addBackTask(backTask);
        }
        catch (Exception e) {
            LOGGER.error((Object)"addBackTask failed.", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public void setBaskTaskIsPrepare(long backTaskId) {
        String operationObj = "";
        try {
            BackTaskServiceImpl service = new BackTaskServiceImpl();
            BackTask backTask = service.getBackTask(backTaskId + "");
            if (null == backTask) {
                return;
            }
            Date startDate = new Date(backTask.getCreateDate() * 1000L);
            SimpleDateFormat smpDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String startDateStr = smpDateFormat.format(startDate);
            operationObj = "reportName:" + backTask.getReportName() + " createTime:" + startDateStr;
            service.changeFieldValue(backTaskId, "STATE", "1");
            service.changeFieldValue(backTaskId, "END_DATE", String.valueOf(System.currentTimeMillis()));
            IReportLogManager.getInstance().printSysLog(new SysOptLog(LocaleUtil.getProperty("backTask.manager"), LocaleUtil.getProperty("backTask.log.edit"), operationObj + " ", LocaleUtil.getProperty("backTask.log.edit") + " " + LocaleUtil.getProperty("backTask.log.success") + " " + operationObj));
        }
        catch (Exception e) {
            IReportLogManager.getInstance().printSysLog(new SysOptLog(LocaleUtil.getProperty("backTask.manager"), LocaleUtil.getProperty("backTask.log.edit"), operationObj + "", 1, LocaleUtil.getProperty("backTask.log.edit") + " " + LocaleUtil.getProperty("backTask.log.failed") + e.toString()));
            LOGGER.error((Object)e);
        }
    }
}

