/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.service.impl;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.model.vo.ReportPlugVO;
import com.security.ireport.service.IReportLoader;
import com.security.ireport.util.IReportUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public final class ReportLoader
implements IReportLoader {
    private static final String PATH_REPORT_URL_LIST = "/iReport/iReportBiz/config/publishReport.properties";
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static ReportLoader mOInstance = new ReportLoader();

    private ReportLoader() {
    }

    public static ReportLoader getInstance() {
        return mOInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addReport(ReportPlugVO report) {
        FileInputStream inStream = null;
        OutputStream os = null;
        Properties properties = new Properties();
        String fileName = IReportUtil.getRealPath() + PATH_REPORT_URL_LIST;
        try {
            String reportId = report.getReportId();
            inStream = new FileInputStream(fileName);
            properties.load(inStream);
            properties.put(reportId, report.getUrl());
            os = new FileOutputStream(fileName);
            properties.store(os, reportId);
            os.flush();
            return true;
        }
        catch (IOException e) {
            LOGGER.error((Object)"load param.properties error", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Close param.properties error", (Throwable)e);
            }
            finally {
                try {
                    if (null != inStream) {
                        ((InputStream)inStream).close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Close param.properties error", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delReport(String reportId) {
        FileInputStream inStream = null;
        OutputStream os = null;
        Properties properties = new Properties();
        String fileName = IReportUtil.getRealPath() + PATH_REPORT_URL_LIST;
        try {
            inStream = new FileInputStream(fileName);
            properties.load(inStream);
            properties.remove(reportId);
            os = new FileOutputStream(fileName);
            properties.store(os, reportId);
            os.flush();
            return true;
        }
        catch (IOException e) {
            LOGGER.error((Object)"load param.properties error", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Close param.properties error", (Throwable)e);
            }
            finally {
                try {
                    if (null != inStream) {
                        ((InputStream)inStream).close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Close param.properties error", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean delReport(ReportPlugVO report) {
        return false;
    }
}

