/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.task;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.IReportParse;
import com.security.ireport.engine.PluginManager;
import com.security.ireport.task.IRTimeTaskMgr;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class IReportListener
implements ServletContextListener {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    public void contextDestroyed(ServletContextEvent arg0) {
        if (!IRTimeTaskMgr.getInstance().destroyTimeTaskThread()) {
            LOGGER.error((Object)"Destroy time task failed...");
        } else {
            LOGGER.info((Object)"Destroy time task OK...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent arg0) {
        InputStream ins = null;
        try {
            System.setProperty("net.sf.jasperreports.properties", "ireport_default.jasperreports.properties");
            ins = IReportListener.class.getResourceAsStream("/reportConfig.properties");
            Properties prop = new Properties();
            prop.load(ins);
            if (prop.containsKey("webapp.path")) {
                IReportUtil.setRealPath(prop.get("webapp.path").toString());
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"webapp.path is not read from reportConfig.properties");
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"webapp.path is not read from reportConfig.properties");
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Error to close ins.", (Throwable)e);
                }
            }
        }
        try {
            IReportUtil.cleanIReportTempImage();
            ServletContext sContext = arg0.getServletContext();
            IReportConfigUtil ireportConfig = IReportConfigUtil.getInstance();
            String extConfig = ireportConfig.getIReportExtConfig();
            sContext.setAttribute("IREPORT_EXT", (Object)extConfig);
            String ireportDebug = ireportConfig.getConfig("ireport.debug");
            sContext.setAttribute("_IREPORT_DEBUG_", (Object)ireportDebug);
            String ireportStyle = ireportConfig.getConfig("ireport.style");
            sContext.setAttribute("_IREPORT_STYLE_", (Object)ireportStyle);
            String queryPosition = ireportConfig.getConfig("report.product.queryButton.position");
            if ("center".equals(queryPosition)) {
                sContext.setAttribute("_IREPORT_DISPLAY_STYLE_", (Object)queryPosition);
            } else if ("left".equals(queryPosition)) {
                sContext.setAttribute("_IREPORT_DISPLAY_STYLE_", (Object)queryPosition);
            } else {
                sContext.setAttribute("_IREPORT_DISPLAY_STYLE_", (Object)"right");
            }
            PluginManager.getInstance();
            IReportParse.getInstance();
            LOGGER.info((Object)"contextInitialized success.");
        }
        catch (Exception e) {
            LOGGER.error((Object)"contextInitialized failed", (Throwable)e);
        }
    }
}

