/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.task;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.task.adapter.AbstractTimerNameAdapter;
import com.security.ireport.util.IReportMgrUtil;
import com.security.ireport.util.LocaleUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class VsmTimerNameAdapter
extends AbstractTimerNameAdapter {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    @Override
    public String productTimeName(Locale locale, int schedule, Calendar cal, Map<String, JsonValueObj> jsonCond) {
        StringBuilder resultBuilder = new StringBuilder();
        switch (schedule) {
            case 1: {
                resultBuilder.append(LocaleUtil.getProperty("ireport.daily.report", locale));
                break;
            }
            case 2: {
                resultBuilder.append(LocaleUtil.getProperty("ireport.weekly.report", locale));
                break;
            }
            case 3: {
                resultBuilder.append(LocaleUtil.getProperty("ireport.monthly.report", locale));
                break;
            }
            case 4: {
                resultBuilder.append(LocaleUtil.getProperty("ireport.yearly.report", locale));
                break;
            }
            default: {
                LOGGER.error((Object)("TimeTask execute schedule error:" + schedule));
            }
        }
        SimpleDateFormat smpDateFormat = new SimpleDateFormat("yyyyMMdd");
        List<JsonValueItem> jsonValueItem = IReportMgrUtil.getTaskDateScope(schedule, cal);
        Date dateStart = new Date(Long.parseLong(jsonValueItem.get(0).getValue()) * 1000L);
        Date dateEnd = new Date(Long.parseLong(jsonValueItem.get(1).getValue()) * 1000L);
        if (schedule == 1) {
            resultBuilder.append(smpDateFormat.format(dateStart));
        } else {
            resultBuilder.append(smpDateFormat.format(dateStart));
            resultBuilder.append('_');
            resultBuilder.append(smpDateFormat.format(dateEnd));
        }
        return resultBuilder.toString();
    }
}

