/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.service.IHandleResultSet;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.ProductFaceUtil;
import com.security.ireport.util.SqlUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class DBConnPool {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    private DBConnPool() {
    }

    private static void setParameter(int index, PreparedStatement ps, Object param) throws SQLException {
        if ("null".equals(String.valueOf(param))) {
            ps.setObject(index, null);
            return;
        }
        if (param instanceof Object[]) {
            Object[] params = (Object[])param;
            int aryIndex = index;
            for (int i = 0; i < params.length; ++i) {
                DBConnPool.setParameter(aryIndex + i, ps, params[i]);
            }
        } else if (param instanceof String) {
            ps.setString(index, String.valueOf(param));
        } else if (param instanceof Integer) {
            ps.setInt(index, Integer.parseInt(param.toString()));
        } else if (param instanceof Long) {
            ps.setLong(index, Long.parseLong(param.toString()));
        } else if (param instanceof Double) {
            ps.setDouble(index, Double.valueOf(param.toString()));
        } else if (param instanceof Character) {
            ps.setString(index, String.valueOf(param));
        } else {
            ps.setObject(index, param);
        }
    }

    private static void closeAll(ResultSet rs, PreparedStatement ps, Connection conn) throws SQLException {
        if (rs != null) {
            rs.close();
        }
        if (ps != null) {
            ps.close();
        }
        if (conn != null) {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object[]> find(String queryString, Object[] values) {
        LOGGER.info((Object)("sql->" + queryString));
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        List<Object[]> result = new ArrayList<Object[]>();
        try {
            conn = ProductFaceUtil.getInstance().getProductDBConn();
            if (null != conn) {
                conn.setAutoCommit(false);
                ps = conn.prepareStatement(queryString);
                for (int i = 0; i < values.length; ++i) {
                    DBConnPool.setParameter(i + 1, ps, values[i]);
                }
                rs = ps.executeQuery();
                result = SqlUtil.transResultSet(rs);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"executeQuery failed", (Throwable)e);
        }
        finally {
            try {
                DBConnPool.closeAll(rs, ps, conn);
            }
            catch (SQLException e) {
                LOGGER.error((Object)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findCount(String queryString, Object[] values) {
        LOGGER.info((Object)("sql->" + queryString));
        int count = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        List<Object> result = new ArrayList();
        try {
            conn = ProductFaceUtil.getInstance().getProductDBConn();
            if (null != conn) {
                conn.setAutoCommit(false);
                ps = conn.prepareStatement(queryString);
                for (int i = 0; i < values.length; ++i) {
                    DBConnPool.setParameter(i + 1, ps, values[i]);
                }
                rs = ps.executeQuery();
                result = SqlUtil.transResultSet(rs);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"executeQuery failed", (Throwable)e);
        }
        finally {
            try {
                DBConnPool.closeAll(rs, ps, conn);
            }
            catch (SQLException e) {
                LOGGER.error((Object)e);
            }
        }
        if (!result.isEmpty()) {
            count = IReportConfCheckUtil.getInteger(((Object[])result.get(0))[0]);
        }
        return count;
    }

    public static Integer executeUpdate(String sql, Object[] values) throws SQLException {
        LOGGER.warn((Object)("sql->" + sql));
        Connection conn = null;
        PreparedStatement ps = null;
        int result = 0;
        conn = ProductFaceUtil.getInstance().getProductDBConn();
        if (null != conn) {
            try {
                conn.setAutoCommit(false);
                ps = conn.prepareStatement(sql);
                for (int i = 0; i < values.length; ++i) {
                    DBConnPool.setParameter(i + 1, ps, values[i]);
                }
                result = ps.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                    throw new SQLException(e);
                }
                catch (Throwable throwable) {
                    DBConnPool.closeAll(null, ps, conn);
                    throw throwable;
                }
            }
            DBConnPool.closeAll(null, ps, conn);
        }
        return result;
    }

    public static Integer update(String sql, Object[] values) throws SQLException {
        LOGGER.warn((Object)("sql->" + sql));
        return DBConnPool.executeUpdate(sql, values);
    }

    public static Integer save(String sql, Object[] values) throws SQLException {
        LOGGER.warn((Object)("sql->" + sql));
        return DBConnPool.executeUpdate(sql, values);
    }

    public static Integer delete(String sql, Object[] values) throws SQLException {
        LOGGER.warn((Object)("sql->" + sql));
        return DBConnPool.executeUpdate(sql, values);
    }

    public static void executeQueryByIHandle(String sql, IHandleResultSet iHandle, Object[] values) throws SQLException {
        LOGGER.info((Object)("sql->" + sql));
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        conn = ProductFaceUtil.getInstance().getProductDBConn();
        if (null != conn) {
            try {
                conn.setAutoCommit(false);
                ps = conn.prepareStatement(sql);
                for (int i = 0; i < values.length; ++i) {
                    DBConnPool.setParameter(i + 1, ps, values[i]);
                }
                rs = ps.executeQuery();
                conn.commit();
                iHandle.handleResultSet(rs);
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                    throw new SQLException(e);
                }
                catch (Throwable throwable) {
                    DBConnPool.closeAll(null, ps, conn);
                    throw throwable;
                }
            }
            DBConnPool.closeAll(null, ps, conn);
        }
    }

    public static String createInParameters(Object[] inData) {
        StringBuffer inString = new StringBuffer();
        for (int i = 0; i < inData.length; ++i) {
            if (i > 0) {
                inString.append(", ");
            }
            inString.append("?");
        }
        return inString.toString();
    }
}

