/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.ReportConstants;
import com.security.ireport.engine.dataset.DBConnectionManager;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.engine.dataset.Parameter;
import com.security.ireport.engine.definition.ComponentElement;
import com.security.ireport.engine.definition.HeaderColumn;
import com.security.ireport.engine.definition.HeaderRow;
import com.security.ireport.engine.definition.IRChart;
import com.security.ireport.engine.definition.IRChartDataItem;
import com.security.ireport.engine.definition.IRColumn;
import com.security.ireport.engine.definition.IRColumnCase;
import com.security.ireport.engine.definition.IRDataSet;
import com.security.ireport.engine.definition.IRDataSource;
import com.security.ireport.engine.definition.IRDefine;
import com.security.ireport.engine.definition.IRSwitchOption;
import com.security.ireport.engine.definition.IRTable;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.util.HotSwapClassLoader;
import com.security.ireport.util.IOrder;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportMgrUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.IpEnd;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.SqlUtil;
import java.io.File;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public abstract class IReportConfCheckUtil {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    public static String isReportPlugValid(IReport iReport, String reportDir) {
        String result = "";
        if (iReport.getIRDefineList().isEmpty()) {
            result = "Define Tag is empty.";
        } else if (IReportConfCheckUtil.isStringEmpty(iReport.getPublishTime())) {
            result = "publishTime is empty.";
        } else {
            result = IReportConfCheckUtil.checkReportName(iReport, reportDir);
            if (!IReportConfCheckUtil.isStringEmpty(result)) {
                LOGGER.debug((Object)("report name=" + iReport.getName() + " is error."));
            } else {
                result = iReport.getIRDataSourceMap().isEmpty() ? "not configure datasource." : IReportConfCheckUtil.checkDataSoource(iReport, reportDir, result);
            }
            result = IReportConfCheckUtil.checkAllElement(result, iReport);
            if (IReportConfCheckUtil.isStringEmpty(result)) {
                result = IReportConfCheckUtil.checkCaseValue(iReport);
            }
            if (IReportConfCheckUtil.isStringEmpty(result)) {
                result = IReportConfCheckUtil.checkAllChart(iReport.getIRChartList(), iReport.getIRDataSourceMap());
            }
            if (IReportConfCheckUtil.isStringEmpty(result)) {
                result = IReportConfCheckUtil.checkAllTable(iReport.getIRTableList(), iReport.getIRDataSourceMap());
            }
        }
        if (!IReportConfCheckUtil.isStringEmpty(result)) {
            result = "reportId=" + iReport.getId() + ":" + result;
            LOGGER.error((Object)result);
        }
        return result;
    }

    private static String checkDataSoource(IReport iReport, String reportDir, String result) {
        for (Map.Entry<String, IRDataSource> dsMap : iReport.getIRDataSourceMap().entrySet()) {
            IRDataSource ds = dsMap.getValue();
            ds.setPath(reportDir);
            result = IReportConfCheckUtil.isDataSourceValid(ds, reportDir);
            if (IReportConfCheckUtil.isStringEmpty(result)) continue;
            break;
        }
        return result;
    }

    private static String checkReportName(IReport iReport, String reportDir) {
        int maxLen = IReportConfigUtil.getInstance().getReportNameMaxLen();
        String chPropertyFile = reportDir + "/" + LocaleUtil.getPropertiesFileName(Locale.SIMPLIFIED_CHINESE);
        String enPropertyFile = reportDir + "/" + LocaleUtil.getPropertiesFileName(Locale.ENGLISH);
        String defaultPropertyFile = reportDir + "/" + LocaleUtil.getPropertiesFileName(Locale.FRENCH);
        LocaleUtil.removeReportRroperty(chPropertyFile);
        LocaleUtil.removeReportRroperty(enPropertyFile);
        LocaleUtil.removeReportRroperty(defaultPropertyFile);
        Properties chProp = LocaleUtil.readProperty(chPropertyFile);
        Properties enProp = LocaleUtil.readProperty(enPropertyFile);
        Properties defaultProp = LocaleUtil.readProperty(defaultPropertyFile);
        String result = IReportConfCheckUtil.isNameValid(iReport.getName(), maxLen, chProp, enProp, defaultProp);
        if (!IReportConfCheckUtil.isStringEmpty(result)) {
            return "Report " + result;
        }
        for (IRDefine define : iReport.getIRDefineList()) {
            result = IReportConfCheckUtil.isNameValid(define.getTitle(), maxLen, chProp, enProp, defaultProp);
            if (IReportConfCheckUtil.isStringEmpty(result)) continue;
            return "Define " + result;
        }
        return "";
    }

    private static String isNameValid(String name, int maxLen, Properties chProp, Properties enProp, Properties defaultProp) {
        if (IReportConfCheckUtil.isStringEmpty(name)) {
            return "name or title is empty.";
        }
        if (!IReportUtil.isPropertyKey(name)) {
            return "name or title =" + name + " is not resource key.";
        }
        ArrayList<Properties> propList = new ArrayList<Properties>();
        propList.add(chProp);
        String chName = IReportUtil.getProperty(name, propList);
        if (IReportConfCheckUtil.isStringEmpty(chName) || chName.length() > maxLen) {
            return "name or title =" + name + " chinese res =" + chName + " is empty or length > " + maxLen;
        }
        propList.clear();
        propList.add(enProp);
        String enName = IReportUtil.getProperty(name, propList);
        if (IReportConfCheckUtil.isStringEmpty(enName) || enName.length() > maxLen) {
            return "name or title =" + name + " english res =" + enName + " is empty or length > " + maxLen;
        }
        propList.clear();
        propList.add(defaultProp);
        String defaultName = IReportUtil.getProperty(name, propList);
        if (IReportConfCheckUtil.isStringEmpty(defaultName) || defaultName.length() > maxLen) {
            return "name or title =" + name + " default res =" + defaultName + " is empty or length > " + maxLen;
        }
        return "";
    }

    private static String checkAllElement(String result, IReport iReport) {
        if (IReportConfCheckUtil.isStringEmpty(result)) {
            ArrayList<String> elementIdList = new ArrayList<String>();
            for (ComponentElement componentElement : iReport.getElementList()) {
                if (IReportConfCheckUtil.isStringEmpty(componentElement.getId())) {
                    result = "Empty ID of Chart or Table";
                    break;
                }
                if (elementIdList.contains(componentElement.getId().toLowerCase(Locale.US).trim())) {
                    result = "Duplicate ID of Chart or Table : " + componentElement.getId();
                    break;
                }
                elementIdList.add(componentElement.getId().toLowerCase(Locale.US).trim());
            }
        }
        return result;
    }

    private static String checkCaseValue(IReport iReport) {
        String result = "";
        IRSwitchOption switchOption = iReport.getIRSwitchOption();
        if (null == switchOption) {
            if (IReportConfCheckUtil.isDefineListConfCaseValue(iReport.getIRDefineList())) {
                return "Define configure caseValue is not contained in SwitchOption";
            }
            if (IReportConfCheckUtil.isChartListConfCaseValue(iReport.getIRChartList())) {
                return "Chart configure caseValue is not contained in SwitchOption";
            }
            if (IReportConfCheckUtil.isTableListConfCaseValue(iReport.getIRTableList())) {
                return "Table configure caseValue is not contained in SwitchOption";
            }
        } else {
            result = IReportConfCheckUtil.isSwitchOptionCaseRepeat(switchOption.getCaseValueList());
            if (IReportConfCheckUtil.isStringEmpty(result)) {
                result = IReportConfCheckUtil.isDefineCaseRepeat(iReport.getIRDefineList());
            }
            if (IReportConfCheckUtil.isStringEmpty(result)) {
                result = IReportConfCheckUtil.isDefineCaseConfInSwitch(switchOption, iReport.getIRDefineList());
            }
            if (IReportConfCheckUtil.isStringEmpty(result)) {
                result = IReportConfCheckUtil.isChartCaseConfInSwitch(switchOption, iReport.getIRChartList());
            }
            if (IReportConfCheckUtil.isStringEmpty(result)) {
                result = IReportConfCheckUtil.isTableCaseConfInSwitch(switchOption, iReport.getIRTableList());
            }
            if (IReportConfCheckUtil.isStringEmpty(result)) {
                result = IReportConfCheckUtil.isDefineHasComponent(iReport);
            }
        }
        return result;
    }

    private static String isDefineHasComponent(IReport iReport) {
        String result = "";
        for (String caseValue : iReport.getIRSwitchOption().getCaseValueList()) {
            List<ComponentElement> list = iReport.getComponentListByCase(caseValue);
            if (!list.isEmpty()) continue;
            result = "caseValue =" + caseValue + " not used in table and chart.";
            break;
        }
        return result;
    }

    private static String isDefineCaseRepeat(List<IRDefine> iRDefineList) {
        String result = "";
        HashMap<String, String> map = new HashMap<String, String>();
        block0: for (IRDefine item : iRDefineList) {
            for (String caseValue : item.getCaseValueList()) {
                if (!map.containsKey(caseValue)) {
                    map.put(caseValue, caseValue);
                    continue;
                }
                result = "caseValue =" + caseValue + " is repeated.";
                continue block0;
            }
        }
        return result;
    }

    private static String isDefineCaseConfInSwitch(IRSwitchOption switchOption, List<IRDefine> iRDefineList) {
        String result = "";
        int caseValueSize = 0;
        block0: for (IRDefine item : iRDefineList) {
            for (String caseValue : item.getCaseValueList()) {
                ++caseValueSize;
                if (switchOption.getCaseValueList().contains(caseValue)) continue;
                result = "Define configure caseValue =" + caseValue + " is not contained in SwitchOption";
                continue block0;
            }
        }
        if (caseValueSize != switchOption.getCaseValueList().size()) {
            result = "Define configure caseValue number not equal SwitchOption";
        }
        return result;
    }

    private static String isChartCaseConfInSwitch(IRSwitchOption switchOption, List<IRChart> iRChartList) {
        String result = "";
        block0: for (IRChart item : iRChartList) {
            for (String caseValue : item.getCaseValueList()) {
                if (switchOption.getCaseValueList().contains(caseValue)) continue;
                result = "Chart configure caseValue =" + caseValue + " is not contained in SwitchOption";
                continue block0;
            }
        }
        return result;
    }

    private static String isTableCaseConfInSwitch(IRSwitchOption switchOption, List<IRTable> iRTableList) {
        String result = "";
        block0: for (IRTable item : iRTableList) {
            for (String caseValue : item.getCaseValueList()) {
                if (switchOption.getCaseValueList().contains(caseValue)) continue;
                result = "Table configure caseValue =" + caseValue + " is not contained in SwitchOption";
                continue block0;
            }
        }
        return result;
    }

    private static String isSwitchOptionCaseRepeat(List<String> caseValueList) {
        String result = "";
        HashMap<String, String> map = new HashMap<String, String>();
        for (String item : caseValueList) {
            if (IReportConfCheckUtil.isStringEmpty(item)) {
                result = "caseValue is empty.";
                break;
            }
            if (!map.containsKey(item)) {
                map.put(item, item);
                continue;
            }
            result = "caseValue =" + item + " is repeated.";
            break;
        }
        return result;
    }

    private static boolean isDefineListConfCaseValue(List<IRDefine> iRDefineList) {
        boolean flag = false;
        for (IRDefine item : iRDefineList) {
            if (IReportConfCheckUtil.isStringEmpty(item.getCaseValue())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean isChartListConfCaseValue(List<IRChart> iRChartList) {
        boolean flag = false;
        for (IRChart item : iRChartList) {
            if (IReportConfCheckUtil.isStringEmpty(item.getCaseValue())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean isTableListConfCaseValue(List<IRTable> iRTableList) {
        boolean flag = false;
        for (IRTable item : iRTableList) {
            if (IReportConfCheckUtil.isStringEmpty(item.getCaseValue())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static String isDataSourceValid(IRDataSource ds, String reportDir) {
        String result = "";
        result = IReportConfCheckUtil.isStringEmpty(ds.getId()) ? "ds id is empty." : (IReportConfCheckUtil.isStringEmpty(ds.getType()) ? "ds type is empty." : (ds.getType().equalsIgnoreCase("java") ? IReportConfCheckUtil.isJavaDataSourceValid(ds) : (ds.getType().equalsIgnoreCase("csv") ? IReportConfCheckUtil.isCsvDataSourceValid(ds, reportDir) : (ds.getType().equalsIgnoreCase("sql") ? IReportConfCheckUtil.isSqlDataSourceValid(ds) : "ds type not csv, sql, java."))));
        if (!IReportConfCheckUtil.isStringEmpty(result)) {
            result = "ds id=" + ds.getId() + ":" + result;
        }
        return result;
    }

    private static String isJavaDataSourceValid(IRDataSource ds) {
        String result = "";
        String className = ds.getClassName();
        String pojoName = ds.getPojo();
        if (IReportConfCheckUtil.isStringEmpty(pojoName) || IReportConfCheckUtil.isStringEmpty(className)) {
            result = "pojoName or className is empty.";
        }
        return result;
    }

    public static String isLoadClassSuccess(String classPath, String javaClass) {
        String result = "";
        String simpleClsName = IReportUtil.getSimpleClassName(javaClass);
        String packageName = IReportUtil.getClassPackage(javaClass);
        String classFilePath = classPath + "/" + simpleClsName + ".class";
        try {
            Class<?> cls;
            File directory = new File(classPath);
            File[] files = directory.listFiles();
            if (null != files) {
                for (File file : files) {
                    if (!file.isFile() || file.getName().equals(simpleClsName + ".class") || !file.getName().endsWith(".class")) continue;
                    String filePathName = file.getPath();
                    String className = packageName + "." + IReportUtil.getFileNameNotSuffix(file.getName());
                    cls = HotSwapClassLoader.getInstance().load(className, filePathName);
                    cls.newInstance();
                }
            } else {
                LOGGER.error((Object)"files is null.");
            }
            cls = HotSwapClassLoader.getInstance().load(javaClass, classFilePath);
            cls.newInstance();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error to get class loader or load class.", (Throwable)e);
            result = "load class path=" + classFilePath + " Exception";
        }
        catch (Error e) {
            LOGGER.error((Object)"load class error.", (Throwable)e);
            result = "load class path=" + classFilePath + " Error";
        }
        return result;
    }

    public static String isSqlDataSourceValid(IRDataSource ds) {
        String result = "";
        if (IReportConfCheckUtil.isStringEmpty(ds.getDatabase())) {
            result = " database is empty.";
        } else if (!DBConnectionManager.getInstance().getDbConfigMap().containsKey(ds.getDatabase())) {
            result = " database " + ds.getDatabase() + " is not exist or repeat in dbConfig.xml";
        } else if (!ds.isUseSqlInterface()) {
            result = IReportConfCheckUtil.isSqlCsvCommonValid(ds);
        }
        return result;
    }

    private static String isCsvDataSourceValid(IRDataSource ds, String reportDir) {
        String filePathName;
        String[] fileStr;
        String fileType;
        String result = "";
        result = IReportConfCheckUtil.isStringEmpty(ds.getFilePath()) ? "CSV Datasource filePath can not be empty!" : (IReportConfCheckUtil.isStringEmpty(ds.getFileSeparator()) ? " fileSeparator is empty!" : (!(fileType = (fileStr = ds.getFilePath().split("\\."))[fileStr.length - 1]).equalsIgnoreCase("csv") ? "CSV Datasource filePath can be csv type!" : (!IReportMgrUtil.isExistFile(filePathName = reportDir + "/" + ds.getFilePath()) ? "CSV Datasource filePath configure:" + ds.getFilePath() + " not exist!" : IReportConfCheckUtil.isSqlCsvCommonValid(ds))));
        return result;
    }

    private static String isSqlCsvCommonValid(IRDataSource ds) {
        String result = "";
        result = IReportConfCheckUtil.isSqlValid(ds.getAllSql());
        if (IReportConfCheckUtil.isStringEmpty(result)) {
            boolean checkParaNum = SqlUtil.isParamMatch(ds.getSql(), ds.getParaList().getParaList());
            if (!checkParaNum) {
                result = "SQL Datasource paraList number is not equal sql ? number!";
            } else {
                ArrayList<IOrder> iOrders = new ArrayList<IOrder>();
                for (Parameter parameter : ds.getParaList().getParaList()) {
                    iOrders.add(parameter);
                }
                boolean checkParaOrder = SqlUtil.isParaOrderValid(iOrders);
                if (!checkParaOrder) {
                    result = "SQL Datasource paraList seriesOrder have error!";
                    return result;
                }
                result = IReportConfCheckUtil.isAllFieldValid(ds.getFieldList().getFieldList());
            }
        }
        return result;
    }

    private static String isAllFieldValid(List<FieldInfo> fieldList) {
        String result = "";
        boolean isFieldValid = IReportConfCheckUtil.isFieldValid(fieldList);
        if (!isFieldValid) {
            result = "SQL Datasource fieldList have error!";
        } else {
            ArrayList<IOrder> fieldOrderList = new ArrayList<IOrder>();
            for (FieldInfo fieldInfo : fieldList) {
                fieldOrderList.add(fieldInfo);
            }
            boolean isParaOrderValid = SqlUtil.isParaOrderValid(fieldOrderList);
            if (!isParaOrderValid) {
                result = "SQL Datasource fieldList seriesOrder have error!";
            }
        }
        return result;
    }

    private static boolean isFieldValid(List<FieldInfo> fieldList) {
        boolean result = true;
        if (fieldList != null && !fieldList.isEmpty()) {
            for (FieldInfo item : fieldList) {
                if (null != item.getFieldName() && !item.getFieldName().isEmpty() && item.getFieldType() != null && !item.getFieldType().isEmpty()) continue;
                LOGGER.error((Object)"fieldInfo has fieldName or fieldType is empty.");
                result = false;
                break;
            }
        } else {
            LOGGER.error((Object)"fieldList is empty.");
            result = false;
        }
        return result;
    }

    public static String isSqlValid(String sql) {
        String result = "";
        List<String> sqlSectionList = SqlUtil.getSqlSection(sql);
        if (sqlSectionList.isEmpty()) {
            result = "sql configuration item is empty!";
            return result;
        }
        if (!sqlSectionList.get(0).equals("SELECT")) {
            result = "sql configuration item is not legal\uff0cmust start with <select>!";
        } else if (!sqlSectionList.contains("FROM")) {
            result = "sql configuration item is not legal\uff0cmust including <from> keyword!";
        } else if (sqlSectionList.indexOf("FROM") == sqlSectionList.size() - 1) {
            result = "sql configuration item is not legal\uff0cafter keyword <from> with TABLE name!";
        } else {
            int orderIndex = sqlSectionList.indexOf("ORDER");
            if (orderIndex == -1 || sqlSectionList.size() == orderIndex || !sqlSectionList.get(orderIndex + 1).equals("BY")) {
                result = "sql configuration item is not legal\uff0cmust have <order by xxx> sentence!";
            }
        }
        return result;
    }

    public static boolean isStringEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static String trim(String str) {
        if (str != null) {
            return str.trim();
        }
        return "";
    }

    public static boolean isListEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    private static String checkAllTable(List<IRTable> tableList, Map<String, IRDataSource> dsMap) {
        IRTable iTable;
        String result = "";
        Iterator<IRTable> iterator = tableList.iterator();
        while (iterator.hasNext() && IReportConfCheckUtil.isStringEmpty(result = IReportConfCheckUtil.isTableConfValid(iTable = iterator.next(), dsMap))) {
        }
        return result;
    }

    private static String isTableConfValid(IRTable iTable, Map<String, IRDataSource> dsMap) {
        IRDataSource myds;
        String result = "";
        if (IReportConfCheckUtil.isStringEmpty(iTable.getId())) {
            result = "table id is empty.";
            return result;
        }
        result = IReportConfCheckUtil.isStringEmpty(iTable.getDataSource()) ? "its DataSource id is empty." : (!dsMap.containsKey(iTable.getDataSource()) ? "its DataSource id=" + iTable.getDataSource() + " not exist in\u3000report.xml." : ((myds = dsMap.get(iTable.getDataSource())).getType().equalsIgnoreCase("java") ? IReportConfCheckUtil.checkColumn(iTable.getIRColumnList(), myds, null) : IReportConfCheckUtil.checkColumn(iTable.getIRColumnList(), myds, myds.getFieldList().getFieldList())));
        result = IReportConfCheckUtil.checkTableUnite(iTable);
        if (!IReportConfCheckUtil.isStringEmpty(result)) {
            result = "table id=" + iTable.getId() + ":" + result;
        }
        return result;
    }

    private static String checkTableUnite(IRTable iTable) {
        HeaderRow headerRow;
        String result = "";
        if (null == iTable.getHeaderRowList() || iTable.getHeaderRowList().isEmpty()) {
            return "";
        }
        int columnSize = iTable.getIRColumnList().size();
        columnSize += iTable.isSerialNumShow() ? 1 : 0;
        for (int rowNo = 0; rowNo < iTable.getHeaderRowList().size() && IReportConfCheckUtil.isStringEmpty(result = IReportConfCheckUtil.checkTableRowUnite(headerRow = iTable.getHeaderRowList().get(rowNo), columnSize, rowNo)); ++rowNo) {
        }
        return result;
    }

    private static String checkTableRowUnite(HeaderRow headerRow, int columnSize, int rowNo) {
        int headerColumnSize = 0;
        if (headerRow != null && !headerRow.getHeaderColumnList().isEmpty()) {
            for (HeaderColumn item : headerRow.getHeaderColumnList()) {
                headerColumnSize += item.getExportColspan();
            }
        }
        if (headerColumnSize != columnSize) {
            return "HeaderRow number=" + rowNo + " columnSize(" + headerColumnSize + ") not equals table columnSize(" + columnSize + ")";
        }
        return "";
    }

    private static String checkColumn(List<IRColumn> tblColumnLst, IRDataSource ds, List<FieldInfo> checkFieldList) {
        String result = "";
        for (IRColumn column : tblColumnLst) {
            if (IReportConfCheckUtil.isStringEmpty(column.getHeader()) || IReportConfCheckUtil.isStringEmpty(column.getField())) {
                result = "column header or field is empty.";
                break;
            }
            result = IReportConfCheckUtil.checkColumn(column, ds, checkFieldList);
            if (IReportConfCheckUtil.isStringEmpty(result)) continue;
            break;
        }
        return result;
    }

    private static String checkColumn(IRColumn column, IRDataSource ds, List<FieldInfo> checkFieldList) {
        String result = "";
        List<FieldInfo> fieldInfos = null;
        if (ds.getType().equalsIgnoreCase("java")) {
            fieldInfos = IReportMgrUtil.getAllFieldInfo(ds.getPojo(), ds.getPath());
            if (!IReportConfCheckUtil.isSpecialField(column.getField()) && !IReportMgrUtil.isIncludeField(column.getField(), fieldInfos)) {
                result = "its field(" + column.getField() + ") not exist in pojo class(" + ds.getPojo() + ").";
                return result;
            }
            if (!IReportConfCheckUtil.isStringEmpty(column.getUrlField()) && !IReportMgrUtil.isIncludeField(column.getUrlField(), fieldInfos)) {
                result = "its urlField(" + column.getUrlField() + ") not exist in pojo class(" + ds.getPojo() + ").";
                return result;
            }
        } else if (checkFieldList != null) {
            fieldInfos = checkFieldList;
            if (!IReportConfCheckUtil.isSpecialField(column.getField()) && !IReportMgrUtil.isIncludeField(column.getField(), fieldInfos)) {
                result = "its field(" + column.getField() + ") not exist in " + ds.getType() + " conf fieldList.";
                return result;
            }
            if (!IReportConfCheckUtil.isStringEmpty(column.getUrlField()) && !IReportMgrUtil.isIncludeField(column.getUrlField(), fieldInfos)) {
                result = "its field(" + column.getUrlField() + ") not exist in " + ds.getType() + " conf fieldList.";
                return result;
            }
        }
        return result;
    }

    public static boolean isSpecialField(String fieldName) {
        boolean isSpecialField = false;
        if (fieldName.startsWith("=")) {
            isSpecialField = true;
        }
        return isSpecialField;
    }

    private static String checkAllChart(List<IRChart> chartList, Map<String, IRDataSource> dsMap) {
        IRChart iChart;
        String result = "";
        Iterator<IRChart> iterator = chartList.iterator();
        while (iterator.hasNext() && IReportConfCheckUtil.isStringEmpty(result = IReportConfCheckUtil.isChartConfValid(iChart = iterator.next(), dsMap))) {
        }
        return result;
    }

    private static String isChartConfValid(IRChart iChart, Map<String, IRDataSource> dsMap) {
        String result = "";
        IRDataSet dataSet = iChart.getIRDataSet();
        if (IReportConfCheckUtil.isStringEmpty(dataSet.getDatasource())) {
            result = "datasource of dataset is empty.";
        } else if (!dsMap.containsKey(dataSet.getDatasource())) {
            result = "datasource = " + dataSet.getDatasource() + " of dataset is not exist.";
        } else {
            IRDataSource myds = dsMap.get(dataSet.getDatasource());
            result = IReportConfCheckUtil.isChartDataSetValid(myds, dataSet, ReportConstants.getChartType(iChart));
        }
        if (!IReportConfCheckUtil.isStringEmpty(result)) {
            result = "chartId=" + iChart.getId() + ":" + result;
        }
        return result;
    }

    private static String isChartDataSetValid(IRDataSource myds, IRDataSet dataSet, int chartType) {
        if (myds.getType().equalsIgnoreCase("java")) {
            List<FieldInfo> fieldInfos = IReportMgrUtil.getAllFieldInfo(myds.getPojo(), myds.getPath());
            if (!IReportConfCheckUtil.isStringEmpty(dataSet.getGroup()) && !IReportMgrUtil.isIncludeField(dataSet.getGroup(), fieldInfos)) {
                return "its group Field(" + dataSet.getGroup() + ") not exist in pojo class(" + myds.getPojo() + ").";
            }
        } else {
            List<FieldInfo> fieldList = myds.getFieldList().getFieldList();
            if (!IReportConfCheckUtil.isStringEmpty(dataSet.getGroup()) && !IReportMgrUtil.isIncludeField(dataSet.getGroup(), fieldList)) {
                return "its group Field(" + dataSet.getGroup() + ") not exist in sql,csv datasource fieldList";
            }
        }
        if (null == dataSet.getDataItemList() || dataSet.getDataItemList().isEmpty()) {
            return "its chart dataSet not conf item.";
        }
        int n = dataSet.getDataItemList().size();
        for (int i = 0; i < n; ++i) {
            String result = IReportConfCheckUtil.isChartDataSetItemValid(myds, dataSet.getDataItemList().get(i), chartType, dataSet.isAutoExpand());
            if (IReportConfCheckUtil.isStringEmpty(result)) continue;
            return result;
        }
        return "";
    }

    private static String isChartDataSetItemValid(IRDataSource myds, IRChartDataItem item, int chartType, boolean isAutoExpand) {
        if (IReportConfCheckUtil.isStringEmpty(item.getKey()) || IReportConfCheckUtil.isStringEmpty(item.getValue())) {
            return "key or value of dataset is empty.";
        }
        if (isAutoExpand) {
            return IReportConfCheckUtil.isChartDataSetItemAutoExpandValid(myds, item);
        }
        List<FieldInfo> fieldList = null;
        fieldList = myds.getType().equalsIgnoreCase("java") ? IReportMgrUtil.getAllFieldInfo(myds.getPojo(), myds.getPath()) : myds.getFieldList().getFieldList();
        if (!IReportMgrUtil.isNumberField(item.getValue(), fieldList)) {
            return "value of datasetis error. Error maybe 1: not exist in pojo class, sql or csv datasource fieldList; 2:value is not number type";
        }
        if (!(chartType != 2 && chartType != 3 || IReportMgrUtil.isIncludeField(item.getKey(), fieldList))) {
            return "key of dataset is error. Error maybe 1: not exist in pojo class, sql or csv datasource fieldList; 2:value is not number type";
        }
        if (!IReportConfCheckUtil.isStringEmpty(item.getUrlField()) && !IReportMgrUtil.isIncludeField(item.getUrlField(), fieldList)) {
            return "its urlField(" + item.getUrlField() + ") not exist in pojo class, sql or csv datasource fieldList";
        }
        return "";
    }

    private static String isChartDataSetItemAutoExpandValid(IRDataSource myds, IRChartDataItem item) {
        if (myds.getType().equalsIgnoreCase("java")) {
            List<FieldInfo> fieldInfos = IReportMgrUtil.getAllFieldInfo(myds.getPojo(), myds.getPath());
            if (!IReportMgrUtil.isIncludeField(item.getKey(), fieldInfos) || !IReportMgrUtil.isNumberField(item.getValue(), fieldInfos)) {
                return "key or value of dataset is error. Error maybe 1: not exist in pojo class=" + myds.getPojo() + "; 2:value is not number type";
            }
            if (!IReportConfCheckUtil.isStringEmpty(item.getUrlField()) && !IReportMgrUtil.isIncludeField(item.getUrlField(), fieldInfos)) {
                return "its urlField(" + item.getUrlField() + ") not exist in pojo class(" + myds.getPojo() + ").";
            }
            if (!IReportConfCheckUtil.isStringEmpty(item.getSeries()) && !IReportMgrUtil.isIncludeField(item.getSeries(), fieldInfos)) {
                return "its series Field(" + item.getSeries() + ") not exist in pojo class(" + myds.getPojo() + ").";
            }
        } else {
            List<FieldInfo> fieldList = myds.getFieldList().getFieldList();
            if (!IReportMgrUtil.isIncludeField(item.getKey(), fieldList) || !IReportMgrUtil.isNumberField(item.getValue(), fieldList)) {
                return "key or value of dataset is error. Error maybe 1: not exist in sql,csv datasource fieldList; 2:value is not number type";
            }
            if (!IReportConfCheckUtil.isStringEmpty(item.getUrlField()) && !IReportMgrUtil.isIncludeField(item.getUrlField(), fieldList)) {
                return "its urlField(" + item.getUrlField() + ") not exist in sql,csv datasource fieldList";
            }
            if (!IReportConfCheckUtil.isStringEmpty(item.getSeries()) && !IReportMgrUtil.isIncludeField(item.getSeries(), fieldList)) {
                return "its series Field(" + item.getSeries() + ") not exist in sql,csv datasource fieldList";
            }
        }
        return "";
    }

    public static boolean isUsedByOther(String dsId, IReport iReport) {
        boolean blUsed = false;
        List<IRChart> iRChartList = iReport.getIRChartList();
        List<IRTable> iRTableList = iReport.getIRTableList();
        if (IReportConfCheckUtil.isUsedByCharts(dsId, iRChartList) || IReportConfCheckUtil.isUsedByTables(dsId, iRTableList)) {
            blUsed = true;
        }
        return blUsed;
    }

    private static boolean isUsedByCharts(String dsId, List<IRChart> charts) {
        boolean blUsed = false;
        for (IRChart chart : charts) {
            if (!dsId.equalsIgnoreCase(chart.getIRDataSet().getDatasource())) continue;
            blUsed = true;
            break;
        }
        return blUsed;
    }

    private static boolean isUsedByTables(String dsId, List<IRTable> tables) {
        boolean blUsed = false;
        for (IRTable table : tables) {
            if (!dsId.equalsIgnoreCase(table.getDataSource())) continue;
            blUsed = true;
        }
        return blUsed;
    }

    public static String getObjectStr(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static Integer getInteger(Object obj) {
        if (null == obj) {
            LOGGER.error((Object)"obj is null");
            return -1;
        }
        try {
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            return Integer.valueOf(obj.toString());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return -1;
        }
    }

    public static Long getLong(Object obj) {
        if (null == obj) {
            LOGGER.error((Object)"obj is null");
            return -1L;
        }
        try {
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            return Long.valueOf(obj.toString());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return -1L;
        }
    }

    public static Double getDouble(Object obj) {
        if (null == obj) {
            LOGGER.error((Object)"obj is null");
            return -1.0;
        }
        try {
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            return Double.valueOf(obj.toString());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return -1.0;
        }
    }

    public static String formatObj(Object obj, IRColumn columnDefine) {
        if (null == obj || IReportConfCheckUtil.isStringEmpty(obj.toString())) {
            return "";
        }
        if (null == columnDefine) {
            return "";
        }
        String result = null;
        String formatType = columnDefine.getFormatType();
        String formatValue = columnDefine.getFormatValue();
        if (!IReportConfCheckUtil.isStringEmpty(formatType)) {
            if (formatType.equals("dateFormat")) {
                result = IReportConfCheckUtil.formatDate(obj, formatValue);
            } else if (formatType.equalsIgnoreCase("percentFormat")) {
                result = IReportConfCheckUtil.percentFormatObj(columnDefine, obj);
            } else if (formatType.equalsIgnoreCase("ipFormat")) {
                result = IpEnd.longToIP(IReportConfCheckUtil.getLong(obj));
            } else if (formatType.equalsIgnoreCase("img")) {
                result = IReportConfCheckUtil.formatImg(obj, formatValue, columnDefine.getColumnCaseList());
            } else if (formatType.equalsIgnoreCase("NumberFormat")) {
                result = IReportConfCheckUtil.formatNumber(obj, formatValue);
            }
        }
        if (null == result) {
            result = obj.toString();
        }
        return result;
    }

    private static String percentFormatObj(IRColumn columnDefine, Object obj) {
        String result = null;
        NumberFormat nf = NumberFormat.getPercentInstance();
        String formatValue = columnDefine.getFormatValue();
        int defaultDigit = IReportConfCheckUtil.getInteger(formatValue);
        if (defaultDigit < 0) {
            LOGGER.error((Object)("formatValue=" + formatValue + " is error."));
            defaultDigit = 2;
        }
        nf.setMinimumFractionDigits(defaultDigit);
        result = nf.format(IReportConfCheckUtil.getDouble(obj));
        return result;
    }

    private static String formatNumber(Object str, String formatValue) {
        String result = "";
        DecimalFormat formatter = null;
        try {
            formatter = !IReportConfCheckUtil.isStringEmpty(formatValue) ? new DecimalFormat(formatValue) : new DecimalFormat();
            result = formatter.format(IReportConfCheckUtil.getDouble(str));
        }
        catch (Exception e) {
            LOGGER.error((Object)("formatValue=" + formatValue + ";str=" + str), (Throwable)e);
        }
        return result;
    }

    private static String formatImg(Object str, String formatValue, List<IRColumnCase> columnCaseList) {
        String contextPath = IReportConfigUtil.getInstance().getContextPath();
        String result = contextPath + "/" + formatValue;
        if (columnCaseList.isEmpty()) {
            return result;
        }
        for (IRColumnCase item : columnCaseList) {
            if (!str.toString().equals(item.getOriginValue())) continue;
            result = contextPath + "/" + item.getMapped();
            break;
        }
        return result;
    }

    private static String formatDate(Object str, String formatValue) {
        String result = null;
        result = str.toString().equals("0") ? "--" : (!IReportConfCheckUtil.isStringEmpty(formatValue) ? IReportUtil.transTimeStr(IReportConfCheckUtil.getLong(str), formatValue) : IReportUtil.transTimeStr(IReportConfCheckUtil.getLong(str)));
        return result;
    }

    public static void setDatasourcePath(IReport myReport) {
        String pluginId = myReport.getId();
        String classPath = IReportUtil.getRealPath() + "/iReport/iReportBiz/reportPlugins/" + pluginId;
        IRDataSource ds = null;
        for (Map.Entry<String, IRDataSource> dsMap : myReport.getIRDataSourceMap().entrySet()) {
            ds = dsMap.getValue();
            ds.setPath(classPath);
        }
    }

    public static String calcTableColCount(List<?> dataSetList, int colNum, IRColumn columnDefine) {
        String result = "";
        if (null == dataSetList || dataSetList.isEmpty()) {
            return result;
        }
        if (columnDefine.getTotalExpression() != null) {
            if (columnDefine.getTotalExpression().contains("$P{SUM}")) {
                double sum = IReportConfCheckUtil.calcSumFunction(dataSetList, colNum, columnDefine);
                if ("percentFormat".equalsIgnoreCase(columnDefine.getFormatType()) && sum > 1.0) {
                    sum = 1.0;
                }
                result = IReportConfCheckUtil.formatObj(sum, columnDefine);
                result = columnDefine.getTotalExpression().replace("$P{SUM}", result);
            } else if (columnDefine.getTotalExpression().contains("$P{ROWCOUNT}")) {
                result = columnDefine.getTotalExpression().replace("$P{ROWCOUNT}", dataSetList.size() + "");
            } else if (columnDefine.getTotalExpression().contains("$P{AVERAGE}")) {
                double sum = IReportConfCheckUtil.calcSumFunction(dataSetList, colNum, columnDefine);
                double avg = sum / (double)dataSetList.size();
                result = IReportConfCheckUtil.formatObj(avg, columnDefine);
                result = columnDefine.getTotalExpression().replace("$P{AVERAGE}", result);
            } else {
                result = columnDefine.getTotalExpression();
            }
        }
        return result;
    }

    public static double calcSumFunction(Object[][] objects, int colNum, IRColumn columnDefine) {
        double result = 0.0;
        try {
            for (int i = 0; i < objects.length; ++i) {
                result += IReportConfCheckUtil.getDoubleValue(columnDefine, String.valueOf(objects[i][colNum]));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        return result;
    }

    public static double calcSumFunction(List<?> dataSetList, int colNum, IRColumn columnDefine) {
        double result = 0.0;
        try {
            for (int i = 0; i < dataSetList.size(); ++i) {
                result += IReportConfCheckUtil.getDoubleValue(columnDefine, String.valueOf(Array.get(dataSetList.get(i), colNum)));
            }
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"failed to calcuSumFunction", (Throwable)e);
        }
        return result;
    }

    public static double getDoubleValue(IRColumn column, String numberStr) {
        try {
            if (null != column.getFormatType() && column.getFormatType().equalsIgnoreCase("percentFormat")) {
                return NumberFormat.getPercentInstance().parse(numberStr).doubleValue();
            }
            return NumberFormat.getInstance().parse(numberStr).doubleValue();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return 0.0;
        }
    }
}

