/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.model.vo.ReportPlugVO;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.LocaleUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class IReportConfigUtil {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static Properties properties = null;
    private static IReportConfigUtil pluginConfigUtil = null;
    private String fileDbUserName = "";
    private String fileDbPwd = "";
    private String csvDbUserName = "sa";
    private String csvDbPwd = "";
    private String contextPath = "";
    private long iReportConfLastModifyTime = 0L;
    private Lock ireportConfLock = new ReentrantLock();

    private IReportConfigUtil() {
    }

    public String getFileDbUserName() {
        return this.fileDbUserName;
    }

    public String getFileDbPwd() {
        return this.fileDbPwd;
    }

    public String getCsvDbUserName() {
        return this.csvDbUserName;
    }

    public String getCsvDbPwd() {
        return this.csvDbPwd;
    }

    public static IReportConfigUtil getInstance() {
        if (null == pluginConfigUtil) {
            pluginConfigUtil = new IReportConfigUtil();
        }
        return pluginConfigUtil;
    }

    public String getIReportExtConfig() {
        return this.getConfig("ireport.extension");
    }

    public int getExportPageSize() {
        String str = this.getConfig("ireport.export.page.size");
        int result = IReportConfCheckUtil.getInteger(str);
        if (result <= 1) {
            result = 65534;
        }
        return result;
    }

    public int getFirstRSessionQueueLength() {
        String str = this.getConfig("first.reportSession.queue.length");
        int result = IReportConfCheckUtil.getInteger(str);
        if (result < 1) {
            result = 1;
        }
        return result;
    }

    public int getSecondRSessionQueueLength() {
        String str = this.getConfig("second.reportSession.queue.length");
        int result = IReportConfCheckUtil.getInteger(str);
        if (result < 1) {
            result = 1;
        }
        return result;
    }

    public int getCsvExportAlertCount() {
        String str = this.getConfig("csv.export.alert.count");
        int result = IReportConfCheckUtil.getInteger(str);
        if (result <= 1) {
            result = 65534;
        }
        return result;
    }

    public String getCsvExportAlert() {
        int count = this.getCsvExportAlertCount();
        String str = LocaleUtil.getProperty("csv.export.alert");
        String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
        if (!productName.equalsIgnoreCase("SIG V1")) {
            str = LocaleUtil.getProperty("ireport.vsm.csv.export.alert");
        }
        Object[] objs = new Object[]{count};
        return MessageFormat.format(str, objs);
    }

    public String getDBType() {
        return this.getConfig("ireport.db.type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConfig(String key) {
        LOGGER.info((Object)"get iReport.conf");
        this.ireportConfLock.lock();
        InputStream inStream = null;
        String returnValue = null;
        try {
            String fileName = IReportUtil.getRealPath() + "/iReport/iReportBiz/config/" + "iReport.conf";
            File file = new File(fileName);
            if (file.lastModified() > this.iReportConfLastModifyTime) {
                if (null == properties) {
                    properties = new Properties();
                }
                this.iReportConfLastModifyTime = file.lastModified();
                inStream = new FileInputStream(file);
                properties.load(inStream);
            }
            returnValue = properties.getProperty(key);
        }
        catch (IOException e) {
            LOGGER.error((Object)"load param.properties error", (Throwable)e);
        }
        catch (Throwable e) {
            LOGGER.error((Object)"load param.properties error", e);
        }
        finally {
            this.ireportConfLock.unlock();
            try {
                if (null != inStream) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Close param.properties error", (Throwable)e);
            }
        }
        return returnValue;
    }

    public int getIntValue(String key, int defaultValue) {
        int ret = defaultValue;
        try {
            int value;
            String poolSize = this.getConfig(key);
            if (poolSize != null && (value = Integer.parseInt(poolSize)) > 0) {
                ret = value;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Configure parameters item with error,will use default value:" + e));
            ret = defaultValue;
        }
        return ret;
    }

    public int getReportNameMaxLen() {
        String nameLength = this.getConfig("report.name.max.length");
        int maxLen = 32;
        if (null != nameLength) {
            try {
                maxLen = Integer.parseInt(nameLength);
            }
            catch (Exception e) {
                LOGGER.error((Object)("iReport.conf property report.name.max.length =" + nameLength + " invalid. maxLen reset to default=" + 32));
            }
        }
        if (0 >= maxLen) {
            maxLen = 32;
        }
        return maxLen;
    }

    public String getProductName() {
        return this.getConfig("report.productName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setConfig(String key, String value) {
        LOGGER.info((Object)"set iReport.conf");
        this.ireportConfLock.lock();
        InputStream inStream = null;
        OutputStream os = null;
        try {
            String fileName = IReportUtil.getRealPath() + "/iReport/iReportBiz/config/" + "iReport.conf";
            inStream = new FileInputStream(fileName);
            Properties propertiesNew = new Properties();
            propertiesNew.load(inStream);
            propertiesNew.put(key, value);
            os = new FileOutputStream(fileName);
            propertiesNew.store(os, key);
            os.flush();
            return true;
        }
        catch (IOException e) {
            LOGGER.error((Object)"load param.properties error", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.ireportConfLock.unlock();
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Close param.properties error", (Throwable)e);
            }
            finally {
                try {
                    if (null != inStream) {
                        inStream.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Close param.properties error", (Throwable)e);
                }
            }
        }
    }

    public static ReportPlugVO ireportToVO(IReport iReport) {
        String ext = IReportConfigUtil.getInstance().getIReportExtConfig();
        ReportPlugVO reportPlugVO = new ReportPlugVO();
        reportPlugVO.setReportId(iReport.getId());
        reportPlugVO.setReportName(iReport.getName());
        reportPlugVO.setVersion(iReport.getVersion());
        reportPlugVO.setIsCorrectVersion(iReport.getIsCorrectVersion());
        reportPlugVO.setUrl("atic/ireport/reportPage" + ext + "?reportId=" + iReport.getId());
        return reportPlugVO;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getJasperPdfFontName() {
        return this.getConfig("jasper.pdf.pdfFontName");
    }
}

