/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.InputSource;

public abstract class IReportDTDParser {
    private static Map<String, InputSource> dtdEntityResources = new HashMap<String, InputSource>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputSource resolveEntity(String dtdName, String path) {
        if (dtdEntityResources.containsKey(dtdName)) {
            return dtdEntityResources.get(dtdName);
        }
        InputSource inputSource = null;
        if (dtdName != null) {
            ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
            URL url = null;
            if (clsLoader != null) {
                url = clsLoader.getResource(path);
            }
            if (null == url) {
                clsLoader = IReportDTDParser.class.getClassLoader();
            }
            InputStream is = null;
            try {
                is = null == clsLoader ? IReportDTDParser.class.getResourceAsStream("/" + path) : clsLoader.getResourceAsStream(path);
                if (is != null) {
                    inputSource = new InputSource(is);
                    dtdEntityResources.put(dtdName, inputSource);
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    return inputSource;
                }
            }
        }
        return inputSource;
    }
}

