/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.PluginManager;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.engine.exception.ParaException;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.model.vo.OperateResult;
import com.security.ireport.util.HotSwapClassLoader;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.JSONUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.ZipUtil;
import com.security.logserver.module.condition.cfg.ConditionParser;
import java.io.File;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class IReportMgrUtil {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final int INTERVAL_DAY = 1;
    private static final int INTERVAL_WEEK = 2;
    private static final int INTERVAL_MONTH = 3;
    private static final int INTERVAL_YEAR = 4;
    private static final int DAY_COUNT_WEEK = 7;
    private static final int POS_OF_YEAR_OR_MINUTE = 2;
    private static final String RUN_SCHEDULE_MARK = ",";
    private static final String RUN_TIME_MARK = ":";
    private static final String REPORT_NAME_FROM_TEMPLATE = "myreport";
    private static final String SEPARATOR = "@";

    private IReportMgrUtil() {
    }

    public static long getCurrentTimeMill() {
        long currentMill = 0L;
        try {
            currentMill = System.currentTimeMillis();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Get system current mill time faile:", (Throwable)e);
            return currentMill;
        }
        return currentMill;
    }

    public static List<String> getList(String str, String mark) {
        ArrayList<String> myList = new ArrayList<String>();
        String[] strs = str.split(mark);
        if (strs.length > 0) {
            for (String tmp : strs) {
                myList.add(tmp);
            }
        }
        return myList;
    }

    private static List<String> getNeedFileLst() {
        ArrayList<String> neededLst = new ArrayList<String>();
        neededLst.clear();
        neededLst.add("parameter.xml");
        neededLst.add("report.xml");
        neededLst.add("resources_en.properties");
        neededLst.add("resources_zh_CN.properties");
        neededLst.add("resources.properties");
        return neededLst;
    }

    public static boolean isExistNeededFiles(String plugPath) {
        boolean isExistFile = true;
        List<String> neededLst = null;
        try {
            neededLst = IReportMgrUtil.getNeedFileLst();
            for (String neededFile : neededLst) {
                String fileName = plugPath + File.separator + neededFile;
                if (IReportMgrUtil.isExistFile(fileName)) continue;
                isExistFile = false;
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Operate file failed,", (Throwable)e);
        }
        return isExistFile;
    }

    public static boolean isExistFile(String filePathName) {
        boolean isExistFile = true;
        File tmpFile = null;
        try {
            tmpFile = new File(filePathName);
            if (!tmpFile.exists()) {
                isExistFile = false;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Operate file failed,", (Throwable)e);
        }
        return isExistFile;
    }

    public static long getNewTime(int type, long priTime) {
        long retTime = 0L;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(priTime);
        switch (type) {
            case 1: {
                cal.add(5, 1);
                break;
            }
            case 2: {
                cal.add(5, 7);
                break;
            }
            case 3: {
                cal.add(2, 1);
                break;
            }
            case 4: {
                cal.add(1, 1);
                break;
            }
            default: {
                LOGGER.error((Object)("Time task schedule type:" + type + "is Error!"));
            }
        }
        retTime = cal.getTimeInMillis();
        return retTime;
    }

    public static List<FieldInfo> getAllFieldInfo(String pojo, String classPath) {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        try {
            Field[] fields;
            String simpleClsName = IReportUtil.getSimpleClassName(pojo);
            String packageName = IReportUtil.getClassPackage(pojo);
            String path = classPath + "/" + simpleClsName + ".class";
            String className = packageName + "." + simpleClsName;
            Class<?> pojoClass = HotSwapClassLoader.getInstance().load(className, path);
            for (Field field : fields = pojoClass.getDeclaredFields()) {
                FieldInfo info = new FieldInfo();
                info.setFieldName(field.getName());
                info.setFieldType(field.getType().getSimpleName());
                fieldInfos.add(info);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Load path:" + classPath + " all class file:" + pojo + " failed,"), (Throwable)e);
        }
        catch (Error error) {
            LOGGER.error((Object)("Load path:" + classPath + " all class file:" + pojo + " failed,"), (Throwable)error);
        }
        return fieldInfos;
    }

    public static boolean isExistClass(String path, String pkgName) {
        boolean isExist = false;
        String[] pkgLst = pkgName.split("\\.");
        String className = pkgLst[pkgLst.length - 1] + ".class";
        if (IReportMgrUtil.isExistFile(path + File.separator + className)) {
            isExist = true;
        }
        return isExist;
    }

    public static boolean isNumberField(String key, List<FieldInfo> fieldInfos) {
        boolean isExist = false;
        for (FieldInfo field : fieldInfos) {
            String fieldName = field.getFieldName();
            String fieldType = field.getFieldType();
            if (!fieldName.equals(key) || !IReportMgrUtil.isNumberField(fieldType)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    private static boolean isNumberField(String fieldType) {
        boolean ret = false;
        if (IReportMgrUtil.isIntegerNumberField(fieldType) || IReportMgrUtil.isFloatNumberField(fieldType) || IReportMgrUtil.isLongNumberField(fieldType) || IReportMgrUtil.isDoubleNumberField(fieldType)) {
            ret = true;
        }
        return ret;
    }

    private static boolean isIntegerNumberField(String fieldType) {
        boolean ret = false;
        if (fieldType.equalsIgnoreCase("int") || fieldType.equalsIgnoreCase("java.lang.Integer")) {
            ret = true;
        }
        return ret;
    }

    private static boolean isFloatNumberField(String fieldType) {
        boolean ret = false;
        if (fieldType.equalsIgnoreCase("float") || fieldType.equalsIgnoreCase("java.lang.Float")) {
            ret = true;
        }
        return ret;
    }

    private static boolean isDoubleNumberField(String fieldType) {
        boolean ret = false;
        if (fieldType.equalsIgnoreCase("double") || fieldType.equalsIgnoreCase("java.lang.Double")) {
            ret = true;
        }
        return ret;
    }

    private static boolean isLongNumberField(String fieldType) {
        boolean ret = false;
        if (fieldType.equalsIgnoreCase("long") || fieldType.equalsIgnoreCase("java.lang.Long")) {
            ret = true;
        }
        return ret;
    }

    public static boolean isIncludeField(String key, List<FieldInfo> fieldInfos) {
        boolean isExist = false;
        for (FieldInfo field : fieldInfos) {
            String fieldName = field.getFieldName();
            if (!fieldName.equals(key)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public static String getExportPath() {
        String path = null;
        File filePath = null;
        String newPath = IReportUtil.getRealPath() + "/iReport/iReportBiz/customReport";
        try {
            path = IReportConfigUtil.getInstance().getConfig("task.export.file.path");
            if (null != path && !path.equals("")) {
                filePath = new File(path);
                if (!filePath.exists()) {
                    path = newPath;
                }
            } else {
                path = newPath;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Get time task export file path failed:", (Throwable)e);
        }
        return path;
    }

    private static long getRunTimeByDay(String executeTime, int year, int month, int date, long curtime) {
        LOGGER.info((Object)("[xxx]:executeTime:" + executeTime + ";y:" + year + ";m:" + month + ";d:" + date + ";cur:" + curtime));
        long ret = 0L;
        Calendar newcal = Calendar.getInstance();
        String[] runtime = executeTime.split(RUN_TIME_MARK);
        newcal.set(year, month, date);
        newcal.set(11, Integer.parseInt(runtime[0]));
        newcal.set(12, Integer.parseInt(runtime[1]));
        newcal.set(13, Integer.parseInt(runtime[2]));
        LOGGER.info((Object)("after:" + newcal));
        newcal.set(14, 0);
        long newtime = newcal.getTimeInMillis();
        if (newtime <= curtime) {
            int hour = IReportMgrUtil.fetchOutDstHour(newcal);
            if (hour == Integer.parseInt(runtime[0])) {
                newcal.set(11, Integer.parseInt(runtime[0]));
                newcal.add(11, 1);
                if (newcal.get(11) != Integer.parseInt(runtime[0])) {
                    newcal.add(11, -1);
                }
                newcal.add(5, 1);
                newcal.set(12, Integer.parseInt(runtime[1]));
                newcal.set(13, Integer.parseInt(runtime[2]));
            } else if (IReportMgrUtil.fetchInDstHour(newcal) == Integer.parseInt(runtime[0])) {
                newcal.set(11, Integer.parseInt(runtime[0]) + 1);
                newcal.set(12, Integer.parseInt(runtime[1]));
                newcal.set(13, Integer.parseInt(runtime[2]));
                newcal.add(5, 1);
            } else {
                newcal.add(5, 1);
            }
        }
        ret = newcal.getTimeInMillis();
        return ret;
    }

    private static int fetchOutDstHour(Calendar base) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(base.getTime());
        cal.add(5, 1);
        int ret = -1;
        cal.set(11, 0);
        Calendar after = Calendar.getInstance();
        after.setTime(cal.getTime());
        for (int i = 0; i < 23; ++i) {
            after.add(11, 1);
            if (cal.get(11) == after.get(11)) {
                ret = cal.get(11);
                break;
            }
            cal.add(11, 1);
        }
        return ret;
    }

    private static int fetchInDstHour(Calendar base) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(base.getTime());
        cal.add(5, 1);
        int ret = -1;
        cal.set(11, 0);
        Calendar after = Calendar.getInstance();
        after.setTime(cal.getTime());
        for (int i = 0; i < 23; ++i) {
            after.add(11, 1);
            if (after.get(11) - cal.get(11) > 1) {
                ret = cal.get(11) + 1;
                break;
            }
            cal.add(11, 1);
        }
        return ret;
    }

    private static long getRunTimeByWeek(String executeTime, int week, int year, int month, int date, long curtime) {
        long ret = 0L;
        Calendar newcal = Calendar.getInstance();
        String[] runtime = executeTime.split(RUN_SCHEDULE_MARK);
        int nweek = 0;
        nweek = 0 == week - 1 ? 7 : week - 1;
        int rweek = Integer.parseInt(runtime[0]);
        String[] rtime = runtime[1].split(RUN_TIME_MARK);
        int rhour = Integer.parseInt(rtime[0]);
        int rminute = Integer.parseInt(rtime[1]);
        newcal.set(year, month, date, rhour, rminute, Integer.parseInt(rtime[2]));
        int offset = 0;
        if (nweek > rweek) {
            offset = 7 - (nweek - rweek);
        } else if (rweek > nweek) {
            offset = rweek - nweek;
        } else {
            long newtime = newcal.getTimeInMillis();
            if (newtime <= curtime) {
                offset = 7;
            }
        }
        newcal.add(5, offset);
        ret = newcal.getTimeInMillis();
        return ret;
    }

    private static long getRunTimeByMonth(String executeTime, int year, int month, long curtime) {
        long ret = 0L;
        Calendar newcal = Calendar.getInstance();
        String[] runtime = executeTime.split(RUN_SCHEDULE_MARK);
        int rdate = Integer.parseInt(runtime[0]);
        String[] rtime = runtime[1].split(RUN_TIME_MARK);
        int rhour = Integer.parseInt(rtime[0]);
        int rminute = Integer.parseInt(rtime[1]);
        newcal.set(year, month, rdate, rhour, rminute, Integer.parseInt(rtime[2]));
        if (newcal.getTimeInMillis() <= curtime) {
            newcal.add(2, 1);
        }
        ret = newcal.getTimeInMillis();
        return ret;
    }

    private static long getRunTimeByYear(String executeTime, int year, long curtime) {
        long ret = 0L;
        Calendar newcal = Calendar.getInstance();
        String[] runtime = executeTime.split(RUN_SCHEDULE_MARK);
        int rmonth = Integer.parseInt(runtime[0]);
        int rdate = Integer.parseInt(runtime[1]);
        String[] rtime = runtime[2].split(RUN_TIME_MARK);
        int rhour = Integer.parseInt(rtime[0]);
        int rminute = Integer.parseInt(rtime[1]);
        newcal.set(year, rmonth - 1, rdate, rhour, rminute, Integer.parseInt(rtime[2]));
        if (newcal.getTimeInMillis() <= curtime) {
            newcal.add(1, 1);
        }
        ret = newcal.getTimeInMillis();
        return ret;
    }

    public static long getTaskNextRunTime(int schedule, String executeTime, long startTime, long endTime) {
        long tempTime;
        long result = 0L;
        Calendar curCalendar = Calendar.getInstance();
        long nextRunTime = IReportMgrUtil.getTaskNextRunTime(schedule, executeTime, curCalendar.getTimeInMillis());
        long curtime = Calendar.getInstance().getTimeInMillis();
        long l = tempTime = curtime > startTime ? curtime : startTime;
        if (tempTime < endTime) {
            while (nextRunTime < tempTime) {
                curCalendar.add(5, 1);
                nextRunTime = IReportMgrUtil.getTaskNextRunTime(schedule, executeTime, curCalendar.getTimeInMillis());
            }
            if (nextRunTime < endTime) {
                result = nextRunTime;
            }
        }
        return result;
    }

    private static long getTaskNextRunTime(int schedule, String executeTime, long curtime) {
        long retValue = 0L;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(curtime);
        int nowyear = cal.get(1);
        int nowmonth = cal.get(2);
        int nowdate = cal.get(5);
        int nowweek = cal.get(7);
        switch (schedule) {
            case 1: 
            case 5: {
                retValue = IReportMgrUtil.getRunTimeByDay(executeTime, nowyear, nowmonth, nowdate, curtime);
                break;
            }
            case 2: {
                retValue = IReportMgrUtil.getRunTimeByWeek(executeTime, nowweek, nowyear, nowmonth, nowdate, curtime);
                break;
            }
            case 3: {
                retValue = IReportMgrUtil.getRunTimeByMonth(executeTime, nowyear, nowmonth, curtime);
                break;
            }
            case 4: {
                retValue = IReportMgrUtil.getRunTimeByYear(executeTime, nowyear, curtime);
                break;
            }
            default: {
                LOGGER.error((Object)("TimeTask execute schedule error:" + schedule));
            }
        }
        return retValue;
    }

    public static boolean isIntMultipleWithFive(Calendar cal) {
        boolean ret = false;
        int minute = cal.get(12);
        if (0 == minute % 2) {
            ret = true;
        }
        return ret;
    }

    public static boolean parseQueryFile(String pluginPath) {
        String path = pluginPath + File.separator + "parameter.xml";
        boolean isSess = ConditionParser.getInstance().parseSingleFile(path);
        return isSess;
    }

    public static String copyDirectory(String sourPath, String desPath) {
        String result = "";
        boolean isExistFile = false;
        try {
            File sourDirectory = new File(sourPath);
            if (!sourDirectory.exists() || !sourDirectory.isDirectory()) {
                return " source directory:" + sourPath + " is not exist!";
            }
            File desDirectory = new File(desPath);
            if (!desDirectory.exists()) {
                return " destination directory:" + desPath + " is not exist!";
            }
            File[] sourFiles = sourDirectory.listFiles();
            if (null == sourFiles || sourFiles.length <= 0) {
                return " it is not exist JAVA Class files at Source directory:" + sourPath + ",it may have effect with preview!";
            }
            for (File file : sourFiles) {
                if (!file.isFile() || file.getName().equalsIgnoreCase(".svn")) continue;
                isExistFile = true;
                IReportUtil.copyFileBuffered(file, desPath);
            }
            if (!isExistFile) {
                result = " it is not exist JAVA Class files at Source directory:" + sourPath + ",it may have effect with preview!";
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(" copy file to destination:" + desPath + "faild from source " + sourPath + " :"), (Throwable)e);
            result = e.getMessage();
        }
        return result;
    }

    public static OperateResult getOperateResult(String objId, String objName, boolean result, String msg) {
        OperateResult operateResult = null;
        operateResult = new OperateResult();
        operateResult.setObjId(objId);
        operateResult.setObjName(objName);
        operateResult.setResult(result);
        operateResult.setResultInfo(msg);
        return operateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exportToZipFile(String path, String fileName) {
        String ret = "";
        String exportFile = path + fileName;
        try {
            ZipUtil.zip(exportFile, exportFile + ".zip", fileName);
        }
        catch (Exception e) {
            ret = "export to zip file failed!";
            LOGGER.error((Object)ret, (Throwable)e);
            String string = ret;
            return string;
        }
        finally {
            IReportUtil.deleteDirectory(path + fileName);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exportToZipFileForSig(String path, String fileName) {
        String ret = "";
        String exportFile = path + fileName;
        File[] listFiles = new File(exportFile).listFiles();
        ArrayList<String> listFile = new ArrayList<String>();
        if (null != listFiles) {
            for (int i = 0; i < listFiles.length; ++i) {
                listFile.add(listFiles[i].toString());
            }
        } else {
            LOGGER.error((Object)"listFiles is null.");
        }
        try {
            ZipUtil.zipWithFilter(listFile, exportFile + ".zip", null);
        }
        catch (Exception e) {
            ret = "export to zip file failed!";
            LOGGER.error((Object)ret, (Throwable)e);
            String string = ret;
            return string;
        }
        finally {
            IReportUtil.deleteDirectory(path + fileName);
        }
        return ret;
    }

    public static boolean createExportPath(String path) {
        boolean blRtn = false;
        File fpath = null;
        fpath = new File(path);
        if (fpath.exists()) {
            IReportUtil.deleteDirectory(path);
        } else if (!fpath.mkdirs()) {
            LOGGER.error((Object)"Create directory failed!");
        } else {
            blRtn = true;
        }
        return blRtn;
    }

    public static String replaceAllBlank(String srcStr) {
        String ret = "";
        ret = srcStr.trim();
        ret = ret.replaceAll(" ", "");
        ret = ret.replaceAll("[\\s]+", "_");
        return ret;
    }

    public static String getPluginNameFromProperty(String pluginId, Locale locale) {
        String ret = "";
        try {
            IReport report = PluginManager.getInstance().getReportPlugin(pluginId);
            if (null != report) {
                ret = IReportUtil.getProperty(report.getName(), pluginId, locale);
            } else {
                LOGGER.error((Object)("Plugin ID:" + pluginId + " can not be loaded, the time task can not be executed!"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Get plugin ID:" + pluginId + " name failed:"), (Throwable)e);
        }
        return ret;
    }

    public static List<JsonValueItem> getTaskDateScope(int schedule, Calendar cal) {
        List<Object> dataScope = new ArrayList();
        int nowyear = cal.get(1);
        int nowmonth = cal.get(2);
        int nowdate = cal.get(5);
        int nowweek = cal.get(7);
        switch (schedule) {
            case 1: 
            case 5: {
                dataScope = IReportMgrUtil.getDateScopeByDay(nowyear, nowmonth, nowdate);
                break;
            }
            case 2: {
                dataScope = IReportMgrUtil.getDateScopeByWeek(nowweek, nowyear, nowmonth, nowdate);
                break;
            }
            case 3: {
                dataScope = IReportMgrUtil.getDateScopeByMonth(nowyear, nowmonth);
                break;
            }
            case 4: {
                dataScope = IReportMgrUtil.getDateScopeByYear(nowyear);
                break;
            }
            default: {
                LOGGER.error((Object)("TimeTask execute schedule error:" + schedule));
            }
        }
        return dataScope;
    }

    public static String getReportNameFromTemplate() {
        return REPORT_NAME_FROM_TEMPLATE;
    }

    private static List<JsonValueItem> getDateScopeByDay(int year, int month, int date) {
        SimpleDateFormat smpDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<JsonValueItem> dataScope = new ArrayList<JsonValueItem>();
        JsonValueItem startDateObj = new JsonValueItem();
        JsonValueItem endDateObj = new JsonValueItem();
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.set(year, month, date - 1, 0, 0, 0);
        endDate.set(year, month, date - 1, 23, 59, 59);
        startDateObj.setValue(Long.valueOf(startDate.getTimeInMillis() / 1000L).toString());
        startDateObj.setText(smpDateFormat.format(startDate.getTime()));
        endDateObj.setValue(Long.valueOf(endDate.getTimeInMillis() / 1000L).toString());
        endDateObj.setText(smpDateFormat.format(endDate.getTime()));
        startDateObj.setExtendMap(IReportMgrUtil.transMap(startDateObj));
        endDateObj.setExtendMap(IReportMgrUtil.transMap(endDateObj));
        dataScope.add(startDateObj);
        dataScope.add(endDateObj);
        return dataScope;
    }

    private static List<JsonValueItem> getDateScopeByWeek(int week, int year, int month, int date) {
        String dataRangeWay = "zh";
        SimpleDateFormat smpDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        JsonValueItem startDateObj = new JsonValueItem();
        JsonValueItem endDateObj = new JsonValueItem();
        ArrayList<JsonValueItem> dataScope = new ArrayList<JsonValueItem>();
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        dataRangeWay = LocaleUtil.getProperty("task.dataRange");
        if (dataRangeWay.equals("zh")) {
            startDate.set(year, month, date - week + 1 - 7 + 1, 0, 0, 0);
            endDate.set(year, month, date - week + 1, 23, 59, 59);
        } else {
            startDate.set(year, month, date - week + 1 - 7, 0, 0, 0);
            endDate.set(year, month, date - week, 23, 59, 59);
        }
        startDateObj.setValue(Long.valueOf(startDate.getTimeInMillis() / 1000L).toString());
        startDateObj.setText(smpDateFormat.format(startDate.getTime()));
        endDateObj.setValue(Long.valueOf(endDate.getTimeInMillis() / 1000L).toString());
        endDateObj.setText(smpDateFormat.format(endDate.getTime()));
        startDateObj.setExtendMap(IReportMgrUtil.transMap(startDateObj));
        endDateObj.setExtendMap(IReportMgrUtil.transMap(endDateObj));
        dataScope.add(startDateObj);
        dataScope.add(endDateObj);
        return dataScope;
    }

    private static List<JsonValueItem> getDateScopeByMonth(int year, int month) {
        SimpleDateFormat smpDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        JsonValueItem startDateObj = new JsonValueItem();
        JsonValueItem endDateObj = new JsonValueItem();
        ArrayList<JsonValueItem> dataScope = new ArrayList<JsonValueItem>();
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.set(year, month - 1, 1, 0, 0, 0);
        endDate.set(year, month, 0, 23, 59, 59);
        startDateObj.setValue(Long.valueOf(startDate.getTimeInMillis() / 1000L).toString());
        startDateObj.setText(smpDateFormat.format(startDate.getTime()));
        endDateObj.setValue(Long.valueOf(endDate.getTimeInMillis() / 1000L).toString());
        endDateObj.setText(smpDateFormat.format(endDate.getTime()));
        startDateObj.setExtendMap(IReportMgrUtil.transMap(startDateObj));
        endDateObj.setExtendMap(IReportMgrUtil.transMap(endDateObj));
        dataScope.add(startDateObj);
        dataScope.add(endDateObj);
        return dataScope;
    }

    private static List<JsonValueItem> getDateScopeByYear(int year) {
        SimpleDateFormat smpDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        JsonValueItem startDateObj = new JsonValueItem();
        JsonValueItem endDateObj = new JsonValueItem();
        ArrayList<JsonValueItem> dataScope = new ArrayList<JsonValueItem>();
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.set(year - 1, 0, 1, 0, 0, 0);
        endDate.set(year, 0, 0, 23, 59, 59);
        startDateObj.setValue(Long.valueOf(startDate.getTimeInMillis() / 1000L).toString());
        startDateObj.setText(smpDateFormat.format(startDate.getTime()));
        endDateObj.setValue(Long.valueOf(endDate.getTimeInMillis() / 1000L).toString());
        endDateObj.setText(smpDateFormat.format(endDate.getTime()));
        startDateObj.setExtendMap(IReportMgrUtil.transMap(startDateObj));
        endDateObj.setExtendMap(IReportMgrUtil.transMap(endDateObj));
        dataScope.add(startDateObj);
        dataScope.add(endDateObj);
        return dataScope;
    }

    private static List<JsonValueItem> getTaskDateScopeForSig(String startTime, String endTime) {
        ArrayList<JsonValueItem> dataScope = new ArrayList<JsonValueItem>();
        SimpleDateFormat smpDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar sCalendar = Calendar.getInstance();
        Calendar eCalendar = Calendar.getInstance();
        JsonValueItem startDateObj = new JsonValueItem();
        JsonValueItem endDateObj = new JsonValueItem();
        String[] sTime = startTime.split(SEPARATOR);
        String[] eTime = endTime.split(SEPARATOR);
        sCalendar.add(5, Integer.parseInt(sTime[0]) * -1);
        sCalendar.set(11, Integer.parseInt(sTime[1]));
        sCalendar.set(12, Integer.parseInt(sTime[2]));
        sCalendar.set(13, 0);
        eCalendar.add(5, Integer.parseInt(eTime[0]) * -1);
        eCalendar.set(11, Integer.parseInt(eTime[1]));
        eCalendar.set(12, Integer.parseInt(eTime[2]));
        eCalendar.set(13, 0);
        String startDateStr = String.valueOf(sCalendar.getTimeInMillis() / 1000L);
        startDateObj.setValue(startDateStr);
        String endDateStr = String.valueOf(eCalendar.getTimeInMillis() / 1000L);
        startDateObj.setText(smpDateFormat.format(sCalendar.getTime()));
        endDateObj.setValue(endDateStr);
        endDateObj.setText(smpDateFormat.format(eCalendar.getTime()));
        startDateObj.setExtendMap(IReportMgrUtil.transMap(startDateObj));
        endDateObj.setExtendMap(IReportMgrUtil.transMap(endDateObj));
        dataScope.add(startDateObj);
        dataScope.add(endDateObj);
        return dataScope;
    }

    private static Map<String, String> transMap(JsonValueItem value) {
        HashMap<String, String> extendMap = new HashMap<String, String>();
        extendMap.put("value", value.getValue());
        extendMap.put("text", value.getText());
        return extendMap;
    }

    public static List<String> changCondition(List<String> conditionList, int schedule, Calendar cal) throws ParaException {
        List<JsonValueItem> dataScope = IReportMgrUtil.getTaskDateScope(schedule, cal);
        ArrayList<String> conditionNew = new ArrayList<String>();
        for (String item : conditionList) {
            if (!item.equals("null") && !"--".equals(item)) {
                conditionNew.add(IReportMgrUtil.changCondition(item, dataScope));
                continue;
            }
            conditionNew.add("null");
        }
        return conditionNew;
    }

    private static String changCondition(String condition, List<JsonValueItem> dataScope) throws ParaException {
        Map<String, JsonValueObj> reportCond = JSONUtil.transformKeyValueObjMap(condition);
        for (Map.Entry<String, JsonValueObj> executeTask : reportCond.entrySet()) {
            if (executeTask.getValue().getType().equals("dateRange")) {
                executeTask.getValue().setValueList(dataScope);
                continue;
            }
            if (executeTask.getValue().getType().equals("comboDate")) {
                JsonValueItem dataGranularity = executeTask.getValue().getValueList().get(2);
                dataScope.add(dataGranularity);
                executeTask.getValue().setValueList(dataScope);
                continue;
            }
            if (executeTask.getKey().equals("startTime_atic")) {
                ArrayList<JsonValueItem> startTime = new ArrayList<JsonValueItem>();
                startTime.add(dataScope.get(0));
                executeTask.getValue().setValueList(startTime);
                continue;
            }
            if (!executeTask.getKey().equals("endTime_atic")) continue;
            ArrayList<JsonValueItem> endTime = new ArrayList<JsonValueItem>();
            endTime.add(dataScope.get(1));
            executeTask.getValue().setValueList(endTime);
        }
        return JSONUtil.mapToJson(reportCond);
    }

    public static String changConditionForSig(String condition, String startTime, String endTime) throws ParaException {
        List<JsonValueItem> dataScope = IReportMgrUtil.getTaskDateScopeForSig(startTime, endTime);
        Map<String, JsonValueObj> reportCond = null;
        reportCond = JSONUtil.transformKeyValueObjMap(condition);
        for (Map.Entry<String, JsonValueObj> executeTask : reportCond.entrySet()) {
            if (!executeTask.getValue().getType().equals("comboDate") && !executeTask.getValue().getType().equals("dateRange")) continue;
            executeTask.getValue().setValueList(dataScope);
        }
        return JSONUtil.mapToJson(reportCond);
    }

    public static Map<String, JsonValueObj> changConditionForSig(String reportCond) throws ParaException {
        Map<String, JsonValueObj> reportCondMap = JSONUtil.transformKeyValueObjMap(reportCond);
        return IReportMgrUtil.changConditionForSig(reportCondMap);
    }

    public static Map<String, JsonValueObj> changConditionForSig(Map<String, JsonValueObj> reportCondMap) {
        HashMap<String, JsonValueObj> newMap = new HashMap<String, JsonValueObj>();
        newMap.putAll(reportCondMap);
        for (Map.Entry<String, JsonValueObj> executeTask : reportCondMap.entrySet()) {
            if (!executeTask.getValue().getType().equals("comboDate") && !executeTask.getValue().getType().equals("dateRange")) continue;
            JsonValueObj dateRangeObj = executeTask.getValue();
            Calendar startCalendar = Calendar.getInstance();
            Calendar endCalendar = Calendar.getInstance();
            String timeLevel = "";
            if (dateRangeObj.getValueList().get(0).getValue().indexOf(SEPARATOR) < 0) break;
            String[] startTime = dateRangeObj.getValueList().get(0).getValue().split(SEPARATOR);
            startCalendar.add(5, Integer.parseInt(startTime[0]) * -1);
            startCalendar.set(11, Integer.parseInt(startTime[1]));
            startCalendar.set(12, Integer.parseInt(startTime[2]));
            startCalendar.set(13, 0);
            String valueStr = String.valueOf(startCalendar.getTimeInMillis() / 1000L);
            String textStr = IReportUtil.transTimeStr(startCalendar.getTimeInMillis());
            dateRangeObj.getValueList().get(0).setValue(valueStr);
            dateRangeObj.getValueList().get(0).setText(textStr);
            HashMap<String, String> tempMap1 = new HashMap<String, String>();
            tempMap1.put("value", valueStr);
            tempMap1.put("text", textStr);
            dateRangeObj.getValueList().get(0).setExtendMap(tempMap1);
            if (dateRangeObj.getValueList().size() > 1 && dateRangeObj.getValueList().get(1) != null && dateRangeObj.getValueList().get(1).getText().contains(SEPARATOR)) {
                String[] endTime = dateRangeObj.getValueList().get(1).getValue().split(SEPARATOR);
                endCalendar.add(5, Integer.parseInt(endTime[0]) * -1);
                endCalendar.set(11, Integer.parseInt(endTime[1]));
                endCalendar.set(12, Integer.parseInt(endTime[2]));
                endCalendar.set(13, 0);
                String value2Str = String.valueOf(endCalendar.getTimeInMillis() / 1000L);
                String text2Str = IReportUtil.transTimeStr(endCalendar.getTimeInMillis());
                dateRangeObj.getValueList().get(1).setValue(value2Str);
                dateRangeObj.getValueList().get(1).setText(text2Str);
                HashMap<String, String> tempMap2 = new HashMap<String, String>();
                tempMap2.put("value", value2Str);
                tempMap2.put("text", text2Str);
                dateRangeObj.getValueList().get(1).setExtendMap(tempMap2);
            } else if (dateRangeObj.getValueList().size() > 1 && dateRangeObj.getValueList().get(1) != null && !dateRangeObj.getValueList().get(1).getText().contains(SEPARATOR)) {
                timeLevel = dateRangeObj.getValueList().get(1).getValue();
                dateRangeObj.getValueList().get(1).setValue(timeLevel);
            }
            if (dateRangeObj.getValueList().size() > 2) {
                timeLevel = dateRangeObj.getValueList().get(2).getValue();
                dateRangeObj.getValueList().get(2).setValue(timeLevel);
            }
            executeTask.setValue(dateRangeObj);
            newMap.remove(executeTask.getKey());
            newMap.put(executeTask.getKey(), dateRangeObj);
        }
        LOGGER.info((Object)("changConditionForSig ->" + IReportUtil.getcleanedMessage(JSONUtil.mapToJson(newMap))));
        return newMap;
    }
}

