/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.exception.ParaException;
import com.security.ireport.model.vo.DisplayCondObj;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.LocaleUtil;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public abstract class JSONUtil {
    public static final String JSON_ID = "id";
    public static final String JSON_VALUE = "value";
    public static final String JSON_TEXT = "text";
    public static final String JSON_SUBGROUP_ID = "subGroupId";
    public static final String JSON_ORDERINFO_ID = "groupOrder";
    public static final String JSON_TYPE = "type";
    public static final String JSON_DISPLAY_FIELD = "displayField";
    public static final String JSON_VALUE_FIELD = "valueField";
    public static final String JSON_SUBGROUP_LABEL = "subGroupLabel";
    public static final String COMBODATE_TYPE = "comboDate";
    public static final String NATUREDATE_TYPE = "natureDate";
    public static final String DATERANGE_TYPE = "dateRange";
    public static final String TIMECOMBINA_TYPE = "TimeCombina";
    public static final String TEXT_SUFFIX = "_text";
    public static final String PARA_REPORT_ID = "reportId";
    public static final String PARA_REPORT_SESSION_ID = "reportSessionId";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final String HIDDEN_TYPE = "hidden";
    private static final String SHOW_INFO = "showInfo";

    public static Map<String, Object> transform(String str) {
        if (IReportConfCheckUtil.isStringEmpty(str)) {
            LOGGER.error((Object)"json str is empty.");
            return new HashMap<String, Object>();
        }
        return JSONUtil.transformJson(str);
    }

    private static Map<String, Object> transformJson(String str) {
        HashMap<String, Object> reportCond = new HashMap<String, Object>();
        if (JSONUtil.isArray(str)) {
            JSONArray jsonArray = JSONArray.fromObject((Object)str);
            for (int i = 0; i < jsonArray.size(); ++i) {
                reportCond.put("" + i, JSONUtil.transStr(jsonArray.get(i).toString()));
            }
        } else {
            JSONObject jsonObject = JSONObject.fromObject((Object)str);
            Iterator e = jsonObject.keys();
            while (e.hasNext()) {
                String key = IReportConfCheckUtil.getObjectStr(e.next());
                reportCond.put(key, JSONUtil.transStr(jsonObject.get(key).toString()));
            }
        }
        return reportCond;
    }

    private static Object transStr(String str) {
        if (str.startsWith("[") || str.startsWith("{")) {
            return JSONUtil.transform(str);
        }
        return str;
    }

    public static Map<String, List<String>> transformKeyValueMap(Map<String, JsonValueObj> map) {
        HashMap<String, List<String>> keyValueMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, JsonValueObj> item : map.entrySet()) {
            ArrayList<String> list = new ArrayList<String>();
            for (JsonValueItem valueItem : item.getValue().getValueList()) {
                list.add(valueItem.getValue());
            }
            keyValueMap.put(item.getKey(), list);
        }
        return keyValueMap;
    }

    public static Map<String, JsonValueObj> transformKeyValueObjMap(String jsonStr) throws ParaException {
        LOGGER.debug((Object)("jsonStr:" + IReportUtil.getcleanedMessage(jsonStr)));
        Map<String, Object> map = JSONUtil.transform(jsonStr);
        return JSONUtil.transformKeyValueObjMap(map);
    }

    public static Map<String, JsonValueObj> transformKeyValueObjMap(Map<String, Object> map) throws ParaException {
        HashMap<String, JsonValueObj> keyValueMap = new HashMap<String, JsonValueObj>();
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry<String, Object> item : set) {
            Map temp = (Map)item.getValue();
            String key = IReportConfCheckUtil.getObjectStr(temp.get(JSON_ID));
            String subGroupId = "";
            if (temp.containsKey(JSON_SUBGROUP_ID)) {
                subGroupId = IReportConfCheckUtil.getObjectStr(temp.get(JSON_SUBGROUP_ID));
            }
            String orderInforId = "";
            if (temp.containsKey(JSON_ORDERINFO_ID)) {
                orderInforId = IReportConfCheckUtil.getObjectStr(temp.get(JSON_ORDERINFO_ID));
            }
            String subGroupLabel = "";
            if (temp.containsKey(JSON_SUBGROUP_LABEL)) {
                subGroupLabel = IReportConfCheckUtil.getObjectStr(temp.get(JSON_SUBGROUP_LABEL));
            }
            String type = "";
            if (temp.containsKey(JSON_TYPE)) {
                type = IReportConfCheckUtil.getObjectStr(temp.get(JSON_TYPE));
            }
            String displayField = JSON_TEXT;
            if (temp.containsKey(JSON_DISPLAY_FIELD)) {
                displayField = IReportConfCheckUtil.getObjectStr(temp.get(JSON_DISPLAY_FIELD));
            }
            String valueField = JSON_VALUE;
            if (temp.containsKey(JSON_VALUE_FIELD)) {
                valueField = IReportConfCheckUtil.getObjectStr(temp.get(JSON_VALUE_FIELD));
            }
            String showInfo = "true";
            if (temp.containsKey(SHOW_INFO)) {
                showInfo = IReportConfCheckUtil.getObjectStr(temp.get(SHOW_INFO));
            }
            Map valueMap = (Map)temp.get(JSON_VALUE);
            JsonValueObj valueObj = new JsonValueObj();
            List<JsonValueItem> valueList = JSONUtil.getJsonValueList(valueMap, valueField, displayField);
            if (valueList.isEmpty()) continue;
            if (!JSONUtil.checkData(key, type, valueList)) {
                throw new ParaException(key + " check error.");
            }
            valueObj.setSubLabel(IReportConfCheckUtil.getObjectStr(temp.get("subLabel")));
            valueObj.setSubGroupId(subGroupId);
            valueObj.setSubGroupLabel(subGroupLabel);
            valueObj.setType(type);
            valueObj.setDisplayField(displayField);
            valueObj.setValueField(valueField);
            valueObj.setValueList(valueList);
            valueObj.setShowInfo(showInfo);
            valueObj.setOrderInforId(orderInforId);
            keyValueMap.put(key, valueObj);
        }
        return keyValueMap;
    }

    private static boolean checkData(String key, String type, List<JsonValueItem> valueList) {
        if (!JSONUtil.checkNumber(key, valueList)) {
            return false;
        }
        if (!JSONUtil.checkTopN(key, valueList)) {
            return false;
        }
        if (!JSONUtil.checkCheckboxValue(key, valueList)) {
            return false;
        }
        if (!JSONUtil.checkIpv4(key, valueList)) {
            return false;
        }
        if (!JSONUtil.checkIds(key, valueList)) {
            return false;
        }
        if (!JSONUtil.checkUsers(key, valueList)) {
            return false;
        }
        if (!JSONUtil.checkDateRange(key, valueList)) {
            return false;
        }
        if (!JSONUtil.checkMenuId(key, valueList)) {
            return false;
        }
        return JSONUtil.checkFileTypes(key, valueList);
    }

    private static boolean checkFileTypes(String key, List<JsonValueItem> valueList) {
        if ("fileTypes".equals(key)) {
            if (valueList.size() != 1) {
                return false;
            }
            String kv = valueList.get(0).getValue();
            if (null != kv && !kv.isEmpty() && !kv.matches("[a-zA-Z0-9,]*")) {
                return false;
            }
        }
        return true;
    }

    private static boolean checkMenuId(String key, List<JsonValueItem> valueList) {
        if ("menuId".equals(key)) {
            if (valueList.size() != 1) {
                return false;
            }
            String kv = valueList.get(0).getValue();
            if (null != kv && !kv.isEmpty()) {
                String[] vs;
                for (String v : vs = kv.split("-")) {
                    if (v.isEmpty() || JSONUtil.isNumber(v)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkTopN(String key, List<JsonValueItem> valueList) {
        if ("topN".equals(key)) {
            if (valueList.size() != 1) {
                return false;
            }
            String kv = valueList.get(0).getValue();
            if (!JSONUtil.isNumber(kv)) {
                return false;
            }
            int num = Integer.parseInt(kv);
            if (num <= 0 || num > 50) {
                return false;
            }
        }
        return true;
    }

    private static boolean checkNumber(String key, List<JsonValueItem> valueList) {
        String[] ckKeys;
        for (String k : ckKeys = new String[]{"operaObject"}) {
            if (!k.equals(key)) continue;
            if (valueList.size() != 1) {
                return false;
            }
            return JSONUtil.isNumber(valueList.get(0).getValue());
        }
        return true;
    }

    private static boolean checkIds(String key, List<JsonValueItem> valueList) {
        if ("DEVICE_ID".equals(key)) {
            for (JsonValueItem item : valueList) {
                String v = item.getValue();
                if (JSONUtil.isNumber(v)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private static boolean checkUsers(String key, List<JsonValueItem> valueList) {
        if ("users".equals(key)) {
            for (JsonValueItem item : valueList) {
                String v = item.getValue();
                if (JSONUtil.isUserNumber(v)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private static boolean checkDateRange(String key, List<JsonValueItem> valueList) {
        try {
            if (DATERANGE_TYPE.equals(key)) {
                int end;
                if (valueList.size() != 2) {
                    return false;
                }
                if (!JSONUtil.isNumber(valueList.get(0).getValue()) || !JSONUtil.isNumber(valueList.get(1).getValue())) {
                    return false;
                }
                int from = Integer.parseInt(valueList.get(0).getValue());
                if (from > (end = Integer.parseInt(valueList.get(1).getValue()))) {
                    return false;
                }
            }
        }
        catch (RuntimeException ex) {
            return false;
        }
        return true;
    }

    private static boolean checkCheckboxValue(String key, List<JsonValueItem> valueList) {
        String[] ckKeys;
        for (String k : ckKeys = new String[]{"protocolId", "protocols", "probeProtocol", "action", "headOffType", "headOffType", "detailApp"}) {
            if (!k.equals(key)) continue;
            for (JsonValueItem item : valueList) {
                String[] vvs;
                for (String v : vvs = item.getValue().split(",")) {
                    if (JSONUtil.isNumber(v)) continue;
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private static boolean checkIpv4(String key, List<JsonValueItem> valueList) {
        String[] ckKeys;
        for (String k : ckKeys = new String[]{"ipMark1", "ipMark2"}) {
            if (!k.equals(key)) continue;
            if (valueList.size() != 1) {
                return false;
            }
            return JSONUtil.isIpv4(valueList.get(0).getValue());
        }
        return true;
    }

    private static boolean isNumber(String value) {
        int size = value.length();
        for (int i = 0; i < size; ++i) {
            char c = value.charAt(i);
            if (c == '-' && i == 0 && size > 1 || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isUserNumber(String value) {
        value = value.replace(",", "");
        int size = value.length();
        for (int i = 0; i < size; ++i) {
            char c = value.charAt(i);
            if (c == '-' && i == 0 && size > 1 || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isIpv4(String value) {
        String[] ss = value.split("\\.");
        if (ss.length != 4) {
            return false;
        }
        for (String s : ss) {
            if (s.isEmpty() || !JSONUtil.isNumber(s)) {
                return false;
            }
            int si = Integer.parseInt(s);
            if (si >= 0 && si <= 255) continue;
            return false;
        }
        return true;
    }

    private static List<JsonValueItem> getJsonValueList(Map<?, ?> valueMap, String valueField, String displayField) {
        ArrayList<JsonValueItem> valueList = new ArrayList<JsonValueItem>();
        if (valueMap.containsKey(JSON_VALUE)) {
            JsonValueItem obj = new JsonValueItem();
            obj.setValue(IReportConfCheckUtil.getObjectStr(valueMap.get(valueField)));
            if (!obj.getValue().trim().isEmpty()) {
                obj.setText(IReportConfCheckUtil.getObjectStr(valueMap.get(displayField)));
                obj.setExtendMap(valueMap);
                valueList.add(obj);
            }
        } else {
            for (int i = 0; i < valueMap.size(); ++i) {
                JsonValueItem obj = new JsonValueItem();
                Map tempMap = (Map)valueMap.get(i + "");
                obj.setExtendMap(tempMap);
                obj.setValue(IReportConfCheckUtil.getObjectStr(tempMap.get(valueField)));
                obj.setText(IReportConfCheckUtil.getObjectStr(tempMap.get(displayField)));
                valueList.add(obj);
            }
        }
        return valueList;
    }

    private static boolean isArray(String str) {
        String normalizeStr = Normalizer.normalize(str, Normalizer.Form.NFKC);
        return normalizeStr.startsWith("[");
    }

    public static Map<String, JsonValueObj> createParaMap(Map<String, String[]> requestParaMap) {
        HashMap<String, JsonValueObj> result = new HashMap<String, JsonValueObj>();
        HashMap<String, String[]> paraMap = new HashMap<String, String[]>();
        paraMap.putAll(requestParaMap);
        paraMap.remove(PARA_REPORT_ID);
        paraMap.remove(PARA_REPORT_SESSION_ID);
        for (Map.Entry<String, String[]> entry : paraMap.entrySet()) {
            String normalizeKeyDb = Normalizer.normalize((CharSequence)entry.getKey(), Normalizer.Form.NFKC);
            if (normalizeKeyDb.endsWith(TEXT_SUFFIX)) continue;
            JsonValueObj obj = JSONUtil.createJsonValueObj(entry, paraMap);
            obj.setShowInfo("false");
            result.put(entry.getKey(), obj);
        }
        return result;
    }

    private static JsonValueObj createJsonValueObj(Map.Entry<String, String[]> item, Map<String, String[]> paraMap) {
        JsonValueObj obj = new JsonValueObj();
        ArrayList<JsonValueItem> list = new ArrayList<JsonValueItem>();
        if (item.getValue().length > 1) {
            int size = item.getValue().length;
            for (int i = 0; i < size; ++i) {
                JsonValueItem temp = new JsonValueItem();
                temp.setValue(item.getValue()[i]);
                if (paraMap.containsKey(item.getKey() + TEXT_SUFFIX)) {
                    temp.setText(paraMap.get(item.getKey() + TEXT_SUFFIX)[i]);
                } else {
                    temp.setText(item.getValue()[i]);
                }
                HashMap<String, String> extendMap = new HashMap<String, String>();
                extendMap.put(JSON_VALUE, temp.getValue());
                extendMap.put(JSON_TEXT, temp.getText());
                temp.setExtendMap(extendMap);
                list.add(temp);
            }
        } else {
            JsonValueItem valueItem = new JsonValueItem();
            valueItem.setValue(item.getValue()[0]);
            if (paraMap.containsKey(item.getKey() + TEXT_SUFFIX)) {
                valueItem.setText(paraMap.get(item.getKey() + TEXT_SUFFIX)[0]);
            } else {
                valueItem.setText(item.getValue()[0]);
            }
            HashMap<String, String> extendMap = new HashMap<String, String>();
            extendMap.put(JSON_VALUE, valueItem.getValue());
            extendMap.put(JSON_TEXT, valueItem.getText());
            valueItem.setExtendMap(extendMap);
            list.add(valueItem);
        }
        obj.setValueList(list);
        return obj;
    }

    /*
     * WARNING - void declaration
     */
    public static List<DisplayCondObj> toDisplayCond(String str, Locale locale) {
        ArrayList<DisplayCondObj> displayCondList = new ArrayList<DisplayCondObj>();
        LinkedHashMap<String, DisplayCondObj> displayCondMap = new LinkedHashMap<String, DisplayCondObj>();
        boolean isHasOrderInfo = true;
        int maxKey = 0;
        String[] orders = new String[]{};
        DisplayCondObj[] displayCondObjs = new DisplayCondObj[]{};
        try {
            Map<String, Object> map = JSONUtil.transform(str);
            for (int i = 0; i < map.size(); ++i) {
                String order;
                String value;
                DisplayCondObj displayCondObj;
                Map condMap = (Map)map.get(String.valueOf(i));
                if (HIDDEN_TYPE.equals(IReportConfCheckUtil.getObjectStr(condMap.get(JSON_TYPE)))) continue;
                if (COMBODATE_TYPE.equals(IReportConfCheckUtil.getObjectStr(condMap.get(JSON_TYPE)))) {
                    String string = IReportConfCheckUtil.getObjectStr(condMap.get(JSON_SUBGROUP_LABEL));
                    String order2 = IReportConfCheckUtil.getObjectStr(condMap.get(JSON_ORDERINFO_ID));
                    if (Integer.parseInt(order2) >= maxKey) {
                        maxKey = Integer.parseInt(order2);
                    }
                    String value2 = JSONUtil.getComboDateValueStr(condMap);
                    displayCondObj = new DisplayCondObj(order2, value2);
                    if (displayCondMap.get(string) == null) {
                        displayCondMap.put(string, displayCondObj);
                        continue;
                    }
                    displayCondObj.setValue(((DisplayCondObj)displayCondMap.get(string)).getValue() + "; " + value2);
                    displayCondMap.put(string, displayCondObj);
                    continue;
                }
                if (NATUREDATE_TYPE.equals(IReportConfCheckUtil.getObjectStr(condMap.get(JSON_TYPE)))) {
                    String string = IReportConfCheckUtil.getObjectStr(condMap.get(JSON_SUBGROUP_LABEL));
                    value = JSONUtil.getNatureDateValueStr(condMap);
                    order = IReportConfCheckUtil.getObjectStr(condMap.get(JSON_ORDERINFO_ID));
                    if (Integer.parseInt(order) >= maxKey) {
                        maxKey = Integer.parseInt(order);
                    }
                    displayCondObj = new DisplayCondObj(order, value);
                    if (displayCondMap.get(string) == null) {
                        displayCondMap.put(string, displayCondObj);
                        continue;
                    }
                    displayCondObj.setValue(((DisplayCondObj)displayCondMap.get(string)).getValue() + "; " + value);
                    displayCondMap.put(string, displayCondObj);
                    continue;
                }
                if (Boolean.FALSE.toString().equals(IReportConfCheckUtil.getObjectStr(condMap.get(SHOW_INFO)))) continue;
                String string = IReportConfCheckUtil.getObjectStr(condMap.get(JSON_SUBGROUP_LABEL));
                value = JSONUtil.getValueStr(condMap, displayCondMap, string, JSON_SUBGROUP_LABEL, locale);
                order = IReportConfCheckUtil.getObjectStr(condMap.get(JSON_ORDERINFO_ID));
                if (order.equals("")) {
                    isHasOrderInfo = false;
                } else if (Integer.parseInt(order) >= maxKey) {
                    maxKey = Integer.parseInt(order);
                }
                displayCondObj = new DisplayCondObj(order, value);
                if (IReportConfCheckUtil.isStringEmpty(value)) continue;
                if (displayCondMap.get(string) == null) {
                    displayCondMap.put(string, displayCondObj);
                } else {
                    displayCondObj.setValue(((DisplayCondObj)displayCondMap.get(string)).getValue() + "; " + value);
                    displayCondMap.put(string, displayCondObj);
                }
                if (!TIMECOMBINA_TYPE.equals(IReportConfCheckUtil.getObjectStr(condMap.get(JSON_TYPE)))) continue;
                Object[] resultObjects = JSONUtil.handleTimeCombina(condMap, displayCondMap, order, locale, orders, displayCondObjs);
                orders = (String[])resultObjects[0];
                displayCondObjs = (DisplayCondObj[])resultObjects[1];
            }
            if (isHasOrderInfo) {
                void var11_21;
                DisplayCondObj[] array = new DisplayCondObj[maxKey + 1];
                for (Map.Entry entry : displayCondMap.entrySet()) {
                    array[Integer.parseInt((String)((DisplayCondObj)entry.getValue()).getKey())] = new DisplayCondObj((String)entry.getKey(), ((DisplayCondObj)entry.getValue()).getValue());
                }
                boolean[] isSortOrder = new boolean[orders.length];
                boolean bl = false;
                while (var11_21 < array.length) {
                    if (array[var11_21] != null) {
                        displayCondList.add(new DisplayCondObj(array[var11_21].getKey(), array[var11_21].getValue()));
                    }
                    for (int j = 0; j < orders.length; ++j) {
                        if (!String.valueOf((int)var11_21).equals(orders[j]) || isSortOrder[j]) continue;
                        isSortOrder[j] = true;
                        orders[j] = String.valueOf(displayCondList.size());
                        break;
                    }
                    ++var11_21;
                }
            } else {
                for (Map.Entry entry : displayCondMap.entrySet()) {
                    displayCondList.add(new DisplayCondObj((String)entry.getKey(), ((DisplayCondObj)entry.getValue()).getValue()));
                }
            }
        }
        catch (RuntimeException e) {
            displayCondList = new ArrayList();
            LOGGER.error((Object)("json format is error:" + IReportUtil.getcleanedMessage(str)));
        }
        JSONUtil.addTimesubLabel(displayCondList, isHasOrderInfo, orders, displayCondObjs);
        return displayCondList;
    }

    private static void addTimesubLabel(List<DisplayCondObj> displayCondLis, boolean isHasOrderInfo, String[] orders, DisplayCondObj[] displayCondObjs) {
        block4: {
            if (IReportConfCheckUtil.isListEmpty(displayCondLis) || displayCondObjs.length <= 0) break block4;
            if (isHasOrderInfo) {
                int num = orders.length;
                for (int index = 0; index < num; ++index) {
                    displayCondLis.add(Integer.parseInt(orders[index]), displayCondObjs[index]);
                }
            } else {
                int num = displayCondObjs.length;
                for (int index = 0; index < num; ++index) {
                    displayCondLis.add(displayCondObjs[index]);
                }
            }
        }
    }

    private static Object[] handleTimeCombina(Map<String, Object> condMap, Map<String, DisplayCondObj> displayCondMap, String order, Locale locale, String[] orders, DisplayCondObj[] displayCondObjs) {
        DisplayCondObj displayCondObj = null;
        Object[] resultObjects = new Object[]{orders, displayCondObjs};
        String key = (String)condMap.get("subLabel");
        if (!IReportConfCheckUtil.isStringEmpty(key)) {
            String value = JSONUtil.getValueStr(condMap, displayCondMap, key, null, locale);
            displayCondObj = new DisplayCondObj(key, value);
        }
        if (null == displayCondObj) {
            return resultObjects;
        }
        String[] tempOrders = new String[orders.length + 1];
        DisplayCondObj[] tempDisplayCondObjs = new DisplayCondObj[displayCondObjs.length + 1];
        System.arraycopy(orders, 0, tempOrders, 0, orders.length);
        tempOrders[orders.length] = order;
        System.arraycopy(displayCondObjs, 0, tempDisplayCondObjs, 0, displayCondObjs.length);
        tempDisplayCondObjs[displayCondObjs.length] = displayCondObj;
        resultObjects[0] = tempOrders;
        resultObjects[1] = tempDisplayCondObjs;
        return resultObjects;
    }

    private static String getNatureDateValueStr(Map<String, Object> condMap) {
        String value = "";
        Map valueMap = (Map)condMap.get(JSON_VALUE);
        String displayField = JSON_TEXT;
        String valueField = JSON_VALUE;
        if (valueMap.get("0") != null && valueMap.get("1") != null) {
            String startTimeStr = IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("0")).get(displayField));
            String endTimeStr = IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("1")).get(displayField));
            SimpleDateFormat smpDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date startTimeDate = smpDateFormat.parse(startTimeStr);
                Date endTimeDate = smpDateFormat.parse(endTimeStr);
                value = value + startTimeStr;
                if (startTimeDate.getTime() / 1000L == Long.parseLong(IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("0")).get(valueField))) + (long)JSONUtil.getDSTOffset()) {
                    value = value + startTimeStr + " DST";
                }
                if (endTimeDate.getTime() / 1000L == Long.parseLong(IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("1")).get(valueField))) + (long)JSONUtil.getDSTOffset()) {
                    endTimeStr = endTimeStr + " DST";
                }
                value = value + ", " + endTimeStr;
            }
            catch (ParseException e) {
                LOGGER.error((Object)"ParseException->", (Throwable)e);
            }
        } else {
            LOGGER.error((Object)("comboDate json is error. valueMap size:" + valueMap.size()));
        }
        return value;
    }

    private static String getValueStr(Map<String, Object> condMap, Map<String, DisplayCondObj> displayCondMap, String key, String constantKey, Locale locale) {
        Map valueMap;
        String value = "";
        if (displayCondMap.get(key) != null && !displayCondMap.get(key).getValue().isEmpty()) {
            value = displayCondMap.get(key).getValue() + "; ";
        }
        if ((valueMap = (Map)condMap.get(JSON_VALUE)).containsKey(JSON_VALUE)) {
            value = value + IReportConfCheckUtil.getObjectStr(valueMap.get(JSON_TEXT));
        } else {
            String displayField = JSON_TEXT;
            if (condMap.containsKey(JSON_DISPLAY_FIELD)) {
                displayField = IReportConfCheckUtil.getObjectStr(condMap.get(JSON_DISPLAY_FIELD));
            }
            value = value + JSONUtil.getMoreValue(condMap, valueMap, displayField, constantKey, locale);
        }
        return value;
    }

    private static String getComboDateValueStr(Map<String, Object> condMap) {
        String value = "";
        Map valueMap = (Map)condMap.get(JSON_VALUE);
        String displayField = JSON_TEXT;
        String valueField = JSON_VALUE;
        if (condMap.containsKey(JSON_DISPLAY_FIELD)) {
            displayField = IReportConfCheckUtil.getObjectStr(condMap.get(JSON_DISPLAY_FIELD));
            valueField = IReportConfCheckUtil.getObjectStr(condMap.get(JSON_VALUE_FIELD));
        }
        if (valueMap.get("0") != null && valueMap.get("1") != null) {
            String dataLevelKind = "";
            String timeVal = "";
            String startTimeStr = IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("0")).get(displayField));
            String endTimeStr = IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("1")).get(displayField));
            SimpleDateFormat smpDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            switch (valueMap.size()) {
                case 5: {
                    dataLevelKind = IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("2")).get(valueField));
                    timeVal = IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("3")).get(valueField));
                    break;
                }
                case 4: {
                    timeVal = IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("2")).get(valueField));
                    break;
                }
                case 3: {
                    dataLevelKind = IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("2")).get(valueField));
                    break;
                }
                case 2: {
                    break;
                }
            }
            try {
                Date startTimeDate = smpDateFormat.parse(startTimeStr);
                Date endTimeDate = smpDateFormat.parse(endTimeStr);
                value = startTimeStr;
                if (startTimeDate.getTime() / 1000L == Long.parseLong(IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("0")).get(valueField))) + (long)JSONUtil.getDSTOffset()) {
                    value = startTimeStr + " DST";
                }
                if (endTimeDate.getTime() / 1000L == Long.parseLong(IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("1")).get(valueField))) + (long)JSONUtil.getDSTOffset()) {
                    endTimeStr = endTimeStr + " DST";
                }
                value = value + ", " + endTimeStr;
                if (!"".equals(timeVal)) {
                    String timeValStr = "";
                    switch (Integer.parseInt(timeVal)) {
                        case 1: {
                            timeValStr = LocaleUtil.getProperty("time.day");
                            break;
                        }
                        case 2: {
                            timeValStr = LocaleUtil.getProperty("time.week");
                            break;
                        }
                        case 3: {
                            timeValStr = LocaleUtil.getProperty("time.month");
                            break;
                        }
                        case 4: {
                            timeValStr = LocaleUtil.getProperty("time.quarter");
                            break;
                        }
                    }
                    value = value + ", " + LocaleUtil.getProperty("time.timeGranularity") + ":" + timeValStr;
                }
                if (!"".equals(dataLevelKind)) {
                    String dataLevelKindStr = "";
                    switch (Integer.parseInt(dataLevelKind)) {
                        case 0: {
                            dataLevelKindStr = LocaleUtil.getProperty("time.default");
                            break;
                        }
                        case 1: {
                            dataLevelKindStr = LocaleUtil.getProperty("time.minute");
                            break;
                        }
                        case 2: {
                            dataLevelKindStr = LocaleUtil.getProperty("time.hour");
                            break;
                        }
                        case 3: {
                            dataLevelKindStr = LocaleUtil.getProperty("time.day");
                            break;
                        }
                        case 4: {
                            dataLevelKindStr = LocaleUtil.getProperty("time.month");
                            break;
                        }
                    }
                    value = value + ", " + LocaleUtil.getProperty("time.dataGranularity") + ":" + dataLevelKindStr;
                }
            }
            catch (ParseException e) {
                LOGGER.error((Object)"ParseException->", (Throwable)e);
            }
        } else {
            LOGGER.error((Object)("comboDate json is error. valueMap size:" + valueMap.size()));
        }
        return value;
    }

    private static int getDSTOffset() {
        Calendar calendar = Calendar.getInstance();
        int dSTOffSet = calendar.get(16) / 1000;
        if (dSTOffSet == 0) {
            dSTOffSet = 3600;
        }
        if (dSTOffSet < 0) {
            dSTOffSet = -dSTOffSet;
        }
        return dSTOffSet;
    }

    private static String getMoreValue(Map<String, Object> condMap, Map<?, ?> valueMap, String displayField, String constantKey, Locale locale) {
        StringBuffer value = new StringBuffer();
        if (valueMap.get("0") != null) {
            if (TIMECOMBINA_TYPE.equals(IReportConfCheckUtil.getObjectStr(condMap.get(JSON_TYPE)))) {
                if (JSON_SUBGROUP_LABEL.equals(constantKey)) {
                    value.append(IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("0")).get(displayField)).substring(0, 10));
                    value.append(' ').append(LocaleUtil.getProperty("dateRange.common.time.to", locale)).append(' ').append(IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("1")).get(displayField)).substring(0, 10));
                } else {
                    value.append(IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("2")).get(displayField)));
                }
            } else {
                value.append(IReportConfCheckUtil.getObjectStr(((Map)valueMap.get("0")).get(displayField)));
                for (int j = 1; j < valueMap.size(); ++j) {
                    if (DATERANGE_TYPE.equals(IReportConfCheckUtil.getObjectStr(condMap.get(JSON_TYPE)))) {
                        value.append(' ').append(LocaleUtil.getProperty("dateRange.common.time.to", locale)).append(' ').append(IReportConfCheckUtil.getObjectStr(((Map)valueMap.get(String.valueOf(j))).get(displayField)));
                        continue;
                    }
                    value.append(", ").append(IReportConfCheckUtil.getObjectStr(((Map)valueMap.get(String.valueOf(j))).get(displayField)));
                }
            }
        }
        return value.toString();
    }

    public static String mapToJson(Map<String, JsonValueObj> cond) {
        String temp = "";
        if (cond != null && !cond.isEmpty()) {
            StringBuffer json = new StringBuffer();
            for (Map.Entry<String, JsonValueObj> item : cond.entrySet()) {
                json.append('{').append("\"id\":\"").append(item.getKey()).append("\",");
                json.append("\"value\":");
                json.append('[');
                String temp2 = JSONUtil.mapToValueJson(item);
                if (!temp2.isEmpty()) {
                    json.append(temp2.substring(0, temp2.length() - 1));
                }
                json.append(']');
                json.append(",\"subGroupId\":\"").append(item.getValue().getSubGroupId()).append('\"');
                json.append(",\"subGroupLabel\":\"").append(item.getValue().getSubGroupLabel()).append('\"');
                json.append(",\"groupOrder\":\"").append(item.getValue().getOrderInforId()).append('\"');
                if (!IReportConfCheckUtil.isStringEmpty(item.getValue().getType())) {
                    json.append(",\"type\":\"").append(item.getValue().getType()).append('\"');
                }
                if (!IReportConfCheckUtil.isStringEmpty(item.getValue().getDisplayField())) {
                    json.append(",\"displayField\":\"").append(item.getValue().getDisplayField()).append('\"');
                }
                if (!IReportConfCheckUtil.isStringEmpty(item.getValue().getValueField())) {
                    json.append(",\"valueField\":\"").append(item.getValue().getValueField()).append('\"');
                }
                if (!IReportConfCheckUtil.isStringEmpty(item.getValue().getSubLabel())) {
                    json.append(",\"subLabel\":\"").append(item.getValue().getSubLabel()).append('\"');
                }
                if (!IReportConfCheckUtil.isStringEmpty(item.getValue().getShowInfo())) {
                    json.append(",\"showInfo\":\"").append(item.getValue().getShowInfo()).append('\"');
                } else {
                    json.append(",\"showInfo\":\"").append("true").append('\"');
                }
                json.append("},");
            }
            temp = json.toString();
            temp = temp.substring(0, temp.length() - 1);
        }
        return '[' + temp + ']';
    }

    private static String mapToValueJson(Map.Entry<String, JsonValueObj> item) {
        StringBuffer valueJson = new StringBuffer();
        for (JsonValueItem value : item.getValue().getValueList()) {
            valueJson.append('{');
            Set<Map.Entry<String, String>> tempSet = value.getExtendMap().entrySet();
            StringBuffer tempJson = new StringBuffer();
            for (Map.Entry<String, String> entry : tempSet) {
                tempJson.append('\"').append(JSONUtil.escapeContentString(entry.getKey())).append("\":");
                tempJson.append('\"').append(JSONUtil.escapeContentString(entry.getValue())).append("\",");
            }
            String temp3 = tempJson.toString();
            if (!temp3.isEmpty()) {
                valueJson.append(temp3.substring(0, temp3.length() - 1));
            }
            valueJson.append("},");
        }
        return valueJson.toString();
    }

    private static String escapeContentString(String content) {
        if (null == content) {
            content = "";
        }
        return content.replace("\"", "\\\"");
    }

    public static boolean isValidJsonStr(String jsonStr) {
        try {
            JSONArray.fromObject((Object)jsonStr);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return false;
        }
        return true;
    }
}

