/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.util.IReportUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public abstract class JasperReportConfigFactory {
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static Map<TemplateFileName, String> templateMap = new HashMap<TemplateFileName, String>();
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTemplateXmlByCache(TemplateFileName fileName) {
        Object object = LOCK;
        synchronized (object) {
            String templateXml = templateMap.get((Object)fileName);
            if (!(null != templateXml && templateXml.length() != 0 || null != (templateXml = templateMap.get((Object)fileName)) && templateXml.length() != 0)) {
                templateXml = JasperReportConfigFactory.getTemplateXml(fileName);
                templateMap.put(fileName, templateXml);
            }
            return templateXml;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getTemplateXml(TemplateFileName fileName) {
        String xmlFile = IReportUtil.getJasperTemplatePath() + fileName.name + ".jrxml";
        FileInputStream fis = null;
        BufferedReader reader = null;
        try {
            String line;
            StringBuffer fileContent = new StringBuffer();
            fis = new FileInputStream(xmlFile);
            reader = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                fileContent.append(line).append('\n');
            }
            String string = fileContent.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("File read failed: " + fileName.name));
            String string = null;
            return string;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("File read failed: " + fileName.name), (Throwable)e);
            String string = null;
            return string;
        }
        catch (IOException e) {
            LOG.error((Object)("File read failed: " + fileName.name), (Throwable)e);
            String string = null;
            return string;
        }
        catch (RuntimeException e) {
            LOG.error((Object)("File read failed: " + fileName.name), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"close failed", (Throwable)e);
                }
            }
            if (null != fis) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException e) {
                    LOG.error((Object)"close failed", (Throwable)e);
                }
            }
        }
    }

    public static enum TemplateFileName {
        TEMPLATE_FRAME("rptTemplate1", null);

        private final String name;
        private final String tempName;

        private TemplateFileName(String name, String tempName) {
            this.name = name;
            this.tempName = tempName;
        }

        public String getName() {
            return this.name;
        }

        public String getTempName() {
            return this.tempName;
        }
    }
}

