/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.security.ireport.engine.definition.IRColumn;
import com.security.ireport.model.vo.TableCellObj;
import com.security.ireport.model.vo.TableObj;
import com.security.ireport.model.vo.group.TableCellNode;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.chart.LegendUtil;
import java.util.List;

public abstract class TableGroupShowUtil {
    public static void showTableCellNode(TableObj tableObj, List<TableCellNode> tableCellNode, ClassCount count, List<IRColumn> iRColumnList, String basePath, StringBuilder builder, int columnIndex) {
        if (null == builder) {
            builder = new StringBuilder();
        }
        TableCellNode tempTableCellNode = null;
        List<Object> tableCellObjList = null;
        TableCellObj[] tempTableCellObjs = null;
        int num = tableCellNode.size();
        for (int index = 0; index < num; ++index) {
            tempTableCellNode = tableCellNode.get(index);
            if (null == tempTableCellNode.getChildNodeList()) {
                tableCellObjList = tempTableCellNode.getExportObjList();
                if (!tempTableCellNode.getParent().isHasRowspan()) {
                    for (TableCellNode parent = (TableCellNode)tempTableCellNode.getParent(); null != parent; parent = (TableCellNode)parent.getParent()) {
                        parent.setHasRowspan(Boolean.TRUE);
                    }
                } else {
                    TableGroupShowUtil.addNewRow(tableObj, count, builder);
                }
                TableGroupShowUtil.addNewTdDataByNode(tempTableCellNode, iRColumnList.get(columnIndex), basePath, builder);
                if (!tableCellObjList.isEmpty()) {
                    tempTableCellObjs = (TableCellObj[])tableCellObjList.get(0);
                    TableGroupShowUtil.addTableCellObjs(tempTableCellObjs, iRColumnList, count, basePath, builder, columnIndex);
                }
                builder.append("</tr>");
                int cellNum = tableCellObjList.size();
                for (int tempIndex = 1; tempIndex < cellNum; ++tempIndex) {
                    TableGroupShowUtil.addNewRow(tableObj, count, builder);
                    TableGroupShowUtil.addTableCellObjs((TableCellObj[])tableCellObjList.get(tempIndex), iRColumnList, count, basePath, builder, columnIndex);
                    builder.append("</tr>");
                }
                continue;
            }
            if (columnIndex == 0 || tempTableCellNode.getParent().isHasRowspan()) {
                TableGroupShowUtil.addNewRow(tableObj, count, builder);
            }
            TableGroupShowUtil.addNewTdDataByNode(tempTableCellNode, iRColumnList.get(columnIndex), basePath, builder);
            if (null != tempTableCellNode.getTotalBarShowData() && !tableObj.isTotalBarDown()) {
                for (Object temp : tempTableCellNode.getTotalBarShowData()) {
                    builder.append("<td class=\"ireport_table_td\" ").append(iRColumnList.get(columnIndex).getTextAlignStyle()).append(" >").append(temp).append("</td>");
                }
                builder.append("</tr>");
                TableGroupShowUtil.addNewRow(tableObj, count, builder);
            }
            TableGroupShowUtil.showTableCellNode(tableObj, tempTableCellNode.getChildNodeList(), count, iRColumnList, basePath, builder, columnIndex + 1);
            if (null == tempTableCellNode.getTotalBarShowData() || !tableObj.isTotalBarDown()) continue;
            TableGroupShowUtil.addNewRow(tableObj, count, builder);
            for (Object temp : tempTableCellNode.getTotalBarShowData()) {
                builder.append("<td class=\"ireport_table_td\" ").append(iRColumnList.get(columnIndex).getTextAlignStyle()).append(" >").append(temp).append("</td>");
            }
            builder.append("</tr>");
        }
    }

    private static void addNewRow(TableObj tableObj, ClassCount count, StringBuilder builder) {
        builder.append("<tr class=\"").append(count.getPageClass()).append("\">");
        if (tableObj.isSerialNumShow()) {
            builder.append("<td class=\"td_sn\">").append(count.currentCount).append("</td>");
        }
    }

    private static void addNewTdDataByNode(TableCellNode tableCellNode, IRColumn irColumn, String basePath, StringBuilder builder) {
        builder.append("<td class=\"ireport_table_td\" rowspan=\"").append(tableCellNode.getRowSize()).append("\" ").append(irColumn.getTextAlignStyle()).append('>');
        String outPrintValue = tableCellNode.getDataText();
        if (!IReportConfCheckUtil.isStringEmpty(tableCellNode.getUrlText())) {
            String urlText = tableCellNode.getUrlText();
            if (!IReportConfCheckUtil.isStringEmpty(tableCellNode.getDataDrillCond())) {
                if (urlText != null && urlText.indexOf("&") != -1 && urlText.indexOf("&") != 0) {
                    urlText = urlText + "&";
                } else if (urlText != null) {
                    urlText = urlText + "?";
                }
                urlText = urlText + tableCellNode.getDataDrillCond();
                urlText = urlText + "&dataDrillTitle=" + irColumn.getDataDrillTitle();
            }
            if (irColumn.isUserJavaScript()) {
                builder.append("<a href=\"#\" onclick=\"").append(urlText).append("\">").append(outPrintValue).append("</a>");
            } else {
                builder.append("<a href=\"#\" onclick=\"window.open('").append(LegendUtil.changeToWOS(basePath + "/" + urlText)).append("')\">").append(outPrintValue).append("</a>");
            }
            builder.append("</td>");
        } else {
            builder.append(outPrintValue).append("</td>");
        }
    }

    private static void addTableCellObjs(TableCellObj[] tempTableCellObjs, List<IRColumn> iRColumnList, ClassCount count, String basePath, StringBuilder builder, int startIndex) {
        TableCellObj tempTableCell = null;
        int cellNum = tempTableCellObjs.length;
        for (int tableCellIndex = 0; tableCellIndex < cellNum; ++tableCellIndex) {
            tempTableCell = tempTableCellObjs[tableCellIndex];
            TableGroupShowUtil.addTableCellObj(tempTableCell, iRColumnList.get(startIndex + 1 + tableCellIndex), count, basePath, builder);
        }
    }

    private static void addTableCellObj(TableCellObj tempTableCell, IRColumn dcolumn, ClassCount count, String basePath, StringBuilder builder) {
        builder.append("<td class=\"ireport_table_td\" ").append(dcolumn.getTextAlignStyle()).append(" >");
        try {
            String outPrintValue = tempTableCell.getDataText();
            if (!IReportConfCheckUtil.isStringEmpty(tempTableCell.getUrlText())) {
                if (tempTableCell.getDataTextList().isEmpty()) {
                    String urlText = tempTableCell.getUrlText();
                    if (!IReportConfCheckUtil.isStringEmpty(tempTableCell.getDataDrillCond())) {
                        if (urlText != null && urlText.indexOf("&") != -1 && urlText.indexOf("&") != 0) {
                            urlText = urlText + "&";
                        } else if (urlText != null) {
                            urlText = urlText + "?";
                        }
                        urlText = urlText + tempTableCell.getDataDrillCond();
                        urlText = urlText + "&dataDrillTitle=" + dcolumn.getDataDrillTitle();
                    }
                    if (dcolumn.isUserJavaScript()) {
                        builder.append("<a href=\"#\" onclick=\"").append(urlText).append("\">").append(outPrintValue).append("</a>");
                    } else {
                        builder.append("<a href=\"#\" onclick=\"window.open('").append(LegendUtil.changeToWOS(basePath + "/" + urlText)).append("')\">").append(outPrintValue).append("</a>");
                    }
                } else {
                    outPrintValue = "";
                    if (dcolumn.isUserJavaScript()) {
                        builder.append("<a href=\"#\" onclick=\"").append(tempTableCell.getUrlTextList().get(0)).append("\">").append(tempTableCell.getDataTextList().get(0)).append("</a>");
                    } else {
                        builder.append("<a href=\"#\" onclick=\"window.open('").append(LegendUtil.changeToWOS(basePath + "/" + tempTableCell.getUrlTextList().get(0) + "&dataDrillTitle=" + dcolumn.getDataDrillTitle())).append("')\">").append(tempTableCell.getDataTextList().get(0)).append("</a>");
                    }
                    for (int k = 1; k < tempTableCell.getDataTextList().size(); ++k) {
                        if (dcolumn.isUserJavaScript()) {
                            builder.append(" | <a href=\"#\" onclick=\"").append(tempTableCell.getUrlTextList().get(k)).append("\">").append(tempTableCell.getDataTextList().get(k)).append("</a>");
                            continue;
                        }
                        builder.append(" | <a href=\"#\" onclick=\"window.open('").append(LegendUtil.changeToWOS(basePath + "/" + tempTableCell.getUrlTextList().get(k) + "&dataDrillTitle=" + dcolumn.getDataDrillTitle())).append("')\">").append(tempTableCell.getUrlTextList().get(k)).append("</a>");
                    }
                }
            } else if (dcolumn.getTooltips().length() != 0 && outPrintValue.length() > Integer.parseInt(dcolumn.getTooltips())) {
                builder.append("<a id=\"toolTip").append(count.currentCount).append("\" style=\"color:#000000;\">").append(outPrintValue.subSequence(0, Integer.parseInt(dcolumn.getTooltips()))).append("...").append("</a>").append("<script type=\"text/javascript\">").append("var strToolTip =\"toolTip").append(count.currentCount).append("\";").append("var buffer=\"").append(outPrintValue).append("\";").append("if (buffer.length > 0)").append('\n').append('{').append(" var titleBuffer = ''; ").append('\n').append(" var str = ''; ").append('\n').append(" for(var n = 0; n < buffer.length;n++)").append('\n').append('{').append("str = buffer.substring(n,n+1);").append('\n').append("titleBuffer+= str;").append("if(n!=0 && n%75==0)").append('\n').append('{').append("titleBuffer+=\" \";").append('}').append('}').append("$(\"#\"+ strToolTip).attr(\"title\", titleBuffer);").append('}').append("</script>");
            } else {
                builder.append(IReportUtil.transHtml(outPrintValue));
            }
        }
        catch (RuntimeException e) {
            builder.append(IReportUtil.transHtml(tempTableCell.toString()));
        }
        builder.append("</td>");
    }

    public static class ClassCount {
        int currentCount;

        public String getPageClass() {
            if (this.currentCount % 2 == 0) {
                ++this.currentCount;
                return "ireport_tr_line2";
            }
            ++this.currentCount;
            return "ireport_tr_line1";
        }
    }
}

