/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.security.ireport.util.ParseRemoteConf;

public final class UIServiceHelper {
    public static final String LEGO_LOG_SERVICE = "sysLogService";
    private static UIServiceHelper reportService = new UIServiceHelper();
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    private UIServiceHelper() {
    }

    public static UIServiceHelper getInstance() {
        return reportService;
    }

    public <T> T getService(String serviceName, Class<T> tClass) {
        T instance = null;
        instance = serviceName.indexOf("eLogServer/") != -1 ? (T)this.getService(serviceName, tClass, ParseRemoteConf.getInstance().isUseRemoteIp()) : (T)this.getService(serviceName, tClass, false);
        return instance;
    }

    private <T> T getService(String serviceName, Class<T> tClass, boolean useConfServerIp) {
        T instance = this.addService(serviceName, tClass, useConfServerIp);
        return instance;
    }

    private synchronized <T> T addService(String serviceName, Class<T> clazzs, boolean useConfServerIp) {
        LOGGER.debug(clazzs);
        if (clazzs == null) {
            return null;
        }
        ServiceContext svcCtx = ServiceContext.getInstance();
        Object instance = null;
        instance = svcCtx.getService(serviceName, clazzs);
        return (T)instance;
    }

    public static ISysOptLog getLegoLogService() {
        ISysOptLog logService = null;
        try {
            logService = UIServiceHelper.getInstance().getService(LEGO_LOG_SERVICE, ISysOptLog.class);
        }
        catch (Exception e) {
            LOGGER.error((Object)("get ISysOptLog exception : " + e.getMessage()));
        }
        return logService;
    }

    public static IUserMgr getUserMgr() {
        IUserMgr userMgr = null;
        try {
            userMgr = reportService.getService("user/usermgr", IUserMgr.class);
        }
        catch (Exception e) {
            LOGGER.error((Object)("enter getUserMgr() method, Exception happen: " + e.getMessage()));
        }
        LOGGER.info((Object)("retrieve the userMgr: " + userMgr));
        return userMgr;
    }
}

