/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public abstract class ZipUtil {
    private static final String ZIP_FILE_SEPARATOR = "/";
    private static final Character ZIP_FILE_SEPARATOR_CHAR = Character.valueOf('/');
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String inputFilePath, String zipFilePath, String baseName) {
        LOGGER.info((Object)"zip-->begin");
        ZipOutputStream zOut = null;
        try {
            zOut = new ZipOutputStream((OutputStream)new FileOutputStream(zipFilePath));
            zOut.setEncoding("gb2312");
            ZipUtil.zip(zOut, new File(inputFilePath), baseName);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        finally {
            try {
                if (zOut != null) {
                    zOut.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
        LOGGER.info((Object)"zip-->end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipWithFilter(String inputFilePath, String zipFilePath, String baseName, List<String> filterList) {
        if (null == inputFilePath || null == zipFilePath) {
            return;
        }
        File f = new File(inputFilePath);
        if (!f.exists()) {
            return;
        }
        File file = new File(zipFilePath);
        if (file.exists()) {
            LOGGER.warn((Object)("fileName =" + file.getName() + " is exist."));
            return;
        }
        ZipOutputStream zOut = null;
        try {
            zOut = new ZipOutputStream((OutputStream)new FileOutputStream(zipFilePath));
            LOGGER.debug((Object)"zip-->begin");
            ZipUtil.zipWithFilter(zOut, f, baseName, filterList);
            LOGGER.debug((Object)"zip-->end");
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        finally {
            try {
                if (zOut != null) {
                    zOut.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipWithFilter(ZipOutputStream zOut, File file, String base, List<String> filterList) {
        FileInputStream in = null;
        try {
            if (file != null && file.isDirectory()) {
                File[] listFiles = file.listFiles();
                String entryName = base + ZIP_FILE_SEPARATOR;
                LOGGER.debug((Object)("zip(ZipOutputStream zOut, File file, String base)-> entryName:" + entryName));
                zOut.putNextEntry(new ZipEntry(entryName));
                String string = base = base.length() == 0 ? "" : base + ZIP_FILE_SEPARATOR;
                if (null != listFiles) {
                    for (int i = 0; i < listFiles.length; ++i) {
                        ZipUtil.zipWithFilter(zOut, listFiles[i], base + listFiles[i].getName(), filterList);
                    }
                }
            } else if (file != null) {
                int len;
                if (!ZipUtil.isFileNameValid(file, filterList)) {
                    return;
                }
                if ("".equals(base)) {
                    base = file.getName();
                }
                LOGGER.debug((Object)("zip(ZipOutputStream zOut, File file, String base)-> entryName:" + base));
                zOut.putNextEntry(new ZipEntry(base));
                LOGGER.debug((Object)("zip(ZipOutputStream zOut, File file, String base) -> " + file.getPath() + "," + base));
                in = new FileInputStream(file);
                byte[] bytes = new byte[8192];
                while ((len = in.read(bytes)) != -1) {
                    zOut.write(bytes, 0, len);
                }
                zOut.flush();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
    }

    private static boolean isFileNameValid(File file, List<String> filterList) {
        if (filterList != null && !filterList.isEmpty()) {
            for (String item : filterList) {
                if (!file.getName().endsWith(item)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(List<String> directoryList, String zipFileName) {
        ZipOutputStream zOut = null;
        try {
            if (directoryList != null && !directoryList.isEmpty()) {
                zOut = new ZipOutputStream((OutputStream)new FileOutputStream(zipFileName));
                for (String item : directoryList) {
                    LOGGER.debug((Object)"zip-->begin");
                    ZipUtil.zip(zOut, new File(item), ZipUtil.getDirectoryName(item));
                    LOGGER.debug((Object)"zip-->end");
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"File not found");
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)e);
        }
        finally {
            try {
                if (zOut != null) {
                    zOut.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipWithFilter(List<String> directoryList, String zipFileName, List<String> filterList) {
        ZipOutputStream zOut = null;
        try {
            if (directoryList != null && !directoryList.isEmpty()) {
                zOut = new ZipOutputStream((OutputStream)new FileOutputStream(zipFileName));
                for (String item : directoryList) {
                    LOGGER.debug((Object)"zip-->begin");
                    ZipUtil.zipWithFilter(zOut, new File(item), ZipUtil.getDirectoryName(item), filterList);
                    LOGGER.debug((Object)"zip-->end");
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"File not found");
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)e);
        }
        finally {
            try {
                if (zOut != null) {
                    zOut.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
    }

    private static String getDirectoryName(String directoryPath) {
        if (directoryPath != null) {
            String[] dirs = directoryPath.replace('\\', ZIP_FILE_SEPARATOR_CHAR.charValue()).split(ZIP_FILE_SEPARATOR);
            return dirs[dirs.length - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(ZipOutputStream zOut, File file, String base) {
        FileInputStream in = null;
        try {
            LOGGER.debug((Object)("zip(ZipOutputStream zOut, File file, String base)-> fileName=" + file.getName()));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                String entryName = base + ZIP_FILE_SEPARATOR;
                LOGGER.debug((Object)("zip(ZipOutputStream zOut, File file, String base)-> entryName:" + entryName));
                zOut.putNextEntry(new ZipEntry(entryName));
                String string = base = base.length() == 0 ? "" : base + ZIP_FILE_SEPARATOR;
                if (null != listFiles) {
                    for (int i = 0; i < listFiles.length; ++i) {
                        ZipUtil.zip(zOut, listFiles[i], base + listFiles[i].getName());
                    }
                }
            } else {
                int len;
                if (base.equals("")) {
                    base = file.getName();
                }
                LOGGER.debug((Object)("zip(ZipOutputStream zOut, File file, String base)-> entryName:" + base));
                zOut.putNextEntry(new ZipEntry(base));
                LOGGER.debug((Object)("zip(ZipOutputStream zOut, File file, String base) -> " + file.getPath() + "," + base));
                in = new FileInputStream(file);
                byte[] bytes = new byte[8192];
                while ((len = in.read(bytes)) != -1) {
                    zOut.write(bytes, 0, len);
                }
                zOut.flush();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
    }
}

