/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util.chart;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.definition.IRChart;
import com.security.ireport.engine.definition.chart.CategoryChartValue;
import com.security.ireport.engine.definition.chart.ChartValue;
import com.security.ireport.engine.definition.chart.PieChartValue;
import com.security.ireport.engine.definition.chart.TimeChartValue;
import com.security.ireport.engine.definition.chart.XYChartValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.util.SortOrder;

public abstract class ChartDataSetFactory {
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    public static PieDataset createPieDataset(IRChart iRChart, ChartValue[] values) {
        DefaultPieDataset dataset;
        block4: {
            dataset = new DefaultPieDataset();
            if (values == null || values.length <= 0) break block4;
            DefaultKeyedValues defaultKeyedValues = ChartDataSetFactory.changeDefaultKeyedValues(iRChart, values);
            if (null != defaultKeyedValues) {
                for (int i = 0; i < defaultKeyedValues.getItemCount(); ++i) {
                    dataset.setValue(defaultKeyedValues.getKey(i), defaultKeyedValues.getValue(i));
                }
            } else {
                PieChartValue value = null;
                for (ChartValue item : values) {
                    value = (PieChartValue)item;
                    dataset.setValue((Comparable)((Object)value.getKey()), (Number)value.getValue());
                }
            }
        }
        return dataset;
    }

    public static PieDataset createPieDataset(IRChart iRChart, ChartValue[] values, int topN) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        if (null != values && values.length > 0) {
            DefaultKeyedValues defaultKeyedValues = ChartDataSetFactory.changeDefaultKeyedValues(iRChart, values);
            int size = 0;
            if (null != defaultKeyedValues) {
                size = defaultKeyedValues.getItemCount();
                if (topN > 0) {
                    size = size > topN ? topN : size;
                }
                for (int i = 0; i < size; ++i) {
                    dataset.setValue(defaultKeyedValues.getKey(i), defaultKeyedValues.getValue(i));
                }
                if (defaultKeyedValues.getItemCount() > size) {
                    double other = 0.0;
                    other = ChartDataSetFactory.getDataValue(defaultKeyedValues, size);
                    dataset.setValue((Comparable)((Object)"Other"), other);
                }
            } else {
                size = values.length;
                if (topN > 0) {
                    size = size > topN ? topN : size;
                }
                PieChartValue value = null;
                for (int i = 0; i < size; ++i) {
                    value = (PieChartValue)values[i];
                    dataset.setValue((Comparable)((Object)value.getKey()), (Number)value.getValue());
                }
                if (values.length > size) {
                    double other = 0.0;
                    other = ChartDataSetFactory.getDataValue(values, size);
                    dataset.setValue((Comparable)((Object)"Other"), other);
                }
            }
        }
        return dataset;
    }

    public static CategoryDataset createBarCategoryDataset(IRChart iRChart, ChartValue[] values) {
        DefaultCategoryDataset dataset;
        block4: {
            dataset = new DefaultCategoryDataset();
            if (values == null || values.length <= 0) break block4;
            DefaultKeyedValues defaultKeyedValues = ChartDataSetFactory.changeDefaultKeyedValues(iRChart, values);
            if (null != defaultKeyedValues) {
                for (int i = 0; i < defaultKeyedValues.getItemCount(); ++i) {
                    dataset.addValue(defaultKeyedValues.getValue(i), defaultKeyedValues.getKey(i), (Comparable)((Object)""));
                }
            } else {
                CategoryChartValue value = null;
                for (ChartValue item : values) {
                    value = (CategoryChartValue)item;
                    dataset.addValue((Number)value.getValue(), (Comparable)((Object)value.getCategory()), (Comparable)((Object)""));
                }
            }
        }
        return dataset;
    }

    private static void defKeyedValuesNotNull(DefaultKeyedValues defaultKeyedValues, DefaultStatisticalCategoryDataset dataset) {
        for (int i = 0; i < defaultKeyedValues.getItemCount(); ++i) {
            dataset.add(defaultKeyedValues.getValue(i), (Number)0, defaultKeyedValues.getKey(i), (Comparable)((Object)""));
        }
    }

    private static void defKeyedValuesNull(ChartValue[] values, DefaultStatisticalCategoryDataset dataset) {
        CategoryChartValue value = null;
        for (ChartValue item : values) {
            value = (CategoryChartValue)item;
            dataset.add(value.getValue().doubleValue(), 0.0, (Comparable)((Object)value.getCategory()), (Comparable)((Object)""));
        }
    }

    public static CategoryDataset create2DBarCategoryDataset(IRChart iRChart, ChartValue[] values) {
        DefaultStatisticalCategoryDataset dataset = new DefaultStatisticalCategoryDataset();
        if (values != null && values.length > 0) {
            DefaultKeyedValues defaultKeyedValues = ChartDataSetFactory.changeDefaultKeyedValues(iRChart, values);
            if (null != defaultKeyedValues) {
                ChartDataSetFactory.defKeyedValuesNotNull(defaultKeyedValues, dataset);
            } else {
                ChartDataSetFactory.defKeyedValuesNull(values, dataset);
            }
        }
        return dataset;
    }

    private static DefaultKeyedValues changeDefaultKeyedValues(IRChart iRChart, ChartValue[] values) {
        String sortOrderName = iRChart.getSortOrder();
        DefaultKeyedValues resultKeyValues = null;
        Object sortOrder = null;
        sortOrder = "ASC".equalsIgnoreCase(sortOrderName) ? SortOrder.ASCENDING : ("DESC".equalsIgnoreCase(sortOrderName) ? SortOrder.DESCENDING : ("NO".equalsIgnoreCase(sortOrderName) ? null : SortOrder.DESCENDING));
        if (null != sortOrder) {
            resultKeyValues = new DefaultKeyedValues();
            if (values[0] instanceof PieChartValue) {
                for (ChartValue item : values) {
                    PieChartValue value = (PieChartValue)item;
                    resultKeyValues.addValue((Comparable)((Object)value.getKey()), (Number)value.getValue());
                }
            } else if (values[0] instanceof CategoryChartValue) {
                for (ChartValue item : values) {
                    CategoryChartValue value = (CategoryChartValue)item;
                    resultKeyValues.addValue((Comparable)((Object)value.getCategory()), (Number)value.getValue());
                }
            }
            resultKeyValues.sortByValues(sortOrder);
        }
        return resultKeyValues;
    }

    private static double getDataValue(DefaultKeyedValues data, int size) {
        double other = 0.0;
        for (int i = size; i < data.getItemCount(); ++i) {
            other += data.getValue(i).doubleValue();
        }
        return other;
    }

    private static double getDataValue(ChartValue[] values, int size) {
        double other = 0.0;
        if (values[0] instanceof PieChartValue) {
            for (int i = size; i < values.length; ++i) {
                other += ((PieChartValue)values[i]).getValue().doubleValue();
            }
        }
        return other;
    }

    public static CategoryDataset createCategoryDataset(ChartValue[] values) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int i = 0; i < values.length; ++i) {
            CategoryChartValue value = (CategoryChartValue)values[i];
            dataset.addValue((Number)value.getValue(), (Comparable)((Object)value.getSeries()), (Comparable)((Object)value.getCategory()));
        }
        return dataset;
    }

    public static XYDataset createXYDataset(ChartValue[] values) {
        HashMap<String, XYSeries> map = new HashMap<String, XYSeries>();
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        for (int i = 0; i < values.length; ++i) {
            XYChartValue value = (XYChartValue)values[i];
            if (!map.containsKey(value.getSeries())) {
                map.put(value.getSeries(), new XYSeries((Comparable)((Object)value.getSeries())));
            }
            ((XYSeries)map.get(value.getSeries())).add((Number)value.getValue(), (Number)value.getYValue());
        }
        for (Map.Entry item : map.entrySet()) {
            seriesCollection.addSeries((XYSeries)item.getValue());
        }
        return seriesCollection;
    }

    public static XYDataset createTimeDataset(ChartValue[] values, IRChart reportChart) {
        HashMap<String, List<ChartValue>> chartValueMap = new HashMap<String, List<ChartValue>>();
        ArrayList<String> orderList = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            TimeChartValue value = (TimeChartValue)values[i];
            if (!chartValueMap.containsKey(value.getSeries())) {
                orderList.add(value.getSeries());
                chartValueMap.put(value.getSeries(), new ArrayList());
                ((List)chartValueMap.get(value.getSeries())).add(value);
                continue;
            }
            ChartDataSetFactory.addToOrderList(value, (List)chartValueMap.get(value.getSeries()));
        }
        TimeSeriesCollection seriesCollection = ChartDataSetFactory.getSeriesCollection(reportChart, chartValueMap, orderList);
        return seriesCollection;
    }

    public static CategoryDataset createLineChartDataset(ChartValue[] values) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int i = 0; i < values.length; ++i) {
            CategoryChartValue value = (CategoryChartValue)values[i];
            dataset.addValue((Number)value.getValue(), (Comparable)((Object)value.getSeries()), (Comparable)((Object)value.getCategory()));
        }
        return dataset;
    }

    public static CategoryDataset createCompBarChartDataset(ChartValue[] values) {
        DefaultStatisticalCategoryDataset dataset = new DefaultStatisticalCategoryDataset();
        CategoryChartValue value = null;
        for (int i = 0; i < values.length; ++i) {
            value = (CategoryChartValue)values[i];
            dataset.add(value.getValue().doubleValue(), 0.0, (Comparable)((Object)value.getSeries()), (Comparable)((Object)value.getCategory()));
        }
        return dataset;
    }

    public static CategoryDataset createHoriBarChartDataset(ChartValue[] values) {
        DefaultStatisticalCategoryDataset dataset = new DefaultStatisticalCategoryDataset();
        CategoryChartValue value = null;
        for (int i = 0; i < values.length; ++i) {
            value = (CategoryChartValue)values[i];
            dataset.add(value.getValue().doubleValue(), 0.0, (Comparable)((Object)value.getSeries()), (Comparable)((Object)value.getCategory()));
        }
        return dataset;
    }

    private static TimeSeriesCollection getSeriesCollection(IRChart reportChart, Map<String, List<ChartValue>> chartValueMap, List<String> orderList) {
        long timeCycle = reportChart.getIRDataSet().getFillByTimeCycleLong();
        long fillValue = reportChart.getIRDataSet().getFillValue();
        TimeSeriesCollection seriesCollection = new TimeSeriesCollection();
        if (timeCycle > 0L) {
            for (Map.Entry<String, List<ChartValue>> series : chartValueMap.entrySet()) {
                List<ChartValue> mendTimeDataList = ChartDataSetFactory.mendTimeData(series.getValue(), timeCycle, fillValue);
                ChartDataSetFactory.mendTimeData(series.getValue(), mendTimeDataList);
            }
        }
        TimeSeries timeSeries = null;
        TimeChartValue value = null;
        for (String tempSeries : orderList) {
            timeSeries = new TimeSeries((Comparable)((Object)tempSeries), Second.class);
            for (ChartValue item : chartValueMap.get(tempSeries)) {
                if (null == item) continue;
                if (item instanceof TimeChartValue) {
                    value = (TimeChartValue)item;
                    timeSeries.addOrUpdate((RegularTimePeriod)new Second(value.getTime()), (Number)value.getValue());
                    continue;
                }
                LOG.error((Object)"Object item is not TimeChartValue.");
            }
            seriesCollection.addSeries(timeSeries);
        }
        return seriesCollection;
    }

    private static void mendTimeData(List<ChartValue> origTimeData, List<ChartValue> mendTimeData) {
        if (mendTimeData != null && !mendTimeData.isEmpty() && origTimeData != null && !origTimeData.isEmpty()) {
            for (ChartValue item : mendTimeData) {
                ChartDataSetFactory.addToOrderList(item, origTimeData);
            }
        }
    }

    private static List<ChartValue> mendTimeData(List<ChartValue> timeData, long timeCycle, long fillValue) {
        List<ChartValue> tempList = new ArrayList<ChartValue>();
        if (timeData != null && !timeData.isEmpty()) {
            Double fillValueD = fillValue < 0L ? null : Double.valueOf(fillValue);
            int n = timeData.size();
            for (int i = 1; i < n; ++i) {
                TimeChartValue tempValue = (TimeChartValue)timeData.get(i - 1);
                long timeMill = ((TimeChartValue)timeData.get(i)).getTime().getTime() - tempValue.getTime().getTime();
                if (timeMill < timeCycle * 2L) continue;
                long num = timeMill / timeCycle;
                tempList = ChartDataSetFactory.getTempList(num, tempList, tempValue, fillValueD, timeCycle);
            }
        }
        return tempList;
    }

    private static List<ChartValue> getTempList(long num, List<ChartValue> tempList, TimeChartValue tempValue, Double fillValueD, long timeCycle) {
        TimeChartValue newValue = null;
        int j = 1;
        while ((long)j < num) {
            newValue = new TimeChartValue();
            newValue.setSeries(tempValue.getSeries());
            newValue.setTime(new Date(tempValue.getTime().getTime() + (long)j * timeCycle));
            newValue.setValue(fillValueD);
            tempList.add(newValue);
            ++j;
        }
        return tempList;
    }

    private static void addToOrderList(ChartValue value, List<ChartValue> chartValueList) {
        if (value instanceof TimeChartValue) {
            TimeChartValue timeValue = (TimeChartValue)value;
            boolean flag = false;
            for (int i = chartValueList.size(); i > 0; --i) {
                if (timeValue.getTime().getTime() >= ((TimeChartValue)chartValueList.get(i - 1)).getTime().getTime()) continue;
                chartValueList.add(i - 1, timeValue);
                flag = true;
                break;
            }
            if (!flag) {
                chartValueList.add(value);
            }
        } else {
            chartValueList.add(value);
        }
    }

    public static TimeTableXYDataset createTimeTableXYDataset(ChartValue[] values, IRChart reportChart) {
        HashMap<String, List<ChartValue>> chartValueMap = new HashMap<String, List<ChartValue>>();
        ArrayList<String> seriesList = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            TimeChartValue value = (TimeChartValue)values[i];
            if (!chartValueMap.containsKey(value.getSeries())) {
                seriesList.add(value.getSeries());
                chartValueMap.put(value.getSeries(), new ArrayList());
                ((List)chartValueMap.get(value.getSeries())).add(value);
                continue;
            }
            ChartDataSetFactory.addToOrderList(value, (List)chartValueMap.get(value.getSeries()));
        }
        TimeTableXYDataset seriesCollection = ChartDataSetFactory.getTimeTableXYDataset(reportChart, chartValueMap, seriesList);
        return seriesCollection;
    }

    private static TimeTableXYDataset getTimeTableXYDataset(IRChart reportChart, Map<String, List<ChartValue>> chartValueMap, List<String> seriesList) {
        TimeTableXYDataset seriesCollection = new TimeTableXYDataset();
        long timeCycle = reportChart.getIRDataSet().getFillByTimeCycleLong();
        long fillValue = reportChart.getIRDataSet().getFillValue();
        if (fillValue < 0L) {
            fillValue = 0L;
        }
        if (timeCycle > 0L) {
            for (Map.Entry<String, List<ChartValue>> series : chartValueMap.entrySet()) {
                List<ChartValue> mendTimeDataList = ChartDataSetFactory.mendTimeData(series.getValue(), timeCycle, fillValue);
                ChartDataSetFactory.mendTimeData(series.getValue(), mendTimeDataList);
            }
        }
        List<ChartValue> chartValueList = null;
        int num = seriesList.size();
        for (int index = 0; index < num; ++index) {
            chartValueList = chartValueMap.get(seriesList.get(index));
            for (ChartValue item : chartValueList) {
                if (null == item) continue;
                if (item instanceof TimeChartValue) {
                    TimeChartValue value = (TimeChartValue)item;
                    seriesCollection.add((TimePeriod)new Second(value.getTime()), value.getValue().doubleValue(), value.getSeries());
                    continue;
                }
                LOG.error((Object)"Object item is not TimeChartValue.");
            }
        }
        return seriesCollection;
    }

    public static DefaultValueDataset createDefaultValueDataset(ChartValue[] values) {
        DefaultValueDataset dataset = new DefaultValueDataset((Number)values[0].getValue());
        return dataset;
    }
}

